/*
 * Decompiled with CFR 0.152.
 */
package catalystchart;

import catalystchart.ChartActionEvent;
import catalystchart.IntradayChart;
import catalystchart.JFreeChartDataProvider;
import chart.data.IDataContainer;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jfree.custom.CustomCrosshairOverlay;
import jfree.custom.InfoBoxCrosshair;
import jfree.custom.InfoBoxCrosshairOverlay;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.panel.AbstractOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;

public class BidAskChart
extends IntradayChart {
    private Crosshair buy_linecrosshair;
    private Crosshair sell_linecrosshair;
    private InfoBoxCrosshair buyinfoboxcrosshair;
    private InfoBoxCrosshair sellinfoboxcrosshair;
    private TimeSeries buySeries;
    private TimeSeries sellSeries;
    private TimeSeriesCollection buyDataSet;
    private TimeSeriesCollection sellDataSet;
    IDataContainer dataContainer;
    IDataContainer dataContainer2;
    final Color BUYCOLOR = new Color(0, 190, 190);
    final Color SELLCOLOR = new Color(213, 0, 175);
    private List<String> values = new ArrayList<String>();
    private List<String> param = new ArrayList<String>();

    public BidAskChart(String string, String string2) {
    }

    public void addBuySellTick(Date date, double d2, double d3) {
        date = new Millisecond(date);
        this.ltrdPrice = d2;
        this.ask = d3;
        if (d2 == 0.0) {
            this.buySeries.addOrUpdate((RegularTimePeriod)date, null);
        } else {
            this.buySeries.addOrUpdate((RegularTimePeriod)date, d2);
        }
        if (d3 == 0.0) {
            this.sellSeries.addOrUpdate((RegularTimePeriod)date, null);
            return;
        }
        this.sellSeries.addOrUpdate((RegularTimePeriod)date, d3);
    }

    public void setInitialDataForbuySellChart(List<Date> list, List<Double> list2, List<Double> list3) {
        JFreeChartDataProvider jFreeChartDataProvider = new JFreeChartDataProvider();
        this.buySeries = new TimeSeries((Comparable)((Object)"Buy"));
        this.sellSeries = new TimeSeries((Comparable)((Object)"Sell"));
        this.buyDataSet = jFreeChartDataProvider.getXYdataset(this.buySeries, list, list2);
        this.sellDataSet = jFreeChartDataProvider.getXYdataset(this.sellSeries, list, list3);
    }

    @Override
    public void InitializeCrosshair() {
        AbstractOverlay abstractOverlay = new CustomCrosshairOverlay();
        this.sell_linecrosshair = new Crosshair(0.0);
        this.sell_linecrosshair.setPaint((Paint)this.SELLCOLOR);
        this.sell_linecrosshair.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        this.sell_linecrosshair.setLabelVisible(true);
        this.sell_linecrosshair.setLabelBackgroundPaint((Paint)this.SELLCOLOR);
        abstractOverlay.addRangeCrosshair(this.sell_linecrosshair);
        this.buy_linecrosshair = new Crosshair(0.0);
        this.buy_linecrosshair.setPaint((Paint)this.BUYCOLOR);
        this.buy_linecrosshair.setLabelAnchor(RectangleAnchor.BOTTOM_RIGHT);
        this.buy_linecrosshair.setLabelVisible(true);
        this.buy_linecrosshair.setLabelBackgroundPaint((Paint)this.BUYCOLOR);
        abstractOverlay.addRangeCrosshair(this.buy_linecrosshair);
        this.chartPanel.addOverlay((Overlay)abstractOverlay);
        abstractOverlay = new InfoBoxCrosshairOverlay();
        this.buyinfoboxcrosshair = new InfoBoxCrosshair(0.0, 0.0);
        this.buyinfoboxcrosshair.setPaint(this.BUYCOLOR);
        this.buyinfoboxcrosshair.showInfoBox(false);
        this.sellinfoboxcrosshair = new InfoBoxCrosshair(0.0, 0.0);
        this.sellinfoboxcrosshair.setPaint(this.SELLCOLOR);
        this.sellinfoboxcrosshair.showInfoBox(true);
        this.sellinfoboxcrosshair.setWaterMark(this.waterMarkText);
        this.sellinfoboxcrosshair.setParams(this.param);
        abstractOverlay.addInfoCrosshair(this.buyinfoboxcrosshair);
        abstractOverlay.addInfoCrosshair(this.sellinfoboxcrosshair);
        this.chartPanel.addOverlay((Overlay)abstractOverlay);
        this.buyinfoboxcrosshair.setLabelVisible(true);
        this.buyinfoboxcrosshair.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        this.buyinfoboxcrosshair.setLabelBackgroundPaint(new Color(255, 255, 0, 100));
    }

    @Override
    public JFreeChart createChart() {
        this.localCombinedDomainXYPlot = new CombinedDomainXYPlot((ValueAxis)new NumberAxis("Domain"));
        this.localCombinedDomainXYPlot.setGap(0.2);
        this.localCombinedDomainXYPlot.setOrientation(PlotOrientation.VERTICAL);
        this.localCombinedDomainXYPlot.setDomainGridlinesVisible(true);
        this.localCombinedDomainXYPlot.setDomainPannable(true);
        this.localCombinedDomainXYPlot.setGap(5.0);
        this.localXYPlot = new XYPlot((XYDataset)this.buyDataSet, null, null, (XYItemRenderer)new StandardXYItemRenderer());
        this.localXYPlot.setDataset(1, (XYDataset)this.sellDataSet);
        this.localXYPlot.setDomainPannable(false);
        this.localXYPlot.getRenderer(0).setSeriesPaint(0, (Paint)this.BUYCOLOR);
        DefaultXYItemRenderer defaultXYItemRenderer = new DefaultXYItemRenderer();
        this.localXYPlot.setRenderer(1, (XYItemRenderer)defaultXYItemRenderer);
        defaultXYItemRenderer = this.localXYPlot.getRenderer(1);
        defaultXYItemRenderer.setSeriesPaint(0, (Paint)this.SELLCOLOR);
        if (defaultXYItemRenderer instanceof XYLineAndShapeRenderer) {
            defaultXYItemRenderer = (XYLineAndShapeRenderer)defaultXYItemRenderer;
            defaultXYItemRenderer.setBaseShapesVisible(false);
        }
        defaultXYItemRenderer = new NumberAxis();
        defaultXYItemRenderer.setAutoRangeIncludesZero(false);
        if (this.lowerBound != 0.0) {
            defaultXYItemRenderer.setLowerBound(this.lowerBound);
        }
        if (this.upperBound != 0.0) {
            defaultXYItemRenderer.setUpperBound(this.upperBound);
        }
        defaultXYItemRenderer.setNumberFormatOverride((NumberFormat)this.localDecimalFormat);
        defaultXYItemRenderer.setTickLabelPaint((Paint)Color.gray);
        this.localXYPlot.setRangeAxis(0, (ValueAxis)defaultXYItemRenderer);
        this.localXYPlot.setRangeAxisLocation(0, AxisLocation.TOP_OR_RIGHT);
        this.localCombinedDomainXYPlot.add(this.localXYPlot, 1);
        defaultXYItemRenderer = new DateAxis("");
        defaultXYItemRenderer.setLowerMargin(0.02);
        defaultXYItemRenderer.setUpperMargin(0.2);
        defaultXYItemRenderer.setTickMarkPaint((Paint)Color.gray);
        defaultXYItemRenderer.setTickLabelPaint((Paint)Color.gray);
        this.localCombinedDomainXYPlot.setDomainAxis(0, (ValueAxis)defaultXYItemRenderer);
        this.localJFreeChart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.localCombinedDomainXYPlot, false);
        return this.localJFreeChart;
    }

    @Override
    public void chartMouseMoved(ChartMouseEvent object) {
        double d2 = object.getTrigger().getX();
        double d3 = object.getTrigger().getY();
        object = this.getDotDatavalue(new Point2D.Double(d2, d3), this.buySeries);
        Point2D point2D = this.getDotDatavalue(new Point2D.Double(d2, d3), this.sellSeries);
        this.buyinfoboxcrosshair.setX(((Point2D)object).getX());
        this.buyinfoboxcrosshair.setY(((Point2D)object).getY());
        this.sellinfoboxcrosshair.setX(point2D.getX());
        this.sellinfoboxcrosshair.setY(point2D.getY());
        Date date = new Date((long)((Point2D)object).getX());
        this.sellinfoboxcrosshair.setTime(date);
        this.param = new ArrayList<String>();
        this.param.add("Buy");
        this.param.add("Sell");
        this.values = new ArrayList<String>();
        this.values.add(this.localDecimalFormat.format(((Point2D)object).getY()));
        this.values.add(this.localDecimalFormat.format(point2D.getY()));
        this.sellinfoboxcrosshair.setParams(this.param);
        this.sellinfoboxcrosshair.setValues(this.values);
        this.sellinfoboxcrosshair.setValue(((Point2D)object).getX());
        this.buyinfoboxcrosshair.setValue(((Point2D)object).getX());
    }

    @Override
    public void chartChanged(ChartChangeEvent chartChangeEvent) {
        if (this.buy_linecrosshair != null) {
            this.buy_linecrosshair.setValue(this.ltrdPrice);
        }
        if (this.sell_linecrosshair != null) {
            this.sell_linecrosshair.setValue(this.ask);
        }
    }

    @Override
    public void AddIndicator(ChartActionEvent chartActionEvent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void createDataset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void RunDemo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

