/*
 * Decompiled with CFR 0.152.
 */
package catalystchart;

import java.awt.Color;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JScrollBar;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;

public class ChartScrollBar
extends JScrollBar
implements AdjustmentListener,
MouseListener,
AxisChangeListener,
DatasetChangeListener {
    private JFreeChart chart;
    private XYPlot plot;
    private double ratio;
    private boolean updating = false;
    private double displayMin;
    private double displayMax;
    private double viewLength;
    private static int a = 100000;
    Color oldColor = Color.LIGHT_GRAY;

    public ChartScrollBar(int n2, JFreeChart jFreeChart) {
        this(n2, jFreeChart, null);
    }

    public ChartScrollBar(int n2, JFreeChart jFreeChart, XYPlot xYPlot) {
        super(n2);
        this.chart = jFreeChart;
        this.plot = xYPlot == null ? jFreeChart.getXYPlot() : xYPlot;
        if (this.getXYPlot() != null && this.getValueAxis() != null) {
            this.getValueAxis().addChangeListener((AxisChangeListener)this);
            this.addAdjustmentListener(this);
            if (this.getXYPlot().getDataset() != null) {
                this.getXYPlot().getDataset().addChangeListener((DatasetChangeListener)this);
            }
            this.axisUpdate();
            this.addMouseListener(this);
        }
    }

    public XYPlot getXYPlot() {
        return this.plot;
    }

    public ValueAxis getValueAxis() {
        if (this.orientation == 1) {
            return this.getXYPlot().getRangeAxis();
        }
        return this.getXYPlot().getDomainAxis();
    }

    public Dataset getDataset() {
        return this.getXYPlot().getDataset();
    }

    public Range getDataRange() {
        return this.getXYPlot().getDataRange(this.getValueAxis());
    }

    public double getDataMinimum() {
        return this.getDataRange().getLowerBound();
    }

    public double getDataMaximum() {
        return this.getDataRange().getUpperBound();
    }

    public double getViewMinimum() {
        return this.getValueAxis().getLowerBound();
    }

    public double getViewMaximum() {
        return this.getValueAxis().getUpperBound();
    }

    public double getViewLength() {
        return this.getValueAxis().getRange().getLength();
    }

    public double getDisplayMaximum() {
        return this.getDataMaximum();
    }

    public double getDisplayMinimum() {
        return this.getDataMinimum();
    }

    public void axisUpdate() {
        ValueAxis valueAxis = this.getValueAxis();
        if (valueAxis.isAutoRange()) {
            if (this.oldColor == null) {
                this.oldColor = this.getBackground();
            }
            this.setBackground(this.oldColor.brighter());
        } else if (this.oldColor != null) {
            this.setBackground(this.oldColor);
            this.oldColor = null;
        }
        if (this.updating) {
            return;
        }
        this.updating = true;
        this.displayMin = 0.0;
        this.displayMax = 0.0;
        this.viewLength = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        this.ratio = 1.0;
        Range range = this.getDataRange();
        if (range != null) {
            this.displayMin = this.getDisplayMinimum();
            this.displayMax = this.getDisplayMaximum();
            d2 = this.getViewMinimum();
            d3 = this.getViewMaximum();
            if (valueAxis instanceof DateAxis) {
                valueAxis = ((DateAxis)valueAxis).getTimeline();
                this.displayMin = valueAxis.toTimelineValue((long)this.displayMin);
                this.displayMax = valueAxis.toTimelineValue((long)this.displayMax);
                d2 = valueAxis.toTimelineValue((long)d2);
                d3 = valueAxis.toTimelineValue((long)d3);
            }
            this.viewLength = d3 - d2;
            this.ratio = (double)a / (this.displayMax - this.displayMin);
        }
        int n2 = a;
        int n3 = (int)(this.viewLength * this.ratio);
        int n4 = this.orientation == 1 ? (int)((this.displayMax - d3) * this.ratio) : (int)((d2 - this.displayMin) * this.ratio);
        this.setValues(n4, n3, 0, n2);
        this.updating = false;
    }

    public void axisChanged(AxisChangeEvent axisChangeEvent) {
        this.axisUpdate();
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.axisUpdate();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        double d2;
        double d3;
        if (this.updating) {
            return;
        }
        this.updating = true;
        if (this.orientation == 1) {
            d3 = this.displayMax - (double)this.getValue() / this.ratio;
            d2 = d3 - this.viewLength;
        } else {
            d2 = (double)this.getValue() / this.ratio + this.displayMin;
            d3 = d2 + this.viewLength;
        }
        if (d3 > d2) {
            adjustmentEvent = this.getValueAxis();
            if (adjustmentEvent instanceof DateAxis) {
                adjustmentEvent = ((DateAxis)adjustmentEvent).getTimeline();
                d2 = adjustmentEvent.toMillisecond((long)d2);
                d3 = adjustmentEvent.toMillisecond((long)d3);
            }
            this.getValueAxis().setRange(d2, d3);
        }
        this.updating = false;
    }

    public void zoomFull() {
        this.getValueAxis().setAutoRange(true);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            this.zoomFull();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

