/*
 * Decompiled with CFR 0.152.
 */
package catalystchart;

import TechnicalAnalysis.TechnicalAnalysis;
import catalystchart.ChartActionEvent;
import catalystchart.IntradayChart;
import catalystchart.JFreeChartDataProvider;
import catalystchart.TAObjects;
import chart.data.IDataContainer;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import jfree.custom.CustomCrosshair;
import jfree.custom.CustomCrosshairOverlay;
import jfree.custom.InfoBoxCrosshair;
import jfree.custom.InfoBoxCrosshairOverlay;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;

public class PriceVolumeCombinedChart
extends IntradayChart {
    private TimeSeries ltrdPriceSeries;
    private TimeSeries ltrdVolumeSeries;
    private TimeSeriesCollection ltrdPriceDataSet;
    private TimeSeriesCollection ltrdVolumeDataSet;
    IDataContainer dataContainer;
    IDataContainer dataContainer2;
    final Object Lock = new Object();
    Hashtable<String, XYPlot> TAPlots = new Hashtable();
    Hashtable<String, TimeSeries> TASeries = new Hashtable();
    Hashtable<String, TAObjects> TAObjects = new Hashtable();
    final Color VolumeColor = new Color(141, 136, 41);
    final Color LtrdPriceColor = new Color(2, 238, 162);
    private final CustomCrosshairOverlay tracelineCrosshairOverlay = new CustomCrosshairOverlay();
    private final InfoBoxCrosshairOverlay infoBoxCrosshairOverlay = new InfoBoxCrosshairOverlay();
    private CustomCrosshair ltrdPriceTraceLine;
    private InfoBoxCrosshair ltrdInfoCrosshair;
    private List<String> values = new ArrayList<String>();
    private List<String> param = new ArrayList<String>();

    public void addPriceVolumeTick(Date date, double d2, double d3) {
        Object object = this.Lock;
        synchronized (object) {
            date = new Millisecond(date);
            this.ltrdPrice = d2;
            if (d2 == 0.0) {
                this.ltrdPriceSeries.addOrUpdate((RegularTimePeriod)date, null);
            } else {
                this.ltrdPriceSeries.addOrUpdate((RegularTimePeriod)date, d2);
            }
            if (d3 == 0.0) {
                this.ltrdVolumeSeries.addOrUpdate((RegularTimePeriod)date, null);
            } else {
                this.ltrdVolumeSeries.addOrUpdate((RegularTimePeriod)date, d3);
            }
            for (TAObjects tAObjects : this.TAObjects.values()) {
                double d4;
                if (tAObjects.b.equalsIgnoreCase("SMA")) {
                    d4 = TechnicalAnalysis.createSMA(this.ltrdPriceSeries, tAObjects.a);
                    tAObjects.c.addOrUpdate((RegularTimePeriod)date, d4);
                    tAObjects.g = d4;
                    continue;
                }
                if (tAObjects.b.equalsIgnoreCase("EMA")) {
                    d4 = TechnicalAnalysis.createEMA(this.ltrdPriceSeries, tAObjects.a);
                    tAObjects.c.addOrUpdate((RegularTimePeriod)date, d4);
                    tAObjects.g = d4;
                    continue;
                }
                if (!tAObjects.b.equalsIgnoreCase("RSI")) continue;
                d4 = TechnicalAnalysis.createRSI(this.ltrdPriceSeries, tAObjects.a);
                tAObjects.c.addOrUpdate((RegularTimePeriod)date, d4);
                tAObjects.g = d4;
            }
            return;
        }
    }

    public void setInitialDataForPriceVolumeChart(List<Date> list, List<Double> list2, List<Double> list3) {
        JFreeChartDataProvider jFreeChartDataProvider = new JFreeChartDataProvider();
        this.ltrdPriceSeries = new TimeSeries((Comparable)((Object)"LastTradePrice"));
        this.ltrdVolumeSeries = new TimeSeries((Comparable)((Object)"LastTradeVolume"));
        this.ltrdPriceDataSet = jFreeChartDataProvider.getXYdataset(this.ltrdPriceSeries, list, list2);
        this.ltrdVolumeDataSet = jFreeChartDataProvider.getXYdataset(this.ltrdVolumeSeries, list, list3);
    }

    @Override
    public void InitializeCrosshair() {
        this.ltrdPriceTraceLine = new CustomCrosshair(0.0);
        this.ltrdPriceTraceLine.setPaint(this.LtrdPriceColor);
        this.ltrdPriceTraceLine.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        this.ltrdPriceTraceLine.setLabelVisible(true);
        this.ltrdPriceTraceLine.setLabelBackgroundPaint(this.LtrdPriceColor);
        this.tracelineCrosshairOverlay.addRangeCrosshair(this.ltrdPriceTraceLine);
        this.chartPanel.addOverlay((Overlay)this.tracelineCrosshairOverlay);
        this.ltrdInfoCrosshair = new InfoBoxCrosshair(0.0, 0.0);
        this.ltrdInfoCrosshair.setPaint(this.LtrdPriceColor);
        this.ltrdInfoCrosshair.showInfoBox(true);
        this.ltrdInfoCrosshair.setWaterMark(this.waterMarkText);
        this.ltrdInfoCrosshair.setLabelVisible(true);
        this.ltrdInfoCrosshair.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        this.ltrdInfoCrosshair.setLabelBackgroundPaint(new Color(255, 255, 0, 100));
        this.ltrdInfoCrosshair.setParams(this.param);
        this.infoBoxCrosshairOverlay.addInfoCrosshair(this.ltrdInfoCrosshair);
        this.chartPanel.addOverlay((Overlay)this.infoBoxCrosshairOverlay);
    }

    @Override
    public JFreeChart createChart() {
        this.localCombinedDomainXYPlot = new CombinedDomainXYPlot((ValueAxis)new NumberAxis("Domain"));
        this.localCombinedDomainXYPlot.setOrientation(PlotOrientation.VERTICAL);
        this.localCombinedDomainXYPlot.setDomainGridlinesVisible(true);
        this.localCombinedDomainXYPlot.setDomainPannable(true);
        this.localCombinedDomainXYPlot.setGap(5.0);
        this.localXYPlot = new XYPlot((XYDataset)this.ltrdPriceDataSet, null, null, (XYItemRenderer)new StandardXYItemRenderer());
        this.localXYPlot.setDomainPannable(false);
        this.localXYPlot.setDataset(1, (XYDataset)new XYBarDataset((XYDataset)this.ltrdVolumeDataSet, 0.2));
        NumberAxis numberAxis = new NumberAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis.setUpperMargin(0.2);
        numberAxis.setLowerMargin(0.2);
        numberAxis.setNumberFormatOverride((NumberFormat)this.localDecimalFormat);
        numberAxis.setTickLabelPaint((Paint)this.LtrdPriceColor);
        NumberAxis numberAxis2 = new NumberAxis();
        numberAxis2.setAutoRangeIncludesZero(false);
        numberAxis2.setTickLabelPaint((Paint)this.VolumeColor);
        numberAxis2.setUpperMargin(1.0);
        numberAxis2.setNumberFormatOverride(this.localNumberFormat);
        this.localXYPlot.setRangeAxis(0, (ValueAxis)numberAxis);
        this.localXYPlot.setRangeAxis(1, (ValueAxis)numberAxis2);
        this.localXYPlot.setRangeAxisLocation(0, AxisLocation.TOP_OR_RIGHT);
        this.localXYPlot.setRangeAxisLocation(1, AxisLocation.TOP_OR_LEFT);
        this.localXYPlot.mapDatasetToRangeAxis(1, 1);
        numberAxis = new XYBarRenderer(0.1);
        this.localXYPlot.setRenderer(1, (XYItemRenderer)numberAxis);
        numberAxis.setSeriesPaint(0, (Paint)this.VolumeColor);
        numberAxis2 = new StandardXYBarPainter();
        numberAxis.setBarPainter((XYBarPainter)numberAxis2);
        numberAxis.setShadowVisible(false);
        this.localXYPlot.getRenderer(0).setSeriesPaint(0, (Paint)this.LtrdPriceColor);
        this.localCombinedDomainXYPlot.add(this.localXYPlot, 3);
        numberAxis = new DateAxis();
        numberAxis.setTickMarkPaint((Paint)Color.gray);
        numberAxis.setTickLabelPaint((Paint)Color.gray);
        this.localCombinedDomainXYPlot.setDomainAxis(0, (ValueAxis)numberAxis);
        numberAxis.setLowerMargin(0.02);
        numberAxis.setUpperMargin(0.2);
        this.localJFreeChart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.localCombinedDomainXYPlot, false);
        return this.localJFreeChart;
    }

    @Override
    public void AddIndicator(ChartActionEvent object) {
        Object object2 = this.Lock;
        synchronized (object2) {
            String string = ((ChartActionEvent)object).getIndicatorName();
            int n2 = ((ChartActionEvent)object).getPeriod();
            String string2 = string;
            if (this.TAObjects.containsKey(string2)) {
                this.localCombinedDomainXYPlot.remove(this.TAObjects.get((Object)string2).d);
                this.tracelineCrosshairOverlay.removeRangeCrosshair(this.TAObjects.get((Object)string2).e);
                this.infoBoxCrosshairOverlay.removeInfoCrosshair(this.TAObjects.get((Object)string2).f);
                this.TAObjects.remove(string2);
                return;
            }
            TimeSeries timeSeries = null;
            if (string.equalsIgnoreCase("SMA")) {
                timeSeries = TechnicalAnalysis.createSMA(this.ltrdPriceSeries, string, n2);
            } else if (string.equalsIgnoreCase("EMA")) {
                timeSeries = TechnicalAnalysis.createEMA(this.ltrdPriceSeries, string, n2);
            } else if (string.equalsIgnoreCase("RSI")) {
                timeSeries = TechnicalAnalysis.createRSI(this.ltrdPriceSeries, string, n2);
            }
            TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
            timeSeriesCollection.addSeries(timeSeries);
            Object object3 = new NumberAxis();
            object3.setTickMarkPaint((Paint)Color.gray);
            object3.setAutoRangeIncludesZero(false);
            object3.setTickLabelPaint((Paint)Color.gray);
            Object object4 = new StandardXYItemRenderer();
            timeSeriesCollection = new XYPlot((XYDataset)timeSeriesCollection, null, (ValueAxis)object3, (XYItemRenderer)object4);
            timeSeriesCollection.getRenderer(0).setSeriesPaint(0, (Paint)((ChartActionEvent)object).getColor());
            timeSeriesCollection.setBackgroundPaint((Paint)this.PLOTBGCOLOR);
            timeSeriesCollection.setDomainGridlinePaint((Paint)Color.white);
            timeSeriesCollection.setRangeGridlinePaint((Paint)Color.white);
            timeSeriesCollection.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
            timeSeriesCollection.getRangeAxis().setTickLabelPaint((Paint)((ChartActionEvent)object).getColor());
            object3 = new NumberAxis();
            object3.setTickMarkOutsideLength(0.0f);
            object3.setLabelPaint((Paint)((ChartActionEvent)object).getColor());
            object3.setLabel(string + "(" + n2 + ")");
            timeSeriesCollection.setRangeAxis(1, (ValueAxis)object3);
            timeSeriesCollection.setRangeCrosshairVisible(true);
            timeSeriesCollection.setRangeCrosshairLockedOnData(true);
            object3 = new CustomCrosshair(0.0);
            object3.setPaint((Paint)((ChartActionEvent)object).getColor());
            object3.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            object3.setLabelVisible(true);
            object3.setLabelBackgroundPaint((Paint)((ChartActionEvent)object).getColor());
            ((CustomCrosshair)((Object)object3)).setXYPlot((XYPlot)timeSeriesCollection);
            object4 = new InfoBoxCrosshair(0.0, 0.0);
            object4.setPaint((Paint)((ChartActionEvent)object).getColor());
            ((InfoBoxCrosshair)((Object)object4)).showInfoBox(false);
            object4.setLabelVisible(true);
            object4.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            object4.setLabelBackgroundPaint((Paint)new Color(255, 255, 0, 100));
            ((InfoBoxCrosshair)((Object)object4)).setXYPlot((XYPlot)timeSeriesCollection);
            object = new TAObjects(string, n2, timeSeries, (XYPlot)timeSeriesCollection, (Crosshair)object3, (InfoBoxCrosshair)((Object)((Object)object4)));
            new TAObjects(string, n2, timeSeries, (XYPlot)timeSeriesCollection, (Crosshair)object3, (InfoBoxCrosshair)((Object)((Object)object4))).g = Double.parseDouble("" + timeSeries.getValue(timeSeries.getItemCount() - 1));
            this.TAObjects.put(string2, (TAObjects)object);
            this.localCombinedDomainXYPlot.setGap(10.0);
            this.localCombinedDomainXYPlot.add((XYPlot)timeSeriesCollection, 1);
            this.tracelineCrosshairOverlay.addRangeCrosshair((Crosshair)object3);
            this.infoBoxCrosshairOverlay.addInfoCrosshair((Crosshair)object4);
            return;
        }
    }

    @Override
    public void createDataset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void chartMouseMoved(ChartMouseEvent object) {
        double d2 = object.getTrigger().getX();
        double d3 = object.getTrigger().getY();
        object = this.getDotDatavalue(new Point2D.Double(d2, d3), this.ltrdPriceSeries);
        Iterator<TAObjects> iterator = this.getDotDatavalue(new Point2D.Double(d2, d3), this.ltrdVolumeSeries);
        Date object22 = new Date((long)((Point2D)object).getX());
        this.ltrdInfoCrosshair.setX(((Point2D)object).getX());
        this.ltrdInfoCrosshair.setY(((Point2D)object).getY());
        this.ltrdInfoCrosshair.setTime(object22);
        this.values = new ArrayList<String>();
        this.values.add(this.localDecimalFormat.format(((Point2D)object).getY()));
        this.values.add(this.localNumberFormat.format(((Point2D)((Object)iterator)).getY()));
        this.param = new ArrayList<String>();
        this.param.add("LTrd Price");
        this.param.add("LTrd Volume");
        for (TAObjects tAObjects : this.TAObjects.values()) {
            Point2D point2D = this.getDotDatavalue(new Point2D.Double(d2, d3), tAObjects.c);
            if (((Point2D)object).getX() == point2D.getX()) {
                tAObjects.f.setX(((Point2D)object).getX());
            }
            tAObjects.f.setY(point2D.getY());
            this.values.add(this.localDecimalFormat.format(point2D.getY()));
            this.param.add(tAObjects.b + "(" + tAObjects.a + ")");
        }
        this.ltrdInfoCrosshair.setValues(this.values);
        this.ltrdInfoCrosshair.setParams(this.param);
        this.ltrdInfoCrosshair.setValue(((Point2D)object).getX());
        for (TAObjects tAObjects : this.TAObjects.values()) {
            tAObjects.f.setValue(((Point2D)object).getX());
        }
    }

    @Override
    public void chartChanged(ChartChangeEvent object) {
        if (this.ltrdPriceTraceLine != null) {
            this.ltrdPriceTraceLine.setValue(this.ltrdPrice);
        }
        for (TAObjects tAObjects : this.TAObjects.values()) {
            tAObjects.e.setValue(tAObjects.g);
        }
    }

    @Override
    public void RunDemo() {
    }

    static /* synthetic */ TimeSeries access$000(PriceVolumeCombinedChart priceVolumeCombinedChart) {
        return priceVolumeCombinedChart.ltrdPriceSeries;
    }

    static /* synthetic */ TimeSeries access$100(PriceVolumeCombinedChart priceVolumeCombinedChart) {
        return priceVolumeCombinedChart.ltrdVolumeSeries;
    }
}

