/*
 * Decompiled with CFR 0.152.
 */
package jfree.custom;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jfree.custom.CustomCrosshair;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.panel.AbstractOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class CustomCrosshairOverlay
extends AbstractOverlay
implements PropertyChangeListener,
Serializable,
Cloneable,
Overlay,
PublicCloneable {
    private List xCrosshairs;
    private List yCrosshairs;
    DecimalFormat localDecimalFormat = new DecimalFormat("###,###.##");

    public CustomCrosshairOverlay() {
        this.localDecimalFormat.setMinimumFractionDigits(2);
        this.localDecimalFormat.setMaximumFractionDigits(2);
        this.xCrosshairs = new ArrayList();
        this.yCrosshairs = new ArrayList();
    }

    public void addDomainCrosshair(Crosshair crosshair) {
        if (crosshair == null) {
            throw new IllegalArgumentException("Null 'crosshair' argument.");
        }
        this.xCrosshairs.add(crosshair);
        crosshair.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void removeDomainCrosshair(Crosshair crosshair) {
        if (crosshair == null) {
            throw new IllegalArgumentException("Null 'crosshair' argument.");
        }
        if (this.xCrosshairs.remove(crosshair)) {
            crosshair.removePropertyChangeListener((PropertyChangeListener)this);
            this.fireOverlayChanged();
        }
    }

    public void clearDomainCrosshairs() {
        if (this.xCrosshairs.isEmpty()) {
            return;
        }
        List list = this.getDomainCrosshairs();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Crosshair crosshair = (Crosshair)list.get(i2);
            this.xCrosshairs.remove(crosshair);
            crosshair.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.fireOverlayChanged();
    }

    public List getDomainCrosshairs() {
        return new ArrayList(this.xCrosshairs);
    }

    public void addRangeCrosshair(Crosshair crosshair) {
        if (crosshair == null) {
            throw new IllegalArgumentException("Null 'crosshair' argument.");
        }
        this.yCrosshairs.add(crosshair);
        crosshair.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void removeRangeCrosshair(Crosshair crosshair) {
        if (crosshair == null) {
            throw new IllegalArgumentException("Null 'crosshair' argument.");
        }
        if (this.yCrosshairs.remove(crosshair)) {
            crosshair.removePropertyChangeListener((PropertyChangeListener)this);
            this.fireOverlayChanged();
        }
    }

    public void clearRangeCrosshairs() {
        if (this.yCrosshairs.isEmpty()) {
            return;
        }
        List list = this.getRangeCrosshairs();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Crosshair crosshair = (Crosshair)list.get(i2);
            this.yCrosshairs.remove(crosshair);
            crosshair.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.fireOverlayChanged();
    }

    public List getRangeCrosshairs() {
        return new ArrayList(this.yCrosshairs);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireOverlayChanged();
    }

    public void paintOverlay(Graphics2D graphics2D, ChartPanel object) {
        List list;
        CombinedDomainXYPlot combinedDomainXYPlot;
        JFreeChart jFreeChart = object.getChart();
        if (jFreeChart.getPlot() instanceof CombinedDomainXYPlot) {
            this.CombinedpaintOverlay(graphics2D, (ChartPanel)object);
            return;
        }
        Shape shape = graphics2D.getClip();
        Rectangle2D rectangle2D = object.getScreenDataArea();
        graphics2D.clip(rectangle2D);
        if (jFreeChart.getPlot() instanceof CombinedDomainXYPlot) {
            combinedDomainXYPlot = (CombinedDomainXYPlot)jFreeChart.getPlot();
            list = combinedDomainXYPlot.getSubplots();
            jFreeChart = (XYPlot)list.get(0);
            try {
                rectangle2D = object.getChartRenderingInfo().getPlotInfo().getSubplotInfo(1).getDataArea();
            }
            catch (Exception exception) {
                rectangle2D = object.getChartRenderingInfo().getPlotInfo().getSubplotInfo(0).getDataArea();
            }
        } else {
            jFreeChart = (XYPlot)jFreeChart.getPlot();
        }
        combinedDomainXYPlot = jFreeChart.getRangeAxis(0);
        list = jFreeChart.getRangeAxisEdge(0);
        for (Crosshair crosshair : this.yCrosshairs) {
            if (!crosshair.isVisible()) continue;
            double d2 = crosshair.getValue();
            double d3 = combinedDomainXYPlot.valueToJava2D(d2, rectangle2D, (RectangleEdge)list);
            if (jFreeChart.getOrientation() == PlotOrientation.VERTICAL) {
                this.drawHorizontalCrosshair(graphics2D, rectangle2D, d3, crosshair);
                continue;
            }
            this.drawVerticalCrosshair(graphics2D, rectangle2D, d3, crosshair);
        }
        graphics2D.setClip(shape);
    }

    public int getPlotIndex(XYPlot xYPlot, ChartPanel chartPanel) {
        chartPanel = chartPanel.getChart();
        chartPanel = (CombinedDomainXYPlot)chartPanel.getPlot();
        for (int i2 = 0; i2 < chartPanel.getSubplots().size(); ++i2) {
            XYPlot xYPlot2 = (XYPlot)chartPanel.getSubplots().get(i2);
            if (xYPlot2 != xYPlot) continue;
            return i2;
        }
        return 0;
    }

    public void CombinedpaintOverlay(Graphics2D graphics2D, ChartPanel chartPanel) {
        JFreeChart jFreeChart = chartPanel.getChart();
        Shape shape = graphics2D.getClip();
        Iterator iterator = this.yCrosshairs.iterator();
        Rectangle2D rectangle2D = chartPanel.getScreenDataArea();
        graphics2D.clip(rectangle2D);
        while (iterator.hasNext()) {
            Crosshair crosshair = (Crosshair)iterator.next();
            int n2 = 0;
            if (crosshair instanceof CustomCrosshair) {
                n2 = this.getPlotIndex(((CustomCrosshair)crosshair).getXYPlot(), chartPanel);
            }
            rectangle2D = chartPanel.getChartRenderingInfo().getPlotInfo().getSubplotInfo(n2).getDataArea();
            Object object = (CombinedDomainXYPlot)jFreeChart.getPlot();
            object = object.getSubplots();
            XYPlot xYPlot = (XYPlot)object.get(n2);
            object = xYPlot.getRangeAxis(0);
            RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
            if (!crosshair.isVisible()) continue;
            double d2 = crosshair.getValue();
            double d3 = object.valueToJava2D(d2, rectangle2D, rectangleEdge);
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                this.drawHorizontalCrosshair(graphics2D, rectangle2D, d3, crosshair);
                continue;
            }
            this.drawVerticalCrosshair(graphics2D, rectangle2D, d3, crosshair);
        }
        graphics2D.setClip(shape);
    }

    protected void drawHorizontalCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, double d2, Crosshair crosshair) {
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setPaint(crosshair.getPaint());
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f));
        graphics2D.draw(double_);
        graphics2D.setStroke(crosshair.getStroke());
        if (crosshair.isLabelVisible()) {
            String string = crosshair.getLabelGenerator().generateLabel(crosshair);
            try {
                string = this.localDecimalFormat.format(Double.parseDouble(string.replaceAll(",", "")));
            }
            catch (Exception exception) {}
            RectangleAnchor rectangleAnchor = crosshair.getLabelAnchor();
            Point2D point2D = CustomCrosshairOverlay.a(double_, rectangleAnchor, 2.0, 2.0);
            float f2 = (float)point2D.getX();
            float f3 = (float)point2D.getY();
            TextAnchor textAnchor = CustomCrosshairOverlay.b(rectangleAnchor);
            Shape shape = TextUtilities.calculateRotatedStringBounds((String)(" " + string + " "), (Graphics2D)graphics2D, (float)f2, (float)f3, (TextAnchor)textAnchor, (double)0.0, (TextAnchor)TextAnchor.CENTER);
            if (!rectangle2D.contains(shape.getBounds2D())) {
                rectangle2D = rectangleAnchor;
                rectangleAnchor = rectangle2D;
                if (rectangle2D.equals(RectangleAnchor.TOP_LEFT)) {
                    rectangleAnchor = RectangleAnchor.BOTTOM_LEFT;
                } else if (rectangle2D.equals(RectangleAnchor.TOP_RIGHT)) {
                    rectangleAnchor = RectangleAnchor.BOTTOM_RIGHT;
                } else if (rectangle2D.equals(RectangleAnchor.TOP)) {
                    rectangleAnchor = RectangleAnchor.BOTTOM;
                } else if (rectangle2D.equals(RectangleAnchor.BOTTOM)) {
                    rectangleAnchor = RectangleAnchor.TOP;
                } else if (rectangle2D.equals(RectangleAnchor.BOTTOM_LEFT)) {
                    rectangleAnchor = RectangleAnchor.TOP_LEFT;
                } else if (rectangle2D.equals(RectangleAnchor.BOTTOM_RIGHT)) {
                    rectangleAnchor = RectangleAnchor.TOP_RIGHT;
                }
                Point2D point2D2 = CustomCrosshairOverlay.a(double_, rectangleAnchor, 5.0, 5.0);
                f2 = (float)point2D2.getX();
                f3 = (float)point2D2.getY();
                textAnchor = CustomCrosshairOverlay.b(rectangleAnchor);
                shape = TextUtilities.calculateRotatedStringBounds((String)(" " + string + " "), (Graphics2D)graphics2D, (float)f2, (float)f3, (TextAnchor)textAnchor, (double)0.0, (TextAnchor)TextAnchor.CENTER);
            }
            graphics2D.setPaint(crosshair.getLabelBackgroundPaint());
            graphics2D.fill(shape);
            graphics2D.setPaint(crosshair.getLabelOutlinePaint());
            graphics2D.draw(shape);
            TextUtilities.drawAlignedString((String)(string + " "), (Graphics2D)graphics2D, (float)f2, (float)f3, (TextAnchor)textAnchor);
        }
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    protected void drawVerticalCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, double d2, Crosshair crosshair) {
        if (d2 >= rectangle2D.getMinX() && d2 <= rectangle2D.getMaxX()) {
            Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setPaint(crosshair.getPaint());
            graphics2D.setStroke(crosshair.getStroke());
            graphics2D.draw(double_);
            if (crosshair.isLabelVisible()) {
                TextAnchor textAnchor;
                float f2;
                RectangleAnchor rectangleAnchor;
                Point2D point2D;
                float f3;
                Shape shape;
                String string = crosshair.getLabelGenerator().generateLabel(crosshair);
                if (crosshair instanceof CustomCrosshair) {
                    string = ((CustomCrosshair)crosshair).getCustomValue();
                }
                if (!rectangle2D.contains((shape = TextUtilities.calculateRotatedStringBounds((String)string, (Graphics2D)graphics2D, (float)(f3 = (float)(point2D = CustomCrosshairOverlay.a(double_, rectangleAnchor = crosshair.getLabelAnchor(), 5.0, 5.0)).getX()), (float)(f2 = (float)point2D.getY()), (TextAnchor)(textAnchor = CustomCrosshairOverlay.a(rectangleAnchor)), (double)0.0, (TextAnchor)TextAnchor.CENTER)).getBounds2D())) {
                    rectangle2D = rectangleAnchor;
                    rectangleAnchor = rectangle2D;
                    if (rectangle2D.equals(RectangleAnchor.TOP_LEFT)) {
                        rectangleAnchor = RectangleAnchor.TOP_RIGHT;
                    } else if (rectangle2D.equals(RectangleAnchor.TOP_RIGHT)) {
                        rectangleAnchor = RectangleAnchor.TOP_LEFT;
                    } else if (rectangle2D.equals(RectangleAnchor.LEFT)) {
                        rectangleAnchor = RectangleAnchor.RIGHT;
                    } else if (rectangle2D.equals(RectangleAnchor.RIGHT)) {
                        rectangleAnchor = RectangleAnchor.LEFT;
                    } else if (rectangle2D.equals(RectangleAnchor.BOTTOM_LEFT)) {
                        rectangleAnchor = RectangleAnchor.BOTTOM_RIGHT;
                    } else if (rectangle2D.equals(RectangleAnchor.BOTTOM_RIGHT)) {
                        rectangleAnchor = RectangleAnchor.BOTTOM_LEFT;
                    }
                    Point2D point2D2 = CustomCrosshairOverlay.a(double_, rectangleAnchor, 5.0, 5.0);
                    f3 = (float)point2D2.getX();
                    f2 = (float)point2D2.getY();
                    textAnchor = CustomCrosshairOverlay.a(rectangleAnchor);
                    shape = TextUtilities.calculateRotatedStringBounds((String)string, (Graphics2D)graphics2D, (float)f3, (float)f2, (TextAnchor)textAnchor, (double)0.0, (TextAnchor)TextAnchor.CENTER);
                }
                graphics2D.setPaint(crosshair.getLabelBackgroundPaint());
                graphics2D.fill(shape);
                graphics2D.setPaint(crosshair.getLabelOutlinePaint());
                graphics2D.draw(shape);
                TextUtilities.drawAlignedString((String)string, (Graphics2D)graphics2D, (float)f3, (float)f2, (TextAnchor)textAnchor);
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
    }

    private static Point2D a(Line2D line2D, RectangleAnchor rectangleAnchor, double d2, double d3) {
        double d4;
        double d5;
        boolean bl = rectangleAnchor == RectangleAnchor.BOTTOM_LEFT || rectangleAnchor == RectangleAnchor.LEFT || rectangleAnchor == RectangleAnchor.TOP_LEFT;
        boolean bl2 = rectangleAnchor == RectangleAnchor.BOTTOM_RIGHT || rectangleAnchor == RectangleAnchor.RIGHT || rectangleAnchor == RectangleAnchor.TOP_RIGHT;
        boolean bl3 = rectangleAnchor == RectangleAnchor.TOP_LEFT || rectangleAnchor == RectangleAnchor.TOP || rectangleAnchor == RectangleAnchor.TOP_RIGHT;
        boolean bl4 = rectangleAnchor == RectangleAnchor.BOTTOM_LEFT || rectangleAnchor == RectangleAnchor.BOTTOM || rectangleAnchor == RectangleAnchor.BOTTOM_RIGHT;
        Rectangle rectangle = line2D.getBounds();
        RectangleAnchor.coordinates((Rectangle2D)rectangle, (RectangleAnchor)rectangleAnchor);
        if (line2D.getX1() == line2D.getX2()) {
            d5 = line2D.getX1();
            d4 = (line2D.getY1() + line2D.getY2()) / 2.0;
            if (bl) {
                d5 -= d2;
            }
            if (bl2) {
                d5 += d2;
            }
            if (bl3) {
                d4 = Math.min(line2D.getY1(), line2D.getY2()) + d3;
            }
            if (bl4) {
                d4 = Math.max(line2D.getY1(), line2D.getY2()) - d3;
            }
        } else {
            d5 = (line2D.getX1() + line2D.getX2()) / 2.0;
            d4 = line2D.getY1();
            if (bl) {
                d5 = Math.min(line2D.getX1(), line2D.getX2()) + d2;
            }
            if (bl2) {
                d5 = Math.max(line2D.getX1(), line2D.getX2()) - d2;
            }
            if (bl3) {
                d4 -= d3;
            }
            if (bl4) {
                d4 += d3;
            }
        }
        return new Point2D.Double(d5, d4);
    }

    private static TextAnchor a(RectangleAnchor rectangleAnchor) {
        TextAnchor textAnchor = TextAnchor.CENTER;
        if (rectangleAnchor.equals((Object)RectangleAnchor.TOP_LEFT)) {
            textAnchor = TextAnchor.TOP_RIGHT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.TOP)) {
            textAnchor = TextAnchor.TOP_CENTER;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.TOP_RIGHT)) {
            textAnchor = TextAnchor.TOP_LEFT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.LEFT)) {
            textAnchor = TextAnchor.HALF_ASCENT_RIGHT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.RIGHT)) {
            textAnchor = TextAnchor.HALF_ASCENT_LEFT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.BOTTOM_LEFT)) {
            textAnchor = TextAnchor.BOTTOM_RIGHT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.BOTTOM)) {
            textAnchor = TextAnchor.BOTTOM_CENTER;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.BOTTOM_RIGHT)) {
            textAnchor = TextAnchor.BOTTOM_LEFT;
        }
        return textAnchor;
    }

    private static TextAnchor b(RectangleAnchor rectangleAnchor) {
        TextAnchor textAnchor = TextAnchor.CENTER;
        if (rectangleAnchor.equals((Object)RectangleAnchor.TOP_LEFT)) {
            textAnchor = TextAnchor.BOTTOM_LEFT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.TOP)) {
            textAnchor = TextAnchor.BOTTOM_CENTER;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.TOP_RIGHT)) {
            textAnchor = TextAnchor.BOTTOM_RIGHT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.LEFT)) {
            textAnchor = TextAnchor.HALF_ASCENT_LEFT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.RIGHT)) {
            textAnchor = TextAnchor.HALF_ASCENT_RIGHT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.BOTTOM_LEFT)) {
            textAnchor = TextAnchor.TOP_LEFT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.BOTTOM)) {
            textAnchor = TextAnchor.TOP_CENTER;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.BOTTOM_RIGHT)) {
            textAnchor = TextAnchor.TOP_RIGHT;
        }
        return textAnchor;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CustomCrosshairOverlay)) {
            return false;
        }
        object = (CustomCrosshairOverlay)object;
        if (!((Object)this.xCrosshairs).equals(((CustomCrosshairOverlay)object).xCrosshairs)) {
            return false;
        }
        return ((Object)this.yCrosshairs).equals(((CustomCrosshairOverlay)object).yCrosshairs);
    }

    public Object clone() {
        CustomCrosshairOverlay customCrosshairOverlay = (CustomCrosshairOverlay)super.clone();
        ((CustomCrosshairOverlay)super.clone()).xCrosshairs = (List)ObjectUtilities.deepClone((Collection)this.xCrosshairs);
        customCrosshairOverlay.yCrosshairs = (List)ObjectUtilities.deepClone((Collection)this.yCrosshairs);
        return customCrosshairOverlay;
    }
}

