/*
 * Decompiled with CFR 0.152.
 */
package jfree.custom;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jfree.custom.CustomCrosshairOverlay;
import jfree.custom.InfoBoxCrosshair;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.panel.AbstractOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class InformationCrosshairOverlay
extends AbstractOverlay
implements PropertyChangeListener,
Serializable,
Cloneable,
Overlay,
PublicCloneable {
    private List infoCrosshairs = new ArrayList();

    public void addInfoCrosshair(Crosshair crosshair) {
        if (crosshair == null) {
            throw new IllegalArgumentException("Null 'crosshair' argument.");
        }
        this.infoCrosshairs.add(crosshair);
        crosshair.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void removeInfoCrosshair(Crosshair crosshair) {
        if (crosshair == null) {
            throw new IllegalArgumentException("Null 'crosshair' argument.");
        }
        if (this.infoCrosshairs.remove(crosshair)) {
            crosshair.removePropertyChangeListener((PropertyChangeListener)this);
            this.fireOverlayChanged();
        }
    }

    public void clearDomainCrosshairs() {
        if (this.infoCrosshairs.isEmpty()) {
            return;
        }
        List list = this.getInfoCrosshairs();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Crosshair crosshair = (Crosshair)list.get(i2);
            this.infoCrosshairs.remove(crosshair);
            crosshair.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.fireOverlayChanged();
    }

    public List getInfoCrosshairs() {
        return new ArrayList(this.infoCrosshairs);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireOverlayChanged();
    }

    public void paintOverlay(Graphics2D graphics2D, ChartPanel chartPanel) {
        Shape shape = graphics2D.getClip();
        Rectangle2D rectangle2D = chartPanel.getScreenDataArea();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() - 20.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        graphics2D.clip(double_);
        chartPanel = chartPanel.getChart();
        chartPanel = (XYPlot)chartPanel.getPlot();
        ValueAxis valueAxis = chartPanel.getDomainAxis();
        RectangleEdge rectangleEdge = chartPanel.getDomainAxisEdge();
        for (Crosshair crosshair : this.infoCrosshairs) {
            if (!crosshair.isVisible()) continue;
            double d2 = crosshair.getValue();
            double d3 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
            System.out.println("PaintOverLay" + d2);
            if (chartPanel.getOrientation() != PlotOrientation.VERTICAL) continue;
            this.drawVerticalCrosshair(graphics2D, double_, d3, crosshair);
        }
        graphics2D.setClip(shape);
    }

    protected void drawVerticalCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, double d2, Crosshair crosshair) {
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setPaint(crosshair.getPaint());
        graphics2D.setStroke(crosshair.getStroke());
        String string = "OHLC";
        if (crosshair instanceof InfoBoxCrosshair) {
            string = "aaa";
        }
        RectangleAnchor rectangleAnchor = crosshair.getLabelAnchor();
        float f2 = (float)rectangle2D.getMinX();
        float f3 = (float)rectangle2D.getMinY();
        Object object = TextAnchor.CENTER;
        if (rectangleAnchor.equals((Object)RectangleAnchor.TOP_LEFT)) {
            object = TextAnchor.TOP_RIGHT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.TOP)) {
            object = TextAnchor.TOP_CENTER;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.TOP_RIGHT)) {
            object = TextAnchor.TOP_LEFT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.LEFT)) {
            object = TextAnchor.HALF_ASCENT_RIGHT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.RIGHT)) {
            object = TextAnchor.HALF_ASCENT_LEFT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.BOTTOM_LEFT)) {
            object = TextAnchor.BOTTOM_RIGHT;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.BOTTOM)) {
            object = TextAnchor.BOTTOM_CENTER;
        } else if (rectangleAnchor.equals((Object)RectangleAnchor.BOTTOM_RIGHT)) {
            object = TextAnchor.BOTTOM_LEFT;
        }
        rectangleAnchor = object;
        object = TextUtilities.calculateRotatedStringBounds((String)string, (Graphics2D)graphics2D, (float)f2, (float)f3, (TextAnchor)rectangleAnchor, (double)0.0, (TextAnchor)TextAnchor.CENTER);
        graphics2D.setPaint(crosshair.getLabelBackgroundPaint());
        graphics2D.fill((Shape)object);
        graphics2D.setPaint(crosshair.getLabelOutlinePaint());
        graphics2D.draw((Shape)object);
        TextUtilities.drawAlignedString((String)string, (Graphics2D)graphics2D, (float)f2, (float)f3, (TextAnchor)rectangleAnchor);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CustomCrosshairOverlay)) {
            return false;
        }
        object = (InformationCrosshairOverlay)object;
        return ((Object)this.infoCrosshairs).equals(((InformationCrosshairOverlay)object).infoCrosshairs);
    }

    public Object clone() {
        InformationCrosshairOverlay informationCrosshairOverlay = (InformationCrosshairOverlay)super.clone();
        ((InformationCrosshairOverlay)super.clone()).infoCrosshairs = (List)ObjectUtilities.deepClone((Collection)this.infoCrosshairs);
        return informationCrosshairOverlay;
    }
}

