/*
 * Decompiled with CFR 0.152.
 */
package common.gui.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;

public class CustomSliderUI
extends BasicSliderUI {
    private BasicStroke stroke = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{1.0f, 2.0f}, 1.0f);

    public CustomSliderUI(JSlider b) {
        super(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(g, c);
    }

    @Override
    protected Dimension getThumbSize() {
        return new Dimension(12, 16);
    }

    @Override
    public void paintTrack(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Stroke old = g2d.getStroke();
        g2d.setStroke(this.stroke);
        g2d.setPaint(Color.BLACK);
        if (this.slider.getOrientation() == 0) {
            g2d.drawLine(this.trackRect.x, this.trackRect.y + this.trackRect.height / 2, this.trackRect.x + this.trackRect.width, this.trackRect.y + this.trackRect.height / 2);
        } else {
            g2d.drawLine(this.trackRect.x + this.trackRect.width / 2, this.trackRect.y, this.trackRect.x + this.trackRect.width / 2, this.trackRect.y + this.trackRect.height);
        }
        g2d.setStroke(old);
    }

    @Override
    public void paintThumb(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int x1 = this.thumbRect.x + 2;
        int x2 = this.thumbRect.x + this.thumbRect.width - 2;
        int width = this.thumbRect.width - 4;
        int topY = this.thumbRect.y + this.thumbRect.height / 2 - this.thumbRect.width / 3;
        GeneralPath shape = new GeneralPath(0);
        shape.moveTo(x1, topY);
        shape.lineTo(x2, topY);
        shape.lineTo((x1 + x2) / 2, topY + width);
        shape.closePath();
        g2d.setPaint(new Color(81, 83, 186));
        g2d.fill(shape);
        Stroke old = g2d.getStroke();
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setPaint(new Color(131, 127, 211));
        g2d.draw(shape);
        g2d.setStroke(old);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JSlider slider = new JSlider(0, 100);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setMinorTickSpacing(5);
        slider.setMajorTickSpacing(25);
        slider.setUI(new CustomSliderUI(slider));
        frame.add(slider);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }
}

