/*
 * Decompiled with CFR 0.152.
 */
package common.gui.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.GroupLayout;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.color.ColorUtil;

public class NxGRoundedPanel
extends JXPanel {
    private int strokeSize = 1;
    private boolean shady = true;
    private boolean highQuality = true;
    private Dimension arcs = new Dimension(5, 5);
    private int shadowGap = 5;
    private int shadowOffset = 4;
    private int shadowAlpha = 150;
    private Color startShadow = Color.LIGHT_GRAY;
    private Color endShadow = Color.DARK_GRAY;

    public NxGRoundedPanel() {
        this.initComponents();
        this.setBackground(Color.WHITE);
    }

    private void initComponents() {
        this.setBackground(new Color(255, 204, 204));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D graphics = (Graphics2D)g;
        if (this.highQuality) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.shady) {
            Graphics2D g2 = (Graphics2D)g;
            GradientPaint painter = new GradientPaint(0.0f, 0.0f, this.startShadow, 0.0f, width * 3 / 2, this.endShadow);
            g2.setPaint(painter);
            g2.fillRoundRect(this.shadowOffset, this.shadowOffset, width - this.strokeSize - this.shadowOffset, height - this.strokeSize - this.shadowOffset, this.arcs.width, this.arcs.height);
        } else {
            this.shadowGap = 1;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRoundRect(0, 0, width - this.shadowGap, height - this.shadowGap, this.arcs.width, this.arcs.height);
        graphics.setColor(this.getForeground());
        graphics.setStroke(new BasicStroke(this.strokeSize));
        graphics.drawRoundRect(0, 0, width - this.shadowGap, height - this.shadowGap, this.arcs.width, this.arcs.height);
        graphics.setStroke(new BasicStroke());
    }

    public int getStrokeSize() {
        return this.strokeSize;
    }

    public void setStrokeSize(int strokeSize) {
        this.strokeSize = strokeSize;
    }

    public boolean isShady() {
        return this.shady;
    }

    public void setShady(boolean shady) {
        this.shady = shady;
    }

    public boolean isHighQuality() {
        return this.highQuality;
    }

    public void setHighQuality(boolean highQuality) {
        this.highQuality = highQuality;
    }

    public Dimension getArcs() {
        return this.arcs;
    }

    public void setArcs(Dimension arcs) {
        this.arcs = arcs;
    }

    public int getShadowGap() {
        return this.shadowGap;
    }

    public void setShadowGap(int shadowGap) {
        this.shadowGap = shadowGap;
    }

    public int getShadowOffset() {
        return this.shadowOffset;
    }

    public void setShadowOffset(int shadowOffset) {
        this.shadowOffset = shadowOffset;
    }

    public int getShadowAlpha() {
        return this.shadowAlpha;
    }

    public void removeShadowAlpha() {
        this.startShadow = ColorUtil.removeAlpha((Color)this.startShadow);
        this.endShadow = ColorUtil.removeAlpha((Color)this.endShadow);
    }

    public void setShadowAlpha(int shadowAlpha) {
        this.startShadow = ColorUtil.setAlpha((Color)this.startShadow, (int)shadowAlpha);
        this.endShadow = ColorUtil.setAlpha((Color)this.endShadow, (int)shadowAlpha);
        this.shadowAlpha = shadowAlpha;
    }

    public Color getStartShadow() {
        return this.startShadow;
    }

    public void setStartShadow(Color startShadow) {
        this.startShadow = startShadow;
    }

    public Color getEndShadow() {
        return this.endShadow;
    }

    public void setEndShadow(Color endShadow) {
        this.endShadow = endShadow;
    }
}

