/*
 * Decompiled with CFR 0.152.
 */
package common.gui.component;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import javax.swing.JTextField;

public class NxGTextFieldGradient
extends JTextField {
    Color start = Color.PINK;
    Color end = Color.PINK.brighter().brighter().brighter();
    private boolean isLinearGradient = true;

    @Override
    public void paint(Graphics g) {
        if (!this.isLinearGradient) {
            this.setOpaque(false);
            int width = this.getWidth();
            int height = this.getHeight();
            GradientPaint paint = new GradientPaint(0.0f, height, this.start, 0.0f, 0.0f, this.end, false);
            Graphics2D g2d = (Graphics2D)g;
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, width, height);
            g2d.setPaint(oldPaint);
            super.paint(g);
        } else {
            this.setOpaque(false);
            Graphics2D g2 = (Graphics2D)g;
            int height = this.getHeight();
            int width = this.getWidth();
            GradientPaint painter = new GradientPaint(0.0f, 0.0f, this.end, 0.0f, height / 2, this.start);
            g2.setPaint(painter);
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, (double)height / 2.0);
            g2.fill(rect);
            painter = new GradientPaint(0.0f, height / 2, this.start, 0.0f, height, this.end);
            g2.setPaint(painter);
            rect = new Rectangle2D.Double(0.0, (double)height / 2.0 - 1.0, width, height);
            g2.fill(rect);
            super.paint(g);
        }
    }

    @Override
    public void setBackground(Color bg) {
        this.setGradient(bg, bg);
    }

    public void setGradient(Color start, Color end) {
        this.start = start;
        this.end = end;
    }
}

