/*
 * Decompiled with CFR 0.152.
 */
package common.gui.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalSliderUI;

class SpecialSliderUI
extends MetalSliderUI {
    private static final float[] fractions = new float[]{0.0f, 0.5f};
    private static final Color[] fillColors = new Color[]{new Color(2525102), new Color(1464494)};
    private static final Color[] backColors = new Color[]{new Color(8159629), new Color(5725288)};
    private static final Paint hFillGradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, 11.0f, fractions, fillColors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
    private static final Paint hBackGradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, 11.0f, fractions, backColors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
    private static final Paint vFillGradient = new LinearGradientPaint(0.0f, 0.0f, 11.0f, 0.0f, fractions, fillColors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
    private static final Paint vBackGradient = new LinearGradientPaint(0.0f, 0.0f, 11.0f, 0.0f, fractions, backColors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
    private static final Stroke roundEndStroke = new BasicStroke(8.0f, 1, 1);

    SpecialSliderUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new SpecialSliderUI();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        if (this.slider.getOrientation() == 0) {
            d.height += 10;
        } else {
            d.width += 10;
        }
        return d;
    }

    @Override
    public void paintTrack(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.slider.getOrientation() == 0) {
            int cy = this.trackRect.height / 2 - 2;
            g.translate(this.trackRect.x, this.trackRect.y + cy);
            g2.setStroke(roundEndStroke);
            g2.setPaint(hBackGradient);
            g2.drawLine(this.thumbRect.x, 2, this.trackRect.width, 2);
            g2.setPaint(hFillGradient);
            g2.drawLine(0, 2, this.thumbRect.x, 2);
            g.translate(-this.trackRect.x, -(this.trackRect.y + cy));
        } else {
            int cx = this.trackRect.width / 2 - 2;
            g.translate(this.trackRect.x + cx, this.trackRect.y);
            g2.setStroke(roundEndStroke);
            g2.setPaint(vBackGradient);
            g2.drawLine(2, 0, 2, this.thumbRect.y);
            g2.setPaint(vFillGradient);
            g2.drawLine(2, this.thumbRect.y, 2, this.trackRect.height);
            g.translate(-(this.trackRect.x + cx), -this.trackRect.y);
        }
    }
}

