/*
 * Decompiled with CFR 0.152.
 */
package common.gui.render;

import common.gui.util.ImageUtil;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CheckBoxHeader
extends JCheckBox
implements TableCellRenderer {
    protected CheckBoxHeader rendererComponent;
    private final String columnName;

    public CheckBoxHeader(JTableHeader header, int targetColumnIndex, String columnName) {
        this.setSelected(true);
        this.columnName = columnName;
        this.setOpaque(false);
        this.setFont(header.getFont());
        this.setMouseEvent(header, targetColumnIndex, columnName);
    }

    private void setMouseEvent(JTableHeader header, final int targetColumnIndex, final String columnName) {
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel;
                int vci;
                JTableHeader header = (JTableHeader)e.getSource();
                JTable table = header.getTable();
                int mci = table.convertColumnIndexToModel(vci = (columnModel = table.getColumnModel()).getColumnIndexAtX(e.getX()));
                if (mci == targetColumnIndex) {
                    TableColumn column = columnModel.getColumn(vci);
                    Object val = column.getHeaderValue();
                    boolean b = true;
                    if (val instanceof String) {
                        int withoutSpace;
                        int withSpace = val.toString().length();
                        b = withSpace == (withoutSpace = val.toString().trim().length());
                    } else {
                        CheckBoxHeader.this.setSelected(true);
                    }
                    System.out.println("b  = " + b);
                    if (b) {
                        CheckBoxHeader.this.setSelected(false);
                        column.setHeaderValue(columnName + " ");
                    } else {
                        CheckBoxHeader.this.setSelected(true);
                        column.setHeaderValue(columnName);
                    }
                    header.repaint();
                }
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable tbl, Object val, boolean isS, boolean hasF, int row, int col) {
        TableCellRenderer r = tbl.getTableHeader().getDefaultRenderer();
        JLabel l = (JLabel)r.getTableCellRendererComponent(tbl, this.columnName, isS, hasF, row, col);
        l.setIcon(ImageUtil.MakeIconOfComponent(this));
        return l;
    }
}

