/*
 * Decompiled with CFR 0.152.
 */
package common.gui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ImageUtil {
    public static BufferedImage createImage(JComponent component, int imageType) {
        Dimension componentSize = component.getPreferredSize();
        component.setDoubleBuffered(false);
        component.setSize(componentSize);
        component.addNotify();
        component.validate();
        BufferedImage img = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(component.getSize().width, component.getSize().height);
        Graphics2D grap = img.createGraphics();
        grap.setColor(Color.WHITE);
        grap.fillRect(0, 0, img.getWidth(), img.getHeight());
        component.print(grap);
        grap.dispose();
        return img;
    }

    public static Icon MakeIconOfComponent(JComponent comp) {
        return new MakeIconOfComponent(comp);
    }

    public static BufferedImage downloadImage(String path) {
        BufferedImage image1 = null;
        try {
            URL url = new URL(path);
            image1 = ImageIO.read(url);
        }
        catch (Exception ex) {
            System.out.println("can not read Image: " + path);
            System.out.println(ex.getMessage());
        }
        return image1;
    }

    private static class MakeIconOfComponent
    implements Icon {
        private final JComponent comp;

        public MakeIconOfComponent(JComponent comp) {
            this.comp = comp;
        }

        @Override
        public int getIconWidth() {
            return this.comp.getPreferredSize().width;
        }

        @Override
        public int getIconHeight() {
            return this.comp.getPreferredSize().height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            SwingUtilities.paintComponent(g, this.comp, (Container)c, x, y, this.getIconWidth(), this.getIconHeight());
        }
    }
}

