/*
 * Decompiled with CFR 0.152.
 */
package common.gui.windows;

import common.gui.util.LogCommon;
import common.gui.util.Util;
import common.gui.windows.render.MBODetailRender;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class MBODetail
extends JPanel {
    private final JTable ownerTable;
    private boolean isFigureFormat = true;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JLabel lblSpace;
    private JScrollPane scrollPane;
    private JTable table;

    public MBODetail(boolean isMBO, boolean isFigureFormat, JTable tbl) {
        this.initComponents();
        this.ownerTable = tbl;
        this.isFigureFormat = isFigureFormat;
        this.table.setTableHeader(null);
        this.table.setDefaultRenderer(Object.class, new MBODetailRender(isMBO));
        this.table.setOpaque(false);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.setLanguageValues();
        this.Refresh();
    }

    public void changeMargin(int space) {
        if (space == 0) {
            this.lblSpace.setVisible(false);
        } else if (this.table.getRowHeight() > 19) {
            this.lblSpace.setVisible(false);
        } else {
            this.lblSpace.setMaximumSize(new Dimension(space, space));
            this.lblSpace.setVisible(true);
        }
        for (int i = 0; i < this.ownerTable.getColumnCount(); ++i) {
            int width = this.ownerTable.getColumn(this.ownerTable.getColumnName(i)).getPreferredWidth();
            this.table.getColumn(this.table.getColumnName(i)).setPreferredWidth(width);
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.table = new MyJTable();
        this.lblSpace = new JLabel();
        this.scrollPane.setBorder(null);
        this.table.setModel(new DefaultTableModel(new Object[][]{{" ", " ", " ", " ", " ", " "}, {"Lower Lock", "Tot. Vol.", "Avg. Prc.", "Avg. Prc.", "Tot. Vol.", "Upper Cap"}}, new String[]{"Flag", "Volume", "Price", "Price2", "Volume2", "Flag2"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.setFocusable(false);
        this.table.getTableHeader().setResizingAllowed(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.scrollPane.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.scrollPane, -1, 226, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.lblSpace)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblSpace, -2, 15, -2).addContainerGap(24, Short.MAX_VALUE)).addComponent(this.scrollPane, -1, 39, Short.MAX_VALUE));
    }

    public void setValues(double upperCap, double lowerLock, double buyVolTot, double selVolTot, double buyPriceTot, double selPriceTot) {
        if (this.isFigureFormat) {
            this.table.setValueAt(Util.format2digit(lowerLock + "") + " ", 0, 0);
            this.table.setValueAt(Util.format0digit(buyVolTot + "") + " ", 0, 1);
            this.table.setValueAt(Util.format2digit(buyPriceTot / buyVolTot + "") + " ", 0, 2);
            this.table.setValueAt(Util.format2digit(selPriceTot / selVolTot + "") + " ", 0, 3);
            this.table.setValueAt(Util.format0digit(selVolTot + "") + " ", 0, 4);
            this.table.setValueAt(Util.format2digit(upperCap + "") + " ", 0, 5);
        } else {
            this.table.setValueAt(Util.format2digit(lowerLock + "") + " ", 0, 0);
            this.table.setValueAt(Util.format0digit(buyVolTot + "") + " ", 0, 1);
            this.table.setValueAt(Util.format2digit(buyPriceTot / buyVolTot + "") + " ", 0, 2);
            this.table.setValueAt(Util.format2digit(selPriceTot / selVolTot + "") + " ", 0, 3);
            this.table.setValueAt(Util.format0digit(selVolTot + "") + " ", 0, 4);
            this.table.setValueAt(Util.format2digit(upperCap + "") + " ", 0, 5);
        }
    }

    public void Refresh() {
        int fontHeight = this.getFontMetrics(LogCommon.MarketDepthFont).getHeight();
        if (fontHeight <= 18) {
            this.table.setRowHeight(18);
        } else {
            this.table.setRowHeight(fontHeight);
        }
        this.table.updateUI();
    }

    public void setDetailEmpty() {
        this.table.setValueAt("", 0, 0);
        this.table.setValueAt("", 0, 1);
        this.table.setValueAt("", 0, 2);
        this.table.setValueAt("", 0, 3);
        this.table.setValueAt("", 0, 4);
        this.table.setValueAt("", 0, 5);
    }

    private void setLanguageValues() {
        this.table.setValueAt(this.languageCentre.getValue(LanguageConstant.LowerLock), 1, 0);
        this.table.setValueAt(this.languageCentre.getValue(LanguageConstant.TotVol), 1, 1);
        this.table.setValueAt(this.languageCentre.getValue(LanguageConstant.AvgPrc), 1, 2);
        this.table.setValueAt(this.languageCentre.getValue(LanguageConstant.AvgPrc), 1, 3);
        this.table.setValueAt(this.languageCentre.getValue(LanguageConstant.TotVol), 1, 4);
        this.table.setValueAt(this.languageCentre.getValue(LanguageConstant.UpperCap), 1, 5);
    }

    private class MyJTable
    extends JTable {
        private MyJTable() {
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            if (c instanceof JComponent) {
                ((JComponent)c).setOpaque(true);
            }
            return c;
        }
    }
}

