/*
 * Decompiled with CFR 0.152.
 */
package CATALYST.Control;

import CATALYST.Control.ColoredTableCellRenderer;
import CATALYST.Control.ColumnData;
import CATALYST.Control.MarketWatch;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.table.TableColumn;

public class AddRemoveActionListener
implements ActionListener {
    private final MarketWatch marketWatch;

    public AddRemoveActionListener(MarketWatch marketWatch) {
        this.marketWatch = marketWatch;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object ob = e.getSource();
        if (ob instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem menu = (JCheckBoxMenuItem)ob;
            this.addRemoveColumn(menu);
        }
    }

    private ColumnData getColumnData(String columnName) {
        for (int i = 0; i < this.marketWatch.m_data.m_columns.length; ++i) {
            ColumnData columnData = this.marketWatch.m_data.m_columns[i];
            if (!columnData.m_title.equalsIgnoreCase(columnName)) continue;
            return columnData;
        }
        return null;
    }

    private void addRemoveColumn(JCheckBoxMenuItem menu) {
        try {
            ColumnData columnData = this.getColumnData(menu.getText());
            if (menu.isSelected()) {
                if (columnData != null) {
                    ColoredTableCellRenderer renderer = new ColoredTableCellRenderer(this.marketWatch, columnData);
                    renderer.setHorizontalAlignment(columnData.m_alignment);
                    int index = this.marketWatch.columnIndex.get(menu.getText());
                    TableColumn column = new TableColumn(index, columnData.m_width - 9, renderer, null);
                    column.setIdentifier(menu.getText());
                    this.marketWatch.m_table.addColumn(column);
                    this.marketWatch.m_table.moveColumn(this.marketWatch.m_table.getColumnCount() - 1, index);
                    this.marketWatch.m_table.getTableHeader().addNotify();
                    this.marketWatch.m_table.getTableHeader().repaint();
                    this.marketWatch.m_table.repaint();
                }
            } else if (columnData != null) {
                this.marketWatch.m_table.removeColumn(this.marketWatch.m_table.getColumn(menu.getText()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.marketWatch.setColumnMenuSelectAllState();
    }
}

