/*
 * Decompiled with CFR 0.152.
 */
package CATALYST.Control;

import CATALYST.Control.BackColor;
import CATALYST.Control.Fraction;
import CATALYST.Control.MarketWatch;
import java.awt.Color;
import java.text.DecimalFormat;

public class ColorData
extends BackColor {
    public boolean selected = false;
    static Double reserveVal = new Double(-9999.0);
    public Color m_backcolor = Color.WHITE;
    public Color m_color = Color.BLACK;
    public Object m_data;
    public static Color GREEN = new Color(0, 128, 0);
    public static Color RED = Color.red;
    public static final DecimalFormat KSE_Digit_Format = new DecimalFormat("###,###.##");
    public static final DecimalFormat PMEX_Digit_Format = new DecimalFormat("###,###.####");
    private MarketWatch marketWatch2;

    public ColorData(MarketWatch marketWatch, Fraction data) {
        super(marketWatch);
        this.marketWatch2 = marketWatch;
        this.m_data = this.m_data == null ? data : data;
    }

    public ColorData(MarketWatch marketWatch, Color color, Object data) {
        super(marketWatch);
        this.marketWatch2 = marketWatch;
        this.m_color = color;
        this.m_data = data;
    }

    public ColorData(MarketWatch marketWatch, Double data) {
        super(marketWatch);
        this.marketWatch2 = marketWatch;
        this.m_data = this.m_data == null ? data : data;
    }

    public void setvalue_for_ChangeBG_Item(Double data, Color back, Color fore) {
        if (data == -9999.0) {
            this.m_color = Color.BLACK;
            this.m_data = reserveVal;
            this.m_backcolor = Color.WHITE;
            this.bgcolor = back;
            this.fgcolor = fore;
        } else if (data == 0.0) {
            this.m_color = fore;
            this.m_data = data;
            this.m_backcolor = back;
            this.bgcolor = back;
            this.fgcolor = fore;
        } else {
            this.m_color = fore;
            this.m_data = data;
            this.m_backcolor = back;
            this.bgcolor = back;
            this.fgcolor = fore;
        }
    }

    public void setvalue_for_normalBG_Item(Double data, Color back, Color fore) {
        if (data == -9999.0) {
            this.m_color = Color.BLACK;
            this.m_data = reserveVal;
            this.m_backcolor = Color.WHITE;
            this.bgcolor = back;
            this.fgcolor = fore;
        } else if (data == 0.0) {
            this.m_color = fore;
            this.m_data = "";
            this.m_backcolor = back;
            this.bgcolor = back;
            this.fgcolor = fore;
        } else {
            this.m_color = fore;
            this.m_data = data;
            this.m_backcolor = back;
            this.bgcolor = back;
            this.fgcolor = fore;
        }
    }

    public void setvalue_for_normalBG_Item(String data, Color back, Color fore) {
        this.m_color = fore;
        this.m_data = data;
        this.m_backcolor = back;
        this.bgcolor = back;
        this.fgcolor = fore;
    }

    public void setvalue(Double data, Color back, Color fore) {
        if (data == -9999.0 || data == 0.0) {
            if (this.getValueDouble() > 0.0) {
                this.m_color = Color.BLACK;
                this.m_data = reserveVal;
                this.m_backcolor = Color.WHITE;
                this.bgcolor = this.marketWatch2.myfont.getcellcolorbg();
                this.fgcolor = this.marketWatch2.myfont.getcellcolorfg();
            } else {
                this.m_color = Color.BLACK;
                this.m_data = reserveVal;
                this.m_backcolor = Color.WHITE;
                this.bgcolor = this.marketWatch2.myfont.getcellcolorbg();
                this.fgcolor = this.marketWatch2.myfont.getcellcolorfg();
            }
        } else {
            this.m_color = fore;
            this.m_data = data;
            this.m_backcolor = back;
            this.bgcolor = back;
            this.fgcolor = fore;
        }
    }

    public Double getValueDouble() {
        return (Double)this.m_data;
    }

    public Object getValueObject() {
        return this.m_data;
    }

    public String gettext() {
        if (this.getValueDouble().toString().compareTo(reserveVal.toString()) == 0) {
            return "";
        }
        return KSE_Digit_Format.format(this.m_data);
    }

    public void selected(boolean isselected) {
        this.selected = isselected;
        this.hasfocus = isselected;
    }

    public String toString() {
        if (this.m_data instanceof Double) {
            if (this.getValueDouble().toString().compareTo(reserveVal.toString()) == 0) {
                return "";
            }
            if (this.marketWatch2.isKSEWatch()) {
                return KSE_Digit_Format.format(this.m_data);
            }
            return PMEX_Digit_Format.format(this.m_data);
        }
        return this.m_data.toString();
    }

    static {
        KSE_Digit_Format.setMinimumFractionDigits(2);
        KSE_Digit_Format.setMaximumFractionDigits(2);
        PMEX_Digit_Format.setMinimumFractionDigits(0);
        PMEX_Digit_Format.setMaximumFractionDigits(4);
    }
}

