/*
 * Decompiled with CFR 0.152.
 */
package CATALYST.Control;

import CATALYST.Control.BackColor;
import CATALYST.Control.ColumnData;
import CATALYST.Control.IconData;
import CATALYST.Control.MarketWatch;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ColoredTableCellRenderer
extends DefaultTableCellRenderer {
    public ColumnData columnData;
    ImageIcon upimg = null;
    ImageIcon downimg = null;
    ImageIcon levelimg = null;
    public int selectedRow;
    private MarketWatch marketWatch;

    public ColumnData getcolumndata() {
        return this.columnData;
    }

    public ColoredTableCellRenderer(MarketWatch marketWatch, ColumnData obj) {
        super.setVerticalTextPosition(0);
        this.setVerticalTextPosition(0);
        this.marketWatch = marketWatch;
        this.columnData = obj;
        this.upimg = this.loadImage("up.png");
        this.downimg = this.loadImage("down.png");
        this.levelimg = this.loadImage("level.png");
    }

    private ImageIcon loadImage(String imageNum) {
        return new ImageIcon(this.getClass().getResource("/Images/" + imageNum));
    }

    @Override
    public void setValue(Object value) {
        BackColor bc;
        if (value instanceof BackColor) {
            bc = (BackColor)value;
            if (value instanceof IconData) {
                IconData icd = (IconData)value;
                if (icd.gettext().equalsIgnoreCase("+")) {
                    super.setIcon(this.upimg);
                } else if (icd.gettext().equalsIgnoreCase("-")) {
                    super.setIcon(this.downimg);
                } else if (icd.gettext().equalsIgnoreCase("=")) {
                    super.setIcon(this.levelimg);
                } else {
                    super.setIcon(null);
                    super.setValue("");
                }
                if (bc.hasfocus) {
                    this.setBackground(this.marketWatch.myfont.getselectedcellcolorbg());
                    this.setForeground(Color.BLACK);
                } else {
                    this.setBackground(bc.bgcolor);
                    this.setForeground(bc.fgcolor);
                }
            } else {
                super.setValue(value);
                if (bc.hasfocus) {
                    if (bc.bgcolor == this.marketWatch.myfont.upvalueColor) {
                        this.setBackground(bc.bgcolor);
                    } else if (bc.bgcolor == this.marketWatch.myfont.downvalueColor) {
                        this.setBackground(bc.bgcolor);
                    } else {
                        this.setBackground(this.marketWatch.myfont.getselectedcellcolorbg());
                    }
                    this.setForeground(bc.fgcolor);
                } else {
                    this.setBackground(bc.bgcolor);
                    this.setForeground(bc.fgcolor);
                }
            }
            this.setToolTipText(bc.toolTip);
        } else {
            super.setValue(value);
            this.setBackground(this.marketWatch.myfont.getcellcolorbg());
        }
        if (this.selectedRow == MarketWatch.itsRow - 1 && MarketWatch.isMouseEnter) {
            this.setBackground(new Color(123, 155, 223));
            this.setForeground(Color.BLACK);
        } else if (this.selectedRow == MarketWatch.itsRow - 1 && !MarketWatch.isMouseEnter) {
            bc = (BackColor)value;
            this.setBackground(bc.bgcolor);
            this.setForeground(bc.fgcolor);
        }
        this.setFont(this.marketWatch.myfont.getfont());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.selectedRow = row;
        return this;
    }
}

