/*
 * Decompiled with CFR 0.152.
 */
package CATALYST.Control;

import CATALYST.Control.MarketWatch;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;

public class RowHeightResizer
extends MouseInputAdapter {
    private JTable table;
    private boolean active;
    private boolean rowSelectionAllowed;
    private int row;
    private int startY;
    private int startHeight;
    private int startX;
    private int startWidth;
    private static final int PIXELS = 5;
    private Cursor lastCursor;
    private static Cursor resizeCursor = Cursor.getPredefinedCursor(9);
    private static Cursor resizeCursorWidth = Cursor.getPredefinedCursor(11);
    private Cursor NewCursor = null;
    MarketWatch Mwh;

    public RowHeightResizer(JTable table, MarketWatch Mwh_) {
        this.table = table;
        this.table.addMouseListener(this);
        this.table.addMouseMotionListener(this);
        this.row = -1;
        this.Mwh = Mwh_;
    }

    public void done() {
        if (this.table == null) {
            return;
        }
        this.table.removeMouseListener(this);
        this.table.removeMouseMotionListener(this);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        this.NewCursor = this.isMouseOverRowMarginNew(p, e);
        if (this.NewCursor != null) {
            if (this.lastCursor == null) {
                this.lastCursor = this.table.getCursor();
            }
            this.table.setCursor(this.NewCursor);
        } else {
            this.table.setCursor(this.lastCursor);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
        if (this.isMouseOverRowMargin(p)) {
            this.active = true;
            this.startY = p.y;
            this.startHeight = this.table.getRowHeight(this.row);
            this.startX = p.x;
            this.rowSelectionAllowed = this.table.getRowSelectionAllowed();
            this.table.setRowSelectionAllowed(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.active) {
            return;
        }
        if (!e.isAltDown() && !e.isControlDown()) {
            return;
        }
        int newHeight = this.startHeight + e.getY() - this.startY;
        newHeight = Math.max(1, newHeight);
        int Change = newHeight - this.table.getRowHeight();
        Font F = this.Mwh.GetFont();
        if (F.getSize() + Change >= 10 && F.getSize() + Change <= 40) {
            F = new Font(F.getFamily(), F.getStyle(), F.getSize() + Change);
            String style = "PLAIN";
            if (F.getStyle() == 1) {
                style = "BOLD";
            } else if (F.getStyle() == 2) {
                style = "ITALIC";
            } else if (F.getStyle() == 0) {
                style = "PLAIN";
            }
            this.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.active) {
            return;
        }
        this.table.setRowSelectionAllowed(this.rowSelectionAllowed);
        this.active = false;
        this.row = -1;
    }

    private Cursor isMouseOverRowMarginNew(Point p, MouseEvent e) {
        if (!this.table.isEnabled()) {
            return null;
        }
        this.row = this.table.rowAtPoint(p);
        int column = this.table.columnAtPoint(p);
        if (this.row == -1 || column == -1) {
            return null;
        }
        Rectangle r = this.table.getCellRect(this.row, column, true);
        if (p.y >= r.y + r.height - 5 && e.isAltDown() && e.isControlDown()) {
            return resizeCursor;
        }
        return null;
    }

    private boolean isMouseOverRowMargin(Point p) {
        if (!this.table.isEnabled()) {
            return false;
        }
        this.row = this.table.rowAtPoint(p);
        int column = this.table.columnAtPoint(p);
        if (this.row == -1 || column == -1) {
            return false;
        }
        Rectangle r = this.table.getCellRect(this.row, column, true);
        return p.y >= r.y + r.height - 5;
    }
}

