/*
 * Decompiled with CFR 0.152.
 */
package CATALYST.Control;

import CATALYST.Control.StockData;
import java.util.Comparator;
import languages.LanguageCentre;
import languages.LanguageConstant;

class StockComparator
implements Comparator {
    protected String m_sortCol;
    protected boolean m_sortAsc;
    private LanguageCentre languageCentre = new LanguageCentre();

    public StockComparator(String sortColName, boolean sortAsc) {
        this.m_sortCol = sortColName;
        this.m_sortAsc = sortAsc;
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof StockData) || !(o2 instanceof StockData)) {
            return 0;
        }
        StockData s1 = (StockData)o1;
        StockData s2 = (StockData)o2;
        int result = 0;
        if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Market).trim())) {
            result = s1.m_market.toString().compareTo(s2.m_market.toString());
        } else if (this.m_sortCol.trim().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Scrip).trim())) {
            result = s1.m_symbol.toString().compareTo(s2.m_symbol.toString());
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("Contract"))) {
            result = s1.m_symbol.toString().compareTo(s2.m_symbol.toString());
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("BuyVol"))) {
            long l1 = s1.m_bvol.m_value;
            long l2 = s2.m_bvol.m_value;
            result = l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Buy))) {
            double d2;
            double d1 = (Double)s1.m_buy.m_data;
            result = d1 < (d2 = ((Double)s2.m_buy.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Sell))) {
            double d2;
            double d1 = (Double)s1.m_sel.m_data;
            result = d1 < (d2 = ((Double)s2.m_sel.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("SellVol"))) {
            long l1 = s1.m_svol.m_value;
            long l2 = s2.m_svol.m_value;
            result = l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.LastPrice))) {
            double d2;
            double d1 = (Double)s1.m_ltrdprice.m_data;
            result = d1 < (d2 = ((Double)s2.m_ltrdprice.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("Change"))) {
            double d2;
            double d1 = (Double)s1.m_change.m_data;
            result = d1 < (d2 = ((Double)s2.m_change.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("Dir"))) {
            result = s1.m_dir.toString().compareTo(s2.m_dir.toString());
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("LTrdTime"))) {
            result = s1.m_ltrdtime.toString().compareTo(s2.m_ltrdtime.toString());
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.TotalVolume))) {
            long l1 = s1.m_totalvolume.m_value;
            long l2 = s2.m_totalvolume.m_value;
            result = l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.High))) {
            double d2;
            double d1 = (Double)s1.m_high.m_data;
            result = d1 < (d2 = ((Double)s2.m_high.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Low))) {
            double d2;
            double d1 = (Double)s1.m_low.m_data;
            result = d1 < (d2 = ((Double)s2.m_low.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Average))) {
            double d2;
            double d1 = (Double)s1.m_avg.m_data;
            result = d1 < (d2 = ((Double)s2.m_avg.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("TotalTrd"))) {
            long l1 = s1.m_tottrd.m_value;
            long l2 = s2.m_tottrd.m_value;
            result = l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("LTrdVolume"))) {
            long l1 = s1.m_ltrdvolume.m_value;
            long l2 = s2.m_ltrdvolume.m_value;
            result = l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ClosePrice))) {
            double d2;
            double d1 = (Double)s1.m_closeprice.m_data;
            result = d1 < (d2 = ((Double)s2.m_closeprice.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.State))) {
            result = s1.m_state.toString().compareTo(s2.m_state.toString());
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("Period"))) {
            result = s1.m_period.toString().compareTo(s2.m_period.toString());
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Flag))) {
            result = s1.m_flag.toString().compareTo(s2.m_flag.toString());
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Trade))) {
            result = s1.m_trade.m_data.toString().compareTo(s2.m_trade.m_data.toString());
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.CompanySnapshot))) {
            result = s1.m_companySnapshot.m_data.toString().compareTo(s2.m_companySnapshot.m_data.toString());
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("MarketCap"))) {
            double d2;
            double d1;
            String val1 = s1.m_marketCaps.m_data.replaceAll("\\,", "").replaceAll("m", "");
            String val2 = s2.m_marketCaps.m_data.replaceAll("\\,", "").replaceAll("m", "");
            if (val1.trim().length() == 0) {
                val1 = "0";
            }
            if (val2.trim().length() == 0) {
                val2 = "0";
            }
            result = (d1 = Double.parseDouble(val1)) < (d2 = Double.parseDouble(val2)) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("P/E"))) {
            double d2;
            double d1 = (Double)s1.m_PE.m_data;
            result = d1 < (d2 = ((Double)s2.m_PE.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("DividendYield"))) {
            double d2;
            double d1 = (Double)s1.m_dividendYield.m_data;
            result = d1 < (d2 = ((Double)s2.m_dividendYield.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("P/B"))) {
            double d2;
            double d1 = (Double)s1.m_priceToBook.m_data;
            result = d1 < (d2 = ((Double)s2.m_priceToBook.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("EPS"))) {
            double d2;
            double d1 = (Double)s1.m_EPS.m_data;
            result = d1 < (d2 = ((Double)s2.m_EPS.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("OutstandingShares"))) {
            double d2;
            double d1;
            String val1 = s1.m_outstandingShares.m_data.replaceAll("\\,", "").replaceAll("m", "");
            String val2 = s2.m_outstandingShares.m_data.replaceAll("\\,", "").replaceAll("m", "");
            if (val1.trim().length() == 0) {
                val1 = "0";
            }
            if (val2.trim().length() == 0) {
                val2 = "0";
            }
            result = (d1 = Double.parseDouble(val1)) < (d2 = Double.parseDouble(val2)) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("52WeekAvg"))) {
            double d2;
            double d1 = (Double)s1.m_weekAveragePrice52.m_data;
            result = d1 < (d2 = ((Double)s2.m_weekAveragePrice52.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("52WeekHigh"))) {
            double d2;
            double d1 = (Double)s1.m_weekHigh52.m_data;
            result = d1 < (d2 = ((Double)s2.m_weekHigh52.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("52WeekLow"))) {
            double d2;
            double d1 = (Double)s1.m_weekLow52.m_data;
            result = d1 < (d2 = ((Double)s2.m_weekLow52.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("Spread"))) {
            double d2;
            double d1 = (Double)s1.m_spread.m_data;
            result = d1 < (d2 = ((Double)s2.m_spread.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("NetQuantity"))) {
            long l1 = s1.m_netqty.m_value;
            long l2 = s2.m_netqty.m_value;
            result = l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("AveragePrice"))) {
            double d2;
            double d1 = (Double)s1.m_avgprice.m_data;
            result = d1 < (d2 = ((Double)s2.m_avgprice.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PercentChange))) {
            double d2;
            double d1 = (Double)s1.m_perChange.m_data;
            result = d1 < (d2 = ((Double)s2.m_perChange.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.OpenPrice))) {
            double d2;
            double d1 = (Double)s1.m_openPrice.m_data;
            result = d1 < (d2 = ((Double)s2.m_openPrice.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("Payout"))) {
            double d2;
            double d1 = (Double)s1.m_payout.m_data;
            result = d1 < (d2 = ((Double)s2.m_payout.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("FreeFloat"))) {
            double d2;
            double d1;
            String val1 = s1.m_free_float.m_data.replaceAll("\\,", "").replaceAll("m", "");
            String val2 = s2.m_free_float.m_data.replaceAll("\\,", "").replaceAll("m", "");
            if (val1.trim().length() == 0) {
                val1 = "0";
            }
            if (val2.trim().length() == 0) {
                val2 = "0";
            }
            result = (d1 = Double.parseDouble(val1)) < (d2 = Double.parseDouble(val2)) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("LP/CP/LDCP"))) {
            double d2;
            double d1 = (Double)s1.m_LP_CP_LDCP.m_data;
            result = d1 < (d2 = ((Double)s2.m_LP_CP_LDCP.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("CurrentMarketCapital"))) {
            double d2;
            double d1 = (Double)s1.m_market_capital.m_data;
            result = d1 < (d2 = ((Double)s2.m_market_capital.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("CurrentDayPoint"))) {
            double d2;
            double d1 = (Double)s1.m_current_day_point.m_data;
            result = d1 < (d2 = ((Double)s2.m_current_day_point.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("LastDayPoint"))) {
            double d2;
            double d1 = (Double)s1.m_last_day_point.m_data;
            result = d1 < (d2 = ((Double)s2.m_last_day_point.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue("PointChange"))) {
            double d2;
            double d1 = (Double)s1.m_point_change.m_data;
            result = d1 < (d2 = ((Double)s2.m_point_change.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.UpperCap))) {
            double d2;
            double d1 = (Double)s1.m_upper_cap.m_data;
            result = d1 < (d2 = ((Double)s2.m_upper_cap.m_data).doubleValue()) ? -1 : (d1 > d2 ? 1 : 0);
        } else if (this.m_sortCol.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.LowerLock))) {
            double d2;
            double d1 = (Double)s1.m_lower_lock.m_data;
            int n = d1 < (d2 = ((Double)s2.m_lower_lock.m_data).doubleValue()) ? -1 : (result = d1 > d2 ? 1 : 0);
        }
        if (!this.m_sortAsc) {
            result = -result;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof StockComparator) {
            StockComparator compObj = (StockComparator)obj;
            return compObj.m_sortCol == this.m_sortCol && compObj.m_sortAsc == this.m_sortAsc;
        }
        return false;
    }
}

