/*
 * Decompiled with CFR 0.152.
 */
package CATALYST.Control;

import CATALYST.Control.ColumnData;
import CATALYST.Control.MarketFeed;
import CATALYST.Control.MarketWatch;
import CATALYST.Control.MsgType;
import CATALYST.Control.StockComparator;
import CATALYST.Control.StockData;
import CATALYST.Control.Utilities;
import common.bean.ContractBrowseBean;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class StockTableData
extends AbstractTableModel {
    public ColumnData[] m_columns;
    public String AddedSymbolList = "";
    public StockData StockDataDefaultItem = null;
    public String StockDataDefaultItemKey = "DefaultItemKey";
    protected Hashtable _m_vector;
    protected SimpleDateFormat m_frm;
    protected Vector m_vector;
    protected Vector m_vector_sortdefault;
    protected Hashtable _m_vector_sortdefault;
    protected boolean SortListChange = true;
    protected Date m_date;
    protected int m_sortCol = 0;
    protected boolean m_sortAsc = true;
    protected int Asc_Desc_Default = 0;
    protected MarketWatch marketWatch = null;
    boolean isSectorTableModel = false;
    private Color speardColor = new Color(163, 192, 255, 229);
    public static DecimalFormat twoPlaces = new DecimalFormat("###,###.##");
    private LanguageCentre languageCentre = new LanguageCentre();

    public StockTableData(MarketWatch Mwh, ColumnData[] MarketWatchColumn) {
        this.marketWatch = Mwh;
        this.m_columns = MarketWatchColumn;
        this.m_frm = new SimpleDateFormat("MM/dd/yyyy");
        this.m_vector = new Vector();
        this._m_vector = new Hashtable();
        this.StockDataDefaultItem = this.getStockDateDefaultItem("", "");
        this.StockDataDefaultItem.isdefault = true;
    }

    public ColumnData getColumnData(String Identifier) {
        for (int i = 0; i < this.m_columns.length; ++i) {
            if (!this.m_columns[i].m_title.equalsIgnoreCase(Identifier)) continue;
            return this.m_columns[i];
        }
        return null;
    }

    public Vector getvectorlist() {
        return this.m_vector;
    }

    void RaiseNotifyEvent(String message) {
    }

    @Override
    public int getRowCount() {
        return this.m_vector == null ? 0 : this.m_vector.size();
    }

    @Override
    public int getColumnCount() {
        return this.m_columns.length;
    }

    @Override
    public String getColumnName(int column) {
        String str = this.m_columns[column].m_title;
        return str;
    }

    void SelectSymbolChange(String selectedsymbolkey) {
        int selectionindex = -1;
        try {
            if (this._m_vector.containsKey(selectedsymbolkey)) {
                selectionindex = this.m_vector.indexOf(this._m_vector.get(selectedsymbolkey));
            }
            int modelRow = selectionindex;
            if (modelRow < 0) {
                System.out.println("SelectSymbolChange: selection FALSE; " + modelRow);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            System.out.println("SelectSymbolChange [" + selectedsymbolkey + "]: Error: " + ee.toString());
        }
    }

    public String addSymbols(String data, boolean isCallHistoricalDataWebService, boolean isAtLoginTime) {
        String ret = "";
        boolean isSymbolListChange = false;
        int selectionindex = -1;
        try {
            this.m_vector.remove(this.StockDataDefaultItem);
            this._m_vector.remove(this.StockDataDefaultItemKey);
            String[] symbolslist = Utilities.split(data, '|');
            for (int i = 0; i < symbolslist.length; ++i) {
                String symbol = symbolslist[i].trim();
                if (symbol.length() <= 0 || symbol.indexOf(";") < 0) continue;
                String[] symbolmarket = Utilities.split(symbol, ';');
                String sym = symbolmarket[0].toString().trim().toUpperCase();
                String mkt = symbolmarket[1].toString().trim().toUpperCase();
                if (sym.length() <= 0 || mkt.length() <= 0) continue;
                StockData tempdata = this.getStockDateDefaultItem(mkt, sym);
                if (this._m_vector.size() < this.marketWatch.allowedScripLimit) {
                    if (!this._m_vector.containsKey(tempdata.gethashkey())) {
                        this.m_vector.add(tempdata);
                        tempdata.rowNumber = selectionindex = this.m_vector.indexOf(tempdata);
                        this._m_vector.put(tempdata.gethashkey(), tempdata);
                        isSymbolListChange = true;
                        selectionindex = this.m_vector.indexOf(this._m_vector.get(tempdata.gethashkey()));
                        this.SortListChange = true;
                        continue;
                    }
                    if (this.marketWatch.isDuplicateScrip) {
                        this.m_vector.add(tempdata);
                        tempdata.rowNumber = selectionindex = this.m_vector.indexOf(tempdata);
                        this._m_vector.put(tempdata.gethashkey(), tempdata);
                        isSymbolListChange = true;
                        selectionindex = this.m_vector.indexOf(this._m_vector.get(tempdata.gethashkey()));
                        this.SortListChange = true;
                        continue;
                    }
                    selectionindex = this.m_vector.indexOf(this._m_vector.get(tempdata.gethashkey()));
                    continue;
                }
                selectionindex = this.m_vector.indexOf(this._m_vector.get(tempdata.gethashkey()));
                if (isAtLoginTime) break;
                this.marketWatch._fireStatsEvent(MsgType.Scrip_Limit_Exceded, data, isCallHistoricalDataWebService);
                break;
            }
            if (!this.m_vector.contains(this.StockDataDefaultItem)) {
                this.m_vector.add(this.StockDataDefaultItem);
                this._m_vector.put(this.StockDataDefaultItemKey, this.StockDataDefaultItem);
            }
            if (isSymbolListChange) {
                Vector c = this.m_vector;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < c.size(); ++i) {
                    StockData _temp = (StockData)c.get(i);
                    if (_temp == null || _temp.m_symbol.m_data.toString().trim().length() <= 0) continue;
                    sb.append(_temp.m_symbol).append(";").append(_temp.m_market.toString()).append("|");
                }
                this.AddedSymbolList = sb.toString();
                this.marketWatch.mkt_AddSymbolsListNew(this.AddedSymbolList, isCallHistoricalDataWebService);
                ret = this.AddedSymbolList;
                this.refresh();
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            System.out.println("addSymbols [" + data + "]: Error: " + ee.toString());
        }
        if (selectionindex >= 0) {
            return selectionindex + "";
        }
        return ret;
    }

    public void RemoveSymbol(String SymbolWithMarket) {
        try {
            boolean isSymbolListChange = false;
            String sym = "";
            String mkt = "";
            Enumeration enumr = this.m_vector.elements();
            while (enumr.hasMoreElements()) {
                StockData obj = (StockData)enumr.nextElement();
                sym = obj.m_symbol.m_data.toString().trim().toUpperCase();
                mkt = obj.m_market.toString().trim().toUpperCase();
                if (!(sym + ";" + mkt).equalsIgnoreCase(SymbolWithMarket)) continue;
                boolean removed = false;
                StockData deletetempdata = (StockData)this._m_vector.get(obj.gethashkey());
                if (deletetempdata != null && deletetempdata != this.StockDataDefaultItem) {
                    removed = this.m_vector.remove(deletetempdata);
                    this._m_vector.remove(obj.gethashkey());
                    isSymbolListChange = true;
                    this.SortListChange = true;
                }
                if (!isSymbolListChange) break;
                Vector c = this.m_vector;
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < c.size(); ++i) {
                    StockData _temp = (StockData)c.get(i);
                    if (_temp == null || _temp.m_symbol.m_data.toString().trim().length() <= 0) continue;
                    sb.append(_temp.m_symbol + ";" + _temp.m_market.toString() + "|");
                }
                this.AddedSymbolList = sb.toString();
                this.marketWatch.mkt_AddSymbolsListNew(this.AddedSymbolList, false);
                break;
            }
            this.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setNetQtyAvgPriceAndClosePrice(String symbol, String market, String NetQty, String AvgPrice, String closePrice) {
        String objjkey = symbol + ":" + market;
        Object stockdataobj = this._m_vector.get(objjkey);
        if (stockdataobj != null && stockdataobj instanceof StockData) {
            StockData stockData = (StockData)stockdataobj;
            stockData.SetNetQty(NetQty);
            stockData.SetAvgPrice(AvgPrice);
            stockData.SetClosePrice(closePrice);
        }
    }

    public void setPayout(String symbol, String market, String payout) {
        String objjkey = symbol + ":" + market;
        Object stockdataobj = this._m_vector.get(objjkey);
        if (stockdataobj != null && stockdataobj instanceof StockData) {
            StockData stockData = (StockData)stockdataobj;
            stockData.SetPayout(payout);
        }
    }

    public void setFreeFloat(String symbol, String market, String freeFloat) {
        String objjkey = symbol + ":" + market;
        Object stockdataobj = this._m_vector.get(objjkey);
        if (stockdataobj != null && stockdataobj instanceof StockData) {
            StockData stockData = (StockData)stockdataobj;
            stockData.SetFreeFloat(freeFloat);
        }
    }

    public void setLP_CP_LDCP(String symbol, String market, String lp_cp_ldcp) {
        String objjkey = symbol + ":" + market;
        Object stockdataobj = this._m_vector.get(objjkey);
        if (stockdataobj != null && stockdataobj instanceof StockData) {
            StockData stockData = (StockData)stockdataobj;
            stockData.SetLP_CP_LDCP(lp_cp_ldcp);
        }
    }

    public void setCurrentMarketCapital(String symbol, String market, String currentMarketCapital) {
        String objjkey = symbol + ":" + market;
        Object stockdataobj = this._m_vector.get(objjkey);
        if (stockdataobj != null && stockdataobj instanceof StockData) {
            StockData stockData = (StockData)stockdataobj;
            stockData.SetCurrentMarketCapital(currentMarketCapital);
        }
    }

    public void setCurrentDayPoint(String symbol, String market, String currentDayPoint) {
        String objjkey = symbol + ":" + market;
        Object stockdataobj = this._m_vector.get(objjkey);
        if (stockdataobj != null && stockdataobj instanceof StockData) {
            StockData stockData = (StockData)stockdataobj;
            stockData.SetCurrentDayPoint(currentDayPoint);
        }
    }

    public void setLastDayPoint(String symbol, String market, String lastDayPoint) {
        String objjkey = symbol + ":" + market;
        Object stockdataobj = this._m_vector.get(objjkey);
        if (stockdataobj != null && stockdataobj instanceof StockData) {
            StockData stockData = (StockData)stockdataobj;
            stockData.SetLastDayPoint(lastDayPoint);
        }
    }

    public void setPointChange(String symbol, String market, String pointChange) {
        String objjkey = symbol + ":" + market;
        Object stockdataobj = this._m_vector.get(objjkey);
        if (stockdataobj != null && stockdataobj instanceof StockData) {
            StockData stockData = (StockData)stockdataobj;
            stockData.SetPointChange(pointChange);
        }
    }

    public void setUpperCap(String symbol, String market, String upperCap) {
        String objjkey = symbol + ":" + market;
        Object stockdataobj = this._m_vector.get(objjkey);
        if (stockdataobj != null && stockdataobj instanceof StockData) {
            StockData stockData = (StockData)stockdataobj;
            stockData.SetUpperCap(upperCap);
        }
    }

    public void setLowerLock(String symbol, String market, String lowerLock) {
        String objjkey = symbol + ":" + market;
        Object stockdataobj = this._m_vector.get(objjkey);
        if (stockdataobj != null && stockdataobj instanceof StockData) {
            StockData stockData = (StockData)stockdataobj;
            stockData.SetLowerLock(lowerLock);
        }
    }

    public void setHistoricalData(String symbol, String market, String m_period, String m_marketCaps, String m_PE, String m_dividendYield, String m_priceToBook, String m_EPS, String m_outstandingShares, String m_52WeekAveragePrice, String m_52WeekHigh, String m_52WeekLow) {
        for (int i = 0; i < this.m_vector.size(); ++i) {
            Object object = this.m_vector.elementAt(i);
            if (object == null || !(object instanceof StockData)) continue;
            StockData stockData = (StockData)object;
            if (stockData.m_symbol.m_data.indexOf("-") > 0) {
                String[] val = stockData.m_symbol.m_data.split("\\-", -1);
                if (!val[0].equalsIgnoreCase(symbol)) continue;
                stockData.SetMarketCaps(m_marketCaps);
                stockData.SetPeriod(m_period);
                stockData.SetPE(m_PE);
                stockData.SetDividendYield(m_dividendYield);
                stockData.SetPriceToBook(m_priceToBook);
                stockData.SetEPS(m_EPS);
                stockData.SetOutstandingShares(m_outstandingShares);
                stockData.Set52WeekAveragePrice(m_52WeekAveragePrice);
                stockData.Set52WeekHigh(m_52WeekHigh);
                stockData.Set52WeekLow(m_52WeekLow);
                this.refresh();
                continue;
            }
            if (!stockData.m_symbol.m_data.equalsIgnoreCase(symbol)) continue;
            stockData.SetMarketCaps(m_marketCaps);
            stockData.SetPE(m_PE);
            stockData.SetPeriod(m_period);
            stockData.SetDividendYield(m_dividendYield);
            stockData.SetPriceToBook(m_priceToBook);
            stockData.SetEPS(m_EPS);
            stockData.SetOutstandingShares(m_outstandingShares);
            stockData.Set52WeekAveragePrice(m_52WeekAveragePrice);
            stockData.Set52WeekHigh(m_52WeekHigh);
            stockData.Set52WeekLow(m_52WeekLow);
            this.refresh();
        }
    }

    public void setDataValues(String data) {
        try {
            String[] feeds = Utilities.split(data, '|');
            for (int i = 0; i < feeds.length; ++i) {
                String objjkey;
                Object stockdataobj;
                String[] feedvalues;
                String feed = feeds[i].trim();
                if (feed.length() <= 0 || feed.indexOf(";") < 0 || (feedvalues = Utilities.split(feed, ';')).length < 18) continue;
                String payout = "";
                String _symbol = feedvalues[1].trim().toUpperCase();
                String _market = feedvalues[2].trim().toUpperCase();
                String _bvol = feedvalues[3].trim();
                String _buy = feedvalues[4].trim();
                String _sel = feedvalues[5].trim();
                String _svol = feedvalues[6].trim();
                String _state = feedvalues[7].trim().toUpperCase();
                String _direction = feedvalues[8].trim();
                String _change = feedvalues[9].trim();
                String _lasttrdtime = feedvalues[10].trim();
                String _lasttrdprice = feedvalues[11].trim();
                String _flag = feedvalues[12].trim().toUpperCase();
                String _avg = feedvalues[13].trim();
                String _high = feedvalues[14].trim();
                String _low = feedvalues[15].trim();
                String _totaltrades = feedvalues[16].trim();
                String _totalvolume = feedvalues[17].trim();
                String _lasttrdvolume = feedvalues[18].trim();
                String _closeprice = "0";
                String _openPrice = "0";
                String _perChange = "0";
                if (feedvalues.length > 19) {
                    _closeprice = feedvalues[19].trim();
                }
                if (feedvalues.length > 20) {
                    _openPrice = feedvalues[20].trim();
                }
                if (feedvalues.length > 21) {
                    _perChange = feedvalues[21].trim();
                }
                if (MarketWatch.Payout.containsKey(_symbol)) {
                    payout = MarketWatch.Payout.get(_symbol);
                }
                if ((stockdataobj = this._m_vector.get(objjkey = _symbol + ":" + _market)) == null || !(stockdataobj instanceof StockData)) continue;
                StockData stockData = (StockData)stockdataobj;
                stockData.SetSymbol();
                stockData.SetMarket();
                stockData.SetBuy(_buy);
                stockData.SetBVol(_bvol);
                stockData.SetSel(_sel);
                stockData.SetSVol(_svol);
                stockData.SetLastTradeVolume(_lasttrdvolume);
                stockData.SetHigh(_high);
                stockData.SetLow(_low);
                stockData.SetAvg(_avg);
                stockData.SetTotalTrade(_totaltrades);
                stockData.SetLastTradePrice(_lasttrdprice);
                stockData.SetTotalVolume(_totalvolume);
                stockData.SetState(_state);
                stockData.SetFlag(_flag);
                stockData.SetLastTrdTime(_lasttrdtime);
                stockData.SetPerChange(_perChange);
                if (_lasttrdprice.length() == 0) {
                    stockData.SetChange("");
                    stockData.SetDir("");
                    stockData.SetPerChange("");
                } else {
                    stockData.SetChange(_change);
                    stockData.SetDir(_direction);
                    stockData.SetPerChange(_perChange);
                }
                stockData.SetClosePrice(_closeprice);
                stockData.SetOpenPrice(_openPrice);
                stockData.SetTrade();
                stockData.SetAnalytics();
                stockData.SetGraph();
                stockData.SetCompanySnapshot();
                stockData.SetPayout(payout);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            System.out.println("FEED Recv [" + data + "]: Error: " + ee.toString());
        }
    }

    public void setDataValuesInitial(String data) {
        try {
            String[] feeds = Utilities.split(data, '|');
            for (int i = 0; i < feeds.length; ++i) {
                StockData stockData;
                String objjkey;
                Object stockdataobj;
                String[] feedvalues;
                String feed = feeds[i].trim();
                if (feed.length() <= 0 || feed.indexOf(";") < 0 || (feedvalues = Utilities.split(feed, ';')).length < 18) continue;
                String _symbol = feedvalues[1].trim().toUpperCase();
                String _market = feedvalues[2].trim().toUpperCase();
                String _bvol = feedvalues[3].trim();
                String _buy = feedvalues[4].trim();
                String _sel = feedvalues[5].trim();
                String _svol = feedvalues[6].trim();
                String _state = feedvalues[7].trim().toUpperCase();
                String _direction = feedvalues[8].trim();
                String _change = feedvalues[9].trim();
                String _lasttrdtime = feedvalues[10].trim();
                String _lasttrdprice = feedvalues[11].trim();
                String _flag = feedvalues[12].trim().toUpperCase();
                String _avg = feedvalues[13].trim();
                String _high = feedvalues[14].trim();
                String _low = feedvalues[15].trim();
                String _totaltrades = feedvalues[16].trim();
                String _totalvolume = feedvalues[17].trim();
                String _lasttrdvolume = feedvalues[18].trim();
                String _openPrice = "0";
                String _closeprice = "0";
                String _perChange = "0";
                if (feedvalues.length > 19) {
                    _closeprice = feedvalues[19].trim();
                }
                if (feedvalues.length > 19) {
                    _openPrice = feedvalues[19].trim();
                }
                if ((stockdataobj = this._m_vector.get(objjkey = _symbol + ":" + _market)) == null || !(stockdataobj instanceof StockData) || (stockData = (StockData)stockdataobj).GetBuy().length() != 0 || stockData.GetBVol().length() != 0 || stockData.GetSel().length() != 0 || stockData.GetSVol().length() != 0 || stockData.GetLastTradePrice().length() != 0) continue;
                stockData.SetBuy(_buy);
                stockData.SetBVol(_bvol);
                stockData.SetSel(_sel);
                stockData.SetSVol(_svol);
                stockData.SetLastTradeVolume(_lasttrdvolume);
                stockData.SetHigh(_high);
                stockData.SetLow(_low);
                stockData.SetAvg(_avg);
                stockData.SetTotalTrade(_totaltrades);
                stockData.SetLastTradePrice(_lasttrdprice);
                stockData.SetTotalVolume(_totalvolume);
                stockData.SetState(_state);
                stockData.SetFlag(_flag);
                stockData.SetLastTrdTime(_lasttrdtime);
                if (_lasttrdprice.length() == 0) {
                    stockData.SetChange("");
                    stockData.SetDir("");
                } else {
                    stockData.SetChange(_change);
                    stockData.SetDir(_direction);
                }
                if (feedvalues.length > 20) {
                    _perChange = feedvalues[20].trim();
                }
                stockData.SetClosePrice(_closeprice);
                stockData.SetOpenPrice(_openPrice);
                stockData.SetPerChange(_perChange);
                stockData.SetTrade();
                stockData.SetCompanySnapshot();
                stockData.SetPayout("");
                this._m_vector.put(stockData.gethashkey(), stockData);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            System.out.println("FEED Recv [" + data + "]: Error: " + ee.toString());
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        block22: {
            try {
                StockData _temp;
                int i;
                boolean isSymbolListChange;
                String sym;
                block26: {
                    String oldmkt;
                    String oldsym;
                    String colname;
                    StockData temp;
                    block23: {
                        block24: {
                            String sta;
                            StockData tempdata;
                            block25: {
                                Object td = this.m_vector.get(row);
                                if (td == null || !(td instanceof StockData)) break block22;
                                temp = (StockData)td;
                                sym = "";
                                isSymbolListChange = false;
                                colname = this.getColumnName(col);
                                oldsym = temp.m_symbol.m_data.toString();
                                oldmkt = temp.m_market.toString().trim().toUpperCase();
                                if (colname.trim().compareTo(this.languageCentre.getValue(LanguageConstant.Scrip).trim()) != 0 && colname.compareTo(this.languageCentre.getValue("Contract").trim()) != 0) break block23;
                                sym = value.toString().trim().toUpperCase();
                                oldmkt = Utilities.GetMarketFromsymbol(sym);
                                if (colname.compareTo(this.languageCentre.getValue("Contract").trim()) == 0) {
                                    if (!this.marketWatch.PMEX_CONTRACT_ALL.containsKey(sym.toUpperCase()) && sym.length() > 0) {
                                        JOptionPane.showMessageDialog(this.marketWatch, "Invalid Contract", "Error", 0);
                                        return;
                                    }
                                    oldmkt = Utilities.GetMarketFromContract(sym);
                                }
                                if (sym.length() <= 0) break block24;
                                tempdata = this.getStockDateDefaultItem(oldmkt, sym);
                                if (tempdata.gethashkey().length() <= 0 || this._m_vector.containsKey(tempdata.gethashkey())) break block25;
                                if (this._m_vector.size() <= this.marketWatch.allowedScripLimit || row < this.marketWatch.allowedScripLimit) {
                                    StockData prevobj = (StockData)this.m_vector.get(row);
                                    this._m_vector.remove(prevobj.gethashkey());
                                    this.m_vector.remove(prevobj);
                                    this.m_vector.add(row, tempdata);
                                    tempdata.rowNumber = row;
                                    this._m_vector.put(tempdata.gethashkey(), tempdata);
                                    isSymbolListChange = true;
                                    this.SortListChange = true;
                                    this.marketWatch.GetTable().addRowSelectionInterval(0, row);
                                } else {
                                    this.marketWatch._fireStatsEvent(MsgType.Scrip_Limit_Exceded, sym, false);
                                }
                                break block26;
                            }
                            int selectionindex = this.m_vector.indexOf(this._m_vector.get(tempdata.gethashkey()));
                            int modelRow = selectionindex;
                            if (modelRow < 0 || (sta = this.addSymbols(sym + ";" + oldmkt, false, false)).equalsIgnoreCase("")) break block26;
                            try {
                                int rownum = Integer.parseInt(sta);
                                this.marketWatch.GetTable().addRowSelectionInterval(0, rownum);
                            }
                            catch (Exception ex) {
                                System.out.println("StockTableData setValueAt: " + ex.toString());
                            }
                            break block26;
                        }
                        boolean removed = false;
                        StockData deletetempdata = (StockData)this._m_vector.get(temp.gethashkey());
                        if (deletetempdata == null || deletetempdata == this.StockDataDefaultItem) break block26;
                        removed = this.m_vector.remove(deletetempdata);
                        this._m_vector.remove(temp.gethashkey());
                        isSymbolListChange = true;
                        this.SortListChange = true;
                        break block26;
                    }
                    if (colname.compareTo(this.languageCentre.getValue(LanguageConstant.Market)) == 0) {
                        String mkt = value.toString().trim().toUpperCase();
                        if (mkt.length() > 0) {
                            if (oldmkt.compareTo(mkt) != 0) {
                                if (oldsym.length() > 0) {
                                    this._m_vector.remove(temp.gethashkey());
                                    this.m_vector.remove(temp);
                                    StockData tempdata = this.getStockDateDefaultItem(mkt, oldsym);
                                    this.m_vector.add(row, tempdata);
                                    this._m_vector.put(tempdata.gethashkey(), tempdata);
                                } else {
                                    temp.m_market.m_data = mkt;
                                }
                                isSymbolListChange = true;
                                this.SortListChange = true;
                            } else {
                                System.out.println("No market change");
                            }
                        } else if (mkt.length() > 0) {
                            temp.m_market.m_data = mkt;
                        }
                        Vector c = this.m_vector;
                        for (i = 0; i < c.size(); ++i) {
                            _temp = (StockData)c.get(i);
                            if (_temp == null || _temp.m_symbol.m_data.toString().trim().length() <= 0) continue;
                            System.out.println("Sym22b: " + i + ": " + _temp.m_symbol);
                        }
                    }
                }
                if (!this.m_vector.contains(this.StockDataDefaultItem)) {
                    this.m_vector.add(this.StockDataDefaultItem);
                    this._m_vector.put(this.StockDataDefaultItemKey, this.StockDataDefaultItem);
                }
                if (isSymbolListChange) {
                    Vector c = this.m_vector;
                    StringBuilder sb = new StringBuilder();
                    for (i = 0; i < c.size(); ++i) {
                        _temp = (StockData)c.get(i);
                        if (_temp == null || _temp.m_symbol.m_data.toString().trim().length() <= 0) continue;
                        sb.append(_temp.m_symbol).append(";").append(_temp.m_market.toString()).append("|");
                    }
                    this.AddedSymbolList = sb.toString();
                    if (sym.length() > 0) {
                        this.marketWatch.mkt_AddSymbolsListNew(this.AddedSymbolList, false);
                    } else {
                        this.marketWatch.mkt_SymbolsRemove(this.AddedSymbolList);
                    }
                }
                this.refresh();
            }
            catch (Exception exc) {
                System.out.println(exc.toString());
            }
        }
    }

    @Override
    public boolean isCellEditable(int nRow, int nCol) {
        String cstr = this.m_columns[nCol].m_title;
        if (cstr.trim().toUpperCase().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Trade))) {
            return true;
        }
        if (cstr.trim().toUpperCase().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.CompanySnapshot))) {
            return true;
        }
        if (cstr.trim().toUpperCase().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Analytics))) {
            return true;
        }
        if (cstr.trim().toUpperCase().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Graph))) {
            return true;
        }
        if (this.isSectorTableModel) {
            return false;
        }
        return cstr.trim().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Market)) || cstr.trim().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Scrip).trim()) || cstr.trim().equalsIgnoreCase(this.languageCentre.getValue("Contract"));
    }

    @Override
    public Object getValueAt(int nRow, int nCol) {
        String columnName;
        if (nRow < 0 || nRow >= this.getRowCount()) {
            return "";
        }
        StockData row = (StockData)this.m_vector.elementAt(nRow);
        if (this.marketWatch.isDuplicateScrip) {
            row = (StockData)this._m_vector.get(row.gethashkey());
        }
        if ((columnName = this.getColumnName(nCol)).equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Market))) {
            return row.m_market;
        }
        if (columnName.trim().equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Scrip).trim())) {
            return row.m_symbol;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("Contract"))) {
            return row.m_symbol;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("BuyVol"))) {
            return row.m_bvol;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Buy))) {
            return row.m_buy;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Sell))) {
            return row.m_sel;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("SellVol"))) {
            return row.m_svol;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.LastPrice))) {
            return row.m_ltrdprice;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("Change"))) {
            return row.m_change;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("Dir"))) {
            return row.m_dir;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("LTrdTime"))) {
            return row.m_ltrdtime;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.TotalVolume))) {
            return row.m_totalvolume;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.High))) {
            return row.m_high;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Low))) {
            return row.m_low;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Average))) {
            return row.m_avg;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("TotalTrd"))) {
            return row.m_tottrd;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("LTrdVolume"))) {
            return row.m_ltrdvolume;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ClosePrice))) {
            return row.m_closeprice;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.OpenPrice))) {
            return row.m_openPrice;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.State))) {
            return row.m_state;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("Period"))) {
            return row.m_period;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Flag))) {
            return row.m_flag;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Trade))) {
            return row.m_trade;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Analytics))) {
            return row.m_Analytics;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.Graph))) {
            return row.m_Graph;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.CompanySnapshot))) {
            return row.m_companySnapshot;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("MarketCap"))) {
            return row.m_marketCaps;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("P/E"))) {
            return row.m_PE;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("DividendYield"))) {
            return row.m_dividendYield;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("P/B"))) {
            return row.m_priceToBook;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("EPS"))) {
            return row.m_EPS;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("OutstandingShares"))) {
            return row.m_outstandingShares;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("52WeekAvg"))) {
            return row.m_weekAveragePrice52;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("52WeekHigh"))) {
            return row.m_weekHigh52;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("52WeekLow"))) {
            return row.m_weekLow52;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("Spread"))) {
            try {
                if (row.m_market.m_data.contains("REG")) {
                    String month;
                    MarketFeed feedregular = this.marketWatch.liveMarket.get(row.gethashkey().replaceAll("\\:", ";"));
                    StockData rowfuture = (StockData)this.m_vector.elementAt(nRow + 1);
                    MarketFeed feedfutue = this.marketWatch.liveMarket.get(rowfuture.gethashkey().replaceAll("\\:", ";"));
                    Double diff = Double.parseDouble(feedfutue.buy) - Double.parseDouble(feedregular.sell);
                    String spread = twoPlaces.format(diff);
                    if (MarketWatch.isCalculatePercentage && rowfuture.m_market.m_data.equalsIgnoreCase("FUT") && MarketWatch.SettleRemainingDays.containsKey(month = Utilities.GetSymbolMonthFromSymbol(rowfuture.gethashkey()))) {
                        Integer remainigDays = MarketWatch.SettleRemainingDays.get(month);
                        Double futureBuy = Double.parseDouble(feedfutue.buy);
                        Double RegSell = Double.parseDouble(feedregular.sell);
                        Double per = (futureBuy - RegSell) / RegSell / (double)remainigDays.intValue() * 365.0 * 100.0;
                        spread = spread + "(" + twoPlaces.format(per) + "%)";
                    }
                    if (diff > 0.0) {
                        row.m_spread.setvalue_for_normalBG_Item(spread, this.speardColor, this.marketWatch.myfont.getupchangecolor());
                    } else if (diff == 0.0) {
                        row.m_spread.setvalue_for_normalBG_Item(spread, this.speardColor, this.marketWatch.myfont.getunchangevaluecolor());
                    } else {
                        row.m_spread.setvalue_for_normalBG_Item(spread, this.speardColor, Color.RED);
                    }
                } else if (row.m_market.m_data.indexOf("FUT") > -1) {
                    MarketFeed feedfutue = this.marketWatch.liveMarket.get(row.gethashkey().replaceAll("\\:", ";"));
                    StockData rowregular = (StockData)this.m_vector.elementAt(nRow - 1);
                    MarketFeed feedregular = this.marketWatch.liveMarket.get(rowregular.gethashkey().replaceAll("\\:", ";"));
                    Double diff = Double.parseDouble(feedregular.buy) - Double.parseDouble(feedfutue.sell);
                    if (diff > 0.0) {
                        row.m_spread.setvalue_for_normalBG_Item(diff, this.speardColor, this.marketWatch.myfont.getupchangecolor());
                    } else if (diff == 0.0) {
                        row.m_spread.setvalue_for_normalBG_Item(diff, this.speardColor, this.marketWatch.myfont.getunchangevaluecolor());
                    } else {
                        row.m_spread.setvalue_for_normalBG_Item(diff, this.speardColor, Color.RED);
                    }
                } else {
                    row.m_spread.setvalue_for_normalBG_Item(0.0, this.speardColor, this.speardColor);
                }
            }
            catch (Exception e) {
                row.m_spread.m_data = new Double(0.0);
            }
            return row.m_spread;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("NetQuantity"))) {
            return row.m_netqty;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("AveragePrice"))) {
            return row.m_avgprice;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.PercentChange))) {
            return row.m_perChange;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("Payout"))) {
            return row.m_payout;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("FreeFloat"))) {
            return row.m_free_float;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("LP/CP/LDCP"))) {
            return row.m_LP_CP_LDCP;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("CurrentMarketCapital"))) {
            return row.m_market_capital;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("CurrentDayPoint"))) {
            return row.m_current_day_point;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("LastDayPoint"))) {
            return row.m_last_day_point;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue("PointChange"))) {
            return row.m_point_change;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.UpperCap))) {
            return row.m_upper_cap;
        }
        if (columnName.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.LowerLock))) {
            return row.m_lower_lock;
        }
        return "";
    }

    public boolean isAlreadyExist(String sym_) {
        String[] str_ = Utilities.split(sym_, ';');
        String SYM_ = str_[0].toString().trim().toUpperCase();
        String MKT_ = str_[1].toString().trim().toUpperCase();
        StockData tempdata = this.getStockDateDefaultItem(MKT_, SYM_);
        return this._m_vector.containsKey(tempdata.gethashkey());
    }

    public String getTitle() {
        if (this.m_date == null) {
            return "Stock Quotes";
        }
        return "Stock Quotes at " + this.m_frm.format(this.m_date);
    }

    public StockData getStockDateDefaultItem(String mkt, String symbol) {
        StockData sd = new StockData(this.marketWatch, mkt, symbol, -9999L, -9999.0, -9999.0, -9999L, -9999.0, -9999.0, -9999L, -9999.0, -9999.0, -9999.0, -9999L, -9999L, "", "", "", "", -9999.0, -9999.0, "", -9999L, -9999.0, -9999.0, "", -9999.0, -9999.0, -9999.0, -9999.0, "", -9999.0, -9999.0, -9999.0, -9999.0, "", -9999.0, -9999.0, -9999.0, -9999.0, -9999.0, -9999.0, -9999.0, -9999.0, -9999.0, "", "", "");
        if (!this.marketWatch.isKSEWatch() && this.marketWatch.PMEX_CONTRACT_ALL.containsKey(symbol)) {
            ContractBrowseBean cb = this.marketWatch.PMEX_CONTRACT_ALL.get(symbol);
            sd.m_symbol.toolTip = "Expiry Date: " + Util.formatDate((Date)cb.getDate());
            if (this.marketWatch.getDate() != null && this.marketWatch.getDate().compareTo(cb.getDate()) == 0) {
                sd.m_symbol.fgcolor = Color.RED;
                sd.m_symbol.toolTip = "will expire today";
            }
        }
        return sd;
    }

    public void clear() {
        this._m_vector.clear();
        this.m_vector.clear();
        if (!this.isSectorTableModel && !this.m_vector.contains(this.StockDataDefaultItem)) {
            this.m_vector.add(this.StockDataDefaultItem);
            this._m_vector.put(this.StockDataDefaultItemKey, this.StockDataDefaultItem);
        }
        this.refresh();
    }

    protected void refresh() {
        try {
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void datachangedevent() {
        this.fireTableDataChanged();
    }

    public void RefreshMarketWatchBGColor() {
        Enumeration e = this._m_vector.elements();
        while (e.hasMoreElements()) {
            Object stockdataobj = e.nextElement();
            try {
                if (stockdataobj == null || !(stockdataobj instanceof StockData)) continue;
                StockData stockData = (StockData)stockdataobj;
                stockData.m_symbol.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_market.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_market.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_buy.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_bvol.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_sel.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_svol.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_spread.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_ltrdprice.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_change.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_perChange.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_avg.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_dir.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_ltrdtime.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_totalvolume.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_high.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_low.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_tottrd.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_ltrdvolume.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_flag.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_state.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_period.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_closeprice.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_openPrice.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_trade.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_companySnapshot.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_Analytics.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_Graph.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_marketCaps.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_PE.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_dividendYield.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_priceToBook.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_EPS.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_outstandingShares.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_weekAveragePrice52.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_weekHigh52.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_weekLow52.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_payout.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_free_float.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_current_day_point.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_last_day_point.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_point_change.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_upper_cap.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                stockData.m_lower_lock.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                if (stockData.m_netqty != null) {
                    stockData.m_netqty.bgcolor = this.marketWatch.myfont.getcellcolorbg();
                }
                if (stockData.m_avgprice == null) continue;
                stockData.m_avgprice.bgcolor = this.marketWatch.myfont.getcellcolorbg();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    static {
        twoPlaces.setMinimumFractionDigits(2);
        twoPlaces.setMaximumFractionDigits(2);
    }

    class ColumnListener
    extends MouseAdapter {
        protected JTable m_tableInstance;
        MarketWatch m;

        public ColumnListener(MarketWatch m, JTable table) {
            this.m = m;
            this.m_tableInstance = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object obj;
            Enumeration<TableColumn> enumr;
            if (SwingUtilities.isRightMouseButton(e)) {
                if (this.m.isDuplicateScrip) {
                    return;
                }
                JTable table = ((JTableHeader)e.getSource()).getTable();
                TableColumnModel colModel = table.getColumnModel();
                int vColIndex = colModel.getColumnIndexAtX(e.getX());
                if (vColIndex == -1) {
                    return;
                }
                if (vColIndex >= 0) {
                    this.m.popupAndNRemove.show(table, e.getX(), e.getY() - 20);
                }
            }
            if (e.getButton() != 1) {
                return;
            }
            TableColumnModel colModel = this.m_tableInstance.getColumnModel();
            int columnModelIndex = colModel.getColumnIndexAtX(e.getX());
            int modelIndex = colModel.getColumn(columnModelIndex).getModelIndex();
            String colName = colModel.getColumn(columnModelIndex).getIdentifier().toString();
            if (modelIndex < 0) {
                return;
            }
            if (StockTableData.this.SortListChange) {
                StockTableData.this.SortListChange = false;
                StockTableData.this.m_vector_sortdefault = new Vector();
                StockTableData.this._m_vector_sortdefault = new Hashtable();
                for (int count = 0; count < StockTableData.this.m_vector.size(); ++count) {
                    StockTableData.this.m_vector_sortdefault.add((StockData)StockTableData.this.m_vector.get(count));
                }
                enumr = StockTableData.this._m_vector.elements();
                while (enumr.hasMoreElements()) {
                    obj = (StockData)((Object)enumr.nextElement());
                    StockTableData.this._m_vector_sortdefault.put(((StockData)obj).gethashkey(), obj);
                }
            }
            if (StockTableData.this.Asc_Desc_Default == 0) {
                StockTableData.this.m_sortAsc = true;
                StockTableData.this.Asc_Desc_Default = 1;
            } else if (StockTableData.this.Asc_Desc_Default == 1) {
                StockTableData.this.m_sortAsc = false;
                StockTableData.this.Asc_Desc_Default = 2;
            } else if (StockTableData.this.Asc_Desc_Default == 2) {
                StockTableData.this.Asc_Desc_Default = 0;
                StockTableData.this.m_vector.clear();
                StockTableData.this._m_vector.clear();
                for (int count = 0; count < StockTableData.this.m_vector_sortdefault.size(); ++count) {
                    StockTableData.this.m_vector.add((StockData)StockTableData.this.m_vector_sortdefault.get(count));
                }
                Enumeration enumr2 = StockTableData.this._m_vector_sortdefault.elements();
                while (enumr2.hasMoreElements()) {
                    obj = (StockData)enumr2.nextElement();
                    StockTableData.this._m_vector.put(((StockData)obj).gethashkey(), obj);
                }
                this.m_tableInstance.tableChanged(new TableModelEvent(StockTableData.this));
                return;
            }
            enumr = colModel.getColumns();
            while (enumr.hasMoreElements()) {
                obj = enumr.nextElement();
                if (!(obj instanceof TableColumn)) continue;
                TableColumn column = obj;
                column.setHeaderValue(StockTableData.this.getColumnName(column.getModelIndex()));
            }
            this.m_tableInstance.getTableHeader().repaint();
            if (StockTableData.this._m_vector.containsKey(StockTableData.this.StockDataDefaultItemKey)) {
                StockTableData.this.m_vector.remove(StockTableData.this.StockDataDefaultItem);
                StockTableData.this._m_vector.remove(StockTableData.this.StockDataDefaultItemKey);
            }
            if (!this.m.isDuplicateScrip) {
                if (this.m.isKSEWatch()) {
                    if (modelIndex == 8) {
                        modelIndex = 21;
                    }
                    Collections.sort(StockTableData.this.m_vector, new StockComparator(colName, StockTableData.this.m_sortAsc));
                } else {
                    Collections.sort(StockTableData.this.m_vector, new StockComparator(colName, StockTableData.this.m_sortAsc));
                }
            }
            if (!StockTableData.this.m_vector.contains(StockTableData.this.StockDataDefaultItem)) {
                StockTableData.this.m_vector.add(StockTableData.this.StockDataDefaultItem);
                StockTableData.this._m_vector.put(StockTableData.this.StockDataDefaultItemKey, StockTableData.this.StockDataDefaultItem);
            }
            this.m_tableInstance.tableChanged(new TableModelEvent(StockTableData.this));
        }
    }
}

