/*
 * Decompiled with CFR 0.152.
 */
package CATALYST.Control;

import CATALYST.Control.MarketWatch;
import CATALYST.Control.MsgType;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class TradeButtonEditor
extends DefaultCellEditor {
    private String label;
    JButton btn;
    private LanguageCentre languageCentre = new LanguageCentre();

    public TradeButtonEditor(final MarketWatch mkt) {
        super(new JCheckBox());
        this.btn = new JButton(this.languageCentre.getValue(LanguageConstant.Trade));
        this.btn.setOpaque(true);
        this.btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mkt._fireStatsEvent(MsgType.TRADE, mkt.GetSymbolAndMarket(), false);
                TradeButtonEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.label = this.languageCentre.getValue(LanguageConstant.Trade);
        return this.btn;
    }

    @Override
    public Object getCellEditorValue() {
        return new String(this.label);
    }

    private void OpenForm() {
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }
}

