/*
 * Decompiled with CFR 0.152.
 */
package CATALYST.Control;

import java.awt.Color;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class Utilities {
    public static String SymbolAndMarketSeprator = ";";

    public static String[] split(String str, char x) {
        return str.split("\\" + String.valueOf(x), -1);
    }

    public static Color convertToColor(String s, Color _default) {
        Color c;
        int i = 0;
        int j = 0;
        String h = "0123456789abcdef";
        int[] hex = new int[6];
        if (s != null && s.length() == 7) {
            for (i = 0; i < 6; ++i) {
                for (j = 0; j < 16; ++j) {
                    if (Character.toLowerCase(s.charAt(i + 1)) != h.charAt(j)) continue;
                    hex[i] = j;
                }
            }
            c = new Color(hex[0] * 16 + hex[1], hex[2] * 16 + hex[3], hex[4] * 16 + hex[5]);
        } else {
            c = _default;
        }
        return c;
    }

    public static double round(double value, int decimalPlace) {
        double power_of_ten = 1.0;
        while (decimalPlace-- > 0) {
            power_of_ten *= 10.0;
        }
        return (double)Math.round(value * power_of_ten) / power_of_ten;
    }

    public static String FormatedText(Number Num) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(true);
        return nf.format(Num);
    }

    public static String DateNow(String DateFormat2) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DateFormat2);
        return sdf.format(cal.getTime());
    }

    public static String GetMarketFromsymbol(String Symbol_) {
        Symbol_ = Symbol_.toUpperCase();
        String[] MarketMonth = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
        String[] SIF_Scrip = new String[]{"KSE100", "KSE30", "KMI30", "ALLSHR"};
        String Market = "REG";
        if (Symbol_.indexOf("-") > 1) {
            String[] SymbilWithMarket = Symbol_.split("\\-", -1);
            if (SymbilWithMarket[1].equalsIgnoreCase("PRO")) {
                Market = "IPO";
            } else {
                for (int i = 0; i < MarketMonth.length; ++i) {
                    if (SymbilWithMarket[1].indexOf(MarketMonth[i]) < 0) continue;
                    for (int j = 0; j < SIF_Scrip.length; ++j) {
                        if (!SIF_Scrip[j].equals(SymbilWithMarket[0])) continue;
                        Market = "SIF";
                        break;
                    }
                    if (Market.equals("SIF")) break;
                    Market = "FUT";
                    break;
                }
            }
        }
        return Market;
    }

    public static String GetMarketFromContract(String contract) {
        return "FUT";
    }

    public static void write(String str) {
        System.out.println(str);
    }

    public static String GetSymbolMonthFromSymbol(String symbol) {
        String month = "";
        if (symbol.indexOf("-") > 0 && (month = symbol.split("\\-", -1)[1]).indexOf(":") > 0) {
            month = month.split("\\:", -1)[0];
        }
        return month;
    }
}

