/*
 * Decompiled with CFR 0.152.
 */
package kse.gui.bean;

import common.gui.util.LogCommon;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class Outstandinglog {
    public static final int indexTrader = 0;
    public static final int indexMarket = 1;
    public static final int indexScrip = 2;
    public static final int indexPrice = 3;
    public static final int indexRemaining = 4;
    public static final int indexAccount = 5;
    public static final int indexOrderNo = 6;
    public static final int indexHouseOrderNo = 7;
    public static final int indexFlag = 8;
    public static final int indexType = 9;
    public static final int indexAction = 10;
    public static final int indexTimeStamp = 11;
    public static final int indexLimitPrice = 12;
    public static final int indexDisclosedVolume = 13;
    public static final int indexActualVolume = 14;
    public static final int indexOrderType = 15;
    public String Outstandinglog_TRADER = "";
    public String Outstandinglog_SYMBOL = "";
    public double Outstandinglog_PRICE = 0.0;
    public long Outstandinglog_REMAINING = 0L;
    public String Outstandinglog_ACCOUNT = "";
    public String Outstandinglog_ORDERNO = "";
    public String Outstandinglog_HORDERNO = "";
    public String Outstandinglog_FLAG = "";
    public String Outstandinglog_TYPE = "";
    public String Outstandinglog_MARKET = "";
    public String Outstandinglog_ACTION = "";
    public String Outstandinglog_TIMESTAMP = "";
    public String Outstandinglog_LIMIT_PRICE = "";
    public String Outstandinglog_DISCLOSED_Volume = "";
    public String Outstandinglog_Actual_Volume = "";
    public String Outstandinglog_Order_Type = "";

    public boolean parse(String log) {
        boolean ret = false;
        try {
            String[] STRARRAY = log.split("\\|", -1);
            String[] STRVALUES = STRARRAY[0].split("\\;", -1);
            if (STRVALUES.length < 7) {
                return false;
            }
            this.Outstandinglog_TRADER = STRVALUES[0].trim().replaceAll("\\,", "");
            this.Outstandinglog_SYMBOL = STRVALUES[2].trim().replaceAll("\\,", "");
            this.Outstandinglog_PRICE = Double.parseDouble(STRVALUES[3].trim().replaceAll("\\,", ""));
            this.Outstandinglog_REMAINING = Long.parseLong(STRVALUES[4].trim().replaceAll("\\,", ""));
            this.Outstandinglog_ACCOUNT = STRVALUES[5].trim().replaceAll("\\,", "");
            this.Outstandinglog_ORDERNO = STRVALUES[6].trim().replaceAll("\\,", "");
            this.Outstandinglog_HORDERNO = STRVALUES[7].trim().replaceAll("\\,", "");
            this.Outstandinglog_FLAG = STRVALUES[8].trim().replaceAll("\\,", "");
            this.Outstandinglog_TYPE = STRVALUES[9].trim().replaceAll("\\,", "");
            this.Outstandinglog_MARKET = STRVALUES[1].trim().replaceAll("\\,", "");
            this.Outstandinglog_ACTION = LogCommon.actionMap.containsKey(STRVALUES[10].toUpperCase()) ? ((String)LogCommon.actionMap.get(STRVALUES[10].toUpperCase())).trim().replaceAll("\\,", "") : STRVALUES[10].trim().replaceAll("\\,", "");
            if (STRVALUES.length - 1 >= 11) {
                this.Outstandinglog_TIMESTAMP = STRVALUES[11].trim().replaceAll("\\,", "");
            } else {
                Date dt = new Date(System.currentTimeMillis());
                SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss-dd-MM-yyyy");
                this.Outstandinglog_TIMESTAMP = f.format(dt);
            }
            this.Outstandinglog_LIMIT_PRICE = STRVALUES[12].trim().replaceAll("\\,", "");
            this.Outstandinglog_DISCLOSED_Volume = STRVALUES[13].trim().replaceAll("\\,", "");
            this.Outstandinglog_Actual_Volume = STRVALUES[14].trim().replaceAll("\\,", "");
            this.Outstandinglog_Order_Type = STRVALUES[15].trim().replaceAll("\\,", "");
            ret = true;
        }
        catch (Exception ee) {
            this.Outstandinglog_TRADER = "";
            this.Outstandinglog_SYMBOL = "";
            this.Outstandinglog_PRICE = 0.0;
            this.Outstandinglog_REMAINING = 0L;
            this.Outstandinglog_ACCOUNT = "";
            this.Outstandinglog_ORDERNO = "";
            this.Outstandinglog_HORDERNO = "";
            this.Outstandinglog_FLAG = "";
            this.Outstandinglog_TYPE = "";
            this.Outstandinglog_MARKET = "";
            this.Outstandinglog_ACTION = "";
            this.Outstandinglog_TIMESTAMP = "";
            this.Outstandinglog_LIMIT_PRICE = "";
            this.Outstandinglog_DISCLOSED_Volume = "";
            this.Outstandinglog_Actual_Volume = "";
            this.Outstandinglog_Order_Type = "";
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.Outstandinglog_TRADER.length() == 0 || this.Outstandinglog_TRADER.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Outstandinglog_TRADER);
        }
        sb.append(";");
        if (this.Outstandinglog_MARKET.length() == 0 || this.Outstandinglog_MARKET.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Outstandinglog_MARKET);
        }
        sb.append(";");
        if (this.Outstandinglog_SYMBOL.length() == 0 || this.Outstandinglog_SYMBOL.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Outstandinglog_SYMBOL);
        }
        sb.append(";");
        sb.append(this.Outstandinglog_PRICE);
        sb.append(";");
        sb.append(this.Outstandinglog_REMAINING);
        sb.append(";");
        if (this.Outstandinglog_ACCOUNT.length() == 0 || this.Outstandinglog_ACCOUNT.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Outstandinglog_ACCOUNT);
        }
        sb.append(";");
        if (this.Outstandinglog_ORDERNO.length() == 0 || this.Outstandinglog_ORDERNO.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Outstandinglog_ORDERNO);
        }
        sb.append(";");
        if (this.Outstandinglog_HORDERNO.length() == 0 || this.Outstandinglog_HORDERNO.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Outstandinglog_HORDERNO);
        }
        sb.append(";");
        if (this.Outstandinglog_FLAG.length() == 0 || this.Outstandinglog_FLAG.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Outstandinglog_FLAG);
        }
        sb.append(";");
        if (this.Outstandinglog_TYPE.length() == 0 || this.Outstandinglog_TYPE.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Outstandinglog_TYPE);
        }
        sb.append(";");
        if (this.Outstandinglog_ACTION.length() == 0 || this.Outstandinglog_ACTION.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Outstandinglog_ACTION);
        }
        sb.append(";");
        if (this.Outstandinglog_TIMESTAMP.length() == 0 || this.Outstandinglog_TIMESTAMP.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Outstandinglog_TIMESTAMP);
        }
        sb.append(";");
        if (this.Outstandinglog_LIMIT_PRICE.length() == 0 || this.Outstandinglog_LIMIT_PRICE.toLowerCase().compareTo("null") == 0) {
            sb.append("0");
        } else {
            sb.append(this.Outstandinglog_LIMIT_PRICE);
        }
        sb.append(";");
        if (this.Outstandinglog_DISCLOSED_Volume.length() == 0 || this.Outstandinglog_DISCLOSED_Volume.toLowerCase().compareTo("null") == 0) {
            sb.append("0");
        } else {
            sb.append(this.Outstandinglog_DISCLOSED_Volume);
        }
        sb.append(";");
        if (this.Outstandinglog_Actual_Volume.length() == 0 || this.Outstandinglog_Actual_Volume.toLowerCase().compareTo("null") == 0) {
            sb.append("0");
        } else {
            sb.append(this.Outstandinglog_Actual_Volume);
        }
        sb.append(";");
        if (this.Outstandinglog_Order_Type.length() == 0 || this.Outstandinglog_Order_Type.toLowerCase().compareTo("null") == 0) {
            sb.append("0");
        } else {
            sb.append(this.Outstandinglog_Order_Type);
        }
        sb.append("|");
        return new String(sb);
    }

    public static long GetTotalVolume(Hashtable hashtable) {
        long volume = 0L;
        try {
            Enumeration e = hashtable.keys();
            while (e.hasMoreElements()) {
                Outstandinglog olog = (Outstandinglog)hashtable.get(e.nextElement().toString());
                if (olog == null) continue;
                volume += olog.Outstandinglog_REMAINING;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return volume;
    }

    public static double GetAvgPrice(Hashtable hashtable) {
        double avgPrice = 0.0;
        try {
            double totPrice = 0.0;
            int tottrade = 0;
            Enumeration e = hashtable.keys();
            while (e.hasMoreElements()) {
                Outstandinglog olog = (Outstandinglog)hashtable.get(e.nextElement().toString());
                if (olog == null) continue;
                totPrice += olog.Outstandinglog_PRICE;
                ++tottrade;
            }
            if (tottrade > 0) {
                avgPrice = totPrice / (double)tottrade;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return avgPrice;
    }

    public static String GetLogForWebClient(ArrayList<Outstandinglog> hashtable) {
        StringBuilder ret = new StringBuilder();
        try {
            if (hashtable == null) {
                return "";
            }
            for (int i = 0; i < hashtable.size(); ++i) {
                Outstandinglog olog = hashtable.get(i);
                if (olog == null) continue;
                ret.append(olog.toString());
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return ret.toString();
    }

    public static synchronized ArrayList<Outstandinglog> GetOrderToCancel(ArrayList<Outstandinglog> hashtable, String OrderNumber) {
        ArrayList<Outstandinglog> retList = new ArrayList();
        try {
            Outstandinglog LastOrderLog = null;
            for (int i = 0; i < hashtable.size(); ++i) {
                Outstandinglog olog = hashtable.get(i);
                if (olog == null || !olog.Outstandinglog_ORDERNO.equalsIgnoreCase(OrderNumber)) continue;
                LastOrderLog = olog;
            }
            if (LastOrderLog != null) {
                retList.add(LastOrderLog);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            retList = hashtable;
        }
        return retList;
    }
}

