/*
 * Decompiled with CFR 0.152.
 */
package kse.gui.bean;

import java.text.SimpleDateFormat;
import java.util.Date;

public class TradeOutLogBean {
    private String Trader = "";
    private String Market = "";
    private String Scrip = "";
    private String Time = "";
    private Date dateTime = new Date();
    private long counter = 0L;
    private String OrderNo = "";
    private String Type = "";
    private long FillVolume = 0L;
    private double Price = 0.0;
    private String Ticket = "";
    private String Account = "";
    private String Action = "";
    private String Flag = "";
    private long TotalVolume = 0L;
    private double TotalValue = 0.0;
    private long Remaining = 0L;
    private String Order_Type = "";
    private long totalFillBuy = 0L;
    private double totolAmountBuy = 0.0;
    private double averageBuy = 0.0;
    private long totalFillSell = 0L;
    private double totolAmountSell = 0.0;
    private double averageSell = 0.0;

    public static TradeOutLogBean parse(String data, boolean isServerPacket) {
        TradeOutLogBean bean = new TradeOutLogBean();
        String[] values = data.split("\\;", -1);
        bean.setTrader(values[0]);
        if (isServerPacket) {
            bean.setScrip(values[1]);
            bean.setMarket(values[2]);
        } else {
            bean.setScrip(values[2]);
            bean.setMarket(values[1]);
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss-dd-MM-yyyy");
            Date date = formatter.parse(values[3]);
            bean.setDateTime(date);
            formatter = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss");
            bean.setTime(formatter.format(date));
        }
        catch (Exception formatter) {
            // empty catch block
        }
        try {
            bean.setCounter(Long.parseLong(values[4]));
        }
        catch (Exception formatter) {
            // empty catch block
        }
        bean.setOrderNo(values[5]);
        String type = values[6];
        if (type.equalsIgnoreCase("SEL")) {
            bean.setType("SELL");
        } else {
            bean.setType(type);
        }
        try {
            bean.setFillVolume(Long.parseLong(values[7]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bean.setPrice(Double.parseDouble(values[8]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        bean.setTicket(values[9]);
        bean.setAccount(values[10]);
        if (values[11].equalsIgnoreCase("TRD")) {
            bean.setAction("Traded");
        }
        bean.setFlag(values[12]);
        try {
            bean.setTotalVolume(Long.parseLong(values[13]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bean.setTotalValue(Double.parseDouble(values[14]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        bean.setRemaining(Long.parseLong(values[15]));
        if (values.length - 1 >= 16) {
            bean.setOrder_Type(values[16]);
        } else {
            bean.setOrder_Type("");
        }
        return bean;
    }

    public String getTrader() {
        return this.Trader;
    }

    public void setTrader(String Trader) {
        this.Trader = Trader;
    }

    public String getMarket() {
        return this.Market;
    }

    public void setMarket(String Market) {
        this.Market = Market;
    }

    public String getScrip() {
        return this.Scrip;
    }

    public void setScrip(String Scrip) {
        this.Scrip = Scrip;
    }

    public String getTime() {
        return this.Time;
    }

    public void setTime(String Time) {
        this.Time = Time;
    }

    public Date getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(Date dateTime) {
        this.dateTime = dateTime;
    }

    public long getCounter() {
        return this.counter;
    }

    public void setCounter(long counter) {
        this.counter = counter;
    }

    public String getOrderNo() {
        return this.OrderNo;
    }

    public void setOrderNo(String OrderNo) {
        this.OrderNo = OrderNo;
    }

    public String getType() {
        return this.Type;
    }

    public void setType(String Type) {
        this.Type = Type;
    }

    public long getFillVolume() {
        return this.FillVolume;
    }

    public void setFillVolume(long FillVolume) {
        this.FillVolume = FillVolume;
    }

    public double getPrice() {
        return this.Price;
    }

    public void setPrice(double Price) {
        this.Price = Price;
    }

    public String getTicket() {
        return this.Ticket;
    }

    public void setTicket(String Ticket) {
        this.Ticket = Ticket;
    }

    public String getAccount() {
        return this.Account;
    }

    public void setAccount(String Account) {
        this.Account = Account;
    }

    public String getAction() {
        return this.Action;
    }

    public void setAction(String Action2) {
        this.Action = Action2;
    }

    public String getFlag() {
        return this.Flag;
    }

    public void setFlag(String Flag) {
        this.Flag = Flag;
    }

    public long getTotalVolume() {
        return this.TotalVolume;
    }

    public void setTotalVolume(long TotalVolume) {
        this.TotalVolume = TotalVolume;
    }

    public double getTotalValue() {
        return this.TotalValue;
    }

    public void setTotalValue(double TotalValue) {
        this.TotalValue = TotalValue;
    }

    public long getRemaining() {
        return this.Remaining;
    }

    public void setRemaining(long Remaining) {
        this.Remaining = Remaining;
    }

    public long getTotalFillBuy() {
        return this.totalFillBuy;
    }

    public void setTotalFillBuy(long totalFillBuy) {
        this.totalFillBuy = totalFillBuy;
    }

    public double getTotolAmountBuy() {
        return this.totolAmountBuy;
    }

    public void setTotolAmountBuy(double totolAmountBuy) {
        this.totolAmountBuy = totolAmountBuy;
    }

    public double getAverageBuy() {
        return this.averageBuy;
    }

    public void setAverageBuy(double averageBuy) {
        this.averageBuy = averageBuy;
    }

    public long getTotalFillSell() {
        return this.totalFillSell;
    }

    public void setTotalFillSell(long totalFillSell) {
        this.totalFillSell = totalFillSell;
    }

    public double getTotolAmountSell() {
        return this.totolAmountSell;
    }

    public void setTotolAmountSell(double totolAmountSell) {
        this.totolAmountSell = totolAmountSell;
    }

    public double getAverageSell() {
        return this.averageSell;
    }

    public void setAverageSell(double averageSell) {
        if (Double.isNaN(averageSell)) {
            averageSell = 0.0;
        }
        this.averageSell = averageSell;
    }

    public String getOrder_Type() {
        return this.Order_Type;
    }

    public void setOrder_Type(String Order_Type) {
        this.Order_Type = Order_Type;
    }

    public String toString() {
        return "Trader = " + this.Trader + "Market = " + this.Market + "Scrip = " + this.Scrip + "Time = " + this.Time + "counter = " + this.counter + "OrderNo = " + this.OrderNo + "Type = " + this.Type + "FillVolume = " + this.FillVolume + "Price = " + this.Price + "Ticket = " + this.Ticket + "Account = " + this.Account + "Action = " + this.Action + "Flag = " + this.Flag + "TotalVolume = " + this.TotalVolume + "TotalValue = " + this.TotalValue + "Remaining = " + this.Remaining + "totalFillBuy = " + this.totalFillBuy + "totolAmountBuy = " + this.totolAmountBuy + "averageBuy = " + this.averageBuy + "totalFillSell = " + this.totalFillSell + "totolAmountSell = " + this.totolAmountSell + "averageSell = " + this.averageSell;
    }
}

