/*
 * Decompiled with CFR 0.152.
 */
package kse.gui.comparator;

import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import kse.gui.bean.MarginCallBean;
import kse.util.LogsKSE;

public class MarginCallComparator
implements Comparator {
    protected int m_sortCol;
    protected boolean m_sortAsc;
    private HashMap<String, String> ht = null;

    public MarginCallComparator(int sortCol, boolean sortAsc) {
        this.m_sortCol = sortCol;
        this.m_sortAsc = sortAsc;
        this.ht = new HashMap();
        this.ht.put("First Margin Call", "a");
        this.ht.put("Second Margin Call", "b");
        this.ht.put("Final Margin Call", "c");
    }

    public int compare(Object o1, Object o2) {
        int result = 0;
        try {
            MarginCallBean s1 = null;
            MarginCallBean s2 = null;
            if (o1 instanceof MarginCallBean && o2 instanceof MarginCallBean) {
                s1 = (MarginCallBean)o1;
                s2 = (MarginCallBean)o2;
            }
            switch (this.m_sortCol) {
                case 0: {
                    result = s1.account.trim().compareTo(s2.account.trim());
                    break;
                }
                case 1: {
                    result = s1.name.trim().compareTo(s2.name.trim());
                    break;
                }
                case 2: {
                    result = this.ht.get(s1.call.trim()).compareTo(this.ht.get(s2.call.trim()));
                    break;
                }
                case 3: {
                    double c1 = Double.parseDouble(s1.shortfall.trim().replaceAll("\\,", ""));
                    double c2 = Double.parseDouble(s2.shortfall.trim().replaceAll("\\,", ""));
                    result = c1 < c2 ? -1 : (c1 > c2 ? 1 : 0);
                    break;
                }
                case 4: {
                    double b1 = Double.parseDouble(s1.shortfallPer.trim().replaceAll("\\,", ""));
                    double b2 = Double.parseDouble(s2.shortfallPer.trim().replaceAll("\\,", ""));
                    result = b1 < b2 ? -1 : (b1 > b2 ? 1 : 0);
                    break;
                }
                case 5: {
                    Date d1 = LogsKSE.sdfMessage.parse(s1.dateTime.trim());
                    Date d2 = LogsKSE.sdfMessage.parse(s2.dateTime.trim());
                    result = d1.compareTo(d2);
                }
            }
            if (!this.m_sortAsc) {
                result = -result;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

