/*
 * Decompiled with CFR 0.152.
 */
package kse.gui.render;

import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import kse.gui.bean.ClosePriceExportBean;

public class ClosePriceExportRender
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel cell = new JLabel();
        cell.setHorizontalAlignment(2);
        cell.setOpaque(true);
        String colName = table.getColumnName(column);
        if (value == null) {
            value = "";
        }
        ClosePriceExportBean b = null;
        if (value instanceof ClosePriceExportBean) {
            b = (ClosePriceExportBean)value;
            if (colName.equalsIgnoreCase("Market")) {
                cell.setHorizontalAlignment(2);
                cell.setText(" " + b.getMarket());
            } else if (colName.equalsIgnoreCase("Scrip")) {
                cell.setText(" " + b.getScrip());
            } else if (colName.equalsIgnoreCase("Close Price")) {
                cell.setText(Util.format2digit((String)(b.getClosePrice() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("Open Price")) {
                cell.setText(Util.format2digit((String)(b.getOpenPrice() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("High")) {
                cell.setText(Util.format2digit((String)(b.getHigh() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("Low")) {
                cell.setText(Util.format2digit((String)(b.getLow() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("Direction")) {
                cell.setText(" " + b.getDirection());
                cell.setHorizontalAlignment(0);
            } else if (colName.equalsIgnoreCase("Change")) {
                cell.setText(Util.format2digit((String)(b.getChange() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("Total Trade")) {
                cell.setText(Util.format0digit((String)(b.getTotalTrade() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("Total Volume")) {
                cell.setText(Util.format0digit((String)(b.getTotalVolume() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("Value")) {
                cell.setText(Util.format2digit((String)(b.getValue() + "")) + " ");
                cell.setHorizontalAlignment(4);
            }
            if (row % 2 == 0) {
                cell.setBackground(MyColors.cellRenderEven);
            } else {
                cell.setBackground(MyColors.cellRenderOdd);
            }
            if (isSelected) {
                cell.setBackground(MyColors.SelectionFG);
            }
        }
        return cell;
    }
}

