/*
 * Decompiled with CFR 0.152.
 */
package kse.gui.render;

import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import kse.gui.bean.OrderImportBean;

public class OrderImportRender
extends DefaultTableCellRenderer {
    private ImageIcon closeIcon = new ImageIcon(this.getClass().getResource("/kse/gui/images/close.png"));

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel cell = new JLabel();
        cell.setHorizontalAlignment(2);
        cell.setOpaque(true);
        String transType = "";
        String order_Type = "";
        String colName = table.getColumnName(column);
        if (value == null) {
            value = "";
        }
        OrderImportBean b = null;
        if (value instanceof OrderImportBean) {
            b = (OrderImportBean)value;
            transType = b.getType();
            order_Type = b.getType();
            if (b.getType().indexOf("SEL") >= 0) {
                b.setType("SELL");
            }
            if (colName.equalsIgnoreCase("Remove")) {
                cell.setIcon(this.closeIcon);
                cell.setHorizontalAlignment(0);
            } else if (colName.equalsIgnoreCase("Market")) {
                cell.setText(" " + b.getMarket());
            } else if (colName.equalsIgnoreCase("Scrip")) {
                cell.setText(" " + b.getScrip());
            } else if (colName.equalsIgnoreCase("Price")) {
                cell.setText(Util.format2digit((String)(b.getPrice() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("Volume")) {
                cell.setText(Util.format0digit((String)(b.getVolume() + "")) + " ");
                cell.setHorizontalAlignment(4);
            } else if (colName.equalsIgnoreCase("Account")) {
                cell.setText(" " + b.getAccount());
            } else if (colName.equalsIgnoreCase("Type")) {
                cell.setText(" " + b.getType());
            }
        }
        if (transType.equalsIgnoreCase("SELL")) {
            cell.setBackground(MyColors.tradeLogSellBG);
            cell.setForeground(MyColors.tradeLogSellFG);
        } else if (transType.equalsIgnoreCase("BUY")) {
            cell.setBackground(MyColors.tradeLogBuyBG);
            cell.setForeground(MyColors.tradeLogBuyFG);
        }
        if (order_Type.equalsIgnoreCase("SHS")) {
            cell.setForeground(MyColors.tradeLogSellFG.darker().darker().darker());
        }
        if (b.isInOutsanding()) {
            cell.setBackground(Color.YELLOW);
        }
        return cell;
    }
}

