/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui;

import common.gui.component.NxGLabel;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.Timer;
import org.jdesktop.swingx.JXPanel;
import pmex.gui.Tile;

public class PricePanel
extends JXPanel {
    public static final int volHeight = 15;
    private boolean buy = false;
    private Color foucsColor = Color.WHITE;
    private Tile holder;
    private Color start = Color.WHITE;
    private Color end = Color.WHITE;
    private Timer timerDefaultColor = new Timer(10000, null);
    private Color defaultColor = Color.LIGHT_GRAY;
    private NxGLabel lblPrice;
    private NxGLabel lblVolume;

    public PricePanel() {
        try {
            this.initComponents();
            this.lblPrice.setOpaque(false);
            this.lblVolume.setOpaque(false);
            this.start = this.foucsColor;
            this.SetTimer(this.lblPrice, this.timerDefaultColor);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.lblPrice = new NxGLabel();
        this.lblVolume = new NxGLabel();
        this.setBackground(new Color(255, 255, 255));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PricePanel.this.formMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PricePanel.this.formMouseExited(evt);
            }
        });
        this.setLayout(null);
        this.lblPrice.setForeground(new Color(51, 204, 0));
        this.lblPrice.setHorizontalAlignment(0);
        this.lblPrice.setText("88,888.8");
        this.lblPrice.setFont(new Font("Tahoma", 1, 18));
        this.lblPrice.setOpaque(true);
        this.add((Component)this.lblPrice);
        this.lblPrice.setBounds(0, 0, 100, 30);
        this.lblVolume.setHorizontalAlignment(0);
        this.lblVolume.setText("V 9999");
        this.lblVolume.setFont(new Font("Tahoma", 1, 12));
        this.add((Component)this.lblVolume);
        this.lblVolume.setBounds(0, 30, 100, 20);
    }

    private void formMouseEntered(MouseEvent evt) {
    }

    private void formMouseExited(MouseEvent evt) {
    }

    protected void paintComponent(Graphics g) {
        this.setOpaque(false);
        Graphics2D g2 = (Graphics2D)g;
        int height = this.getHeight();
        int width = this.getWidth();
        GradientPaint painter = new GradientPaint(0.0f, height / 2, this.end, 0.0f, height, this.start);
        g2.setPaint(painter);
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, height / 2, width, height);
        g2.fill(rect);
        super.paintComponent(g);
    }

    public boolean isBuy() {
        return this.buy;
    }

    public void setIsBuy(boolean isBuy) {
        this.buy = isBuy;
    }

    public Color getFoucsColor() {
        return this.foucsColor;
    }

    public void setFoucsColor(Color foucsColor) {
        this.foucsColor = foucsColor;
        this.start = foucsColor;
    }

    public void setShowVolume(boolean showVolume) {
        this.lblVolume.setVisible(showVolume);
        this.repaint();
        this.getRootPane().repaint();
    }

    public Tile getHolder() {
        return this.holder;
    }

    public void setHolder(Tile holder) {
        this.holder = holder;
    }

    public void setPrice(double price) {
        this.lblPrice.setText(Util.formatPMEXAsCome((String)(price + "")));
    }

    public void setVolume(long volume) {
        this.lblVolume.setText(Util.format0digit((String)(volume + "")));
    }

    public void setDefaultValues() {
        this.lblPrice.setText("");
        this.lblVolume.setText("");
    }

    public void setForeground2(Color fg) {
        this.lblPrice.setForeground(fg);
        this.lblVolume.setForeground(fg);
    }

    private void SetTimer(final NxGLabel Obj, Timer timer) {
        ActionListener Task = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Obj.setBlendColorForeground(PricePanel.this.defaultColor);
                Obj.repaint();
            }
        };
        timer.setRepeats(false);
        timer.addActionListener(Task);
        timer.start();
    }

    public void restart(Color bgColor) {
        this.timerDefaultColor.restart();
        this.lblPrice.setBlendColorForeground(bgColor);
        this.lblPrice.repaint();
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = defaultColor;
    }
}

