/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui;

import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import pmex.gui.Tile;

public class PricePanel1
extends JXPanel {
    public static final int volHeight = 15;
    private boolean buy = false;
    private Color foucsColor = Color.WHITE;
    private Tile holder;
    private Color start = Color.WHITE;
    private Color end = Color.WHITE;
    private JXLabel lblPrice;
    private JXLabel lblVolume;

    public PricePanel1() {
        try {
            this.initComponents();
            this.start = this.foucsColor;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.lblPrice = new JXLabel();
        this.lblVolume = new JXLabel();
        this.setBackground(new Color(255, 255, 255));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PricePanel1.this.formMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PricePanel1.this.formMouseExited(evt);
            }
        });
        this.setLayout(null);
        this.lblPrice.setForeground(new Color(51, 204, 0));
        this.lblPrice.setHorizontalAlignment(0);
        this.lblPrice.setText("88,888.8");
        this.lblPrice.setFont(new Font("Tahoma", 1, 18));
        this.add((Component)this.lblPrice);
        this.lblPrice.setBounds(0, 0, 100, 30);
        this.lblVolume.setHorizontalAlignment(0);
        this.lblVolume.setText("V 9999");
        this.lblVolume.setFont(new Font("Tahoma", 1, 12));
        this.add((Component)this.lblVolume);
        this.lblVolume.setBounds(0, 30, 100, 20);
    }

    private void formMouseEntered(MouseEvent evt) {
    }

    private void formMouseExited(MouseEvent evt) {
    }

    protected void paintComponent(Graphics g) {
        this.setOpaque(false);
        Graphics2D g2 = (Graphics2D)g;
        int height = this.getHeight();
        int width = this.getWidth();
        GradientPaint painter = new GradientPaint(0.0f, height / 2, this.end, 0.0f, height, this.start);
        g2.setPaint(painter);
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, height / 2, width, height);
        g2.fill(rect);
        super.paintComponent(g);
    }

    public boolean isBuy() {
        return this.buy;
    }

    public void setIsBuy(boolean isBuy) {
        this.buy = isBuy;
    }

    public Color getFoucsColor() {
        return this.foucsColor;
    }

    public void setFoucsColor(Color foucsColor) {
        this.foucsColor = foucsColor;
        this.start = foucsColor;
    }

    public void setShowVolume(boolean showVolume) {
        this.lblVolume.setVisible(showVolume);
        this.repaint();
        this.getRootPane().repaint();
    }

    public Tile getHolder() {
        return this.holder;
    }

    public void setHolder(Tile holder) {
        this.holder = holder;
    }

    public void setPrice(double price) {
        this.lblPrice.setText(Util.format2digit((String)(price + "")));
    }

    public void setVolume(long volume) {
        this.lblVolume.setText(Util.format0digit((String)(volume + "")));
    }

    public void setDefaultValues() {
        this.lblPrice.setText("");
        this.lblVolume.setText("");
    }

    public void setForeground2(Color fg) {
        this.lblPrice.setForeground(fg);
        this.lblVolume.setForeground(fg);
    }
}

