/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui;

import common.dragndrop.DragAndDropLock;
import common.dragndrop.GhostGlassPane;
import common.gui.component.DocumentType;
import common.gui.component.NxGLabel;
import common.gui.component.NxGLink;
import common.gui.component.NxGRoundedPanel;
import common.gui.component.NxGTextFeild;
import common.gui.component.NxGTextWraper;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LoginMode;
import common.gui.util.MyColors;
import common.gui.util.Title;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXLabel;
import pmex.gui.PricePanel;
import pmex.gui.bean.PMEXMarketFeedBean;
import pmex.gui.bean.TileBean;
import pmex.gui.dragdrop.TileDropDestination;
import pmex.gui.dragdrop.TileItemTransferHandler;
import pmex.gui.dragdrop.TravelBackToOrigin;
import pmex.gui.event.PMEXTileEvent;
import pmex.gui.event.PMEXTileEventListener;
import pmex.gui.util.LogsPMEX;

public class Tile
extends NxGRoundedPanel
implements ActionListener,
PMEXTileEventListener,
MouseListener,
DragGestureListener,
DragSourceMotionListener,
DragSourceListener,
Serializable {
    public static final int unitHeight = 22;
    private boolean showUnit = false;
    private Timer timerDefaultColor = new Timer(10000, null);
    private Color bgColorHeader = Color.LIGHT_GRAY;
    private Color bgColorBuy = MyColors.MBPBuyFG;
    private Color bgColorSell = MyColors.MBPSellFG;
    private final Color expireColor = new Color(111, 111, 111);
    private final Color upColorHeader = new Color(255, 255, 196);
    private final Color downColorHeader = new Color(151, 255, 203);
    private final Color upColorPrice = new Color(51, 216, 133);
    private final Color downColorPrice = new Color(204, 204, 14);
    private final Color bgColorDefault = Color.LIGHT_GRAY;
    private int ID = -1;
    private RenderingHints hints;
    private boolean isMove = true;
    private String contract = "";
    private boolean isExpire = false;
    private PMEXMarketFeedBean fb = null;
    private List _listeners = new ArrayList();
    private DragSource dragSource = DragSource.getDefaultDragSource();
    private TileDropDestination tileDropDestination;
    private boolean isExpireToday = false;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JXLabel lblBuy;
    private JXLabel lblChange;
    private NxGLabel lblClose;
    private NxGLabel lblContract;
    private JXLabel lblQuantity;
    private JXLabel lblSell;
    private JMenuItem menuAddContract;
    private JMenuItem menuBuy;
    private JMenuItem menuClose;
    private JMenuItem menuDeleteAll;
    private JMenuItem menuLadder;
    private JMenuItem menuMBP;
    private JMenuItem menuSell;
    private JPopupMenu popupMenu;
    private PricePanel ppBuy;
    private PricePanel ppSell;
    private JSeparator separator;
    private NxGTextFeild txtQuantity;

    public Tile() {
        try {
            this.initComponents();
            this.createRenderingHints();
            this.setThis();
            this.setupMenu();
            this.lblBuy.setText("<html><b>" + Title.PMEX_Buy + "</b><html>");
            this.lblSell.setText("<html><b>" + Title.PMEX_Sell + "</b><html>");
            this.lblBuy.setForeground(MyColors.BuyBG);
            this.lblSell.setForeground(MyColors.SellBG);
            this.lblQuantity.setVisible(false);
            this.txtQuantity.setVisible(false);
            this.txtQuantity.setDocument(DocumentType.NUMERIC);
            this.ppBuy.setIsBuy(true);
            this.ppSell.setIsBuy(false);
            this.ppSell.setDefaultColor(MyColors.MBPSellFG);
            this.ppBuy.setDefaultColor(MyColors.MBPBuyFG);
            NxGTextWraper t = new NxGTextWraper("Quantity", (JTextComponent)this.txtQuantity, NxGTextWraper.Show.FOCUS_LOST);
            t.setIcon((Icon)new ImageIcon(this.getClass().getResource("/pmex/gui/images/gold.png")));
            this.SetTimerChange(this.lblContract, this.timerDefaultColor);
            this.SetTimerChange(this.lblClose, this.timerDefaultColor);
            this.setOpaque(false);
            this.lblContract.setBackground(this.bgColorDefault);
            this.lblClose.setBackground(this.bgColorDefault);
            this.setDefaultValues();
            this.setPreferredSize(new Dimension(217, 103));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "Tiles " + ex);
        }
    }

    private void setThis() {
        this.lblContract.setLabelFor((Component)((Object)this));
        this.dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 1, this);
        this.dragSource.addDragSourceMotionListener(this);
        this.dragSource.createDefaultDragGestureRecognizer((Component)this.lblContract, 1, this);
        this.dragSource.addDragSourceMotionListener(this);
        this.ppBuy.setHolder(this);
        this.ppSell.setHolder(this);
        this.ppBuy.addMouseListener(this);
        this.ppSell.addMouseListener(this);
        this.separator.addMouseListener(this);
        this.lblContract.addMouseListener((MouseListener)this);
        this.lblClose.addMouseListener((MouseListener)this);
        this.lblSell.addMouseListener((MouseListener)this);
        this.lblBuy.addMouseListener((MouseListener)this);
        this.menuLadder.addActionListener(this);
        this.menuAddContract.addActionListener(this);
        this.menuMBP.addActionListener(this);
        this.menuSell.addActionListener(this);
        this.menuBuy.addActionListener(this);
        this.menuClose.addActionListener(this);
        this.menuDeleteAll.addActionListener(this);
        this.setPopupIcon();
    }

    private void setupMenu() {
        this.lblContract.setComponentPopupMenu(this.popupMenu);
        this.menuLadder.setText(Title.PMEX_Ladder);
        this.menuMBP.setText(Title.PMEX_MarketDepthByPrice);
        this.menuSell.setText(Title.PMEX_Sell);
        this.menuBuy.setText(Title.PMEX_Buy);
        this.ppSell.setComponentPopupMenu(this.popupMenu);
        this.ppBuy.setComponentPopupMenu(this.popupMenu);
        this.lblClose.setComponentPopupMenu(this.popupMenu);
    }

    private void createRenderingHints() {
        this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Object value = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        try {
            Field declaredField = RenderingHints.class.getDeclaredField("VALUE_TEXT_ANTIALIAS_LCD_HRGB");
            value = declaredField.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, value);
    }

    public void updateFeed(PMEXMarketFeedBean bean) {
        boolean isBuyChange = false;
        boolean isSellChange = false;
        boolean isChangeChange = false;
        if (!this.isExpire()) {
            if (this.fb != null) {
                if (this.fb.getChange() < bean.getChange()) {
                    this.bgColorHeader = this.upColorHeader;
                    isChangeChange = true;
                } else if (this.fb.getChange() > bean.getChange()) {
                    this.bgColorHeader = this.downColorHeader;
                    isChangeChange = true;
                }
                if (this.fb.getBuy() < bean.getBuy()) {
                    this.bgColorBuy = this.upColorPrice;
                    isBuyChange = true;
                } else if (this.fb.getBuy() > bean.getBuy()) {
                    this.bgColorBuy = this.downColorPrice;
                    isBuyChange = true;
                }
                if (this.fb.getSell() < bean.getSell()) {
                    this.bgColorSell = this.upColorPrice;
                    isSellChange = true;
                } else if (this.fb.getSell() > bean.getSell()) {
                    this.bgColorSell = this.downColorPrice;
                    isSellChange = true;
                }
                if (bean.getPercentChangeIndex() > 0) {
                    this.ppSell.setFoucsColor(MyColors.PercentChangePlus[bean.getPercentChangeIndex() - 1]);
                    this.ppBuy.setFoucsColor(MyColors.PercentChangePlus[bean.getPercentChangeIndex() - 1]);
                } else {
                    this.ppSell.setFoucsColor(MyColors.PercentChangeMinus[5 + bean.getPercentChangeIndex()]);
                    this.ppBuy.setFoucsColor(MyColors.PercentChangeMinus[5 + bean.getPercentChangeIndex()]);
                }
                this.ppSell.setForeground2(MyColors.MBPSellFG);
                this.ppBuy.setForeground2(MyColors.MBPBuyFG);
                this.ppSell.setPrice(bean.getSell());
                this.ppSell.setVolume(bean.getSellVolume());
                this.ppBuy.setPrice(bean.getBuy());
                this.ppBuy.setVolume(bean.getBuyVolume());
                if (isBuyChange) {
                    this.ppBuy.restart(this.bgColorBuy);
                    this.ppBuy.repaint();
                }
                if (isSellChange) {
                    this.ppSell.restart(this.bgColorSell);
                    this.ppSell.repaint();
                }
                if (bean.getLastTradePrice() == 0.0 || bean.getLastTradePrice() == 0.0) {
                    this.lblContract.setIcon((Icon)new ImageIcon(this.getClass().getResource("/pmex/gui/images/level12_2.gif")));
                    this.lblContract.setForeground(Color.BLUE);
                } else if (bean.getLastTradePrice() > this.fb.getLastTradePrice()) {
                    this.lblContract.setForeground(Color.GREEN.darker());
                    this.lblContract.setIcon((Icon)new ImageIcon(this.getClass().getResource("/pmex/gui/images/up12_2.GIF")));
                } else if (bean.getLastTradePrice() < this.fb.getLastTradePrice()) {
                    this.lblContract.setForeground(Color.RED);
                    this.lblContract.setIcon((Icon)new ImageIcon(this.getClass().getResource("/pmex/gui/images/down12_2.gif")));
                }
            } else {
                this.ppSell.setForeground2(MyColors.MBPSellFG);
                this.ppBuy.setForeground2(MyColors.MBPBuyFG);
                this.ppSell.setPrice(bean.getSell());
                this.ppSell.setVolume(bean.getSellVolume());
                this.ppBuy.setPrice(bean.getBuy());
                this.ppBuy.setVolume(bean.getBuyVolume());
            }
            this.lblChange.setText(Util.formatPMEXAsCome((String)(bean.getChange() + "")) + " (" + Util.formatPMEXAsCome((String)(bean.getPercentChange() + "")) + "%)");
            if (bean.getChange() == 0.0) {
                this.lblChange.setForeground(Color.BLUE);
            } else if (bean.getChange() > 0.0) {
                this.lblChange.setForeground(Color.GREEN.darker());
            } else if (bean.getChange() < 0.0) {
                this.lblChange.setForeground(Color.RED);
            }
            this.lblContract.setText(this.contract + " (" + Util.formatPMEXAsCome((String)(bean.getLastTradePrice() + "")) + ")");
            this.setToolTip(bean.getContract());
            if (isChangeChange) {
                this.lblContract.setBlendColorBackground(this.bgColorHeader);
                this.lblClose.setBlendColorBackground(this.bgColorHeader);
            }
            this.fb = bean;
            this.repaint();
            this.restart(this.bgColorHeader);
        }
    }

    public boolean isShowUnit() {
        return this.showUnit;
    }

    public void setID(int i) {
        this.ID = i;
    }

    public synchronized void addEventListener(PMEXTileEventListener listener) {
        this._listeners.add(listener);
    }

    public synchronized void removeEventListener(PMEXTileEventListener listener) {
        this._listeners.remove(listener);
    }

    private synchronized void fireEventShowWindow(FormName formName) {
        PMEXTileEvent event = new PMEXTileEvent(this);
        for (PMEXTileEventListener ev : this._listeners) {
            ev.showWindow(event, formName, this.contract);
        }
    }

    private synchronized void fireEventRemoveTile() {
        PMEXTileEvent event = new PMEXTileEvent(this);
        for (PMEXTileEventListener ev : this._listeners) {
            ev.removeTile(event, this, this.contract, "");
        }
    }

    private void closeTile() {
        this.setVisible(false);
        this.fireEventRemoveTile();
    }

    private Color isTodayExpire() {
        if (this.isExpireToday) {
            return Color.RED;
        }
        return Color.LIGHT_GRAY;
    }

    public void setAdded(boolean isBlink) {
        final Timer BlinkTimmer = new Timer(0, null);
        if (isBlink) {
            ActionListener ac = new ActionListener(){
                int i = 0;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.i >= 8) {
                        BlinkTimmer.stop();
                        Tile.this.setStartShadow(Tile.this.isTodayExpire());
                        Tile.this.lblClose.setIcon(null);
                        Tile.this.repaint();
                    } else {
                        if (this.i % 2 == 0) {
                            Tile.this.setStartShadow(Color.YELLOW);
                            Tile.this.repaint();
                        } else {
                            Tile.this.setStartShadow(Tile.this.isTodayExpire());
                            Tile.this.repaint();
                        }
                        ++this.i;
                    }
                }
            };
            BlinkTimmer.addActionListener(ac);
            BlinkTimmer.setDelay(100);
            BlinkTimmer.setRepeats(true);
            BlinkTimmer.start();
        } else {
            BlinkTimmer.stop();
            this.setStartShadow(this.isTodayExpire());
            this.repaint();
        }
    }

    private void initComponents() {
        this.menuDeleteAll = new JMenuItem();
        this.popupMenu = new JPopupMenu();
        this.menuBuy = new JMenuItem();
        this.menuSell = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.menuMBP = new JMenuItem();
        this.menuLadder = new JMenuItem();
        this.menuAddContract = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.menuClose = new JMenuItem();
        this.lblChange = new JXLabel();
        this.separator = new JSeparator();
        this.ppBuy = new PricePanel();
        this.ppSell = new PricePanel();
        this.lblQuantity = new JXLabel();
        this.lblContract = new NxGLabel();
        this.lblBuy = new NxGLink("Buy");
        this.lblSell = new NxGLink("Sell");
        this.txtQuantity = new NxGTextFeild();
        this.lblClose = new NxGLabel();
        this.menuDeleteAll.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/deleteall.png")));
        this.menuDeleteAll.setText("Remove all contracts");
        this.menuBuy.setText("Buy");
        this.popupMenu.add(this.menuBuy);
        this.menuSell.setText("Sell");
        this.popupMenu.add(this.menuSell);
        this.popupMenu.add(this.jSeparator2);
        this.menuMBP.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/MBP.png")));
        this.menuMBP.setText("MBP");
        this.popupMenu.add(this.menuMBP);
        this.menuLadder.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/graph.png")));
        this.menuLadder.setText("Ladder");
        this.popupMenu.add(this.menuLadder);
        this.menuAddContract.setText("Add To Market Watch");
        this.popupMenu.add(this.menuAddContract);
        this.popupMenu.add(this.jSeparator3);
        this.menuClose.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/close12x12.png")));
        this.menuClose.setText("Remove");
        this.popupMenu.add(this.menuClose);
        this.setLayout(null);
        this.lblChange.setBackground(new Color(255, 255, 255));
        this.lblChange.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.lblChange.setHorizontalAlignment(0);
        this.lblChange.setText("88.88");
        this.lblChange.setVerticalAlignment(1);
        this.lblChange.setDoubleBuffered(true);
        this.lblChange.setFont(new Font("Tahoma", 1, 13));
        this.lblChange.setOpaque(true);
        this.add((Component)this.lblChange);
        this.lblChange.setBounds(45, 75, 130, 20);
        this.separator.setOrientation(1);
        this.add(this.separator);
        this.separator.setBounds(106, 27, 2, 40);
        this.ppBuy.setBackground(new Color(51, 255, 204));
        this.ppBuy.setOpaque(false);
        this.add((Component)((Object)this.ppBuy));
        this.ppBuy.setBounds(3, 22, 100, 50);
        this.add((Component)((Object)this.ppSell));
        this.ppSell.setBounds(110, 22, 100, 50);
        this.lblQuantity.setBackground(new Color(51, 255, 0));
        this.lblQuantity.setText("QTY :");
        this.add((Component)this.lblQuantity);
        this.lblQuantity.setBounds(10, 97, 35, 20);
        this.lblContract.setBackground(new Color(0, 204, 0));
        this.lblContract.setForeground(new Color(255, 255, 255));
        this.lblContract.setHorizontalAlignment(0);
        this.lblContract.setText("TOLAGOLD-WED");
        this.lblContract.setFont(new Font("Tahoma", 1, 11));
        this.lblContract.setOpaque(true);
        this.lblContract.setRequestFocusEnabled(false);
        this.add((Component)this.lblContract);
        this.lblContract.setBounds(2, 2, 180, 20);
        this.lblBuy.setForeground(new Color(0, 102, 102));
        this.lblBuy.setText("Buy");
        this.add((Component)this.lblBuy);
        this.lblBuy.setBounds(10, 75, 25, 20);
        this.lblSell.setForeground(new Color(255, 128, 26));
        this.lblSell.setText("Sell");
        this.add((Component)this.lblSell);
        this.lblSell.setBounds(180, 75, 25, 20);
        this.add((Component)this.txtQuantity);
        this.txtQuantity.setBounds(45, 97, 130, 20);
        this.lblClose.setBackground(new Color(153, 204, 0));
        this.lblClose.setHorizontalAlignment(0);
        this.lblClose.setOpaque(true);
        this.add((Component)this.lblClose);
        this.lblClose.setBounds(182, 2, 28, 20);
    }

    @Override
    public void showUnit(PMEXTileEvent e, boolean showUnit) {
        this.showUnit = showUnit;
        this.lblQuantity.setVisible(showUnit);
        this.txtQuantity.setVisible(showUnit);
        if (!showUnit) {
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getPreferredSize().height - 22));
        } else {
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getPreferredSize().height + 22));
        }
        this.repaint();
    }

    @Override
    public void showWindow(PMEXTileEvent e, FormName fr, String windowName) {
    }

    private void SetTimerChange(final NxGLabel Obj, Timer timer) {
        ActionListener Task = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Obj.setBlendColorBackground(Tile.this.bgColorDefault);
                Obj.repaint();
            }
        };
        timer.setRepeats(false);
        timer.addActionListener(Task);
        timer.start();
    }

    public void restart(Color bgColor) {
        this.bgColorHeader = bgColor;
        this.timerDefaultColor.restart();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if ((e.getSource() == this.lblContract || e.getSource() == this.ppBuy || e.getSource() == this.ppSell || e.getSource() == this.separator) && e.getClickCount() == 2) {
            if (AppConfig.loginMode == LoginMode.PMEX) {
                this.fireEventShowWindow(FormName.PMEX_Ladder_Dock);
            } else if (AppConfig.loginMode == LoginMode.KSEPMEX) {
                this.fireEventShowWindow(FormName.PMEX_Ladder);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Object obj = e.getSource();
        if (obj == this.lblClose) {
            this.closeTile();
        } else if (obj != this.lblContract) {
            if (obj == this.lblSell) {
                this.fireEventShowWindow(FormName.PMEX_Sell);
            } else if (obj == this.lblBuy) {
                this.fireEventShowWindow(FormName.PMEX_Buy);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Object obj = e.getSource();
        if (obj == this.lblClose) {
            this.lblClose.setIcon((Icon)new ImageIcon(this.getClass().getResource("/pmex/gui/images/close12x12.png")));
        } else if (obj == this.lblContract) {
            this.lblClose.setIcon((Icon)new ImageIcon(this.getClass().getResource("/pmex/gui/images/closegray12x12.png")));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Object obj = e.getSource();
        if (obj == this.lblClose) {
            this.lblClose.setIcon(null);
        } else if (obj == this.lblContract) {
            this.lblClose.setIcon(null);
        }
    }

    @Override
    public void removeTile(PMEXTileEvent e, Tile tile, String contract, String market) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object scr = e.getSource();
        if (scr == this.menuLadder) {
            this.fireEventShowWindow(FormName.PMEX_Ladder);
        } else if (scr == this.menuMBP) {
            this.fireEventShowWindow(FormName.PMEX_MBP);
        } else if (scr == this.menuSell) {
            this.fireEventShowWindow(FormName.PMEX_Sell);
        } else if (scr == this.menuBuy) {
            this.fireEventShowWindow(FormName.PMEX_Buy);
        } else if (scr == this.menuAddContract) {
            this.fireEventShowWindow(FormName.PMEX_AddContract);
        } else if (scr == this.menuClose) {
            this.closeTile();
        } else if (scr == this.menuDeleteAll) {
            this.closeAllTile();
        }
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        try {
            Tile c = this;
            if (DragAndDropLock.isLocked()) {
                DragAndDropLock.setDragAndDropStarted((boolean)false);
                return;
            }
            DragAndDropLock.setLocked((boolean)true);
            DragAndDropLock.setDragAndDropStarted((boolean)true);
            dge.startDrag(Cursor.getDefaultCursor(), new TileItemTransferHandler(this.getValues()), this);
            GhostGlassPane glassPane = (GhostGlassPane)SwingUtilities.getRootPane((Component)((Object)this)).getGlassPane();
            glassPane.setVisible(true);
            Point p = (Point)dge.getDragOrigin().clone();
            SwingUtilities.convertPointToScreen(p, (Component)((Object)this));
            SwingUtilities.convertPointFromScreen(p, (Component)glassPane);
            BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics g = image.getGraphics();
            g.drawImage(image, this.getWidth(), this.getHeight(), null);
            ((Component)((Object)c)).paint(g);
            g.dispose();
            glassPane.setPoint(p);
            glassPane.setImage(image, image.getWidth());
            glassPane.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void dragMouseMoved(DragSourceDragEvent dsde) {
        if (!DragAndDropLock.isDragAndDropStarted()) {
            return;
        }
        try {
            GhostGlassPane glassPane = (GhostGlassPane)SwingUtilities.getRootPane((Component)((Object)this)).getGlassPane();
            Point p = (Point)dsde.getLocation().clone();
            SwingUtilities.convertPointFromScreen(p, (Component)glassPane);
            glassPane.setPoint(p);
            glassPane.repaint(glassPane.getRepaintRect());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (!DragAndDropLock.isDragAndDropStarted()) {
            return;
        }
        DragAndDropLock.setDragAndDropStarted((boolean)false);
        GhostGlassPane glassPane = (GhostGlassPane)SwingUtilities.getRootPane((Component)((Object)this)).getGlassPane();
        Point p = (Point)dsde.getLocation().clone();
        SwingUtilities.convertPointFromScreen(p, (Component)glassPane);
        if (!dsde.getDropSuccess()) {
            Point end = (Point)this.getLocation().clone();
            SwingUtilities.convertPointToScreen(end, this.getParent());
            SwingUtilities.convertPointFromScreen(end, (Component)glassPane);
            end.x += this.getWidth() / 2;
            end.y += this.getHeight() / 2;
            Timer backTimer = new Timer(16, new TravelBackToOrigin(glassPane, p, end));
            backTimer.start();
        } else {
            glassPane.setPoint(p);
            glassPane.repaint(glassPane.getRepaintRect());
        }
    }

    public boolean isMove() {
        return this.isMove;
    }

    public void setIsMove(boolean isMove) {
        this.isMove = isMove;
    }

    public String getContract() {
        return this.contract;
    }

    public void setContract(String contract) {
        this.contract = contract;
        this.lblContract.setText(contract);
        this.setToolTip(contract);
    }

    private void setToolTip(String contract) {
        if (LogsPMEX.PMEX_CONTRACT_ALL.containsKey(contract)) {
            if (this.isExpireToday) {
                this.lblContract.setToolTipText("will expire today");
            } else {
                this.lblContract.setToolTipText("Expire: " + Util.formatDate((Date)LogsPMEX.PMEX_CONTRACT_ALL.get(contract).getDate()));
            }
        } else {
            this.lblContract.setToolTipText(null);
        }
    }

    public void setValues(TileBean tb) {
    }

    public Object getValues() {
        if (!this.isMove()) {
            TileBean tb = new TileBean();
            tb.setContract(this.lblContract.getText());
            return tb;
        }
        return this;
    }

    private void setDefaultValues() {
        this.lblContract.setText("");
        this.lblChange.setText("");
        this.lblQuantity.setText("");
        this.ppSell.setDefaultValues();
        this.ppBuy.setDefaultValues();
    }

    public void setContractExpire(boolean isExpire) {
        this.setIsExpire(isExpire);
        this.lblChange.setText("");
        this.lblQuantity.setText("");
        this.ppSell.setDefaultValues();
        this.ppBuy.setDefaultValues();
        if (isExpire) {
            this.lblContract.setForeground(this.expireColor);
        } else {
            this.lblContract.setForeground(new Color(255, 255, 255));
        }
    }

    private void closeAllTile() {
        for (int i = 0; i < this.tileDropDestination.getComponentCount(); ++i) {
            Component com = this.tileDropDestination.getComponent(i);
            if (!(com instanceof Tile)) continue;
            ((Tile)((Object)com)).closeTile();
        }
    }

    public void setAllHolder(TileDropDestination tileDropDestination) {
        this.tileDropDestination = tileDropDestination;
    }

    public boolean isExpire() {
        return this.isExpire;
    }

    public void setIsExpire(boolean isExpire) {
        this.isExpire = isExpire;
    }

    private void setPopupIcon() {
        try {
            this.menuLadder.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/ladder16.png")));
            this.menuAddContract.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/marketWatch16.png")));
            this.menuSell.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/ask16.png")));
            this.menuBuy.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/bid16.png")));
            this.menuMBP.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/marketDeptByPrice16.png")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String toString() {
        return this.getContract();
    }

    public void setExpireContractToday() {
        this.isExpireToday = true;
        this.lblContract.setToolTipText("will expire today");
        this.setAdded(false);
    }
}

