/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui.bean;

import java.text.SimpleDateFormat;
import java.util.Date;

public class OrderActivityBean {
    private String trader;
    private String time;
    private String orderID;
    private String account;
    private String contract;
    private String orderType;
    private String transactionType;
    private String status;
    private long volume;
    private long filledVolume;
    private long totalFilled;
    private long remainingVolume;
    private double price;
    private double fillPrice;
    private String remarks;
    private double distance;
    private double trailingStep;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public String getTrader() {
        return this.trader;
    }

    public void setTrader(String trader) {
        this.trader = trader;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        try {
            Date date = this.formatter.parse(time);
            this.formatter = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss");
            this.time = this.formatter.format(date);
        }
        catch (Exception e) {
            this.time = time;
        }
    }

    public String getOrderID() {
        return this.orderID;
    }

    public void setOrderID(String orderID) {
        this.orderID = orderID;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getContract() {
        return this.contract;
    }

    public void setContract(String contract) {
        this.contract = contract;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public long getVolume() {
        return this.volume;
    }

    public void setVolume(long volume) {
        this.volume = volume;
    }

    public long getFilledVolume() {
        return this.filledVolume;
    }

    public void setFilledVolume(long filledVolume) {
        this.filledVolume = filledVolume;
    }

    public long getTotalFilled() {
        return this.totalFilled;
    }

    public void setTotalFilled(long totalFilled) {
        this.totalFilled = totalFilled;
    }

    public long getRemainingVolume() {
        return this.remainingVolume;
    }

    public void setRemainingVolume(long remainingVolume) {
        this.remainingVolume = remainingVolume;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public double getFillPrice() {
        return this.fillPrice;
    }

    public void setFillPrice(double fillPrice) {
        this.fillPrice = fillPrice;
    }

    public static OrderActivityBean parse(String string) {
        OrderActivityBean b = new OrderActivityBean();
        if (string.indexOf(";") > 0) {
            String[] values = string.split("\\;", -1);
            b.setTrader(values[0]);
            b.setTime(values[1]);
            b.setOrderID(values[2]);
            b.setAccount(values[3]);
            b.setContract(values[4]);
            b.setOrderType(values[5]);
            b.setTransactionType(values[6]);
            b.setStatus(values[7]);
            try {
                b.setVolume(Long.parseLong(values[8]));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                b.setFilledVolume(Long.parseLong(values[9]));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                b.setTotalFilled(Long.parseLong(values[10]));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                b.setRemainingVolume(Long.parseLong(values[11]));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                b.setPrice(Double.parseDouble(values[12]));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                b.setFillPrice(Double.parseDouble(values[13]));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                b.setDistance(Double.parseDouble(values[14]));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                b.setTrailingStep(Double.parseDouble(values[15]));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                b.setRemarks(values[16]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return b;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getTrailingStep() {
        return this.trailingStep;
    }

    public void setTrailingStep(double trailingStep) {
        this.trailingStep = trailingStep;
    }

    public String toString() {
        return "trader = " + this.getTrader() + ", time = " + this.getTime() + ", orderID = " + this.getOrderID() + ", account = " + this.getAccount() + ", contract = " + this.getContract() + ", orderType = " + this.getOrderType() + ", transactionType = " + this.getTransactionType() + ", status = " + this.getStatus() + ", volume = " + this.getVolume() + ", filledVolume = " + this.getFilledVolume() + ", totalFilled = " + this.getTotalFilled() + ", remainingVolume = " + this.getRemainingVolume() + ", price = " + this.getPrice() + ", fillPrice = " + this.getFillPrice() + ", remarks = " + this.getRemarks() + ", distance = " + this.getDistance() + ", trailing step = " + this.getTrailingStep();
    }
}

