/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui.bean;

import java.text.SimpleDateFormat;
import java.util.Date;

public class TradedOrderBean {
    private String trader = "";
    private String account = "";
    private String contract = "";
    private String orderID = "";
    private String ticketID = "";
    private String clientOrderID = "";
    private double price = 0.0;
    private double averagePrice = 0.0;
    private long fillVolume = 0L;
    private long totalFill = 0L;
    private long remainingVolume = 0L;
    private String transactionType = "";
    private String transactionTime = "";
    private double distance = 0.0;
    private double trailingStep = 0.0;
    private long totalFillBuy = 0L;
    private double totolAmountBuy = 0.0;
    private double averageBuy = 0.0;
    private long totalFillSell = 0L;
    private double totolAmountSell = 0.0;
    private double averageSell = 0.0;
    public boolean isSummaryrow = false;
    public int summaryid = 0;
    private Date transDate = new Date(System.currentTimeMillis());

    public static TradedOrderBean parse(String data) {
        TradedOrderBean b = new TradedOrderBean();
        String[] values = data.split("\\;", -1);
        b.setTrader(values[0]);
        b.setAccount(values[1]);
        b.setContract(values[2]);
        b.setOrderID(values[3]);
        b.setTicketID(values[4]);
        b.setClientOrderID(values[5]);
        try {
            b.setPrice(Double.parseDouble(values[6]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            b.setAveragePrice(Double.parseDouble(values[7]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            b.setFillVolume(Long.parseLong(values[8]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            b.setTotalFill(Long.parseLong(values[9]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            b.setRemainingVolume(Long.parseLong(values[10]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        b.setTransactionType(values[11]);
        b.setTransactionTime(values[12].replaceAll("\\|", ""));
        try {
            b.setDistance(Double.parseDouble(values[13]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            b.setTrailingStep(Double.parseDouble(values[14]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return b;
    }

    public String getTrader() {
        return this.trader;
    }

    public void setTrader(String trader) {
        this.trader = trader;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getContract() {
        return this.contract;
    }

    public void setContract(String contract) {
        this.contract = contract;
    }

    public String getOrderID() {
        return this.orderID;
    }

    public void setOrderID(String orderID) {
        this.orderID = orderID;
    }

    public String getTicketID() {
        return this.ticketID;
    }

    public void setTicketID(String ticketID) {
        this.ticketID = ticketID;
    }

    public String getClientOrderID() {
        return this.clientOrderID;
    }

    public void setClientOrderID(String clientOrderID) {
        this.clientOrderID = clientOrderID;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public double getAveragePrice() {
        return this.averagePrice;
    }

    public void setAveragePrice(double averagePrice) {
        this.averagePrice = averagePrice;
    }

    public long getFillVolume() {
        return this.fillVolume;
    }

    public void setFillVolume(long fillVolume) {
        this.fillVolume = fillVolume;
    }

    public long getTotalFill() {
        return this.totalFill;
    }

    public void setTotalFill(long totalFill) {
        this.totalFill = totalFill;
    }

    public long getRemainingVolume() {
        return this.remainingVolume;
    }

    public void setRemainingVolume(long remainingVolume) {
        this.remainingVolume = remainingVolume;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public String getTransactionTime() {
        return this.transactionTime;
    }

    public Date getTransactionTimeToDate() {
        return this.getTransDate();
    }

    public void setTransactionTime(String transactionTime) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.setTransDate(formatter.parse(transactionTime));
            formatter = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss");
            this.transactionTime = formatter.format(this.getTransDate());
        }
        catch (Exception e) {
            this.transactionTime = transactionTime;
        }
    }

    public long getTotalFillBuy() {
        return this.totalFillBuy;
    }

    public void setTotalFillBuy(long totalFillBuy) {
        this.totalFillBuy = totalFillBuy;
    }

    public double getTotolAmountBuy() {
        return this.totolAmountBuy;
    }

    public void setTotolAmountBuy(double totolAmountBuy) {
        this.totolAmountBuy = totolAmountBuy;
    }

    public double getAverageBuy() {
        return this.averageBuy;
    }

    public void setAverageBuy(double averageBuy) {
        this.averageBuy = averageBuy;
    }

    public long getTotalFillSell() {
        return this.totalFillSell;
    }

    public void setTotalFillSell(long totalFillSell) {
        this.totalFillSell = totalFillSell;
    }

    public double getTotolAmountSell() {
        return this.totolAmountSell;
    }

    public void setTotolAmountSell(double totolAmountSell) {
        this.totolAmountSell = totolAmountSell;
    }

    public double getAverageSell() {
        return this.averageSell;
    }

    public void setAverageSell(double averageSell) {
        this.averageSell = averageSell;
    }

    public Date getTransDate() {
        return this.transDate;
    }

    public void setTransDate(Date transDate) {
        this.transDate = transDate;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getTrailingStep() {
        return this.trailingStep;
    }

    public void setTrailingStep(double trailingStep) {
        this.trailingStep = trailingStep;
    }
}

