/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui.bean;

public class WorkingOrderBean {
    private String trader = "";
    private String account = "";
    private String contract = "";
    private String orderID = "";
    private String clientOrderID = "";
    private long quantity = 0L;
    private double limitPrice = 0.0;
    private double triggerPrice = 0.0;
    private double distance = 0.0;
    private double trailingStep = 0.0;
    private String orderType = "";
    private String transactionType = "";
    private boolean selected = false;
    private boolean isGoodTillCancel = false;
    private long totalFillBuy = 0L;
    private double totolAmountBuy = 0.0;
    private double averageBuy = 0.0;
    private long totalFillSell = 0L;
    private double totolAmountSell = 0.0;
    private double averageSell = 0.0;
    public boolean isSummaryrow = false;
    public int summaryid = 0;
    private boolean isAlradyAdded = false;

    public static WorkingOrderBean parse(String data) {
        data = data.replaceAll("\\|", "");
        WorkingOrderBean b = new WorkingOrderBean();
        String[] values = data.split("\\;", -1);
        b.setTrader(values[0]);
        b.setAccount(values[1]);
        b.setContract(values[2]);
        b.setOrderID(values[3]);
        b.setClientOrderID(values[4]);
        try {
            b.setQuantity(Long.parseLong(values[5]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            b.setLimitPrice(Double.parseDouble(values[6]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            b.setTriggerPrice(Double.parseDouble(values[7]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            b.setDistance(Double.parseDouble(values[11]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            b.setTrailingStep(Double.parseDouble(values[12]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        b.setOrderType(values[8]);
        b.setTransactionType(values[9]);
        try {
            String val = values[10];
            if (val.trim().equalsIgnoreCase("Day")) {
                b.setIsGoodTillCancel(false);
            } else {
                b.setIsGoodTillCancel(true);
            }
        }
        catch (Exception ex) {
            b.setIsGoodTillCancel(false);
            ex.printStackTrace();
        }
        return b;
    }

    public String getTrader() {
        return this.trader;
    }

    public void setTrader(String trader) {
        this.trader = trader;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getOrderID() {
        return this.orderID;
    }

    public void setOrderID(String orderID) {
        this.orderID = orderID;
    }

    public String getClientOrderID() {
        return this.clientOrderID;
    }

    public void setClientOrderID(String clientOrderID) {
        this.clientOrderID = clientOrderID;
    }

    public double getLimitPrice() {
        return this.limitPrice;
    }

    public void setLimitPrice(double price) {
        this.limitPrice = price;
    }

    public String getOrderType() {
        if (this.orderType.equalsIgnoreCase("StopLimit")) {
            this.orderType = "Stop Loss Limit";
        }
        if (this.orderType.equalsIgnoreCase("Stop")) {
            this.orderType = "Stop Loss Market";
        }
        if (this.orderType.equalsIgnoreCase("MarketType")) {
            this.orderType = "Market";
        }
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType.equalsIgnoreCase("TrailingStopMarket") ? "Trailling Stop Market" : orderType;
    }

    public String getContract() {
        return this.contract;
    }

    public void setContract(String contract) {
        this.contract = contract;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(long quantity) {
        this.quantity = quantity;
    }

    public double getTriggerPrice() {
        return this.triggerPrice;
    }

    public void setTriggerPrice(double triggerPrice) {
        this.triggerPrice = triggerPrice;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public long getTotalFillBuy() {
        return this.totalFillBuy;
    }

    public void setTotalFillBuy(long totalFillBuy) {
        this.totalFillBuy = totalFillBuy;
    }

    public double getTotolAmountBuy() {
        return this.totolAmountBuy;
    }

    public void setTotolAmountBuy(double totolAmountBuy) {
        this.totolAmountBuy = totolAmountBuy;
    }

    public double getAverageBuy() {
        if (Double.isNaN(this.averageBuy)) {
            return 0.0;
        }
        return this.averageBuy;
    }

    public void setAverageBuy(double averageBuy) {
        this.averageBuy = averageBuy;
    }

    public long getTotalFillSell() {
        return this.totalFillSell;
    }

    public void setTotalFillSell(long totalFillSell) {
        this.totalFillSell = totalFillSell;
    }

    public double getTotolAmountSell() {
        return this.totolAmountSell;
    }

    public void setTotolAmountSell(double totolAmountSell) {
        this.totolAmountSell = totolAmountSell;
    }

    public double getAverageSell() {
        if (Double.isNaN(this.averageSell)) {
            return 0.0;
        }
        return this.averageSell;
    }

    public void setAverageSell(double averageSell) {
        this.averageSell = averageSell;
    }

    public boolean isGoodTillCancel() {
        return this.isGoodTillCancel;
    }

    public boolean getIsGoodTillCancel() {
        return this.isGoodTillCancel;
    }

    public void setIsGoodTillCancel(boolean isGoodTillCancel) {
        this.isGoodTillCancel = isGoodTillCancel;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getTrailingStep() {
        return this.trailingStep;
    }

    public void setTrailingStep(double trailingStep) {
        this.trailingStep = trailingStep;
    }

    public String toString() {
        return "trader = " + this.getTrader() + ", account = " + this.getAccount() + ", contract = " + this.getContract() + ", orderID = " + this.getOrderID() + ", clientOrderID = " + this.getClientOrderID() + ", quantity = " + this.getQuantity() + ", price = " + this.getLimitPrice() + ", triggerPrice = " + this.getTriggerPrice() + ", orderType = " + this.getOrderType() + ", transactionType = " + this.getTransactionType() + ", distance = " + this.getDistance() + ", trailingStep = " + this.getTrailingStep();
    }

    public boolean isAlradyAdded() {
        return this.isAlradyAdded;
    }

    public void setIsAlradyAdded(boolean isAlradyAdded) {
        this.isAlradyAdded = isAlradyAdded;
    }
}

