/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui.dragdrop;

import common.dragndrop.GhostGlassPane;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import pmex.gui.dragdrop.GhostDropAdapter;
import pmex.gui.dragdrop.GhostDropEvent;

public class GhostComponentAdapter
extends GhostDropAdapter {
    public GhostComponentAdapter(GhostGlassPane glassPane, String action) {
        super(glassPane, action);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Component c = e.getComponent();
        BufferedImage image = new BufferedImage(c.getWidth(), c.getHeight(), 2);
        Graphics g = image.getGraphics();
        c.paint(g);
        this.glassPane.setVisible(true);
        Point p = (Point)e.getPoint().clone();
        SwingUtilities.convertPointToScreen(p, c);
        SwingUtilities.convertPointFromScreen(p, (Component)this.glassPane);
        g.dispose();
        this.glassPane.setPoint(p);
        this.glassPane.setImage(image);
        this.glassPane.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Component c = e.getComponent();
        Point p = (Point)e.getPoint().clone();
        SwingUtilities.convertPointToScreen(p, c);
        Point eventPoint = (Point)p.clone();
        SwingUtilities.convertPointFromScreen(p, (Component)this.glassPane);
        this.glassPane.setPoint(p);
        this.glassPane.setVisible(false);
        this.glassPane.setImage(null);
        this.fireGhostDropEvent(new GhostDropEvent(this.action, eventPoint));
    }
}

