/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui.dragdrop;

import common.dragndrop.DragAndDropLock;
import common.dragndrop.GhostGlassPane;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import java.awt.Color;
import java.awt.Component;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import pmex.gui.Tile;
import pmex.gui.event.PMEXTileEvent;
import pmex.gui.event.PMEXTileEventListener;
import pmex.gui.util.UtilPMEX;
import pmex.interfaces.ContractBarInterface;

public class TileDropDestination
extends JComponent
implements DropTargetListener,
PMEXTileEventListener {
    private RenderingHints hints;
    private boolean isDuplicateAllow = false;
    private ContractBarInterface contractBarInterface;
    private Map<String, Tile> allTileHolderUnique = new HashMap<String, Tile>();
    private List<Tile> allTileHolderDuplicate = new ArrayList<Tile>(){

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (Tile key : TileDropDestination.this.allTileHolderDuplicate) {
                sb.append(key.getContract()).append(":").append(UtilPMEX.GetMarketFromContract(key.getContract())).append(";");
            }
            return sb.toString();
        }
    };

    public TileDropDestination(ContractBarInterface contractBarInterface) {
        this.createRenderingHints();
        this.setBackground(Color.red);
        this.contractBarInterface = contractBarInterface;
        this.setDropTarget(new DropTarget(this, this));
    }

    public List<Tile> getAllTiles() {
        return this.allTileHolderDuplicate;
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        super.setOpaque(false);
    }

    @Override
    public Component add(Component comp) {
        Component comp2 = null;
        if (comp instanceof Tile) {
            Tile tile = (Tile)((Object)comp);
            tile.setAllHolder(this);
            if (this.isDuplicateAllow) {
                tile.addEventListener(this);
                this.allTileHolderDuplicate.add((Tile)((Object)comp));
                this.allTileHolderUnique.put(tile.getContract(), tile);
                comp2 = super.add(comp);
            } else if (!this.allTileHolderUnique.containsKey(tile.getContract())) {
                tile.addEventListener(this);
                this.allTileHolderDuplicate.add((Tile)((Object)comp));
                this.allTileHolderUnique.put(tile.getContract(), tile);
                comp2 = super.add(comp);
            } else {
                this.allTileHolderUnique.get(tile.getContract()).setAdded(true);
            }
        }
        return comp2;
    }

    private void createRenderingHints() {
        this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        this.hints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    private void addTile(Object transfer) {
        if (transfer instanceof Tile) {
            Tile t = (Tile)transfer;
            this.contractBarInterface.addContractToWatch(t.getContract(), false);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (flavors == null) {
            return;
        }
        for (int i = flavors.length - 1; i >= 0; --i) {
            if (flavors[i].equals(LogCommon.TILE_ITEM_FLAVOR)) {
                dtde.acceptDrop(1);
                Transferable transferable = dtde.getTransferable();
                Object trasfer = null;
                try {
                    trasfer = transferable.getTransferData(LogCommon.TILE_ITEM_FLAVOR);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (trasfer == null) {
                    return;
                }
                GhostGlassPane glassPane = (GhostGlassPane)SwingUtilities.getRootPane(this).getGlassPane();
                this.addTile(trasfer);
                glassPane.setImage(null);
                glassPane.setVisible(false);
                DragAndDropLock.setLocked((boolean)false);
                dtde.dropComplete(true);
                break;
            }
            if (!flavors[i].equals(DataFlavor.stringFlavor)) continue;
            String data = "";
            try {
                data = (String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (data.indexOf("PMEX=") < 0) break;
            data = data.replaceAll("PMEX=", "");
            data = data.replaceAll(";FUT", "");
            this.contractBarInterface.addAllContractsToWatch(data, false);
            break;
        }
    }

    @Override
    public void showUnit(PMEXTileEvent e, boolean showUnit) {
    }

    @Override
    public void showWindow(PMEXTileEvent e, FormName formName, String contract) {
    }

    @Override
    public void removeTile(PMEXTileEvent e, Tile tile, String contract, String market) {
        this.allTileHolderDuplicate.remove(tile);
        this.allTileHolderUnique.remove(contract);
    }

    public String getContractAdded() {
        return this.allTileHolderDuplicate.toString();
    }

    public boolean isDuplicateAllow() {
        return this.isDuplicateAllow;
    }

    public void setDuplicateAllow(boolean isDuplicateAllow) {
        this.isDuplicateAllow = isDuplicateAllow;
    }
}

