/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui.dragdrop;

import common.dragndrop.DragAndDropLock;
import common.dragndrop.GhostGlassPane;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class TravelBackToOrigin
implements ActionListener {
    private boolean isInitialized;
    private long start;
    private Point startPoint;
    private Point endPoint;
    private GhostGlassPane glassPane;
    private static final double INITIAL_SPEED = 500.0;
    private static final double INITIAL_ACCELERATION = 6000.0;

    public TravelBackToOrigin(GhostGlassPane glassPane, Point start, Point end) {
        this.glassPane = glassPane;
        this.startPoint = start;
        this.endPoint = end;
        this.isInitialized = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.start = System.currentTimeMillis();
        }
        long elapsed = System.currentTimeMillis() - this.start;
        double time = (double)elapsed / 1000.0;
        double a = (double)(this.endPoint.y - this.startPoint.y) / (double)(this.endPoint.x - this.startPoint.x);
        double b = (double)this.endPoint.y - a * (double)this.endPoint.x;
        int travelX = (int)(6000.0 * time * time / 2.0 + 500.0 * time);
        if (this.startPoint.x > this.endPoint.x) {
            travelX = -travelX;
        }
        int travelY = (int)((double)(this.startPoint.x + travelX) * a + b);
        int distanceX = Math.abs(this.startPoint.x - this.endPoint.x);
        if (Math.abs(travelX) >= distanceX) {
            ((Timer)e.getSource()).stop();
            this.glassPane.setPoint(this.endPoint);
            this.glassPane.repaint(this.glassPane.getRepaintRect());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TravelBackToOrigin.this.glassPane.setImage(null);
                    TravelBackToOrigin.this.glassPane.setVisible(false);
                }
            });
            DragAndDropLock.setLocked((boolean)false);
            return;
        }
        this.glassPane.setPoint(new Point(this.startPoint.x + travelX, travelY));
        this.glassPane.repaint(this.glassPane.getRepaintRect());
    }
}

