/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui.render;

import common.gui.component.NxGLabelDoubleColor;
import common.gui.render.NxGTableCellRender;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import pmex.gui.bean.LeaderBean;
import pmex.gui.model.LeaderModel;

public class LeaderRender
extends NxGTableCellRender {
    EtchedBorder border = (EtchedBorder)BorderFactory.createEtchedBorder(0, null, Color.gray.darker());
    private final LeaderModel model;
    private double lastTradePrice = LeaderBean.DEFAULT_VALUE;
    private boolean isChangeUp;

    public LeaderRender(JTable table, LeaderModel model) {
        super(table);
        this.model = model;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String colName = table.getColumnName(column);
        NxGLabelDoubleColor cell = new NxGLabelDoubleColor();
        cell.setHorizontalAlignment(4);
        cell.setForeground(Color.BLACK);
        cell.setBorder(null);
        cell.setIcon(null);
        if (value instanceof LeaderBean) {
            LeaderBean bean = (LeaderBean)value;
            if (colName.equalsIgnoreCase("VAP")) {
                if (bean.getVAP() == (long)LeaderBean.DEFAULT_VALUE) {
                    cell.setText("");
                } else {
                    cell.setText(Util.format0digit((String)(bean.getVAP() + "")));
                }
                if (this.model.isVAP && bean.getVAP() != (long)LeaderBean.DEFAULT_VALUE) {
                    cell.setPaintWidthPercent(bean.getVAPPercent());
                    cell.setStartPercentColor(new Color(148, 215, 148, 150));
                    cell.setEndPercentColor(new Color(207, 245, 207, 150));
                } else {
                    cell.setPaintWidthPercent(0);
                }
                return cell;
            }
            if (colName.equalsIgnoreCase("Orders")) {
                if (bean.getOrders() == 0L) {
                    cell.setText("");
                } else {
                    cell.setText(Util.format0digit((String)(bean.getOrders() + "")));
                }
                cell.setPaintWidthPercent(0);
                return cell;
            }
            if (colName.equalsIgnoreCase("Buy")) {
                if (bean.getBuy() == (double)LeaderBean.DEFAULT_VALUE) {
                    cell.setText("");
                } else {
                    cell.setText(bean.getBuyFormatted());
                    cell.setForeground(MyColors.MBPBuyFG);
                    if (bean.getBuy() == this.lastTradePrice) {
                        cell.setBorder((Border)this.border);
                        if (this.isChangeUp) {
                            cell.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pmex/gui/images/up12.png")));
                        } else {
                            cell.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pmex/gui/images/down12.png")));
                        }
                    }
                }
                if (bean.getSize() > 0L && bean.getBuy() > 0.0) {
                    cell.setPaintWidthPercent(100);
                    if (MyColors.MBPBuyColor.length >= bean.getRowIndex() && bean.getRowIndex() != LeaderBean.DEFAULT_VALUE) {
                        cell.setStartPercentColor(MyColors.MBPBuyColor[bean.getRowIndex()]);
                        cell.setEndPercentColor(MyColors.MBPBuyColor[bean.getRowIndex()]);
                        if (bean.getRowIndex() == 0) {
                            cell.setFont(cell.getFont().deriveFont(1));
                        } else {
                            cell.setFont(AppConfig.defaultPlanFont);
                        }
                    }
                    if (this.model.isBuy) {
                        cell.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pmex/gui/images/blue" + bean.getSizePercentIndex() + ".png")));
                    }
                } else {
                    cell.setPaintWidthPercent(0);
                }
                return this.createPanel(cell);
            }
            if (colName.equalsIgnoreCase("Sell")) {
                if (bean.getSell() == (double)LeaderBean.DEFAULT_VALUE) {
                    cell.setText("");
                } else {
                    cell.setText(bean.getSellFormatted());
                    cell.setForeground(MyColors.MBPSellFG);
                    if (bean.getSell() == this.lastTradePrice) {
                        cell.setBorder((Border)this.border);
                        if (this.isChangeUp) {
                            cell.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pmex/gui/images/up12.png")));
                        } else {
                            cell.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pmex/gui/images/down12.png")));
                        }
                    }
                }
                if (bean.getSize() > 0L && bean.getSell() > 0.0) {
                    cell.setPaintWidthPercent(100);
                    if (MyColors.MBPSellColor.length >= bean.getRowIndex() && bean.getRowIndex() != LeaderBean.DEFAULT_VALUE) {
                        cell.setStartPercentColor(MyColors.MBPSellColor[bean.getRowIndex() - 1]);
                        cell.setEndPercentColor(MyColors.MBPSellColor[bean.getRowIndex() - 1]);
                        if (bean.getRowIndex() - 1 == 0) {
                            cell.setFont(cell.getFont().deriveFont(1));
                        } else {
                            cell.setFont(AppConfig.defaultPlanFont);
                        }
                    }
                    if (this.model.isSell) {
                        cell.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getResource("/pmex/gui/images/pink" + bean.getSizePercentIndex() + ".png")));
                    }
                } else {
                    cell.setPaintWidthPercent(0);
                }
                return this.createPanel(cell);
            }
            if (colName.equalsIgnoreCase("Size")) {
                if (bean.getSize() == (long)LeaderBean.DEFAULT_VALUE) {
                    cell.setText("");
                } else {
                    cell.setText(Util.format0digit((String)(bean.getSize() + "")));
                }
                if (this.model.isSize) {
                    cell.setPaintWidthPercent(bean.getSizePercent());
                } else {
                    cell.setPaintWidthPercent(0);
                }
                if (bean.getSell() > 0.0) {
                    cell.setStartPercentColor(new Color(239, 176, 134, 150));
                    cell.setEndPercentColor(new Color(246, 217, 198, 150));
                } else if (bean.getBuy() > 0.0) {
                    cell.setStartPercentColor(new Color(129, 177, 238, 150));
                    cell.setEndPercentColor(new Color(192, 219, 252, 150));
                }
                return cell;
            }
            if (colName.equalsIgnoreCase("Price")) {
                if (bean.getPrice() == (double)LeaderBean.DEFAULT_VALUE) {
                    cell.setText("");
                } else {
                    cell.setText(bean.getPriceFormatted());
                }
                cell.setPaintWidthPercent(0);
                return cell;
            }
            if (colName.equalsIgnoreCase("Total")) {
                if (bean.getTotal() == (long)LeaderBean.DEFAULT_VALUE) {
                    cell.setText("");
                } else {
                    cell.setText(Util.format0digit((String)(bean.getTotal() + "")));
                }
                if (this.model.isTotal) {
                    cell.setPaintWidthPercent(bean.getTotalPercent());
                } else {
                    cell.setPaintWidthPercent(0);
                }
                if (bean.getSell() > 0.0) {
                    cell.setStartPercentColor(new Color(239, 176, 134, 150));
                    cell.setEndPercentColor(new Color(246, 217, 198, 150));
                } else if (bean.getBuy() > 0.0) {
                    cell.setStartPercentColor(new Color(129, 177, 238, 150));
                    cell.setEndPercentColor(new Color(192, 219, 252, 150));
                }
                return cell;
            }
        }
        return cell;
    }

    public double getLastTradePrice() {
        return this.lastTradePrice;
    }

    public void setLastTradePrice(double lastTradePrice) {
        this.lastTradePrice = lastTradePrice;
    }

    public boolean isChangeUp() {
        return this.isChangeUp;
    }

    public void setChangeUp(boolean isChangeUp) {
        this.isChangeUp = isChangeUp;
    }

    private JPanel createPanel(NxGLabelDoubleColor lbl) {
        boolean paintWidthPercent = false;
        int paintRemainPercent = 100;
        final Color startPercentColor = lbl.getStart();
        final Color endPercentColor = lbl.getEnd();
        final Color startDefault = lbl.getStart();
        final Color endDefault = lbl.getEnd();
        JPanel p = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                int height = this.getHeight();
                int width = this.getWidth();
                int paint = (int)((double)width * (Double.valueOf("0") / 100.0));
                int paintRemain = (int)((double)width * (Double.valueOf("100") / 100.0));
                GradientPaint painter = new GradientPaint(0.0f, 0.0f, endPercentColor, 0.0f, height / 2, startPercentColor);
                g2.setPaint(painter);
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, paint, (double)height / 2.0);
                g2.fill(rect);
                painter = new GradientPaint(0.0f, height / 2, startPercentColor, 0.0f, height, endPercentColor);
                g2.setPaint(painter);
                rect = new Rectangle2D.Double(0.0, (double)height / 2.0 - 1.0, paint, height);
                g2.fill(rect);
                painter = new GradientPaint(0.0f, 0.0f, endDefault, 0.0f, height / 2, startDefault);
                g2.setPaint(painter);
                rect = new Rectangle2D.Double(paint, 0.0, paintRemain, (double)height / 2.0);
                g2.fill(rect);
                painter = new GradientPaint(0.0f, height / 2, startDefault, 0.0f, height, endDefault);
                g2.setPaint(painter);
                rect = new Rectangle2D.Double(paint, (double)height / 2.0 - 1.0, paintRemain, height);
                g2.fill(rect);
            }
        };
        NxGLabelDoubleColor lblString = new NxGLabelDoubleColor();
        NxGLabelDoubleColor lblIcon = new NxGLabelDoubleColor();
        lblString.setPaintWidthPercent(lbl.getPaintWidthPercent());
        lblIcon.setPaintWidthPercent(lbl.getPaintWidthPercent());
        lblString.setHorizontalAlignment(2);
        lblIcon.setHorizontalAlignment(0);
        lblString.setText(lbl.getText());
        lblIcon.setIcon(lbl.getIcon());
        lblString.setFont(lbl.getFont());
        lblString.setStartPercentColor(lbl.getStart());
        lblString.setEndPercentColor(lbl.getEnd());
        lblIcon.setStartPercentColor(lbl.getStart());
        lblIcon.setEndPercentColor(lbl.getEnd());
        this.setBorder(lbl.getBorder());
        lblString.setBackground(lbl.getBackground());
        lblIcon.setBackground(lbl.getBackground());
        lblString.setForeground(lbl.getForeground());
        lblIcon.setForeground(lbl.getForeground());
        p.add((Component)lblString, "East");
        p.add((Component)lblIcon, "West");
        return p;
    }
}

