/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui.render;

import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class OrderActivityRender
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel cell = new JLabel();
        cell.setFont(LogCommon.LogFont);
        cell.setOpaque(true);
        String status = table.getValueAt(row, 7).toString();
        String transType = table.getValueAt(row, 6).toString();
        if (value == null) {
            value = "";
        }
        if (table.getColumnClass(column) == String.class) {
            cell.setText(" " + value);
            cell.setHorizontalAlignment(2);
        } else if (table.getColumnClass(column) == Double.class || table.getColumnClass(column) == Float.class) {
            cell.setText(Util.formatPMEX((String)(value + "")) + " ");
            cell.setHorizontalAlignment(4);
        } else if (table.getColumnClass(column) == Long.class || table.getColumnClass(column) == Integer.class) {
            cell.setText(Util.format0digit((String)(value + "")) + " ");
            cell.setHorizontalAlignment(4);
        }
        if (transType.equalsIgnoreCase("Buy")) {
            if (status.equalsIgnoreCase("Queued")) {
                cell.setBackground(MyColors.dailyActivityLogBuyBGQ);
                cell.setForeground(MyColors.dailyActivityLogBuyFGQ);
            } else if (status.equalsIgnoreCase("Fill")) {
                cell.setBackground(MyColors.dailyActivityLogBuyBGFill);
                cell.setForeground(MyColors.dailyActivityLogBuyFGFill);
            } else if (status.equalsIgnoreCase("Partial Fill")) {
                cell.setBackground(MyColors.dailyActivityLogBuyBGFill);
                cell.setForeground(MyColors.dailyActivityLogBuyFGFill);
            } else if (status.equalsIgnoreCase("Business Message Reject")) {
                cell.setBackground(MyColors.dailyActivityLogRejectBG);
                cell.setForeground(MyColors.dailyActivityLogRejectFG);
            } else if (status.equalsIgnoreCase("Rejected")) {
                cell.setBackground(MyColors.dailyActivityLogRejectBG);
                cell.setForeground(MyColors.dailyActivityLogRejectFG);
            } else if (status.equalsIgnoreCase("Cancel Reject")) {
                cell.setBackground(MyColors.dailyActivityLogRejectBG);
                cell.setForeground(MyColors.dailyActivityLogRejectFG);
            } else if (status.equalsIgnoreCase("Cancelled")) {
                cell.setBackground(MyColors.dailyActivityLogBuyBGCancel);
                cell.setForeground(MyColors.dailyActivityLogBuyFGCancel);
            } else if (status.equalsIgnoreCase("Replaced")) {
                cell.setBackground(MyColors.dailyActivityLogBGReplaced);
                cell.setForeground(MyColors.dailyActivityLogFGReplaced);
            } else if (status.equalsIgnoreCase("Pending Cancel")) {
                cell.setBackground(MyColors.BuyOHRowCancel);
                cell.setForeground(MyColors.BuyOHTxtCancel);
            } else if (status.equalsIgnoreCase("Pending New")) {
                cell.setBackground(MyColors.BuyOHRowColor);
                cell.setForeground(MyColors.BuyOHTxtColor);
            } else if (status.equalsIgnoreCase("Pending Replace")) {
                cell.setBackground(MyColors.BuyOHRowColor);
                cell.setForeground(MyColors.BuyOHTxtColor);
            } else if (status.equalsIgnoreCase("Suspended")) {
                cell.setBackground(MyColors.dailyActivityLogSellBGSuspended);
                cell.setForeground(MyColors.BuyOHTxtColor);
            } else if (status.equalsIgnoreCase("Expired")) {
                cell.setBackground(MyColors.dailyActivityLogSellBGSuspended);
                cell.setForeground(MyColors.BuyOHTxtColor);
            } else {
                cell.setForeground(Color.RED);
                cell.setBackground(Color.MAGENTA);
            }
        }
        if (transType.equalsIgnoreCase("Sell")) {
            if (status.equalsIgnoreCase("Queued")) {
                cell.setBackground(MyColors.dailyActivityLogSellBGQ);
                cell.setForeground(MyColors.dailyActivityLogSellFGQ);
            } else if (status.equalsIgnoreCase("Fill")) {
                cell.setBackground(MyColors.dailyActivityLogSellBGFill);
                cell.setForeground(MyColors.dailyActivityLogSellFGFill);
            } else if (status.equalsIgnoreCase("Partial Fill")) {
                cell.setBackground(MyColors.dailyActivityLogSellBGFill);
                cell.setForeground(MyColors.dailyActivityLogSellFGFill);
            } else if (status.equalsIgnoreCase("Business Message Reject")) {
                cell.setBackground(MyColors.dailyActivityLogRejectBG);
                cell.setForeground(MyColors.dailyActivityLogRejectFG);
            } else if (status.equalsIgnoreCase("Rejected")) {
                cell.setBackground(MyColors.dailyActivityLogRejectBG);
                cell.setForeground(MyColors.dailyActivityLogRejectFG);
            } else if (status.equalsIgnoreCase("Cancel Reject")) {
                cell.setBackground(MyColors.dailyActivityLogRejectBG);
                cell.setForeground(MyColors.dailyActivityLogRejectFG);
            } else if (status.equalsIgnoreCase("Cancelled")) {
                cell.setBackground(MyColors.dailyActivityLogSellBGCancel);
                cell.setForeground(MyColors.dailyActivityLogSellFGCancel);
            } else if (status.equalsIgnoreCase("Replaced")) {
                cell.setBackground(MyColors.dailyActivityLogBGReplaced);
                cell.setForeground(MyColors.dailyActivityLogFGReplaced);
            } else if (status.equalsIgnoreCase("Pending Cancel")) {
                cell.setBackground(MyColors.SelOHRowCancel);
                cell.setForeground(MyColors.SelOHTxtCancel);
            } else if (status.equalsIgnoreCase("Pending New")) {
                cell.setBackground(MyColors.SelOHRowColor);
                cell.setForeground(MyColors.SelOHTxtColor);
            } else if (status.equalsIgnoreCase("Pending Replace")) {
                cell.setBackground(MyColors.SelOHRowColor);
                cell.setForeground(MyColors.SelOHTxtColor);
            } else if (status.equalsIgnoreCase("Suspended")) {
                cell.setBackground(MyColors.dailyActivityLogSellBGSuspended);
                cell.setForeground(MyColors.SelOHTxtColor);
            } else if (status.equalsIgnoreCase("Expired")) {
                cell.setBackground(MyColors.dailyActivityLogSellBGSuspended);
                cell.setForeground(MyColors.SelOHTxtColor);
            } else {
                cell.setForeground(Color.MAGENTA);
                cell.setBackground(Color.WHITE);
            }
        }
        return cell;
    }
}

