/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui.render;

import common.gui.component.NxGLabelDoubleColor;
import common.gui.component.NxGLabelGradeint;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import pmex.gui.bean.RiskWatchBean;

public class RiskWatchRender
extends DefaultTableCellRenderer
implements MouseListener,
MouseMotionListener {
    private JTable table;
    private Color oddColorStart = new Color(249, 249, 249);
    private Color oddColorEnd = new Color(225, 225, 225);
    private Color evenColorStart = new Color(221, 232, 242);
    private Color evenColorEnd = new Color(192, 207, 220);
    private Color selectColorStart = new Color(28, 78, 111);
    private Color selectColorEnd = new Color(96, 140, 187);
    private Color roleOverColorStart = new Color(89, 136, 166);
    private Color roleOverColorEnd = new Color(139, 187, 218);
    private Color percentColorStart = new Color(148, 215, 148, 150);
    private Color percentColorEnd = new Color(207, 245, 207, 150);
    private int rowNo = -1;

    public RiskWatchRender(JTable table) {
        if (table != null) {
            this.table = table;
            this.table.addMouseListener(this);
            this.table.addMouseMotionListener(this);
            this.addMouseMotionListener(this);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        NxGLabelGradeint cell = null;
        Object obj = value;
        if (obj instanceof RiskWatchBean) {
            RiskWatchBean b = (RiskWatchBean)obj;
            if (table.getColumnName(column).equalsIgnoreCase("Traders")) {
                cell = new NxGLabelGradeint();
                cell.setText(" " + b.getAccount());
            } else if (table.getColumnName(column).equalsIgnoreCase("Net Liqudity")) {
                cell = new NxGLabelGradeint();
                this.setFontAndPKR((Component)cell, b.getNetLiqudity(), false, true);
            } else if (table.getColumnName(column).equalsIgnoreCase("Threshold")) {
                cell = new NxGLabelGradeint();
                this.setFontAndPKR((Component)cell, b.getThreshold(), false, false);
            } else if (table.getColumnName(column).equalsIgnoreCase("Margin Requirement")) {
                cell = new NxGLabelGradeint();
                this.setFontAndPKR((Component)cell, b.getMarginRequirement(), false, true);
            } else if (table.getColumnName(column).equalsIgnoreCase("Realized P/L")) {
                cell = new NxGLabelGradeint();
                this.setFontAndPKR((Component)cell, b.getRealized(), true, true);
            } else if (table.getColumnName(column).equalsIgnoreCase("Unrealized P/L")) {
                cell = new NxGLabelGradeint();
                this.setFontAndPKR((Component)cell, b.getUnrealized(), true, true);
            } else if (table.getColumnName(column).equalsIgnoreCase("Buying Power")) {
                value = b.getBuyingPower();
                cell = new NxGLabelDoubleColor();
                ((NxGLabelDoubleColor)cell).setText("PKR " + Util.format0digit((String)value.toString()));
                ((NxGLabelDoubleColor)cell).setFont(cell.getFont().deriveFont(1));
                ((NxGLabelDoubleColor)cell).setHorizontalAlignment(4);
                ((NxGLabelDoubleColor)cell).setPaintWidthPercent(100 - (int)b.getBuyingPowerPercentUsed());
                ((NxGLabelDoubleColor)cell).setStartPercentColor(this.percentColorStart);
                ((NxGLabelDoubleColor)cell).setEndPercentColor(this.percentColorEnd);
            } else if (table.getColumnName(column).equalsIgnoreCase("% Buying Power Used")) {
                cell = new NxGLabelDoubleColor();
                ((NxGLabelDoubleColor)cell).setText(Util.format2digit((String)(b.getBuyingPowerPercentUsed() + "")) + " ");
                ((NxGLabelDoubleColor)cell).setFont(cell.getFont().deriveFont(1));
                ((NxGLabelDoubleColor)cell).setHorizontalAlignment(4);
                ((NxGLabelDoubleColor)cell).setPaintWidthPercent((int)b.getBuyingPowerPercentUsed());
                ((NxGLabelDoubleColor)cell).setStartPercentColor(this.percentColorStart);
                ((NxGLabelDoubleColor)cell).setEndPercentColor(this.percentColorEnd);
            }
        }
        if (cell instanceof NxGLabelGradeint) {
            if (row % 2 == 0) {
                ((NxGLabelGradeint)cell).setGradient(this.oddColorStart, this.oddColorEnd);
            } else {
                ((NxGLabelGradeint)cell).setGradient(this.evenColorStart, this.evenColorEnd);
            }
            if (isSelected) {
                cell.setGradient(this.selectColorStart, this.selectColorEnd);
                cell.setForeground(Color.WHITE);
            }
            if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
                cell.setGradient(this.roleOverColorStart, this.roleOverColorEnd);
                cell.setForeground(Color.WHITE);
            }
        } else if (cell instanceof NxGLabelDoubleColor) {
            if (row % 2 == 0) {
                ((NxGLabelDoubleColor)cell).setStartDefault(this.oddColorStart);
                ((NxGLabelDoubleColor)cell).setEndDefault(this.oddColorEnd);
            } else {
                ((NxGLabelDoubleColor)cell).setStartDefault(this.evenColorStart);
                ((NxGLabelDoubleColor)cell).setEndDefault(this.evenColorEnd);
            }
            if (isSelected) {
                ((NxGLabelDoubleColor)cell).setStartDefault(this.selectColorStart);
                ((NxGLabelDoubleColor)cell).setEndDefault(this.selectColorEnd);
                ((NxGLabelDoubleColor)cell).setStartPercentColor(this.selectColorStart);
                ((NxGLabelDoubleColor)cell).setEndPercentColor(this.selectColorEnd);
                cell.setForeground(Color.WHITE);
            }
            if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
                ((NxGLabelDoubleColor)cell).setStartDefault(this.roleOverColorStart);
                ((NxGLabelDoubleColor)cell).setEndDefault(this.roleOverColorEnd);
                ((NxGLabelDoubleColor)cell).setStartPercentColor(this.roleOverColorStart);
                ((NxGLabelDoubleColor)cell).setEndPercentColor(this.roleOverColorEnd);
                cell.setForeground(Color.WHITE);
            }
        }
        return cell;
    }

    private void setFontAndPKR(Component cell, double val, boolean isForeColor, boolean isPKR) {
        if (isPKR) {
            ((NxGLabelGradeint)cell).setText("PKR " + Util.format0digit((String)(val + "")) + " ");
        } else {
            ((NxGLabelGradeint)cell).setText(Util.format0digit((String)(val + "")) + " ");
        }
        if (val == -99999.0) {
            ((NxGLabelGradeint)cell).setText(" ");
        }
        ((NxGLabelGradeint)cell).setFont(cell.getFont().deriveFont(1));
        ((NxGLabelGradeint)cell).setHorizontalAlignment(4);
        if (isForeColor) {
            if (val == 0.0) {
                ((NxGLabelGradeint)cell).setForeground(Color.BLUE);
            } else if (val < 0.0) {
                ((NxGLabelGradeint)cell).setForeground(Color.RED.darker());
            } else if (val > 0.0) {
                ((NxGLabelGradeint)cell).setForeground(Color.GREEN.darker());
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        int row = this.table.rowAtPoint(evt.getPoint());
        if (row != this.getRowNo()) {
            this.setRowNo(row);
            this.table.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setRowNo(-1);
        this.table.repaint();
    }

    public int getRowNo() {
        return this.rowNo;
    }

    public void setRowNo(int rowNo) {
        this.rowNo = rowNo;
    }
}

