/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui.render;

import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import pmex.gui.bean.TradedOrderBean;

public class TradedOrderRender
extends DefaultTableCellRenderer {
    private Color sellTotal = new Color(153, 128, 54);
    private Color buyTotal = new Color(18, 117, 166);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel cell = new JLabel();
        cell.setFont(LogCommon.LogFont);
        cell.setOpaque(true);
        String transType = "";
        String colName = table.getColumnName(column);
        if (value == null) {
            value = "";
        }
        if (value instanceof TradedOrderBean) {
            TradedOrderBean b = (TradedOrderBean)value;
            transType = b.getTransactionType();
            if (colName.equalsIgnoreCase("User")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getTrader());
                    cell.setHorizontalAlignment(2);
                }
            } else if (colName.equalsIgnoreCase("Account")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setText(" " + b.getAccount());
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getAccount());
                    cell.setHorizontalAlignment(2);
                }
            } else if (colName.equalsIgnoreCase("Contract")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getContract());
                    cell.setHorizontalAlignment(2);
                }
            } else if (colName.equalsIgnoreCase("Order ID")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)")) {
                    cell.setText(Util.format2digit((String)(b.getAverageSell() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.sellTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else if (b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setText(" ");
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getOrderID());
                    cell.setHorizontalAlignment(2);
                }
            } else if (colName.equalsIgnoreCase("Ticket ID")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setText(Util.format0digit((String)(b.getTotalFillSell() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.sellTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getTicketID());
                    cell.setHorizontalAlignment(2);
                }
            } else if (colName.equalsIgnoreCase("Client Order ID")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setText(Util.formatPMEX((String)(b.getTotolAmountSell() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.sellTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getClientOrderID());
                    cell.setHorizontalAlignment(2);
                }
            } else if (colName.equalsIgnoreCase("Price")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setText(" ");
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(Util.formatPMEX((String)(b.getPrice() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                }
            } else if (colName.equalsIgnoreCase("Average Price")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)")) {
                    cell.setText(Util.format2digit((String)(b.getAverageBuy() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.buyTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else if (b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setText(" ");
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(Util.formatPMEX((String)(b.getAveragePrice() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                }
            } else if (colName.equalsIgnoreCase("Fill Volume")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setText(Util.format0digit((String)(b.getTotalFillBuy() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.buyTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(Util.format0digit((String)(b.getFillVolume() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                }
            } else if (colName.equalsIgnoreCase("Total Fill")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setText(Util.formatPMEX((String)(b.getTotolAmountBuy() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                    cell.setForeground(this.buyTotal);
                    cell.setFont(cell.getFont().deriveFont(1));
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(Util.format0digit((String)(b.getTotalFill() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                }
            } else if (colName.equalsIgnoreCase("Remaining Volume")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setText(" ");
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(Util.format0digit((String)(b.getRemainingVolume() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                }
            } else if (colName.equalsIgnoreCase("Transaction Type")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getTransactionType());
                    cell.setHorizontalAlignment(2);
                }
            } else if (colName.equalsIgnoreCase("Distance")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setText(" ");
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(Util.formatPMEX((String)(b.getDistance() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                }
            } else if (colName.equalsIgnoreCase("Trailing Step")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setText(" ");
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(Util.formatPMEX((String)(b.getTrailingStep() + "")) + " ");
                    cell.setHorizontalAlignment(4);
                }
            } else if (colName.equalsIgnoreCase("Time")) {
                if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) {
                    cell.setBackground(MyColors.TotalBG);
                } else {
                    cell.setText(" " + b.getTransactionTime());
                    cell.setHorizontalAlignment(2);
                }
            }
        }
        if (transType.equalsIgnoreCase("SELL")) {
            cell.setBackground(MyColors.tradeLogSellBG);
            cell.setForeground(MyColors.tradeLogSellFG);
        } else if (transType.equalsIgnoreCase("BUY")) {
            cell.setBackground(MyColors.tradeLogBuyBG);
            cell.setForeground(MyColors.tradeLogBuyFG);
        }
        return cell;
    }
}

