/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui.render;

import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class VaultPositionRender
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel cell = new JLabel();
        cell.setFont(LogCommon.LogFont);
        cell.setOpaque(true);
        cell.setHorizontalAlignment(2);
        String colName = table.getColumnName(column);
        if (value == null) {
            value = "";
        }
        if (colName.equalsIgnoreCase("Trader Name")) {
            cell.setText(" " + value);
        } else if (colName.equalsIgnoreCase("Commodity")) {
            cell.setText(" " + value);
        } else if (colName.equalsIgnoreCase("Balance")) {
            cell.setText(Util.format0digit((String)(value + "")) + " ");
            cell.setHorizontalAlignment(4);
        } else if (colName.equalsIgnoreCase("Locked Balance")) {
            cell.setText(Util.format0digit((String)(value + "")) + " ");
            cell.setHorizontalAlignment(4);
        }
        if (row % 2 == 0) {
            cell.setBackground(MyColors.cellRenderEven);
        } else {
            cell.setBackground(MyColors.cellRenderOdd);
        }
        if (isSelected) {
            cell.setBackground(MyColors.SelectionFG);
        }
        return cell;
    }
}

