/*
 * Decompiled with CFR 0.152.
 */
package pmex.gui.util;

import common.bean.AccountBean;
import common.bean.ContractBrowseBean;
import common.gui.util.CompressManager;
import common.interfaces.AddContract;
import common.services.WebService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import pmex.gui.bean.ContractPIPBean;

public class LogsPMEX {
    public static HashMap<String, ContractBrowseBean> PMEX_CONTRACT_ALL = new HashMap();
    public static HashMap<String, ContractPIPBean> PMEX_SECTOR_PIP = new HashMap();
    public static Set<AddContract> CONTRACT_HOLDER = new HashSet<AddContract>(5);
    public static TreeMap<String, AccountBean> ALL_ACCOUNTS = new TreeMap();
    public static String[] PMEX_MARKETS = new String[]{"FUT"};
    public static String page1Contract = "";
    public static String page2Contract = "";
    public static String page3Contract = "";
    public static long orderNumber = 0L;
    public static final int BlendTime = 10000;
    public static String SelectedSymbol = "";
    public static String SelectedMarket = "";
    public static String accountPrefix = "";
    public static final String Buy = "Buy";
    public static final String Sell = "Sell";
    public static final String Limit = "Limit";
    public static final String Market = "Market";
    public static final String StopLossLimit = "Stop Loss Limit";
    public static final String StopLossMarket = "Stop Loss Market";
    public static final String TrailingStop = "Trailling Stop Market";
    public static final String[] OrderType = new String[]{"Buy", "Sell"};
    public static final String[] OrderTypesSell = new String[]{"Limit", "Market", "Stop Loss Limit", "Stop Loss Market", "Trailling Stop Market"};
    public static final String[] OrderTypesBuy = new String[]{"Limit", "Market", "Stop Loss Limit", "Stop Loss Market", "Trailling Stop Market"};
    public static final String[] OrderTypesSellFast = new String[]{"Limit", "Market", "Stop Loss Limit", "Stop Loss Market"};
    public static final String[] OrderTypesBuyFast = new String[]{"Limit", "Market", "Stop Loss Limit", "Stop Loss Market"};
    public static final Vector<String> OrderActivityStautsTypes = new Vector();
    public static HashMap<String, String> OrderTypes = new HashMap(5);

    protected static void getContract() {
        try {
            if (PMEX_CONTRACT_ALL.size() <= 0) {
                byte[] result = WebService.getInstance().getPort().getCompressedData("", "PMEX_GetContractAll", "");
                LogsPMEX.fillContract(CompressManager.unzipStringFromBytes((byte[])result));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void fillContract(String data) {
        PMEX_CONTRACT_ALL.clear();
        try {
            String scripAll;
            if (data.indexOf("PMEX_GetContractAll=") >= 0 && (scripAll = data.split("\\=", -1)[1]).indexOf("|") > 0) {
                String[] rowsAll = scripAll.split("\\|", -1);
                for (int i = 0; i <= rowsAll.length - 1; ++i) {
                    String rowSingle = rowsAll[i];
                    ContractBrowseBean cb = LogsPMEX.parse_getContractBrowseBean(rowSingle);
                    PMEX_CONTRACT_ALL.put(cb.getContract(), cb);
                }
            }
            Iterator<AddContract> it = CONTRACT_HOLDER.iterator();
            while (it.hasNext()) {
                it.next().addContract();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static ContractBrowseBean parse_getContractBrowseBean(String singleRow) {
        ContractBrowseBean cb = new ContractBrowseBean();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (singleRow.indexOf(";") >= 0) {
            String[] values = singleRow.split("\\;", -1);
            cb.setContract(values[0]);
            cb.setType(values[1]);
            cb.setExchange(values[2]);
            cb.setMaturityMonthYear(values[3]);
            cb.setMaturityDate(values[4]);
            try {
                cb.setDate(df.parse(values[5]));
            }
            catch (ParseException ex) {
                ex.printStackTrace();
                cb.setDate(null);
            }
        }
        return cb;
    }

    protected static void getSectorPIP() {
        try {
            if (PMEX_SECTOR_PIP.size() <= 0) {
                byte[] result = WebService.getInstance().getPort().getCompressedData("", "PMEX_GetSectorPIP", "");
                LogsPMEX.fillSectorPIP(CompressManager.unzipStringFromBytes((byte[])result));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void fillSectorPIP(String data) {
        PMEX_SECTOR_PIP.clear();
        try {
            String scripAll;
            if (data.indexOf("PMEX_GetSectorPIP=") >= 0 && (scripAll = data.split("\\=", -1)[1]).indexOf("|") > 0) {
                String[] rowsAll = scripAll.split("\\|", -1);
                for (int i = 0; i < rowsAll.length; ++i) {
                    String rowSingle = rowsAll[i];
                    ContractPIPBean cb = LogsPMEX.parse_getContractPIPBean(rowSingle);
                    PMEX_SECTOR_PIP.put(cb.getContract(), cb);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static ContractPIPBean parse_getContractPIPBean(String singleRow) {
        ContractPIPBean cb = new ContractPIPBean();
        if (singleRow.indexOf(";") >= 0) {
            String[] values = singleRow.split("\\;", -1);
            cb.setContract(values[0]);
            try {
                cb.setPIP(Double.parseDouble(values[1]));
            }
            catch (Exception ex) {
                cb.setPIP(0.01);
            }
            try {
                cb.setExtraRow(Integer.parseInt(values[2]));
            }
            catch (Exception ex) {
                cb.setExtraRow(20);
            }
            try {
                cb.setRoundDigit(Integer.parseInt(values[3]));
            }
            catch (Exception ex) {
                cb.setRoundDigit(2);
            }
        }
        return cb;
    }

    static {
        System.err.println("CATALYSTPMEX v3.4.3");
        OrderTypes.put(Limit, "LMT");
        OrderTypes.put(Market, "MKT");
        OrderTypes.put(StopLossLimit, "SLL");
        OrderTypes.put(StopLossMarket, "SLM");
        OrderTypes.put(TrailingStop, "TSM");
        OrderActivityStautsTypes.add("ALL");
        OrderActivityStautsTypes.add("Queued");
        OrderActivityStautsTypes.add("Fill");
        OrderActivityStautsTypes.add("Rejected");
        OrderActivityStautsTypes.add("Cancelled");
        OrderActivityStautsTypes.add("Suspended");
        OrderActivityStautsTypes.add("Replaced");
        OrderActivityStautsTypes.add("Expired");
        OrderActivityStautsTypes.add("Partial Fill");
        OrderActivityStautsTypes.add("Business Message Reject");
        OrderActivityStautsTypes.add("Cancel Reject");
        OrderActivityStautsTypes.add("Pending Cancel");
        OrderActivityStautsTypes.add("Pending New");
        OrderActivityStautsTypes.add("Pending Replace");
    }
}

