/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;

public class BusyLabelExample {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new BusyLabelExample();
            }
        });
    }

    public BusyLabelExample() {
        JFrame frame = new JFrame("JXBusyLabel Example");
        frame.add(this.doInit());
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.pack();
        frame.setVisible(true);
    }

    private Component doInit() {
        JXPanel panel = new JXPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        final JXBusyLabel busylabel1 = this.createSimpleBusyLabel();
        final JXBusyLabel busylabel2 = this.createComplexBusyLabel();
        busylabel1.setEnabled(false);
        busylabel2.setEnabled(false);
        final JXLabel label = this.createLabel();
        JButton button = new JButton("start/stop");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!busylabel1.isEnabled()) {
                    busylabel1.setEnabled(true);
                    busylabel2.setEnabled(true);
                }
                if (busylabel1.isBusy()) {
                    label.setText("BusyLabel stopped");
                    busylabel1.setBusy(false);
                    busylabel2.setBusy(false);
                } else {
                    label.setText("BusyLabel started");
                    busylabel1.setBusy(true);
                    busylabel2.setBusy(true);
                }
            }
        });
        panel.setAlpha(0.7f);
        panel.add((Component)label, (Object)"North");
        JXPanel busylabels = new JXPanel((LayoutManager)new FlowLayout(1, 40, 5));
        busylabels.add((Component)busylabel1);
        busylabels.add((Component)busylabel2);
        panel.add((Component)busylabels, (Object)"Center");
        panel.add((Component)button, (Object)"South");
        panel.setPreferredSize(new Dimension(250, 125));
        return panel;
    }

    public JXBusyLabel createSimpleBusyLabel() {
        JXBusyLabel label = new JXBusyLabel();
        label.setToolTipText("simple busy label");
        return label;
    }

    public JXBusyLabel createComplexBusyLabel() {
        JXBusyLabel label = new JXBusyLabel(new Dimension(38, 38));
        BusyPainter painter = new BusyPainter((Shape)new Rectangle2D.Float(0.0f, 0.0f, 8.0f, 8.0f), (Shape)new Rectangle2D.Float(5.5f, 5.5f, 27.0f, 27.0f));
        painter.setTrailLength(4);
        painter.setPoints(8);
        painter.setFrame(-1);
        painter.setBaseColor(Color.blue);
        painter.setHighlightColor(Color.orange);
        label.setPreferredSize(new Dimension(38, 38));
        label.setIcon((Icon)new EmptyIcon(38, 38));
        label.setBusyPainter(painter);
        label.setToolTipText("complex busy label");
        return label;
    }

    public JXLabel createLabel() {
        JXLabel label = new JXLabel();
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        label.setFont(new Font("Segoe UI", 1, 14));
        label.setText("<html>BusyLabel Example...<br>click start/stop button</html>");
        label.setHorizontalAlignment(2);
        label.setBackgroundPainter(this.getPainter());
        return label;
    }

    public Painter getPainter() {
        int width = 100;
        int height = 100;
        Color color1 = Color.WHITE;
        Color color2 = Color.gray;
        LinearGradientPaint gradientPaint = new LinearGradientPaint(0.0f, 0.0f, width, height, new float[]{0.0f, 1.0f}, new Color[]{color1, color2});
        MattePainter mattePainter = new MattePainter((Paint)gradientPaint);
        return mattePainter;
    }
}

