/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import test.ArrowIcon;
import test.ColumnButtonScrollPaneLayout;
import test.LinesBorder;

class ColumnButtonScrollPane
extends JScrollPane {
    Component columnButton;

    public ColumnButtonScrollPane(JTable table) {
        super(table);
        TableColumnModel cm = table.getColumnModel();
        LimitedTableHeader header = new LimitedTableHeader(cm);
        table.setTableHeader(header);
        this.columnButton = this.createUpperCorner(header);
        this.setCorner("UPPER_RIGHT_CORNER", this.columnButton);
        this.setVerticalScrollBarPolicy(22);
        ColumnButtonScrollPaneLayout layout = new ColumnButtonScrollPaneLayout();
        this.setLayout(layout);
        layout.syncWithScrollPane(this);
    }

    protected Component createUpperCorner(JTableHeader header) {
        ColumnButton corner = new ColumnButton(header);
        return corner;
    }

    public class ColumnButton
    extends JPanel {
        JTable table;
        TableColumnModel cm;
        JButton revealButton;
        JButton hideButton;
        Stack stack;

        public ColumnButton(JTableHeader header) {
            this.setLayout(new GridLayout(1, 2));
            this.setBorder(new LinesBorder((Color)SystemColor.controlShadow, new Insets(0, 1, 0, 0)));
            this.stack = new Stack();
            this.table = header.getTable();
            this.cm = this.table.getColumnModel();
            this.revealButton = this.createButton(header, 7);
            this.hideButton = this.createButton(header, 3);
            this.add(this.revealButton);
            this.add(this.hideButton);
            this.revealButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TableColumn column = (TableColumn)ColumnButton.this.stack.pop();
                    ColumnButton.this.cm.addColumn(column);
                    if (ColumnButton.this.stack.empty()) {
                        ColumnButton.this.revealButton.setEnabled(false);
                    }
                    ColumnButton.this.hideButton.setEnabled(true);
                    ColumnButton.this.table.sizeColumnsToFit(-1);
                }
            });
            this.hideButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int n = ColumnButton.this.cm.getColumnCount();
                    TableColumn column = ColumnButton.this.cm.getColumn(n - 1);
                    ColumnButton.this.stack.push(column);
                    ColumnButton.this.cm.removeColumn(column);
                    if (n < 3) {
                        ColumnButton.this.hideButton.setEnabled(false);
                    }
                    ColumnButton.this.revealButton.setEnabled(true);
                    ColumnButton.this.table.sizeColumnsToFit(-1);
                }
            });
            if (1 < this.cm.getColumnCount()) {
                this.hideButton.setEnabled(true);
            } else {
                this.hideButton.setEnabled(false);
            }
            this.revealButton.setEnabled(false);
        }

        protected JButton createButton(JTableHeader header, int direction) {
            int iconHeight = 8;
            JButton button = new JButton();
            button.setIcon(new ArrowIcon(iconHeight, direction, true));
            button.setDisabledIcon(new ArrowIcon(iconHeight, direction, false));
            button.setRequestFocusEnabled(false);
            button.setForeground(header.getForeground());
            button.setBackground(header.getBackground());
            button.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return button;
        }
    }

    public class LimitedTableHeader
    extends JTableHeader {
        public LimitedTableHeader(TableColumnModel cm) {
            super(cm);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            ColumnButtonScrollPane.this.columnButton.repaint();
        }
    }
}

