/*
 * Decompiled with CFR 0.152.
 */
package test;

import common.gui.render.CheckBoxHeader;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.LayoutStyle;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import pmex.gui.bean.LeaderBean;
import pmex.gui.bean.LeaderTickLocksBean;
import pmex.gui.dragdrop.GhostComponentAdapter;
import pmex.gui.model.LeaderModel;
import pmex.gui.render.LeaderRender;
import pmex.gui.util.SwingWorker;
import test.TableRowTransferHandler;

public class Leader_CheckboxHeaderTest
extends JFrame
implements ActionListener,
MouseListener,
DragGestureListener {
    private Vector<LeaderBean> rows = new Vector();
    private Vector<String> columns = new Vector();
    private Hashtable<String, TableColumn> allColumn = new Hashtable(6);
    Hashtable<Double, LeaderBean> allData = new Hashtable();
    Hashtable<String, LeaderTickLocksBean> tickInfo = new Hashtable();
    LeaderModel model = null;
    LeaderRender render = null;
    JTableHeader header = null;
    TableColumnModel columnModel = null;
    GhostComponentAdapter componentAdapter;
    TransferHandler handler = new TableRowTransferHandler();
    SwingWorker worker;
    Thread d = new Thread(new Runnable(){

        @Override
        public void run() {
            while (true) {
                Leader_CheckboxHeaderTest.this.worker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        return Leader_CheckboxHeaderTest.this.doWork();
                    }

                    @Override
                    public void finished() {
                        Leader_CheckboxHeaderTest.this.table.repaint();
                    }
                };
                Leader_CheckboxHeaderTest.this.worker.start();
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Leader_CheckboxHeaderTest.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                break;
            }
        }
    });
    private JButton jButton1;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JPopupMenu jPopupMenu1;
    private JScrollPane jScrollPane1;
    private JMenu menu;
    private JTable table;

    public Leader_CheckboxHeaderTest() {
        int i;
        this.initComponents();
        this.columns.add("VAP");
        this.columns.add("Orders");
        this.columns.add("Buy");
        this.columns.add("Price");
        this.columns.add("Sell");
        this.columns.add("Size");
        this.columns.add("Total");
        this.model = new LeaderModel(this.rows, this.columns);
        this.table.setModel((TableModel)((Object)this.model));
        this.render = new LeaderRender(this.table, this.model);
        this.header = this.table.getTableHeader();
        this.columnModel = this.table.getColumnModel();
        this.header.setComponentPopupMenu(this.jPopupMenu1);
        for (i = 0; i < this.columns.size(); ++i) {
            String string = this.columns.elementAt(i);
            this.table.getColumnModel().getColumn(i).setHeaderRenderer((TableCellRenderer)new CheckBoxHeader(this.header, i, string));
            JCheckBoxMenuItem mp = new JCheckBoxMenuItem(string);
            mp.addActionListener(this);
            this.jPopupMenu1.add(mp);
            this.menu.add(mp);
        }
        this.table.addMouseListener(this);
        this.header.addMouseListener(this);
        for (i = 0; i < this.columns.size(); ++i) {
            TableColumn tc = this.table.getColumnModel().getColumn(i);
            tc.setIdentifier(this.columns.get(i));
            this.allColumn.put(this.columns.get(i), tc);
        }
        for (int k = 0; k < this.columns.size(); ++k) {
            this.table.getColumn(this.columns.elementAt(k)).setCellRenderer((TableCellRenderer)((Object)this.render));
        }
        this.setTickInfo();
        this.addRows();
        this.table.repaint();
        this.d.start();
    }

    private Object doWork() {
        this.addRows();
        return null;
    }

    synchronized void addRows() {
        LeaderBean lb;
        int i;
        this.rows.clear();
        LeaderTickLocksBean tb = this.tickInfo.get("Test");
        int rowsCount = (int)((tb.getUpperCap() - tb.getLowerLock()) / tb.getTick());
        int mid = Math.round(rowsCount / 2);
        double lastPrice = tb.getLowerLock();
        for (i = 0; i < mid; ++i) {
            lastPrice = tb.getTick() + lastPrice;
            lb = this.getBean(lastPrice, true);
            this.allData.put(lb.getPrice(), lb);
        }
        for (i = mid; i < rowsCount; ++i) {
            lastPrice = tb.getTick() + lastPrice;
            lb = this.getBean(lastPrice, false);
            this.allData.put(lb.getPrice(), lb);
        }
        Vector<Double> v = new Vector<Double>(this.allData.keySet());
        Collections.sort(v);
        this.setPercentage(this.getMaximum());
        Iterator<Double> it = v.iterator();
        while (it.hasNext()) {
            this.rows.add(this.allData.get(it.next()));
        }
    }

    private LeaderBean getBean(double price, boolean isSell) {
        LeaderBean lb = new LeaderBean();
        lb.setPrice(price);
        if (isSell) {
            lb.setSell(price);
        } else {
            lb.setBuy(price);
        }
        lb.setOrders(0L);
        lb.setSize(Math.round(Math.random() * 123.0));
        lb.setTotal(Math.round(Math.random() * 97865.0));
        lb.setVAP(Math.round(Math.random() * 4896.0));
        return lb;
    }

    private LeaderBean getMaximum() {
        LeaderBean lb = new LeaderBean();
        Enumeration<LeaderBean> en = this.allData.elements();
        while (en.hasMoreElements()) {
            LeaderBean temp = en.nextElement();
            if (lb.getTotal() < temp.getTotal()) {
                lb.setTotal(temp.getTotal());
            }
            if (lb.getSize() < temp.getSize()) {
                lb.setSize(temp.getSize());
            }
            if (lb.getVAP() >= temp.getVAP()) continue;
            lb.setVAP(temp.getVAP());
        }
        return lb;
    }

    private void setPercentage(LeaderBean lb) {
        double total = new Double(1.0) / (double)lb.getTotal();
        double size = new Double(1.0) / (double)lb.getSize();
        double VAP = new Double(1.0) / (double)lb.getVAP();
        Enumeration<LeaderBean> en = this.allData.elements();
        while (en.hasMoreElements()) {
            LeaderBean temp = en.nextElement();
            temp.setTotalPercent((int)((double)temp.getTotal() * total * 100.0));
            temp.setSizePercent((int)((double)temp.getSize() * size * 100.0));
            temp.setVAPPercent((int)((double)temp.getVAP() * VAP * 100.0));
        }
    }

    private void setTickInfo() {
        LeaderTickLocksBean lb = new LeaderTickLocksBean();
        lb.setTick(0.1);
        lb.setLowerLock(100.0);
        lb.setUpperCap(110.0);
        this.tickInfo.put("Test", lb);
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.menu = new JMenu();
        this.setDefaultCloseOperation(3);
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                Leader_CheckboxHeaderTest.this.tableMouseDragged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.jButton1.setText("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Leader_CheckboxHeaderTest.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("jLabel1");
        this.jLabel1.setBorder(BorderFactory.createEtchedBorder(0, null, new Color(204, 204, 204)));
        this.jMenu1.setText("File");
        this.jMenuItem1.setText("jMenuItem1");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Leader_CheckboxHeaderTest.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.menu.setText("Edit");
        this.jMenuBar1.add(this.menu);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addGap(155, 155, 155).addComponent(this.jLabel1).addGap(128, 128, 128)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 384, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 228, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jLabel1)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int index = this.table.getColumnModel().getColumnCount();
        TableColumn tc = this.table.getColumnModel().getColumn(index - 1);
        this.table.getColumnModel().removeColumn(tc);
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        int index = this.table.getColumnModel().getColumnCount();
        TableColumn tc = this.table.getColumnModel().getColumn(index - 1);
        this.table.getColumnModel().removeColumn(tc);
    }

    private void tableMouseDragged(MouseEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Leader_CheckboxHeaderTest().setVisible(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object ob = e.getSource();
        if (ob instanceof JCheckBoxMenuItem) {
            try {
                JCheckBoxMenuItem mp = (JCheckBoxMenuItem)ob;
                if (mp.isSelected()) {
                    this.table.getTableHeader().getColumnModel().removeColumn(this.allColumn.get(mp.getText()));
                } else {
                    this.table.getColumnModel().addColumn(this.allColumn.get(mp.getText()));
                    this.table.getColumnModel().moveColumn(this.table.getColumnModel().getColumnCount() - 1, this.columns.indexOf(mp.getText()));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            Object obj = e.getSource();
            if (obj == this.table) {
                this.rows.elementAt(this.table.getSelectedRow()).setOrders(99999L);
                this.table.repaint();
            } else if (obj == this.header) {
                int vci = this.columnModel.getColumnIndexAtX(e.getX());
                int clickedColumn = this.table.convertColumnIndexToModel(vci);
                if (clickedColumn == 0) {
                    this.model.isVAP = !this.model.isVAP;
                } else if (clickedColumn == 1) {
                    this.model.isOrders = !this.model.isOrders;
                } else if (clickedColumn == 4) {
                    this.model.isSell = !this.model.isSell;
                } else if (clickedColumn == 2) {
                    this.model.isBuy = !this.model.isBuy;
                } else if (clickedColumn == 5) {
                    this.model.isSize = !this.model.isSize;
                } else if (clickedColumn == 3) {
                    this.model.isPrice = !this.model.isPrice;
                } else if (clickedColumn == 6) {
                    this.model.isTotal = !this.model.isTotal;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
    }

    public void scrollToVisible(JTable table, int rowIndex, int vColIndex) {
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(rowIndex, vColIndex, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }
}

