/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableModel;

class TableRowTransferHandler
extends TransferHandler {
    private int[] rows = null;
    private int addIndex = -1;
    private int addCount = 0;
    private final DataFlavor localObjectFlavor = new ActivationDataFlavor(Object[].class, "application/x-java-jvm-local-objectref", "Array of items");
    private Object[] transferedObjects = null;
    private JComponent source = null;

    @Override
    protected Transferable createTransferable(JComponent c) {
        this.source = c;
        JTable table = (JTable)c;
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        ArrayList<Vector> list = new ArrayList<Vector>();
        this.rows = table.getSelectedRows();
        for (int i : this.rows) {
            list.add(model.getDataVector().elementAt(i));
        }
        this.transferedObjects = list.toArray();
        return new DataHandler((Object)this.transferedObjects, this.localObjectFlavor.getMimeType());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        JTable t = (JTable)info.getComponent();
        boolean b = info.isDrop() && info.isDataFlavorSupported(this.localObjectFlavor);
        t.setCursor(b ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
        return b;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        JTable target = (JTable)info.getComponent();
        JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
        DefaultTableModel model = (DefaultTableModel)target.getModel();
        int index = dl.getRow();
        int max = model.getRowCount();
        if (index < 0 || index > max) {
            index = max;
        }
        this.addIndex = index;
        target.setCursor(Cursor.getPredefinedCursor(0));
        try {
            Object[] values = (Object[])info.getTransferable().getTransferData(this.localObjectFlavor);
            if (this.source == target) {
                this.addCount = values.length;
            }
            for (int i = 0; i < values.length; ++i) {
                int idx = index++;
                model.insertRow(idx, (Vector)values[i]);
                target.getSelectionModel().addSelectionInterval(idx, idx);
            }
            return true;
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent c, Transferable t, int act) {
        this.cleanup(c, act == 2);
    }

    private void cleanup(JComponent src, boolean remove) {
        if (remove && this.rows != null) {
            int i;
            JTable table = (JTable)src;
            src.setCursor(Cursor.getPredefinedCursor(0));
            DefaultTableModel model = (DefaultTableModel)table.getModel();
            if (this.addCount > 0) {
                for (i = 0; i < this.rows.length; ++i) {
                    if (this.rows[i] < this.addIndex) continue;
                    int n = i;
                    this.rows[n] = this.rows[n] + this.addCount;
                }
            }
            for (i = this.rows.length - 1; i >= 0; --i) {
                model.removeRow(this.rows[i]);
            }
        }
        this.rows = null;
        this.addCount = 0;
        this.addIndex = -1;
    }
}

