/*
 * Decompiled with CFR 0.152.
 */
package Beans;

import MyDocking.Mediator;
import Utilities.OutstandingLogUtil;
import common.gui.util.LogCommon;
import common.gui.util.Util;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import kse.gui.bean.TradeOutLogBean;

public class Tradelog {
    static int keyCounter = 0;
    public String Tradelog_TRADER = "";
    public String Tradelog_SYMBOL = "";
    public String Tradelog_MKT = "";
    public String Tradelog_TIME = "";
    public String Tradelog_COUNTER = "";
    public String Tradelog_ORDERNO = "";
    public String Tradelog_TYPE = "";
    public long Tradelog_FILLVOLUME = 0L;
    public double Tradelog_PRICE = 0.0;
    public String Tradelog_TICKET = "";
    public String Tradelog_ACCOUNT = "";
    public String Tradelog_ACTION = "";
    public String Tradelog_FLAG = "";
    public String Tradelog_TOTALVOLUME = "";
    public double Tradelog_TOTALVALUE = 0.0;
    public String Tradelog_REMAINING = "";
    public String Tradelog_Order_Type = "";
    public String Tradelog_KEY = "" + ++keyCounter;

    public boolean parse(String log) {
        boolean ret = false;
        try {
            String[] STRARRAY = log.split("\\|", -1);
            String[] STRVALUES = STRARRAY[0].split("\\;", -1);
            this.Tradelog_TRADER = STRVALUES[0].trim();
            this.Tradelog_SYMBOL = STRVALUES[1].trim();
            this.Tradelog_MKT = STRVALUES[2].trim();
            this.Tradelog_TIME = STRVALUES[3].trim();
            this.Tradelog_COUNTER = STRVALUES[4].trim();
            this.Tradelog_ORDERNO = STRVALUES[5].trim();
            this.Tradelog_TYPE = STRVALUES[6].trim();
            this.Tradelog_FILLVOLUME = Long.parseLong(STRVALUES[7].trim());
            this.Tradelog_PRICE = Double.parseDouble(STRVALUES[8].trim());
            this.Tradelog_TICKET = STRVALUES[9].trim();
            this.Tradelog_KEY = this.Tradelog_ORDERNO + this.Tradelog_TICKET;
            this.Tradelog_ACCOUNT = STRVALUES[10].trim();
            this.Tradelog_ACTION = LogCommon.actionMap.containsKey(STRVALUES[11].trim()) ? (String)LogCommon.actionMap.get(STRVALUES[11].trim()) : STRVALUES[11].trim();
            this.Tradelog_FLAG = STRVALUES[12].trim();
            this.Tradelog_TOTALVOLUME = STRVALUES[13].trim();
            this.Tradelog_TOTALVALUE = Util.round((double)Double.parseDouble(STRVALUES[14].trim()), (int)2);
            this.Tradelog_REMAINING = STRVALUES[15].trim();
            this.Tradelog_Order_Type = STRVALUES[16].trim();
            ret = true;
        }
        catch (Exception ee) {
            this.Tradelog_TRADER = "";
            this.Tradelog_SYMBOL = "";
            this.Tradelog_MKT = "";
            this.Tradelog_TIME = "";
            this.Tradelog_COUNTER = "";
            this.Tradelog_ORDERNO = "";
            this.Tradelog_TYPE = "";
            this.Tradelog_FILLVOLUME = 0L;
            this.Tradelog_PRICE = 0.0;
            this.Tradelog_TICKET = "";
            this.Tradelog_ACCOUNT = "";
            this.Tradelog_ACTION = "";
            this.Tradelog_FLAG = "";
            this.Tradelog_TOTALVOLUME = "";
            this.Tradelog_TOTALVALUE = 0.0;
            this.Tradelog_REMAINING = "";
            this.Tradelog_Order_Type = "";
        }
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.Tradelog_TRADER.length() == 0 || this.Tradelog_TRADER.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Tradelog_TRADER);
        }
        sb.append(";");
        if (this.Tradelog_SYMBOL.length() == 0 || this.Tradelog_SYMBOL.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Tradelog_SYMBOL);
        }
        sb.append(";");
        if (this.Tradelog_MKT.length() == 0 || this.Tradelog_MKT.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Tradelog_MKT);
        }
        sb.append(";");
        if (this.Tradelog_TIME.length() == 0 || this.Tradelog_TIME.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Tradelog_TIME);
        }
        sb.append(";");
        if (this.Tradelog_COUNTER.length() == 0 || this.Tradelog_COUNTER.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Tradelog_COUNTER);
        }
        sb.append(";");
        if (this.Tradelog_ORDERNO.length() == 0 || this.Tradelog_ORDERNO.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Tradelog_ORDERNO);
        }
        sb.append(";");
        if (this.Tradelog_TYPE.length() == 0 || this.Tradelog_TYPE.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Tradelog_TYPE);
        }
        sb.append(";");
        sb.append(this.Tradelog_FILLVOLUME);
        sb.append(";");
        sb.append(this.Tradelog_PRICE);
        sb.append(";");
        if (this.Tradelog_TICKET.length() == 0 || this.Tradelog_TICKET.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Tradelog_TICKET);
        }
        sb.append(";");
        if (this.Tradelog_ACCOUNT.length() == 0 || this.Tradelog_ACCOUNT.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Tradelog_ACCOUNT);
        }
        sb.append(";");
        if (this.Tradelog_ACTION.length() == 0 || this.Tradelog_ACTION.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Tradelog_ACTION);
        }
        sb.append(";");
        if (this.Tradelog_FLAG.length() == 0 || this.Tradelog_FLAG.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Tradelog_FLAG);
        }
        sb.append(";");
        if (this.Tradelog_TOTALVOLUME.length() == 0 || this.Tradelog_TOTALVOLUME.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Tradelog_TOTALVOLUME);
        }
        sb.append(";");
        sb.append(this.Tradelog_TOTALVALUE);
        sb.append(";");
        if (this.Tradelog_REMAINING.length() == 0 || this.Tradelog_REMAINING.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Tradelog_REMAINING);
        }
        sb.append(";");
        if (this.Tradelog_Order_Type.length() == 0 || this.Tradelog_Order_Type.toLowerCase().compareTo("null") == 0) {
            sb.append("-");
        } else {
            sb.append(this.Tradelog_Order_Type);
        }
        sb.append("|");
        return new String(sb);
    }

    public static LinkedHashMap SeperateLogByTrader(LinkedHashMap hashtable, String trader) {
        LinkedHashMap retList = new LinkedHashMap();
        try {
            String temp = "";
            Iterator e = hashtable.keySet().iterator();
            while (e.hasNext()) {
                Tradelog tlog = (Tradelog)hashtable.get(e.next().toString());
                if (tlog == null) continue;
                if (trader.indexOf("%") > 0) {
                    String trader2 = trader.replaceAll("\\%", "");
                    if (tlog.Tradelog_TRADER.indexOf(trader2) < 0) continue;
                    retList.put(tlog.Tradelog_KEY, tlog);
                    continue;
                }
                if (tlog.Tradelog_TRADER.compareToIgnoreCase(trader) != 0) continue;
                retList.put(tlog.Tradelog_KEY, tlog);
            }
        }
        catch (Exception ee) {
            retList = hashtable;
        }
        return retList;
    }

    public static LinkedHashMap SeperateLogBySymbol(LinkedHashMap hashtable, String symbol) {
        LinkedHashMap retList = new LinkedHashMap();
        try {
            String temp = "";
            Iterator e = hashtable.keySet().iterator();
            while (e.hasNext()) {
                Tradelog tlog = (Tradelog)hashtable.get(e.next().toString());
                if (tlog == null || tlog.Tradelog_SYMBOL.compareToIgnoreCase(symbol) != 0) continue;
                retList.put(tlog.Tradelog_KEY, tlog);
            }
        }
        catch (Exception ee) {
            retList = hashtable;
        }
        return retList;
    }

    public static LinkedHashMap SeperateLogByAccount(LinkedHashMap hashtable, String account) {
        LinkedHashMap retList = new LinkedHashMap();
        try {
            String temp = "";
            Iterator e = hashtable.keySet().iterator();
            while (e.hasNext()) {
                Tradelog tlog = (Tradelog)hashtable.get(e.next().toString());
                if (tlog == null) continue;
                if (account.indexOf("%") > 0) {
                    String account2 = account.replaceAll("\\%", "");
                    if (tlog.Tradelog_ACCOUNT.indexOf(account2) < 0) continue;
                    retList.put(tlog.Tradelog_KEY, tlog);
                    continue;
                }
                if (tlog.Tradelog_ACCOUNT.compareToIgnoreCase(account) != 0) continue;
                retList.put(tlog.Tradelog_KEY, tlog);
            }
        }
        catch (Exception ee) {
            retList = hashtable;
        }
        return retList;
    }

    public static LinkedHashMap SeperateLogByOrderType(LinkedHashMap hashtable, String orderType) {
        LinkedHashMap retList = new LinkedHashMap();
        try {
            String temp = "";
            Iterator e = hashtable.keySet().iterator();
            while (e.hasNext()) {
                Tradelog tlog = (Tradelog)hashtable.get(e.next().toString());
                if (tlog == null || tlog.Tradelog_TYPE.compareToIgnoreCase(orderType) != 0) continue;
                retList.put(tlog.Tradelog_KEY, tlog);
            }
        }
        catch (Exception ee) {
            retList = hashtable;
        }
        return retList;
    }

    public static LinkedHashMap SeperateLogByMarket(LinkedHashMap hashtable, String market) {
        LinkedHashMap retList = new LinkedHashMap();
        try {
            String temp = "";
            Iterator e = hashtable.keySet().iterator();
            while (e.hasNext()) {
                Tradelog tlog = (Tradelog)hashtable.get(e.next().toString());
                if (tlog == null || tlog.Tradelog_MKT.compareToIgnoreCase(market) != 0) continue;
                retList.put(tlog.Tradelog_KEY, tlog);
            }
        }
        catch (Exception ee) {
            retList = hashtable;
        }
        return retList;
    }

    public static long GetTotalVolume(Hashtable hashtable) {
        long volume = 0L;
        try {
            Enumeration e = hashtable.keys();
            while (e.hasMoreElements()) {
                Tradelog tlog = (Tradelog)hashtable.get(e.nextElement().toString());
                if (tlog == null) continue;
                volume += tlog.Tradelog_FILLVOLUME;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return volume;
    }

    public static double GetAvgPrice(Hashtable hashtable) {
        double avgPrice = 0.0;
        try {
            double totPrice = 0.0;
            int tottrade = 0;
            Enumeration e = hashtable.keys();
            while (e.hasMoreElements()) {
                Tradelog tlog = (Tradelog)hashtable.get(e.nextElement().toString());
                if (tlog == null) continue;
                totPrice += tlog.Tradelog_PRICE;
                ++tottrade;
            }
            if (tottrade > 0) {
                avgPrice = totPrice / (double)tottrade;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return avgPrice;
    }

    public static String GetLogForWebClient(LinkedHashMap hashtable) {
        StringBuffer ret = new StringBuffer();
        try {
            String temp = "";
            Iterator e = hashtable.keySet().iterator();
            while (e.hasNext()) {
                Tradelog tlog = (Tradelog)hashtable.get(e.next());
                if (tlog == null) continue;
                ret.append(tlog.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret.toString();
    }

    public static TradeOutLogBean AddTradelog(String order_string, boolean isServerPacket) {
        TradeOutLogBean tlog = null;
        try {
            tlog = TradeOutLogBean.parse((String)order_string, (boolean)isServerPacket);
            if (Mediator.getInstance().tradeoutLog != null) {
                Mediator.getInstance().tradeoutLog.addTrade(tlog);
            }
            OutstandingLogUtil.UpdateOutstandinglog(tlog.getOrderNo(), tlog);
            return tlog;
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return tlog;
        }
    }
}

