/*
 * Decompiled with CFR 0.152.
 */
package Chart;

import MyDocking.TradeCast;
import Screener.Loader;
import Utilities.UtilTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import catalystchart.TAObjects;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import jfree.custom.InfoBoxCrosshair;
import jfree.custom.InfoBoxCrosshairOverlay;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.HighLowItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.time.ohlc.OHLCSeries;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;

public class CandleChart
extends JPanel
implements ChartMouseListener {
    private ArrayList<Double> Open = new ArrayList();
    private ArrayList<Double> High = new ArrayList();
    private ArrayList<Double> Low = new ArrayList();
    private ArrayList<Double> Close = new ArrayList();
    private ArrayList<Date> date = new ArrayList();
    private ArrayList<Double> volume = new ArrayList();
    private DateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    private DateFormat df = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
    JDialog window = null;
    JFrame frame = null;
    ChartPanel chartPanel;
    private InfoBoxCrosshair infoCrosshair;
    private final InfoBoxCrosshairOverlay infoBoxCrosshairOverlay = new InfoBoxCrosshairOverlay();
    JFreeChart jFreeChart;
    XYPlot pricePlot;
    CandlestickRenderer candlestickRenderer;
    OHLCDataset ohlcDataSet = null;
    OHLCSeries ohlcSeriers = null;
    XYTextAnnotation xyTextAnnotation;
    private int timetick = 5;
    int num = 0;
    final Color BarCOLOR = new Color(0, 190, 190);
    final Color VolColor = new Color(141, 136, 41);
    private InfoBoxCrosshair ltrdInfoCrosshair;
    boolean Attach = true;
    private String scrip = "";
    private String Market = "";
    private String lastData = "";
    RefreshCandle refreshThread = null;
    final Color VolumeColor = new Color(141, 136, 41);
    final Color LtrdPriceColor = new Color(2, 238, 162);
    private List<String> values = new ArrayList<String>();
    private List<String> param = new ArrayList<String>();
    final Color PLOTBGCOLOR = Color.BLACK;
    TimeSeries Tseries;
    NumberFormat localNumberFormat = new DecimalFormat("###,###");
    Hashtable<String, TAObjects> TAObjects = new Hashtable();
    IntervalXYDataset volumeDataset;
    DecimalFormat localDecimalFormat = new DecimalFormat("###,###.##");
    OHLCSeries ohlseries;
    private final int key;
    final SimpleDateFormat dfDay = new SimpleDateFormat("HH:MM:SS");
    private LanguageCentre languageCentre = new LanguageCentre();
    private JPanel CandlePanel;
    private JPanel ComponentPanel;
    private JButton btnDock;
    private JComboBox cbMarkets;
    private JComboBox cbScrip;
    private JComboBox cbTime;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JLabel lblHistoricalCandleChart;
    private JLabel lblIndexGraph;
    private JLabel lblScripGraph;
    private JLabel lblSymbolName;

    public CandleChart(int num, int key) {
        this.initComponents();
        this.num = num;
        this.key = key;
        this.setAllScrip();
        this.setMarkets();
        this.addLoader();
        this.lblHistoricalCandleChart.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/Historicalcandlestick.png")));
    }

    public void init(String market, String scrip) {
        this.Market = market;
        this.scrip = scrip;
        this.setTitle();
        String Sector = "";
        String tempSymbol = scrip.trim().split("\\-", -1)[0];
        if (scrip.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(tempSymbol)) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                CandleChart.this.getData();
            }
        }).start();
        if (UtilTC.getScripSector(tempSymbol).length() > 0) {
            Sector = UtilTC.getScripSector(tempSymbol) + " Sector";
        }
    }

    private void UpdateGraph() {
        this.addLoader();
        this.parseData(this.lastData);
    }

    private void getData() {
        try {
            String result;
            String call = AppConfig.GraphURL + "?action=Market&identifier=PriceVolume&market=" + this.Market + "&symbol=" + this.scrip;
            URL url = new URL(call);
            URLConnection con = url.openConnection();
            con.setDoOutput(true);
            con.setDoInput(true);
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((result = in.readLine()) != null) {
                sb.append(result);
            }
            in.close();
            this.lastData = result = sb.toString();
            if (this.lastData.trim().length() > 0) {
                this.parseData(result);
            } else {
                this.setEmpty();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void parseData(String mydata) {
        try {
            Calendar calendar = Calendar.getInstance();
            ArrayList<Double> lasttradeprice = new ArrayList<Double>();
            ArrayList<ArrayList<Double>> allarray = new ArrayList<ArrayList<Double>>();
            this.Tseries = new TimeSeries((Comparable)((Object)"series 1"));
            this.date.clear();
            this.Open.clear();
            this.High.clear();
            this.Low.clear();
            this.Close.clear();
            this.volume.clear();
            mydata = mydata.trim();
            if (mydata.substring(mydata.length() - 1).contains("|")) {
                mydata = mydata.substring(0, mydata.length() - 2);
            }
            String[] Tick = mydata.split("\\|", -1);
            Date limit = new Date();
            Date initial = new Date();
            for (int i = 0; i < Tick.length; ++i) {
                if (Tick[i].length() <= 0) continue;
                String[] stringArray = Tick[i].split("\\;", -1);
                try {
                    Millisecond rt;
                    Date dt2;
                    Date dat = this.sdf.parse(stringArray[0]);
                    Calendar cal = Calendar.getInstance();
                    Calendar cal2 = Calendar.getInstance();
                    cal.setTime(dat);
                    cal.set(1, cal2.get(1));
                    cal.set(2, cal2.get(2));
                    cal.set(5, cal2.get(5));
                    initial = dt2 = new Date(cal.getTimeInMillis());
                    double d1 = Double.parseDouble(stringArray[1]);
                    int d2 = Integer.parseInt(stringArray[2]);
                    if (i == 0) {
                        calendar.setTime(dt2);
                        calendar.add(12, this.timetick);
                        limit = calendar.getTime();
                        this.date.add(calendar.getTime());
                        this.volume.add(Double.valueOf(d2));
                        rt = new Millisecond(calendar.getTime());
                        this.Tseries.addOrUpdate((RegularTimePeriod)rt, (double)d2);
                    }
                    if (initial.before(limit)) {
                        lasttradeprice.add(d1);
                    } else {
                        calendar.add(12, this.timetick);
                        limit = calendar.getTime();
                        allarray.add(lasttradeprice);
                        lasttradeprice = new ArrayList();
                        lasttradeprice.add(d1);
                        this.volume.add(Double.valueOf(d2));
                        this.date.add(calendar.getTime());
                        rt = new Millisecond(calendar.getTime());
                        this.Tseries.addOrUpdate((RegularTimePeriod)rt, (double)d2);
                    }
                    if (i != Tick.length - 1) continue;
                    lasttradeprice.add(d1);
                    allarray.add(lasttradeprice);
                    continue;
                }
                catch (Exception eparse) {
                    eparse.printStackTrace();
                }
            }
            for (ArrayList arrayList : allarray) {
                if (arrayList.size() <= 0) continue;
                ArrayList Slice = new ArrayList();
                Slice.clear();
                Slice = arrayList;
                this.Open.add((Double)arrayList.get(0));
                this.Close.add((Double)arrayList.get(arrayList.size() - 1));
                this.High.add((Double)Collections.max(Slice));
                this.Low.add((Double)Collections.min(Slice));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.displayGraph();
    }

    public OHLCDataset createDataset() {
        int j;
        double[] high1 = new double[this.High.size()];
        Date[] mydates = new Date[this.date.size()];
        double[] low1 = new double[this.Low.size()];
        double[] open1 = new double[this.Open.size()];
        double[] close1 = new double[this.Close.size()];
        double[] volume1 = new double[this.volume.size()];
        for (j = 0; j < this.High.size(); ++j) {
            high1[j] = this.High.get(j);
            low1[j] = this.Low.get(j);
            open1[j] = this.Open.get(j);
            close1[j] = this.Close.get(j);
            volume1[j] = this.volume.get(j);
        }
        for (j = 0; j < this.date.size(); ++j) {
            mydates[j] = this.date.get(j);
        }
        this.ohlcDataSet = new DefaultHighLowDataset((Comparable)((Object)""), mydates, high1, low1, open1, close1, volume1);
        return this.ohlcDataSet;
    }

    IntervalXYDataset getVolumeDataset(final OHLCDataset priceDataset, final long barWidthInMilliseconds) {
        return new AbstractIntervalXYDataset(){

            public int getSeriesCount() {
                return priceDataset.getSeriesCount();
            }

            public Comparable getSeriesKey(int series) {
                return priceDataset.getSeriesKey(series) + "-Volume";
            }

            public int getItemCount(int series) {
                return priceDataset.getItemCount(series);
            }

            public Number getX(int series, int item) {
                return priceDataset.getX(series, item);
            }

            public Number getY(int series, int item) {
                return priceDataset.getVolume(series, item);
            }

            public Number getStartX(int series, int item) {
                return priceDataset.getX(series, item).doubleValue() - (double)(barWidthInMilliseconds / 2L);
            }

            public Number getEndX(int series, int item) {
                return priceDataset.getX(series, item).doubleValue() + (double)(barWidthInMilliseconds / 2L);
            }

            public Number getStartY(int series, int item) {
                return new Double(0.0);
            }

            public Number getEndY(int series, int item) {
                return priceDataset.getVolume(series, item);
            }
        };
    }

    private JPanel createGraphPanel() {
        this.jFreeChart = this.createChart(this.createDataset());
        this.jFreeChart.setBackgroundPaint((Paint)new Color(0, 0, 0, 0));
        this.chartPanel = new ChartPanel(this.jFreeChart);
        this.chartPanel.setBackground(Color.BLACK);
        this.chartPanel.setFocusable(true);
        this.chartPanel.setRangeZoomable(false);
        this.chartPanel.addChartMouseListener((ChartMouseListener)this);
        InfoBoxCrosshairOverlay infoBoxCrosshairOverlay = new InfoBoxCrosshairOverlay();
        this.infoCrosshair = new InfoBoxCrosshair(0.0, 0.0);
        this.infoCrosshair.setPaint((Paint)this.LtrdPriceColor);
        this.infoCrosshair.showInfoBox(true);
        this.infoCrosshair.setWaterMark(this.Market + "-" + this.scrip);
        this.infoCrosshair.setLabelVisible(true);
        this.infoCrosshair.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        this.infoCrosshair.setLabelBackgroundPaint((Paint)new Color(255, 255, 0, 100));
        this.infoCrosshair.setParams(this.param);
        infoBoxCrosshairOverlay.addInfoCrosshair((Crosshair)this.infoCrosshair);
        this.chartPanel.addOverlay((Overlay)infoBoxCrosshairOverlay);
        return this.chartPanel;
    }

    public void showInFrmae() {
        this.frame = new JFrame();
        this.frame.setIconImage(AppConfig.houseIcon);
        this.frame.setMinimumSize(new Dimension(770, 500));
        this.frame.setDefaultCloseOperation(2);
        this.window.remove(this);
        this.frame.add(this);
        this.frame.setLocation(this.window.getLocation());
        this.frame.setSize(this.window.getSize());
        this.frame.validate();
        this.window.setVisible(false);
        this.window.validate();
        this.window.dispose();
        this.window = null;
        this.setTitle();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.frame.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.frame.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CandleChart.this.initClose();
                CandleChart.this.frame.dispose();
                TradeCast.getInstance().GetTopWindow();
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                if (CandleChart.this.frame != null) {
                    CandleChart.this.initClose();
                    TradeCast.getInstance().GetTopWindow();
                }
                if (CandleChart.this.frame != null) {
                    TradeCast.getInstance().SaveSizeAndLocation(FormName.CandlestickChart, CandleChart.this.frame.getSize(), CandleChart.this.frame.getLocation());
                }
            }
        });
        TradeCast.getInstance().CandleGraphWindowHolder.put(this.num, this);
        this.frame.setVisible(true);
    }

    private void initClose() {
        TradeCast.getInstance().CandleGraphWindowHolder.remove(this.num);
        TradeCast.getInstance().dynamicViews.remove(this.key);
        this.refreshThread.isRun = false;
    }

    public JDialog showInJDialog() {
        this.window = new JDialog(TradeCast.getInstance().frame);
        this.window.setMinimumSize(new Dimension(770, 500));
        this.window.setDefaultCloseOperation(2);
        if (this.frame != null) {
            this.window.setLocation(this.frame.getLocation());
            this.window.setSize(this.frame.getSize());
            this.frame.remove(this);
            this.frame.validate();
            this.frame.dispose();
            this.frame = null;
        }
        this.setTitle();
        this.window.add(this);
        this.window.validate();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.window.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.window.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CandleChart.this.initClose();
                CandleChart.this.window.dispose();
                TradeCast.getInstance().GetTopWindow();
            }
        });
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                if (CandleChart.this.window != null) {
                    CandleChart.this.initClose();
                    TradeCast.getInstance().GetTopWindow();
                }
                if (CandleChart.this.window != null) {
                    TradeCast.getInstance().SaveSizeAndLocation(FormName.CandlestickChart, CandleChart.this.window.getSize(), CandleChart.this.window.getLocation());
                }
            }
        });
        TradeCast.getInstance().CandleGraphWindowHolder.put(this.num, this);
        this.window.setVisible(true);
        return this.window;
    }

    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        if (this.window != null) {
            this.window.dispose();
        }
    }

    private void initComponents() {
        this.ComponentPanel = new JPanel();
        this.cbMarkets = new JComboBox();
        this.cbScrip = new JComboBox();
        this.cbTime = new JComboBox();
        this.lblSymbolName = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.lblScripGraph = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.lblHistoricalCandleChart = new JLabel();
        this.btnDock = new JButton();
        this.jSeparator4 = new JSeparator();
        this.jSeparator5 = new JSeparator();
        this.lblIndexGraph = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.CandlePanel = new JPanel();
        this.cbMarkets.setEditable(true);
        this.cbMarkets.setModel(new DefaultComboBoxModel<String>(new String[]{"REG", "FUT", "ODL"}));
        this.cbMarkets.setPreferredSize(new Dimension(50, 20));
        this.cbMarkets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CandleChart.this.cbMarketsActionPerformed(evt);
            }
        });
        this.cbScrip.setEditable(true);
        this.cbScrip.setModel(new DefaultComboBoxModel<String>(new String[]{"PPL", "PPLP", ""}));
        this.cbScrip.setPreferredSize(new Dimension(80, 20));
        this.cbScrip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CandleChart.this.cbScripActionPerformed(evt);
            }
        });
        this.cbTime.setModel(new DefaultComboBoxModel<String>(new String[]{"5 Minutes", "10 Minutes", "20 Minutes", "30 Minutes", "60 Minutes"}));
        this.cbTime.setPreferredSize(new Dimension(54, 20));
        this.cbTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CandleChart.this.cbTimeActionPerformed(evt);
            }
        });
        this.lblSymbolName.setText(" ");
        this.lblSymbolName.setPreferredSize(new Dimension(30, 14));
        this.jSeparator1.setOrientation(1);
        this.lblScripGraph.setFont(new Font("Tahoma", 1, 11));
        this.lblScripGraph.setIcon(new ImageIcon(this.getClass().getResource("/Images/scripgraph.png")));
        this.lblScripGraph.setText("Scrip Graph");
        this.lblScripGraph.setMaximumSize(new Dimension(90, 16));
        this.lblScripGraph.setMinimumSize(new Dimension(90, 16));
        this.lblScripGraph.setPreferredSize(new Dimension(90, 16));
        this.lblScripGraph.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CandleChart.this.lblScripGraphMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CandleChart.this.lblScripGraphMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CandleChart.this.lblScripGraphMousePressed(evt);
            }
        });
        this.jSeparator2.setOrientation(1);
        this.lblHistoricalCandleChart.setFont(new Font("Tahoma", 1, 11));
        this.lblHistoricalCandleChart.setIcon(new ImageIcon(this.getClass().getResource("/Images/HistoricalData.png")));
        this.lblHistoricalCandleChart.setText("Historical Candlestick Graph");
        this.lblHistoricalCandleChart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CandleChart.this.lblHistoricalCandleChartMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CandleChart.this.lblHistoricalCandleChartMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CandleChart.this.lblHistoricalCandleChartMousePressed(evt);
            }
        });
        this.btnDock.setIcon(new ImageIcon(this.getClass().getResource("/Images/Detach.png")));
        this.btnDock.setToolTipText("Attach / Detach");
        this.btnDock.setOpaque(false);
        this.btnDock.setPreferredSize(new Dimension(16, 16));
        this.btnDock.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CandleChart.this.btnDockMouseClicked(evt);
            }
        });
        this.jSeparator4.setOrientation(1);
        this.jSeparator5.setOrientation(1);
        this.lblIndexGraph.setFont(new Font("Tahoma", 1, 11));
        this.lblIndexGraph.setIcon(new ImageIcon(this.getClass().getResource("/Images/indexgraph.png")));
        this.lblIndexGraph.setText("Index Graph");
        this.lblIndexGraph.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CandleChart.this.lblIndexGraphMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CandleChart.this.lblIndexGraphMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CandleChart.this.lblIndexGraphMousePressed(evt);
            }
        });
        GroupLayout ComponentPanelLayout = new GroupLayout(this.ComponentPanel);
        this.ComponentPanel.setLayout(ComponentPanelLayout);
        ComponentPanelLayout.setHorizontalGroup(ComponentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ComponentPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.cbMarkets, -2, -1, -2).addGap(5, 5, 5).addComponent(this.cbScrip, -2, -1, -2).addGap(5, 5, 5).addComponent(this.cbTime, -2, 80, -2).addGap(5, 5, 5).addComponent(this.jSeparator1, -2, 3, -2).addGap(7, 7, 7).addComponent(this.lblSymbolName, -1, 50, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.btnDock, -2, -1, -2).addGap(9, 9, 9).addComponent(this.jSeparator4, -2, 3, -2).addGap(2, 2, 2).addComponent(this.lblHistoricalCandleChart, -2, 190, -2).addGap(5, 5, 5).addComponent(this.jSeparator2, -2, 3, -2).addGap(7, 7, 7).addComponent(this.lblScripGraph, -2, -1, -2).addGap(10, 10, 10).addComponent(this.jSeparator5, -2, 3, -2).addGap(7, 7, 7).addComponent(this.lblIndexGraph, -2, 95, -2)));
        ComponentPanelLayout.setVerticalGroup(ComponentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ComponentPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.cbMarkets, -2, -1, -2)).addGroup(ComponentPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.cbScrip, -2, -1, -2)).addGroup(ComponentPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.cbTime, -2, -1, -2)).addGroup(ComponentPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jSeparator1, -2, 20, -2)).addComponent(this.lblSymbolName, -2, 30, -2).addGroup(ComponentPanelLayout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.btnDock, -2, -1, -2)).addGroup(ComponentPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jSeparator4, -2, 20, -2)).addGroup(ComponentPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.lblHistoricalCandleChart, -2, 20, -2)).addGroup(ComponentPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jSeparator2, -2, 20, -2)).addGroup(ComponentPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.lblScripGraph, -2, 20, -2)).addGroup(ComponentPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jSeparator5, -2, 20, -2)).addGroup(ComponentPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.lblIndexGraph, -2, 20, -2)));
        this.CandlePanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ComponentPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator3).addComponent(this.CandlePanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.ComponentPanel, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jSeparator3, -2, 3, -2).addGap(0, 0, 0).addComponent(this.CandlePanel, -1, 320, Short.MAX_VALUE).addGap(0, 0, 0)));
    }

    private void cbScripActionPerformed(ActionEvent evt) {
        if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
            this.addLoader();
            if (this.refreshThread != null) {
                this.refreshThread.isRun = false;
            }
            this.scrip = this.getScrip();
            this.Market = UtilKSE.GetMarketFromsymbol((String)this.scrip);
            this.cbMarkets.setSelectedItem(this.Market);
            this.init(this.Market, this.scrip);
        }
    }

    private void cbMarketsActionPerformed(ActionEvent evt) {
        if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
            this.addLoader();
            if (this.refreshThread != null) {
                this.refreshThread.isRun = false;
            }
            this.Market = this.getMarket();
            this.init(this.Market, this.scrip);
        }
    }

    private void cbTimeActionPerformed(ActionEvent evt) {
        if (this.cbTime.getSelectedItem() == "5 Minutes") {
            this.timetick = 5;
        } else if (this.cbTime.getSelectedItem() == "10 Minutes") {
            this.timetick = 10;
        } else if (this.cbTime.getSelectedItem() == "20 Minutes") {
            this.timetick = 20;
        } else if (this.cbTime.getSelectedItem() == "30 Minutes") {
            this.timetick = 30;
        } else if (this.cbTime.getSelectedItem() == "60 Minutes") {
            this.timetick = 60;
        }
        this.UpdateGraph();
    }

    private void lblHistoricalCandleChartMouseEntered(MouseEvent evt) {
    }

    private void lblHistoricalCandleChartMouseExited(MouseEvent evt) {
    }

    private void lblHistoricalCandleChartMousePressed(MouseEvent evt) {
    }

    private void lblScripGraphMouseEntered(MouseEvent evt) {
        this.lblScripGraph.setCursor(Cursor.getPredefinedCursor(12));
        this.lblScripGraph.setText("<html><U>" + LanguageConstant.ScripGraph + "</U></html>");
    }

    private void lblScripGraphMouseExited(MouseEvent evt) {
        this.lblScripGraph.setCursor(Cursor.getPredefinedCursor(0));
        this.lblScripGraph.setText("<html>" + LanguageConstant.ScripGraph + "</html>");
    }

    private void lblScripGraphMousePressed(MouseEvent evt) {
        TradeCast.getInstance().ShowGraphWindow(FormName.GraphsAndCharts, LanguageConstant.GraphsAndCharts, this.Market, this.scrip);
    }

    private void btnDockMouseClicked(MouseEvent evt) {
        if (this.Attach) {
            this.Attach = false;
            this.btnDock.setIcon(new ImageIcon(this.getClass().getResource("/images/Attach.png")));
        } else {
            this.Attach = true;
            this.btnDock.setIcon(new ImageIcon(this.getClass().getResource("/images/Detach.png")));
        }
        this.Detach();
    }

    private void lblIndexGraphMouseEntered(MouseEvent evt) {
        this.lblIndexGraph.setCursor(Cursor.getPredefinedCursor(12));
        this.lblIndexGraph.setText("<html><U>" + this.languageCentre.getValue(LanguageConstant.IndexGraph) + "</U></html>");
    }

    private void lblIndexGraphMouseExited(MouseEvent evt) {
        this.lblIndexGraph.setCursor(Cursor.getPredefinedCursor(0));
        this.lblIndexGraph.setText("<html>" + this.languageCentre.getValue(LanguageConstant.IndexGraph) + "</html>");
    }

    private void lblIndexGraphMousePressed(MouseEvent evt) {
        TradeCast.getInstance().ShowGraphWindow(FormName.IndexGraph, LanguageConstant.IndexGraph, "", "");
    }

    private void setTitle() {
        String Sector = "";
        String title = "";
        if (UtilTC.getScripSector(this.scrip).length() > 0) {
            Sector = UtilTC.getScripSector(this.scrip) + " Sector";
        }
        if (this.frame != null) {
            this.frame.setTitle(title);
        } else if (this.window != null) {
            this.window.setTitle(title);
        }
    }

    public void setAllScrip() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
                    Collections.sort(allScrip);
                    CandleChart.this.cbScrip.setModel(new DefaultComboBoxModel(allScrip));
                    AutoCompleteSupport.install((JComboBox)CandleChart.this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])allScrip.toArray()));
                    CandleChart.this.cbScrip.setSelectedItem(LogsKSE.SelectedSymbol);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void setMarkets() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Vector<String> allMarket = new Vector<String>();
                for (int i = 0; i < LogCommon.markets.length; ++i) {
                    allMarket.addElement(LogCommon.markets[i]);
                }
                Collections.sort(allMarket);
                CandleChart.this.cbMarkets.setModel(new DefaultComboBoxModel(allMarket));
                AutoCompleteSupport.install((JComboBox)CandleChart.this.cbMarkets, (EventList)GlazedLists.eventListOf((Object[])allMarket.toArray()));
                CandleChart.this.cbMarkets.setSelectedItem(LogsKSE.SelectedMarket);
            }
        });
    }

    private String getMarket() {
        if (this.cbMarkets.getSelectedItem() != null) {
            return this.cbMarkets.getSelectedItem().toString();
        }
        return "";
    }

    public String getScrip() {
        if (this.cbScrip.getSelectedItem() != null) {
            return this.cbScrip.getSelectedItem().toString();
        }
        return "";
    }

    private void setEmpty() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.CandlePanel.removeAll();
            this.CandlePanel.add((Component)new JPanel(), "Center");
            this.CandlePanel.validate();
            JOptionPane.showMessageDialog(null, "No data found", "Information", 1);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CandleChart.this.CandlePanel.removeAll();
                    CandleChart.this.CandlePanel.add((Component)new JPanel(), "Center");
                    CandleChart.this.CandlePanel.validate();
                    JOptionPane.showMessageDialog(null, "No data found", "Information", 1);
                }
            });
        }
    }

    private void addLoader() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.CandlePanel.removeAll();
            this.CandlePanel.add((Component)new Loader(), "Center");
            this.CandlePanel.validate();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CandleChart.this.CandlePanel.removeAll();
                    CandleChart.this.CandlePanel.add((Component)new Loader(), "Center");
                    CandleChart.this.CandlePanel.validate();
                }
            });
        }
    }

    private void displayGraph() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showGraph();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CandleChart.this.showGraph();
                }
            });
        }
    }

    private void showGraph() {
        this.CandlePanel.removeAll();
        this.CandlePanel.add((Component)this.createGraphPanel(), "Center");
        this.CandlePanel.validate();
        this.refreshThread = new RefreshCandle();
        new Thread(this.refreshThread).start();
    }

    public void Detach() {
        if (this.frame == null) {
            this.showInFrmae();
        } else {
            this.showInJDialog();
        }
    }

    public void chartMouseClicked(ChartMouseEvent cme) {
    }

    public void chartMouseMoved(ChartMouseEvent arg0) {
        try {
            double X = arg0.getTrigger().getX();
            double Y = arg0.getTrigger().getY();
            Point2D VolPoint = this.getDotDatavalue(new Point2D.Double(X, Y), this.Tseries);
            Date date = null;
            date = new Date((long)VolPoint.getX());
            this.infoCrosshair.setTime(date);
            this.values = new ArrayList<String>();
            this.values.add(this.localNumberFormat.format(VolPoint.getY()));
            this.param = new ArrayList<String>();
            this.param.add("LTrd Volume");
            this.infoCrosshair.setValues(this.values);
            this.infoCrosshair.setParams(this.param);
            this.chartPanel.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Point2D getDotDatavalue(Point2D point, TimeSeries timeSeries) {
        Rectangle2D _plotArea = this.chartPanel.getScreenDataArea();
        XYPlot plot = this.pricePlot;
        if (this.jFreeChart.getPlot() instanceof CombinedDomainXYPlot) {
            CombinedDomainXYPlot cplot = (CombinedDomainXYPlot)this.jFreeChart.getPlot();
            List list = cplot.getSubplots();
            plot = (XYPlot)list.get(0);
            _plotArea = this.chartPanel.getChartRenderingInfo().getPlotInfo().getSubplotInfo(0).getDataArea();
        }
        ValueAxis domainAxis = plot.getDomainAxis();
        RectangleEdge domainAxisEdge = plot.getDomainAxisEdge();
        ValueAxis rangeAxis = plot.getRangeAxis();
        RectangleEdge rangeAxisEdge = plot.getRangeAxisEdge();
        double coordinateX = domainAxis.java2DToValue(point.getX(), _plotArea, domainAxisEdge);
        int low = 0;
        int high = timeSeries.getItemCount() - 1;
        Date date = new Date((long)coordinateX);
        long time = date.getTime();
        long bestDistance = Long.MAX_VALUE;
        int bestMid = 0;
        while (low <= high) {
            long abs_cmp;
            int mid = low + high >>> 1;
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(mid);
            RegularTimePeriod day = timeSeriesDataItem.getPeriod();
            long search = day.getFirstMillisecond();
            long cmp = search - time;
            if (cmp < 0L) {
                low = mid + 1;
            } else if (cmp > 0L) {
                high = mid - 1;
            } else {
                bestDistance = 0L;
                bestMid = mid;
                break;
            }
            if ((abs_cmp = Math.abs(cmp)) >= bestDistance) continue;
            bestDistance = abs_cmp;
            bestMid = mid;
        }
        TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataItem(bestMid);
        double xValue = timeSeriesDataItem.getPeriod().getFirstMillisecond();
        double yValue = timeSeriesDataItem.getValue().doubleValue();
        return new Point2D.Double(xValue, yValue);
    }

    private JFreeChart createChart(OHLCDataset ohlcDataset) {
        DateAxis domainAxis = new DateAxis();
        domainAxis.setTickLabelPaint((Paint)Color.gray);
        OHLCDataset priceDataset = ohlcDataset;
        NumberAxis priceAxis = new NumberAxis();
        priceAxis.setTickLabelPaint((Paint)Color.CYAN);
        priceAxis.setAutoRangeIncludesZero(false);
        priceAxis.setNumberFormatOverride((NumberFormat)new DecimalFormat("####.##"));
        CandlestickRenderer priceRenderer = new CandlestickRenderer(5.0, false, (XYToolTipGenerator)new HighLowItemLabelGenerator((DateFormat)new SimpleDateFormat("HH:mm:ss"), (NumberFormat)new DecimalFormat("0.00")));
        this.pricePlot = new XYPlot((XYDataset)priceDataset, (ValueAxis)domainAxis, (ValueAxis)priceAxis, (XYItemRenderer)priceRenderer);
        priceRenderer.setSeriesPaint(0, (Paint)this.BarCOLOR);
        priceRenderer.setDrawVolume(false);
        priceAxis.setAutoRangeIncludesZero(false);
        this.volumeDataset = this.getVolumeDataset(priceDataset, 10000L);
        NumberAxis volumeAxis = new NumberAxis();
        volumeAxis.setAutoRangeIncludesZero(false);
        volumeAxis.setTickLabelPaint((Paint)this.VolumeColor);
        XYBarRenderer volumeRenderer = new XYBarRenderer();
        this.pricePlot.setDataset(1, (XYDataset)this.volumeDataset);
        this.pricePlot.setDomainAxis((ValueAxis)domainAxis);
        this.pricePlot.setRenderer(1, (XYItemRenderer)volumeRenderer);
        volumeRenderer.setShadowVisible(false);
        volumeRenderer.setSeriesPaint(0, (Paint)this.VolumeColor);
        volumeRenderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        this.pricePlot.setBackgroundPaint((Paint)this.PLOTBGCOLOR);
        this.pricePlot.setRangeAxis(1, (ValueAxis)volumeAxis);
        this.pricePlot.setRangeAxis(0, (ValueAxis)priceAxis);
        this.pricePlot.setRangeAxisLocation(0, AxisLocation.TOP_OR_RIGHT);
        this.pricePlot.setRangeAxisLocation(1, AxisLocation.TOP_OR_LEFT);
        this.pricePlot.mapDatasetToRangeAxis(1, 1);
        CombinedDomainXYPlot mainPlot = new CombinedDomainXYPlot((ValueAxis)domainAxis);
        mainPlot.add(this.pricePlot);
        return new JFreeChart("", null, (Plot)mainPlot, false);
    }

    private class RefreshCandle
    implements Runnable {
        public boolean isRun = true;

        private RefreshCandle() {
        }

        @Override
        public void run() {
            while (this.isRun) {
                try {
                    if (CandleChart.this.cbTime.getSelectedItem() == "5 Minutes") {
                        Thread.sleep(300000L);
                        CandleChart.this.getData();
                        continue;
                    }
                    if (CandleChart.this.cbTime.getSelectedItem() == "10 Minutes") {
                        Thread.sleep(600000L);
                        CandleChart.this.getData();
                        continue;
                    }
                    if (CandleChart.this.cbTime.getSelectedItem() == "20 Minutes") {
                        Thread.sleep(1200000L);
                        CandleChart.this.getData();
                        continue;
                    }
                    if (CandleChart.this.cbTime.getSelectedItem() == "30 Minutes") {
                        Thread.sleep(1800000L);
                        CandleChart.this.getData();
                        continue;
                    }
                    if (CandleChart.this.cbTime.getSelectedItem() != "60 Minutes") continue;
                    Thread.sleep(3600000L);
                    CandleChart.this.getData();
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                }
            }
        }
    }
}

