/*
 * Decompiled with CFR 0.152.
 */
package Chart;

import Beans.OHLCBean;
import BeansContainer.OHLCContainer;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Screener.Loader;
import Utilities.UtilTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import catalystchart.ChartScrollBar;
import com.google.gson.Gson;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYPointerAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.HighLowItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.TextAnchor;

public class CandleHistoricalChart
extends JPanel {
    Color bearishstart = new Color(255, 136, 136);
    Color bearishend = new Color(255, 221, 221);
    Color bullishstart = new Color(141, 221, 123).darker();
    Color bullishend = new Color(196, 250, 180);
    private ArrayList<Double> Open = new ArrayList();
    private ArrayList<Double> High = new ArrayList();
    private ArrayList<Double> Low = new ArrayList();
    private ArrayList<Double> Close = new ArrayList();
    private ArrayList<Date> date = new ArrayList();
    private ArrayList<Long> volume = new ArrayList();
    private ArrayList<Date> boardmeetingDate = new ArrayList();
    private ArrayList<Date> announcdate = new ArrayList();
    private ArrayList<Boolean> isboardmeeting = new ArrayList();
    private ArrayList<Boolean> isannouncement = new ArrayList();
    private ArrayList<ArrayList<OHLCBean>> allSummrizedData = new ArrayList();
    JDialog window = null;
    JFrame frame = null;
    ChartPanel localChartPanel;
    JFreeChart localJFreeChart;
    JFreeChart averagejfreechart;
    XYPlot averagexyplot;
    XYPlot localXYPlot;
    final Color BarCOLOR = new Color(0, 190, 190);
    final Color VolColor = new Color(141, 136, 41);
    private String scrip = "";
    private String Market = "";
    int Days = -1;
    int num = 0;
    public ChartScrollBar scrollbarhorizontal;
    public ChartScrollBar scrollbarvertical = null;
    private List<String> values = new ArrayList<String>();
    private List<String> param = new ArrayList<String>();
    OHLCDataset ohlcDataSet = null;
    private boolean isCheck = true;
    private String lastData = "";
    boolean Attach = true;
    final Color VolumeColor = new Color(141, 136, 41);
    final Color PLOTBGCOLOR = Color.BLACK;
    Color bgColor = UIManager.getColor("Panel.Background");
    DecimalFormat localDecimalFormat = new DecimalFormat("###,###.##");
    NumberFormat localNumberFormat = new DecimalFormat("###,###");
    private int key = 0;
    double[] avghigh = new double[1];
    double[] avglow = new double[1];
    double[] avgopen = new double[1];
    double[] avgclose = new double[1];
    Date[] datetime = new Date[1];
    double[] avgaverage = new double[1];
    XYPlot pricePlot;
    double[] avgvol = new double[1];
    private LanguageCentre languageCentre = new LanguageCentre();
    private JPanel CandlePanel;
    private JPanel ComponentPanel;
    private JButton btnDock;
    private JComboBox cbDays;
    private JComboBox cbMarkets;
    private JComboBox cbScrip;
    private JPanel hScrollpnl;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JLabel lblCandleStick;
    private JLabel lblIndexGraph;
    private JLabel lblRange;
    private JLabel lblScripGraph;
    private JLabel lblSymbolName;
    private JLabel lblVol;
    private JPanel pnlCandle;
    private JPanel pnlhistoricalCandle;
    private JPanel vScrollpnl;

    public CandleHistoricalChart(int num, int key) {
        this.initComponents();
        this.num = num;
        this.key = key;
        this.lblCandleStick.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/CandleStickChart.png")));
        this.setAllScrip();
        this.setMarkets();
        this.pnlhistoricalCandle.setLayout(new BorderLayout());
    }

    public void init(String market, String scrip) {
        this.Market = market;
        this.scrip = scrip;
        this.setTitle();
        new Thread(new Runnable(){

            @Override
            public void run() {
                CandleHistoricalChart.this.addLoader();
                CandleHistoricalChart.this.getHistoricalData();
            }
        }, "CandleHistoricalChar : init").start();
    }

    private void getHistoricalData() {
        try {
            String result;
            String call = AppConfig.JCR_VIS_Data_URL.replaceFirst("TCFeedFetcher", "") + "/OHLC?scrip=" + this.scrip + "&market=" + this.Market + "&day=-1";
            URL url = new URL(call);
            URLConnection con = url.openConnection();
            con.setDoOutput(true);
            con.setDoInput(true);
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((result = in.readLine()) != null) {
                sb.append(result);
            }
            in.close();
            this.lastData = result = sb.toString();
            this.parseData(result);
        }
        catch (Exception ex) {
            this.setEmpty();
            ex.printStackTrace();
            Mediator.getInstance().PrintLog(ex, "getHistoricalData in Historical Candle Chart");
        }
    }

    private void parseData(String hdata) {
        OHLCDataset avgdataset;
        this.date.clear();
        this.Open.clear();
        this.High.clear();
        this.Low.clear();
        this.Close.clear();
        this.volume.clear();
        this.allSummrizedData.clear();
        this.boardmeetingDate.clear();
        this.announcdate.clear();
        this.isboardmeeting.clear();
        this.isannouncement.clear();
        this.isCheck = true;
        Gson s = new Gson();
        Date init = null;
        Date limit = null;
        if (hdata != null) {
            int i;
            OHLCContainer container = (OHLCContainer)s.fromJson(hdata, OHLCContainer.class);
            ArrayList<OHLCBean> lis = new ArrayList<OHLCBean>();
            for (i = 0; i < container.list.size(); ++i) {
                OHLCBean oHLCBean = (OHLCBean)container.list.get(i);
                if (this.cbDays.getSelectedItem().toString().equalsIgnoreCase("Daily")) {
                    this.date.add(oHLCBean.date);
                    this.Open.add(oHLCBean.open);
                    this.High.add(oHLCBean.high);
                    this.Low.add(oHLCBean.low);
                    this.Close.add(oHLCBean.close);
                    this.volume.add(oHLCBean.volume);
                    if (oHLCBean.isBoardingMeeting) {
                        this.boardmeetingDate.add(oHLCBean.date);
                    }
                    if (!oHLCBean.isAnnouncement) continue;
                    this.announcdate.add(oHLCBean.date);
                    continue;
                }
                if (this.cbDays.getSelectedItem().toString().equalsIgnoreCase("Weekly")) {
                    init = Util.getFirstDayOfWeek((Date)oHLCBean.date);
                    if (this.isCheck) {
                        limit = Util.addSubtractDaysFormDate((Date)init, (int)7);
                        this.isCheck = false;
                    }
                    if (oHLCBean.date.compareTo(init) >= 0 && oHLCBean.date.compareTo(limit) <= 0) {
                        lis.add(oHLCBean);
                        if (oHLCBean.isBoardingMeeting) {
                            this.boardmeetingDate.add(oHLCBean.date);
                        }
                        if (!oHLCBean.isAnnouncement) continue;
                        this.announcdate.add(oHLCBean.date);
                        continue;
                    }
                    this.allSummrizedData.add(lis);
                    this.isCheck = true;
                    lis = new ArrayList();
                    lis.add(oHLCBean);
                    continue;
                }
                if (!this.cbDays.getSelectedItem().toString().equalsIgnoreCase("Monthly")) continue;
                init = Util.getFirstDayOfMonth((Date)oHLCBean.date);
                if (this.isCheck) {
                    limit = Util.addSubtractMonthFormDate((Date)init, (int)1);
                    limit = Util.addSubtractDaysFormDate((Date)limit, (int)-1);
                    this.isCheck = false;
                }
                if (oHLCBean.date.compareTo(init) >= 0 && oHLCBean.date.compareTo(limit) <= 0) {
                    lis.add(oHLCBean);
                    if (oHLCBean.isBoardingMeeting) {
                        this.boardmeetingDate.add(oHLCBean.date);
                    }
                    if (!oHLCBean.isAnnouncement) continue;
                    this.announcdate.add(oHLCBean.date);
                    continue;
                }
                this.allSummrizedData.add(lis);
                this.isCheck = true;
                lis = new ArrayList();
                lis.add(oHLCBean);
            }
            for (i = 0; i < this.allSummrizedData.size(); ++i) {
                ArrayList<Double> tempHigh = new ArrayList<Double>();
                ArrayList<Double> tempLow = new ArrayList<Double>();
                ArrayList<Date> tempdate = new ArrayList<Date>();
                ArrayList<Long> tempvolume = new ArrayList<Long>();
                ArrayList<OHLCBean> arrayList = this.allSummrizedData.get(i);
                for (int j = 0; j < arrayList.size(); ++j) {
                    OHLCBean oHLCBean = arrayList.get(j);
                    tempdate.add(oHLCBean.date);
                    tempHigh.add(oHLCBean.high);
                    tempLow.add(oHLCBean.low);
                    tempvolume.add(oHLCBean.volume);
                }
                this.date.add((Date)Collections.max(tempdate));
                this.Open.add(arrayList.get((int)0).open);
                this.High.add((Double)Collections.max(tempHigh));
                this.Low.add((Double)Collections.min(tempLow));
                this.Close.add(arrayList.get((int)(arrayList.size() - 1)).close);
                this.volume.add((Long)Collections.max(tempvolume));
            }
        }
        if ((avgdataset = this.create52weekdataset(hdata)) != null) {
            this.displayGraph(avgdataset);
        } else {
            this.setEmpty();
        }
    }

    private JFreeChart createChart(OHLCDataset paramOHLCDataset) {
        double millis;
        Minute m;
        int i;
        DateAxis domainAxis = new DateAxis();
        domainAxis.setTickLabelPaint((Paint)Color.gray);
        OHLCDataset ohlc = paramOHLCDataset;
        NumberAxis priceAxis = new NumberAxis();
        priceAxis.setNumberFormatOverride((NumberFormat)this.localDecimalFormat);
        priceAxis.setTickLabelPaint((Paint)Color.CYAN);
        priceAxis.setAutoRangeIncludesZero(false);
        CandlestickRenderer priceRenderer = new CandlestickRenderer(5.0, false, (XYToolTipGenerator)new HighLowItemLabelGenerator((DateFormat)new SimpleDateFormat("EEEE, MMM dd, yyyy"), (NumberFormat)new DecimalFormat("0.00")));
        this.pricePlot = new XYPlot((XYDataset)ohlc, (ValueAxis)domainAxis, (ValueAxis)priceAxis, (XYItemRenderer)priceRenderer);
        priceRenderer.setSeriesPaint(0, (Paint)this.BarCOLOR);
        priceRenderer.setDrawVolume(false);
        priceAxis.setAutoRangeIncludesZero(false);
        IntervalXYDataset volumeDataset = this.getVolumeDataset(ohlc, 10000L);
        NumberAxis volumeAxis = new NumberAxis();
        volumeAxis.setAutoRangeIncludesZero(false);
        volumeAxis.setTickLabelPaint((Paint)this.VolumeColor);
        XYBarRenderer volumeRenderer = new XYBarRenderer();
        this.pricePlot.setDataset(1, (XYDataset)volumeDataset);
        this.pricePlot.setDomainAxis((ValueAxis)domainAxis);
        this.pricePlot.setRenderer(1, (XYItemRenderer)volumeRenderer);
        volumeRenderer.setShadowVisible(false);
        volumeRenderer.setSeriesPaint(0, (Paint)this.VolumeColor);
        volumeRenderer.setBarPainter((XYBarPainter)new StandardXYBarPainter());
        this.pricePlot.setBackgroundPaint((Paint)this.PLOTBGCOLOR);
        this.pricePlot.setRangeAxis(1, (ValueAxis)volumeAxis);
        this.pricePlot.setRangeAxis(0, (ValueAxis)priceAxis);
        this.pricePlot.setRangeAxisLocation(0, AxisLocation.TOP_OR_RIGHT);
        this.pricePlot.setRangeAxisLocation(1, AxisLocation.TOP_OR_LEFT);
        this.pricePlot.mapDatasetToRangeAxis(1, 1);
        for (i = 0; i < this.boardmeetingDate.size(); ++i) {
            m = new Minute(this.boardmeetingDate.get(i));
            millis = m.getFirstMillisecond();
            XYTextAnnotation bm = new XYTextAnnotation("B", millis, 280.0);
            bm.setFont(AppConfig.defaultPlanFont);
            bm.setPaint((Paint)Color.WHITE);
            bm.setTextAnchor(TextAnchor.HALF_ASCENT_RIGHT);
            this.pricePlot.addAnnotation((XYAnnotation)bm);
        }
        for (i = 0; i < this.announcdate.size(); ++i) {
            m = new Minute(this.announcdate.get(i));
            millis = m.getFirstMillisecond();
            XYTextAnnotation announc = new XYTextAnnotation("A", millis, 263.0);
            announc.setFont(AppConfig.defaultPlanFont);
            announc.setPaint((Paint)Color.WHITE);
            announc.setTextAnchor(TextAnchor.HALF_ASCENT_RIGHT);
            this.pricePlot.addAnnotation((XYAnnotation)announc);
        }
        CombinedDomainXYPlot mainPlot = new CombinedDomainXYPlot((ValueAxis)domainAxis);
        mainPlot.add(this.pricePlot);
        return new JFreeChart("", null, (Plot)mainPlot, false);
    }

    public OHLCDataset createdataset() {
        double[] high1 = new double[this.High.size()];
        Date[] mydates = new Date[this.date.size()];
        double[] low1 = new double[this.Low.size()];
        double[] open1 = new double[this.Open.size()];
        double[] close1 = new double[this.Close.size()];
        double[] volume1 = new double[this.volume.size()];
        for (int j = 0; j < this.High.size(); ++j) {
            high1[j] = this.High.get(j);
            low1[j] = this.Low.get(j);
            open1[j] = this.Open.get(j);
            close1[j] = this.Close.get(j);
            volume1[j] = this.volume.get(j).longValue();
            mydates[j] = this.date.get(j);
        }
        this.ohlcDataSet = new DefaultHighLowDataset((Comparable)((Object)""), mydates, high1, low1, open1, close1, volume1);
        return this.ohlcDataSet;
    }

    private JPanel createGraphPanel() {
        this.localJFreeChart = this.createChart(this.createdataset());
        this.localJFreeChart.setBackgroundPaint((Paint)new Color(0, 0, 0, 0));
        this.localChartPanel = new ChartPanel(this.localJFreeChart);
        this.localChartPanel.setBackground(Color.BLACK);
        this.localChartPanel.setFocusable(true);
        this.localChartPanel.requestFocus();
        this.localJFreeChart.setNotify(true);
        this.localChartPanel.setRangeZoomable(true);
        return this.localChartPanel;
    }

    public void showInFrmae() {
        this.frame = new JFrame();
        this.frame.setIconImage(AppConfig.houseIcon);
        this.frame.setMinimumSize(new Dimension(770, 500));
        this.frame.setDefaultCloseOperation(2);
        this.window.remove(this);
        this.frame.add(this);
        this.frame.setLocation(this.window.getLocation());
        this.frame.setSize(this.window.getSize());
        this.frame.validate();
        this.window.setVisible(false);
        this.window.validate();
        this.window.dispose();
        this.window = null;
        this.setTitle();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.frame.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.frame.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CandleHistoricalChart.this.initClose();
                CandleHistoricalChart.this.frame.dispose();
                TradeCast.getInstance().GetTopWindow();
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                if (CandleHistoricalChart.this.frame != null) {
                    CandleHistoricalChart.this.initClose();
                    TradeCast.getInstance().GetTopWindow();
                }
                if (CandleHistoricalChart.this.frame != null) {
                    TradeCast.getInstance().SaveSizeAndLocation(FormName.CandlestickHistoricalChart, CandleHistoricalChart.this.frame.getSize(), CandleHistoricalChart.this.frame.getLocation());
                }
            }
        });
        TradeCast.getInstance().CandleHistoricalGraphWindowHolder.put(this.num, this);
        this.frame.setVisible(true);
    }

    private void initClose() {
        TradeCast.getInstance().CandleHistoricalGraphWindowHolder.remove(this.num);
        TradeCast.getInstance().dynamicViews.remove(this.key);
    }

    public JDialog showInJDialog() {
        this.window = new JDialog(TradeCast.getInstance().frame);
        this.window.setMinimumSize(new Dimension(770, 500));
        this.window.setDefaultCloseOperation(2);
        if (this.frame != null) {
            this.window.setLocation(this.frame.getLocation());
            this.window.setSize(this.frame.getSize());
            this.frame.remove(this);
            this.frame.validate();
            this.frame.dispose();
            this.frame = null;
        }
        this.setTitle();
        this.window.add(this);
        this.window.validate();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.window.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.window.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CandleHistoricalChart.this.initClose();
                CandleHistoricalChart.this.window.dispose();
                TradeCast.getInstance().GetTopWindow();
            }
        });
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                if (CandleHistoricalChart.this.window != null) {
                    CandleHistoricalChart.this.initClose();
                    TradeCast.getInstance().GetTopWindow();
                }
                if (CandleHistoricalChart.this.window != null) {
                    TradeCast.getInstance().SaveSizeAndLocation(FormName.CandlestickHistoricalChart, CandleHistoricalChart.this.window.getSize(), CandleHistoricalChart.this.window.getLocation());
                }
            }
        });
        TradeCast.getInstance().CandleHistoricalGraphWindowHolder.put(this.num, this);
        this.window.setVisible(true);
        return this.window;
    }

    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        if (this.window != null) {
            this.window.dispose();
        }
    }

    private void UpdateGraph() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CandleHistoricalChart.this.addLoader();
                    CandleHistoricalChart.this.parseData(CandleHistoricalChart.this.lastData);
                }
                catch (Exception ex) {
                    CandleHistoricalChart.this.setEmpty();
                    ex.printStackTrace();
                    Mediator.getInstance().PrintLog(ex, "getHistoricalData in Historical Candle Chart");
                }
            }
        }, "CandleHistoricalChar : UpdateGraph").start();
    }

    private void initComponents() {
        this.ComponentPanel = new JPanel();
        this.cbMarkets = new JComboBox();
        this.cbScrip = new JComboBox();
        this.cbDays = new JComboBox();
        this.lblSymbolName = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.btnDock = new JButton();
        this.lblCandleStick = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.lblScripGraph = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.jSeparator5 = new JSeparator();
        this.lblIndexGraph = new JLabel();
        this.CandlePanel = new JPanel();
        this.hScrollpnl = new JPanel();
        this.pnlCandle = new JPanel();
        this.pnlhistoricalCandle = new JPanel();
        this.vScrollpnl = new JPanel();
        this.jLabel1 = new JLabel();
        this.lblVol = new JLabel();
        this.jSeparator6 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.lblRange = new JLabel();
        this.jSeparator7 = new JSeparator();
        this.jSeparator8 = new JSeparator();
        this.cbMarkets.setEditable(true);
        this.cbMarkets.setModel(new DefaultComboBoxModel<String>(new String[]{"REG", "FUT", "ODL"}));
        this.cbMarkets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CandleHistoricalChart.this.cbMarketsActionPerformed(evt);
            }
        });
        this.cbScrip.setEditable(true);
        this.cbScrip.setModel(new DefaultComboBoxModel<String>(new String[]{"PPL", "PPLP", ""}));
        this.cbScrip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CandleHistoricalChart.this.cbScripActionPerformed(evt);
            }
        });
        this.cbDays.setModel(new DefaultComboBoxModel<String>(new String[]{"Daily", "Weekly", "Monthly"}));
        this.cbDays.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CandleHistoricalChart.this.cbDaysActionPerformed(evt);
            }
        });
        this.lblSymbolName.setText(" ");
        this.lblSymbolName.setOpaque(true);
        this.btnDock.setIcon(new ImageIcon(this.getClass().getResource("/Images/Detach.png")));
        this.btnDock.setToolTipText("Attach / Detach");
        this.btnDock.setPreferredSize(new Dimension(16, 16));
        this.btnDock.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CandleHistoricalChart.this.btnDockMouseClicked(evt);
            }
        });
        this.lblCandleStick.setFont(new Font("Tahoma", 1, 11));
        this.lblCandleStick.setIcon(new ImageIcon(this.getClass().getResource("/Images/HistoricalData.png")));
        this.lblCandleStick.setText("Candlestick Chart");
        this.lblCandleStick.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CandleHistoricalChart.this.lblCandleStickMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CandleHistoricalChart.this.lblCandleStickMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CandleHistoricalChart.this.lblCandleStickMousePressed(evt);
            }
        });
        this.jSeparator2.setOrientation(1);
        this.lblScripGraph.setFont(new Font("Tahoma", 1, 11));
        this.lblScripGraph.setIcon(new ImageIcon(this.getClass().getResource("/Images/scripgraph.png")));
        this.lblScripGraph.setText("Scrip Graph");
        this.lblScripGraph.setMaximumSize(new Dimension(90, 16));
        this.lblScripGraph.setMinimumSize(new Dimension(90, 16));
        this.lblScripGraph.setPreferredSize(new Dimension(90, 16));
        this.lblScripGraph.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CandleHistoricalChart.this.lblScripGraphMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CandleHistoricalChart.this.lblScripGraphMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CandleHistoricalChart.this.lblScripGraphMousePressed(evt);
            }
        });
        this.jSeparator3.setOrientation(1);
        this.jSeparator4.setOrientation(1);
        this.jSeparator5.setOrientation(1);
        this.lblIndexGraph.setFont(new Font("Tahoma", 1, 11));
        this.lblIndexGraph.setIcon(new ImageIcon(this.getClass().getResource("/Images/indexgraph.png")));
        this.lblIndexGraph.setText("Index Graph");
        this.lblIndexGraph.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                CandleHistoricalChart.this.lblIndexGraphMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CandleHistoricalChart.this.lblIndexGraphMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                CandleHistoricalChart.this.lblIndexGraphMousePressed(evt);
            }
        });
        GroupLayout ComponentPanelLayout = new GroupLayout(this.ComponentPanel);
        this.ComponentPanel.setLayout(ComponentPanelLayout);
        ComponentPanelLayout.setHorizontalGroup(ComponentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, ComponentPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.cbMarkets, -2, 50, -2).addGap(5, 5, 5).addComponent(this.cbScrip, -2, 80, -2).addGap(5, 5, 5).addComponent(this.cbDays, -2, 80, -2).addGap(6, 6, 6).addComponent(this.jSeparator3, -2, -1, -2).addGap(2, 2, 2).addComponent(this.lblSymbolName, -1, 113, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator4, -2, 3, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDock, -2, 20, -2).addGap(10, 10, 10).addComponent(this.lblCandleStick, -2, 127, -2).addGap(5, 5, 5).addComponent(this.jSeparator2, -2, 3, -2).addGap(7, 7, 7).addComponent(this.lblScripGraph, -2, -1, -2).addGap(10, 10, 10).addComponent(this.jSeparator5, -2, 3, -2).addGap(7, 7, 7).addComponent(this.lblIndexGraph, -2, 95, -2)));
        ComponentPanelLayout.setVerticalGroup(ComponentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ComponentPanelLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(ComponentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ComponentPanelLayout.createSequentialGroup().addGap(1, 1, 1).addGroup(ComponentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbMarkets, -2, -1, -2).addComponent(this.cbScrip, -2, -1, -2).addComponent(this.cbDays, -2, -1, -2).addComponent(this.jSeparator3, -2, 20, -2).addComponent(this.lblSymbolName, -2, 20, -2))).addComponent(this.btnDock, -2, 20, -2).addComponent(this.jSeparator4, -2, 20, -2).addComponent(this.lblCandleStick, -2, 20, -2).addComponent(this.jSeparator2, -2, 20, -2).addComponent(this.lblScripGraph, -2, 20, -2).addComponent(this.jSeparator5, -2, 20, -2).addComponent(this.lblIndexGraph, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addContainerGap()));
        this.CandlePanel.setLayout(new BorderLayout());
        this.hScrollpnl.setLayout(new BoxLayout(this.hScrollpnl, 2));
        this.pnlhistoricalCandle.setLayout(new BorderLayout());
        GroupLayout pnlCandleLayout = new GroupLayout(this.pnlCandle);
        this.pnlCandle.setLayout(pnlCandleLayout);
        pnlCandleLayout.setHorizontalGroup(pnlCandleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlhistoricalCandle, -1, 190, Short.MAX_VALUE));
        pnlCandleLayout.setVerticalGroup(pnlCandleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlhistoricalCandle, GroupLayout.Alignment.TRAILING, -1, 330, Short.MAX_VALUE));
        this.vScrollpnl.setLayout(new BoxLayout(this.vScrollpnl, 2));
        this.jLabel1.setText("52 Week Avg Vol");
        this.lblVol.setFont(new Font("Tahoma", 1, 11));
        this.lblVol.setForeground(new Color(0, 0, 255));
        this.lblVol.setHorizontalAlignment(4);
        this.jLabel3.setText("52 Week Range");
        this.lblRange.setFont(new Font("Tahoma", 1, 11));
        this.lblRange.setForeground(new Color(0, 0, 255));
        this.lblRange.setHorizontalAlignment(4);
        this.jSeparator8.setOrientation(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ComponentPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlCandle, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 90, -2).addGap(0, 0, 0).addComponent(this.lblVol, -2, 70, -2)).addComponent(this.jSeparator6, -2, 165, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 90, -2).addGap(0, 0, 0).addComponent(this.lblRange, -2, 70, -2)).addComponent(this.jSeparator7, -2, 165, -2)))).addGap(5, 5, 5).addComponent(this.jSeparator8, -2, -1, -2).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.CandlePanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.vScrollpnl, -2, 15, -2).addGap(3, 3, 3)).addComponent(this.hScrollpnl, -1, -1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.ComponentPanel, -2, 34, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlCandle, -1, -1, Short.MAX_VALUE).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 20, -2).addComponent(this.lblVol, -2, 20, -2)).addComponent(this.jSeparator6, -2, -1, -2).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -2, 20, -2).addComponent(this.lblRange, -2, 20, -2)).addComponent(this.jSeparator7, -2, -1, -2).addGap(3, 3, 3)).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jSeparator8).addGap(5, 5, 5)).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.CandlePanel, -1, -1, Short.MAX_VALUE).addComponent(this.vScrollpnl, -1, -1, Short.MAX_VALUE)).addGap(5, 5, 5).addComponent(this.hScrollpnl, -2, 15, -2)))));
    }

    private void cbScripActionPerformed(ActionEvent evt) {
        if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
            this.addLoader();
            this.scrip = this.getScrip();
            this.init(this.Market, this.scrip);
        }
    }

    private void cbMarketsActionPerformed(ActionEvent evt) {
        if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
            this.addLoader();
            this.Market = this.getMarket();
            this.init(this.Market, this.scrip);
        }
    }

    private void cbDaysActionPerformed(ActionEvent evt) {
        this.UpdateGraph();
    }

    private void btnDockMouseClicked(MouseEvent evt) {
        if (this.Attach) {
            this.Attach = false;
            this.btnDock.setIcon(new ImageIcon(this.getClass().getResource("/images/Attach.png")));
        } else {
            this.Attach = true;
            this.btnDock.setIcon(new ImageIcon(this.getClass().getResource("/images/Detach.png")));
        }
        this.Detach();
    }

    private void lblCandleStickMouseEntered(MouseEvent evt) {
    }

    private void lblCandleStickMouseExited(MouseEvent evt) {
    }

    private void lblCandleStickMousePressed(MouseEvent evt) {
    }

    private void lblScripGraphMouseEntered(MouseEvent evt) {
        this.lblScripGraph.setCursor(Cursor.getPredefinedCursor(12));
        this.lblScripGraph.setText("<html><U>" + LanguageConstant.ScripGraph + "</U></html>");
    }

    private void lblScripGraphMouseExited(MouseEvent evt) {
        this.lblScripGraph.setCursor(Cursor.getPredefinedCursor(0));
        this.lblScripGraph.setText("<html>" + LanguageConstant.ScripGraph + "</html>");
    }

    private void lblScripGraphMousePressed(MouseEvent evt) {
        TradeCast.getInstance().ShowGraphWindow(FormName.GraphsAndCharts, LanguageConstant.GraphsAndCharts, this.Market, this.scrip);
    }

    private void lblIndexGraphMouseEntered(MouseEvent evt) {
        this.lblIndexGraph.setCursor(Cursor.getPredefinedCursor(12));
        this.lblIndexGraph.setText("<html><U>" + this.languageCentre.getValue(LanguageConstant.IndexGraph) + "</U></html>");
    }

    private void lblIndexGraphMouseExited(MouseEvent evt) {
        this.lblIndexGraph.setCursor(Cursor.getPredefinedCursor(0));
        this.lblIndexGraph.setText("<html>" + this.languageCentre.getValue(LanguageConstant.IndexGraph) + "</html>");
    }

    private void lblIndexGraphMousePressed(MouseEvent evt) {
        TradeCast.getInstance().ShowGraphWindow(FormName.IndexGraph, LanguageConstant.IndexGraph, "", "");
    }

    private void lblScripGraph1MouseEntered(MouseEvent evt) {
    }

    private void lblScripGraph1MouseExited(MouseEvent evt) {
    }

    private void lblScripGraph1MousePressed(MouseEvent evt) {
    }

    private void setTitle() {
        String Sector = "";
        String title = "";
        if (UtilTC.getScripSector(this.scrip).length() > 0) {
            Sector = UtilTC.getScripSector(this.scrip) + " Sector";
        }
        if (this.frame != null) {
            this.frame.setTitle(title);
        } else if (this.window != null) {
            this.window.setTitle(title);
        }
    }

    public void setAllScrip() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
                    Collections.sort(allScrip);
                    CandleHistoricalChart.this.cbScrip.setModel(new DefaultComboBoxModel(allScrip));
                    AutoCompleteSupport.install((JComboBox)CandleHistoricalChart.this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])allScrip.toArray()));
                    CandleHistoricalChart.this.cbScrip.setSelectedItem(LogsKSE.SelectedSymbol);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void setMarkets() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Vector<String> allMarket = new Vector<String>();
                for (int i = 0; i < LogCommon.markets.length; ++i) {
                    allMarket.addElement(LogCommon.markets[i]);
                }
                Collections.sort(allMarket);
                CandleHistoricalChart.this.cbMarkets.setModel(new DefaultComboBoxModel(allMarket));
                AutoCompleteSupport.install((JComboBox)CandleHistoricalChart.this.cbMarkets, (EventList)GlazedLists.eventListOf((Object[])allMarket.toArray()));
                CandleHistoricalChart.this.cbMarkets.setSelectedItem(LogsKSE.SelectedMarket);
            }
        });
    }

    private String getMarket() {
        if (this.cbMarkets.getSelectedItem() != null) {
            return this.cbMarkets.getSelectedItem().toString();
        }
        return "";
    }

    public String getScrip() {
        if (this.cbScrip.getSelectedItem() != null) {
            return this.cbScrip.getSelectedItem().toString();
        }
        return "";
    }

    private void setEmpty() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.pnlhistoricalCandle.removeAll();
            this.pnlhistoricalCandle.add((Component)new JPanel(), "Center");
            this.pnlhistoricalCandle.validate();
            this.CandlePanel.removeAll();
            this.CandlePanel.add((Component)new JPanel(), "Center");
            this.CandlePanel.validate();
            JOptionPane.showMessageDialog(null, "No data found", "Information", 1);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CandleHistoricalChart.this.pnlhistoricalCandle.removeAll();
                    CandleHistoricalChart.this.pnlhistoricalCandle.add((Component)new JPanel(), "Center");
                    CandleHistoricalChart.this.pnlhistoricalCandle.validate();
                    CandleHistoricalChart.this.CandlePanel.removeAll();
                    CandleHistoricalChart.this.CandlePanel.add((Component)new JPanel(), "Center");
                    CandleHistoricalChart.this.CandlePanel.validate();
                    JOptionPane.showMessageDialog(null, "No data found", "Information", 1);
                }
            });
        }
    }

    private void addLoader() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.pnlhistoricalCandle.removeAll();
            this.pnlhistoricalCandle.add((Component)new JPanel(), "Center");
            this.pnlhistoricalCandle.validate();
            this.CandlePanel.removeAll();
            this.CandlePanel.add((Component)new Loader(this.bgColor), "Center");
            this.CandlePanel.validate();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CandleHistoricalChart.this.pnlhistoricalCandle.removeAll();
                    CandleHistoricalChart.this.pnlhistoricalCandle.add((Component)new JPanel(), "Center");
                    CandleHistoricalChart.this.pnlhistoricalCandle.validate();
                    CandleHistoricalChart.this.CandlePanel.removeAll();
                    CandleHistoricalChart.this.CandlePanel.add((Component)new Loader(CandleHistoricalChart.this.bgColor), "Center");
                    CandleHistoricalChart.this.CandlePanel.validate();
                }
            });
        }
    }

    private void displayGraph(final OHLCDataset avgdataset) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.displayChart(avgdataset);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CandleHistoricalChart.this.displayChart(avgdataset);
                }
            });
        }
    }

    private void displayChart(OHLCDataset avgdataset) {
        this.CandlePanel.removeAll();
        this.CandlePanel.add((Component)this.createGraphPanel(), "Center");
        this.setZoom();
        this.CandlePanel.validate();
        this.pnlhistoricalCandle.removeAll();
        this.pnlhistoricalCandle.add((Component)this.create52WeekCandlePanel(avgdataset), "Center");
        this.pnlhistoricalCandle.validate();
        if (this.hScrollpnl != null) {
            this.hScrollpnl.removeAll();
            this.scrollbarhorizontal = new ChartScrollBar(0, this.localJFreeChart, this.localXYPlot);
            this.hScrollpnl.add((Component)this.scrollbarhorizontal);
            this.hScrollpnl.validate();
        } else {
            this.scrollbarhorizontal = new ChartScrollBar(0, this.localJFreeChart, this.localXYPlot);
            this.hScrollpnl.add((Component)this.scrollbarhorizontal);
            this.hScrollpnl.validate();
        }
        if (this.vScrollpnl != null) {
            this.vScrollpnl.removeAll();
            this.scrollbarvertical = new ChartScrollBar(1, this.localJFreeChart, this.pricePlot);
            this.vScrollpnl.add((Component)this.scrollbarvertical);
            this.vScrollpnl.validate();
        } else {
            this.scrollbarvertical = new ChartScrollBar(1, this.localJFreeChart, this.pricePlot);
            this.vScrollpnl.add((Component)this.scrollbarvertical);
            this.vScrollpnl.validate();
        }
    }

    private void setZoom() {
        int devider = 500;
        if (this.cbDays.getSelectedItem().toString().equalsIgnoreCase("daily")) {
            devider = 400;
        } else if (this.cbDays.getSelectedItem().toString().equalsIgnoreCase("Weekly")) {
            devider = 100;
        } else if (this.cbDays.getSelectedItem().toString().equalsIgnoreCase("Monthly")) {
            devider = 50;
        }
        int zoomRatio = (int)Math.floor(this.High.size() / devider);
        ChartRenderingInfo info = this.localChartPanel.getChartRenderingInfo();
        for (int i = 0; i < zoomRatio; ++i) {
            Rectangle2D rect = info.getPlotInfo().getDataArea();
            this.localChartPanel.zoomInBoth(rect.getCenterX(), rect.getCenterY());
        }
    }

    public void Detach() {
        if (this.frame == null) {
            this.showInFrmae();
        } else {
            this.showInJDialog();
        }
    }

    IntervalXYDataset getVolumeDataset(final OHLCDataset priceDataset, final long barWidthInMilliseconds) {
        return new AbstractIntervalXYDataset(){

            public int getSeriesCount() {
                return priceDataset.getSeriesCount();
            }

            public Comparable getSeriesKey(int series) {
                return priceDataset.getSeriesKey(series) + "-Volume";
            }

            public int getItemCount(int series) {
                return priceDataset.getItemCount(series);
            }

            public Number getX(int series, int item) {
                return priceDataset.getX(series, item);
            }

            public Number getY(int series, int item) {
                return priceDataset.getVolume(series, item);
            }

            public Number getStartX(int series, int item) {
                return priceDataset.getX(series, item).doubleValue() - (double)(barWidthInMilliseconds / 2L);
            }

            public Number getEndX(int series, int item) {
                return priceDataset.getX(series, item).doubleValue() + (double)(barWidthInMilliseconds / 2L);
            }

            public Number getStartY(int series, int item) {
                return new Double(0.0);
            }

            public Number getEndY(int series, int item) {
                return priceDataset.getVolume(series, item);
            }
        };
    }

    private JFreeChart create52WeekChart(OHLCDataset dataset) {
        JFreeChart chart = ChartFactory.createCandlestickChart((String)"52 Week Candle", null, null, (OHLCDataset)dataset, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setDomainPannable(true);
        int height = (int)(this.avgopen[0] + this.avgclose[0]);
        CandlestickRenderer priceRenderer = new CandlestickRenderer(50.0);
        priceRenderer.setDrawVolume(false);
        plot.setRenderer((XYItemRenderer)priceRenderer);
        NumberAxis axis = (NumberAxis)plot.getRangeAxis();
        axis.setVisible(false);
        ValueAxis domain = plot.getDomainAxis();
        domain.setVisible(false);
        Font f = new Font("Tahoma", 0, 13);
        Date dt = this.datetime[0];
        Hour hh = new Hour(dt);
        Minute m = new Minute(0, hh);
        double millis = m.getFirstMillisecond();
        GradientPaint downpaint = new GradientPaint(0.0f, height / 2, this.bearishstart, 0.0f, height, this.bearishend, false);
        priceRenderer.setDownPaint((Paint)downpaint);
        GradientPaint uppaint = new GradientPaint(0.0f, height / 2, this.bullishstart, 0.0f, height, this.bullishend, false);
        priceRenderer.setUpPaint((Paint)uppaint);
        double op = this.avgopen[0];
        double hg = this.avghigh[0];
        double lw = this.avglow[0];
        double cl = this.avgclose[0];
        double avg = this.avgaverage[0];
        String o = "Open " + Util.format2digit((String)(this.avgopen[0] + ""));
        String h = "High " + Util.format2digit((String)(this.avghigh[0] + ""));
        String l = "Low " + Util.format2digit((String)(this.avglow[0] + ""));
        String c = "Close " + Util.format2digit((String)(this.avgclose[0] + ""));
        String a = "Avg " + Util.format2digit((String)(this.avgaverage[0] + ""));
        XYPointerAnnotation hi = new XYPointerAnnotation(h, millis, hg, 44.0);
        XYPointerAnnotation low = new XYPointerAnnotation(l, millis, lw, 44.0);
        XYPointerAnnotation open = new XYPointerAnnotation(o, millis, op, 22.0);
        XYPointerAnnotation close = new XYPointerAnnotation(c, millis, cl, 22.0);
        XYPointerAnnotation average = new XYPointerAnnotation(a, millis, avg, 44.0);
        hi.setBaseRadius(35.0);
        hi.setTipRadius(17.0);
        hi.setLabelOffset(75.0);
        hi.setFont(f);
        hi.setPaint((Paint)new Color(0, 102, 0));
        hi.setArrowPaint((Paint)new Color(0, 102, 0));
        hi.setTextAnchor(TextAnchor.HALF_ASCENT_RIGHT);
        low.setBaseRadius(35.0);
        low.setTipRadius(17.0);
        low.setLabelOffset(70.0);
        low.setFont(f);
        low.setPaint((Paint)Color.RED);
        low.setArrowPaint((Paint)Color.RED);
        low.setTextAnchor(TextAnchor.HALF_ASCENT_RIGHT);
        open.setBaseRadius(35.0);
        open.setTipRadius(24.0);
        open.setFont(f);
        open.setPaint((Paint)Color.DARK_GRAY);
        open.setArrowPaint((Paint)Color.DARK_GRAY);
        open.setTextAnchor(TextAnchor.HALF_ASCENT_RIGHT);
        close.setBaseRadius(35.0);
        close.setTipRadius(24.0);
        close.setFont(f);
        close.setPaint((Paint)Color.blue);
        close.setArrowPaint((Paint)Color.BLUE);
        close.setTextAnchor(TextAnchor.HALF_ASCENT_RIGHT);
        average.setBaseRadius(35.0);
        average.setTipRadius(24.0);
        average.setLabelOffset(70.0);
        average.setFont(f);
        average.setPaint((Paint)new Color(102, 51, 0));
        average.setArrowPaint((Paint)new Color(102, 51, 0));
        average.setTextAnchor(TextAnchor.HALF_ASCENT_RIGHT);
        plot.addAnnotation((XYAnnotation)open);
        plot.addAnnotation((XYAnnotation)hi);
        plot.addAnnotation((XYAnnotation)close);
        plot.addAnnotation((XYAnnotation)low);
        plot.addAnnotation((XYAnnotation)average);
        plot.setRangeGridlinesVisible(false);
        plot.setDomainGridlinesVisible(false);
        plot.setBackgroundPaint((Paint)this.bgColor);
        chart.setBackgroundPaint((Paint)this.bgColor);
        axis.setAutoRangeIncludesZero(false);
        return chart;
    }

    private OHLCDataset create52weekdataset(String hdata) {
        try {
            Date dte = new Date();
            Date init = null;
            Object limit = null;
            init = Util.addSubtractYearFormDate((Date)dte, (int)-2);
            Gson s = new Gson();
            OHLCContainer container = (OHLCContainer)s.fromJson(hdata, OHLCContainer.class);
            ArrayList<OHLCBean> lis = new ArrayList<OHLCBean>();
            for (int i = 0; i < container.list.size(); ++i) {
                OHLCBean oHLCBean = (OHLCBean)container.list.get(i);
                if (oHLCBean.date.compareTo(init) < 0) continue;
                lis.add(oHLCBean);
            }
            ArrayList<Double> temhigh = new ArrayList<Double>();
            ArrayList<Double> temlow = new ArrayList<Double>();
            double clo = 0.0;
            double vol = 0.0;
            for (int i = 0; i < lis.size(); ++i) {
                temhigh.add(((OHLCBean)lis.get((int)i)).high);
                temlow.add(((OHLCBean)lis.get((int)i)).low);
                clo += ((OHLCBean)lis.get((int)i)).close;
                vol += (double)((OHLCBean)lis.get((int)i)).volume;
            }
            int closeize = lis.size() - 1;
            this.avgaverage[0] = clo / (double)closeize;
            this.avgvol[0] = vol / (double)closeize;
            this.datetime[0] = ((OHLCBean)lis.get((int)0)).date;
            this.avgopen[0] = ((OHLCBean)lis.get((int)0)).open;
            this.avgclose[0] = ((OHLCBean)lis.get((int)(lis.size() - 1))).close;
            this.avghigh[0] = (Double)Collections.max(temhigh);
            this.avglow[0] = (Double)Collections.min(temlow);
            this.lblVol.setText(Util.inMilliondigits((double)this.avgvol[0]));
            this.lblRange.setText(Util.format2digit((String)Double.toString((this.avghigh[0] + this.avglow[0]) / 2.0)));
            this.lblVol.setToolTipText(Util.inMilliondigits((double)this.avgvol[0]));
            this.lblRange.setToolTipText(Util.format2digit((String)Double.toString((this.avghigh[0] + this.avglow[0]) / 2.0)));
            return new DefaultHighLowDataset((Comparable)((Object)""), this.datetime, this.avghigh, this.avglow, this.avgopen, this.avgclose, this.avgvol);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private JPanel create52WeekCandlePanel(OHLCDataset avgdataset) {
        JFreeChart chart = this.create52WeekChart(avgdataset);
        ChartPanel panel = new ChartPanel(chart);
        panel.setToolTipText(null);
        panel.setSize(50, 500);
        panel.validate();
        return panel;
    }
}

