/*
 * Decompiled with CFR 0.152.
 */
package Chart;

import CATALYST.Control.MarketFeed;
import CustomComponent.MyOptionPane;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.LogsTC;
import catalystchart.ChartActionEvent;
import catalystchart.ChartActionListener;
import catalystchart.ChartType;
import catalystchart.OptionPanel;
import catalystchart.PnlIntraday;
import catalystchart.pnlIndexBar;
import common.bean.ExchangeStateBean;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import windows.ExchangeStats;

public class IndexGraph
extends JPanel
implements ChartActionListener {
    String lastSymbol = "";
    JFrame frame = null;
    JDialog window = null;
    public static boolean isFromShortCutKey = false;
    public String feedSymbol = "";
    int lastwidth;
    private String Index = "";
    private PnlIntraday pnlIntraday;
    Mediator mediator = null;
    boolean IsHistoryDataReceived = false;
    boolean isLoading = false;
    int num = 0;
    private int key;
    ExchangeStateBean ExRate = null;
    long MarketVolume = 0L;
    private LanguageCentre languageCentre = new LanguageCentre();
    boolean LoadingThread = false;
    Image img;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblExSummary;
    private JLabel lblScripGraph;
    private JLabel lblSymbolName;
    private JLabel lblimage;
    private JLabel lblrateleft;
    private JLabel lblrateright;
    private JPanel leftSplitPane;
    private OptionPanel optionPanel1;
    private pnlIndexBar pnlBar1;
    private JPanel pnlBottom;
    private JPanel pnlChart;
    private JPanel pnlChartRegion;
    private JPanel pnlGap;
    private JPanel pnlRate_left;
    private JPanel pnlRate_right;
    private JPanel pnlSeprator;
    private JPanel pnlTop;
    private JSeparator seprator1;

    public IndexGraph(int num, int key) {
        this.mediator = Mediator.getInstance();
        this.initComponents();
        this.num = num;
        this.key = key;
        this.optionPanel1.setIndexList();
        Vector<String> vv = new Vector<String>();
        vv.add("Index / Volume");
        this.optionPanel1.setGraphType(vv);
        this.lblSymbolName.setText("");
        this.lblrateleft.setText("0.00 (0.00");
        this.pnlIntraday = new PnlIntraday();
        PnlIntraday.lastChartType = ChartType.INDEXVOLUME;
        this.pnlIntraday.setWaterMarkText(AppConfig.houseName);
        this.pnlChartRegion.add((Component)this.pnlIntraday);
        this.optionPanel1.addListener((ChartActionListener)this);
        this.lblExSummary.setCursor(Cursor.getPredefinedCursor(12));
        this.lblExSummary.setText("<html>" + this.languageCentre.getValue(LanguageConstant.IndicesSummary) + "</html>");
        this.lblScripGraph.setCursor(Cursor.getPredefinedCursor(12));
        this.lblScripGraph.setText("<html>" + LanguageConstant.ScripGraph + "</html>");
    }

    private void ChangeChart() {
        this.pnlIntraday.setWaterMarkText(this.Index);
        this.isLoading = true;
        try {
            String returnMessage = "";
            this.mediator.sendFeedSymbols("", "Index Graph : ChangeChart");
            if (PnlIntraday.lastChartType == ChartType.INDEXVOLUME) {
                ArrayList<Date> date = new ArrayList<Date>();
                ArrayList<Double> ltrdPrice = new ArrayList<Double>();
                ArrayList<Double> ltrVolume = new ArrayList<Double>();
                this.pnlIntraday.initializeChart("", this.Index, PnlIntraday.lastChartType);
                returnMessage = this.getData("", date, ltrdPrice, ltrVolume);
                this.pnlIntraday.setInitialDataForIndexVolumeChart(date, ltrdPrice, ltrVolume);
                this.pnlIntraday.showChart();
                this.updateChart();
                this.clearCandle();
                this.updateCandle();
                this.clearRetaInPanel();
                this.updateRateInPanel();
            }
            if (returnMessage.equalsIgnoreCase("Error")) {
                this.isLoading = false;
                MyOptionPane.showMessage(MessageType.Error, "Error in loading data", LanguageConstant.GraphsAndCharts, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isLoading = false;
    }

    private String getData(String Type2, List<Date> date, List<Double> data1, List<Double> data2) {
        String returnMessage = "OK";
        try {
            if (!AppConfig.GraphURL.equalsIgnoreCase("Service")) {
                String result;
                URL url = new URL(AppConfig.GraphURL + "?action=Exchange&IndexCode=" + this.Index.replace(" ", ""));
                this.mediator.println(url.toString());
                URLConnection yc = url.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((result = in.readLine()) != null) {
                    sb.append(result);
                }
                in.close();
                result = "=" + sb.toString();
                if (result.length() > 0) {
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
                    this.parseData(result, Type2, date, data1, data2, sdf);
                } else {
                    Mediator.getInstance().println("Historical Data not found!");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            returnMessage = "Error";
        }
        return returnMessage;
    }

    private void parseData(String result, String Type2, List<Date> date, List<Double> data1, List<Double> data2, DateFormat sdf) throws ParseException {
        String Feed_ = result.split("\\=", -1)[1];
        String[] Tick = Feed_.split("\\|", -1);
        for (int i = 0; i < Tick.length; ++i) {
            if (Tick[i].length() <= 0) continue;
            String[] data = Tick[i].split("\\;", -1);
            Date dt = sdf.parse(data[0]);
            double d1 = Double.parseDouble(data[1]);
            double d2 = Double.parseDouble(data[2]);
            date.add(dt);
            data1.add(d1);
            data2.add(d2);
            if (Type2.indexOf("BuySell") < 0) continue;
        }
    }

    public void showInFrmae() {
        this.frame = new JFrame();
        this.frame.setIconImage(AppConfig.houseIcon);
        this.frame.setMinimumSize(new Dimension(770, 500));
        this.frame.setDefaultCloseOperation(2);
        this.window.remove(this);
        this.frame.add(this);
        this.frame.setLocation(this.window.getLocation());
        this.frame.setSize(this.window.getSize());
        this.frame.validate();
        this.window.setVisible(false);
        this.window.validate();
        this.window.dispose();
        this.window = null;
        this.setTitle();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.frame.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.frame.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndexGraph.this.initClose();
                IndexGraph.this.frame.dispose();
                TradeCast.getInstance().GetTopWindow();
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                if (IndexGraph.this.frame != null) {
                    IndexGraph.this.initClose();
                    TradeCast.getInstance().GetTopWindow();
                }
                if (IndexGraph.this.frame != null) {
                    TradeCast.getInstance().SaveSizeAndLocation(FormName.GraphsAndCharts, IndexGraph.this.frame.getSize(), IndexGraph.this.frame.getLocation());
                }
            }
        });
        TradeCast.getInstance().GraphWindowHolder.put(this.num, this);
        this.frame.setVisible(true);
    }

    private void initClose() {
        TradeCast.getInstance().GraphWindowHolder.remove(this.num);
        LogsTC.GraphSymbol.remove(this.Index);
        TradeCast.getInstance().dynamicViews.remove(this.key);
    }

    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        if (this.window != null) {
            this.window.dispose();
        }
    }

    public JDialog showInJDialog() {
        this.window = new JDialog(TradeCast.getInstance().frame);
        this.window.setMinimumSize(new Dimension(770, 500));
        this.window.setDefaultCloseOperation(2);
        if (this.frame != null) {
            this.window.setLocation(this.frame.getLocation());
            this.window.setSize(this.frame.getSize());
            this.frame.remove(this);
            this.frame.validate();
            this.frame.dispose();
            this.frame = null;
        }
        this.setTitle();
        this.window.add(this);
        this.window.validate();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.window.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.window.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IndexGraph.this.initClose();
                IndexGraph.this.window.dispose();
                TradeCast.getInstance().GetTopWindow();
            }
        });
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                if (IndexGraph.this.window != null) {
                    IndexGraph.this.initClose();
                    TradeCast.getInstance().GetTopWindow();
                }
                if (IndexGraph.this.window != null) {
                    TradeCast.getInstance().SaveSizeAndLocation(FormName.GraphsAndCharts, IndexGraph.this.window.getSize(), IndexGraph.this.window.getLocation());
                }
            }
        });
        TradeCast.getInstance().GraphWindowHolder.put(this.num, this);
        this.window.setVisible(true);
        return this.window;
    }

    public void requestFocusWindow() {
        if (this.window != null) {
            this.window.requestFocus();
        } else if (this.frame != null) {
            this.frame.requestFocus();
        }
    }

    public void updateTick() {
        MarketFeed mktfeed = new MarketFeed();
        this.pnlIntraday.addTick(mktfeed);
    }

    public void InitilizeWindow() {
        if (this.LoadingThread) {
            return;
        }
        this.LoadingThread = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                IndexGraph.this.ChangeChart();
                IndexGraph.this.LoadingThread = false;
            }
        }, "Index Graph").start();
    }

    public void FeedRecieved() {
        if (this.Index.length() > 0) {
            this.ExRate = (ExchangeStateBean)LogCommon.ExStatsFeedMap.get("ALLSHR");
            this.MarketVolume = this.ExRate.getCVol();
            this.ExRate = (ExchangeStateBean)LogCommon.ExStatsFeedMap.get(this.Index.toUpperCase());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IndexGraph.this.updateCandle();
                    IndexGraph.this.updateRateInPanel();
                    if (!IndexGraph.this.isLoading) {
                        IndexGraph.this.updateChart();
                    }
                }
            });
        }
    }

    private void updateChart() {
        try {
            if (this.pnlIntraday != null && this.ExRate != null) {
                if (PnlIntraday.lastChartType == ChartType.INDEXVOLUME && (LogsKSE.MarketStauts.toUpperCase().indexOf("OHP") >= 0 || LogsKSE.MarketStauts.toUpperCase().indexOf("OPN") >= 0 || LogsKSE.MarketStauts.toUpperCase().indexOf("PRE") >= 0)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
                    String time = sdf.format(MyTime.getInstance().getDate2());
                    this.pnlIntraday.addIndexVolumeTick(sdf.parse(time), this.ExRate.getIndex(), (double)this.ExRate.getCVol());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void clearCandle() {
        if (this.pnlBar1 != null) {
            this.pnlBar1.clear();
        }
    }

    private void updateCandle() {
        try {
            if (this.pnlBar1 != null && this.ExRate != null) {
                this.pnlBar1.updateData(this.Index, this.ExRate.getHigh(), this.ExRate.getLow(), this.ExRate.getIndex(), this.ExRate.getIndex() - this.ExRate.getIndexChange(), (long)this.ExRate.getCVol(), this.MarketVolume, this.ExRate.getAdvancers(), this.ExRate.getDecliners(), this.ExRate.getUnchanged());
                this.pnlBar1.validate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void clearRetaInPanel() {
        Color color = Color.BLUE;
        this.lblimage.setIcon(ExchangeStats.loadImage("level.png"));
        this.lblrateleft.setText("000.00 (0.00");
        this.lblrateright.setText("0.00%)");
        this.lblrateleft.setForeground(Color.BLUE);
        this.lblrateright.setForeground(Color.BLUE);
    }

    public void setPrefrence(String Index) {
        if (this.isLoading) {
            return;
        }
        this.Index = Index.replace(" ", "");
        this.setTitle();
        this.optionPanel1.setSymbol(Index);
        this.optionPanel1.setMarketComboVisible(false);
        this.ExRate = (ExchangeStateBean)LogCommon.ExStatsFeedMap.get("ALLSHR");
        if (this.ExRate == null) {
            this.ExRate = ExchangeStateBean.parse((String)"");
        }
        this.MarketVolume = this.ExRate.getCVol();
        this.ExRate = (ExchangeStateBean)LogCommon.ExStatsFeedMap.get(this.Index.toUpperCase());
        this.lblSymbolName.setText("<HTML><table><tr><td nowrap='nowrap'><font size='5'>" + this.Index + "  Index</font><font size='3'>  Index / Volume Chart</font></td><tr><table></HTML>");
        this.InitilizeWindow();
    }

    private void updateRateInPanel() {
        try {
            if (this.ExRate != null) {
                double change = this.ExRate.getIndexChange();
                double index = this.ExRate.getIndex();
                double percentage = change / (index - change) * 100.0;
                Color color = Color.BLUE;
                if (change > 0.0) {
                    color = Util.convertToColor((String)"#009900", (Color)Color.GREEN);
                } else if (change < 0.0) {
                    color = Color.RED;
                }
                this.lblrateleft.setText(Util.format2digit((String)(index + "")) + " (" + Util.format2digit((String)(change + "")));
                this.lblrateright.setText(Util.format2digit((String)(percentage + "")) + "%)");
                if (change == 0.0) {
                    this.lblimage.setIcon(ExchangeStats.loadImage("level.png"));
                    this.lblrateleft.setForeground(Color.BLUE);
                    this.lblrateright.setForeground(Color.BLUE);
                } else if (change > 0.0) {
                    this.lblimage.setIcon(ExchangeStats.loadImage("up.png"));
                    this.lblrateleft.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                    this.lblrateright.setForeground(Util.convertToColor((String)"#009900", (Color)Color.GREEN));
                } else if (change < 0.0) {
                    this.lblimage.setIcon(ExchangeStats.loadImage("down.png"));
                    this.lblrateleft.setForeground(Color.RED);
                    this.lblrateright.setForeground(Color.RED);
                }
                this.pnlRate_left.validate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ChartChanged(String str) {
        this.InitilizeWindow();
    }

    public void ZoomIn(ChartActionEvent e) {
        this.pnlIntraday.ZoomIn(e);
    }

    public void ZoomOut(ChartActionEvent e) {
        this.pnlIntraday.ZoomOut(e);
    }

    public void ResetZoom(ChartActionEvent e) {
        this.pnlIntraday.ResetZoom(e);
    }

    public void setInterval(ChartActionEvent e) {
        this.pnlIntraday.setInterval(e);
    }

    public void setChartType(ChartActionEvent e) {
        PnlIntraday.lastChartType = e.getChartType();
        this.InitilizeWindow();
    }

    public void ChangeSymbol(ChartActionEvent e) {
        this.setPrefrence(e.getSymbol().toUpperCase());
    }

    public void AddIndicator(ChartActionEvent e) {
        this.pnlIntraday.AddIndicator(e);
    }

    public void Detach() {
        if (this.frame == null) {
            this.showInFrmae();
        } else {
            this.showInJDialog();
        }
    }

    public void drawLoading(Graphics g) {
        if (this.img == null) {
            this.img = new ImageIcon(this.getClass().getResource("/Images/loaderbgblack.gif")).getImage();
        }
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.pnlChartRegion.getWidth(), this.pnlChartRegion.getHeight());
        g.drawImage(this.img, this.pnlChartRegion.getWidth() / 2 - this.img.getWidth(this) / 2, this.pnlChartRegion.getHeight() / 2 - this.img.getHeight(this) / 2, this);
    }

    private void initComponents() {
        this.leftSplitPane = new JPanel();
        this.pnlTop = new JPanel();
        this.jLabel20 = new JLabel();
        this.pnlRate_left = new JPanel();
        this.lblrateleft = new JLabel();
        this.lblimage = new JLabel();
        this.lblrateright = new JLabel();
        this.jLabel21 = new JLabel();
        this.pnlRate_right = new JPanel();
        this.lblSymbolName = new JLabel();
        this.lblExSummary = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.lblScripGraph = new JLabel();
        this.pnlSeprator = new JPanel();
        this.seprator1 = new JSeparator();
        this.pnlBottom = new JPanel();
        this.jLabel18 = new JLabel();
        this.pnlBar1 = new pnlIndexBar();
        this.jLabel16 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel17 = new JLabel();
        this.pnlChart = new JPanel();
        this.optionPanel1 = new OptionPanel();
        this.pnlChartRegion = new JPanel(){

            @Override
            public void paint(Graphics g) {
                if (IndexGraph.this.isLoading) {
                    IndexGraph.this.drawLoading(g);
                } else {
                    super.paint(g);
                }
            }
        };
        this.jLabel19 = new JLabel();
        this.pnlGap = new JPanel();
        this.setMinimumSize(new Dimension(750, 200));
        this.setPreferredSize(new Dimension(750, 200));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                IndexGraph.this.formKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                IndexGraph.this.formKeyReleased(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.leftSplitPane.setMinimumSize(new Dimension(508, 25));
        this.leftSplitPane.setPreferredSize(new Dimension(898, 300));
        this.leftSplitPane.setLayout(new BoxLayout(this.leftSplitPane, 1));
        this.pnlTop.setMaximumSize(new Dimension(65534, 30));
        this.pnlTop.setPreferredSize(new Dimension(800, 30));
        this.pnlTop.setLayout(new BoxLayout(this.pnlTop, 0));
        this.jLabel20.setMaximumSize(new Dimension(5, 5));
        this.jLabel20.setMinimumSize(new Dimension(5, 5));
        this.jLabel20.setPreferredSize(new Dimension(5, 5));
        this.pnlTop.add(this.jLabel20);
        this.pnlRate_left.setMaximumSize(new Dimension(200, 30));
        this.pnlRate_left.setPreferredSize(new Dimension(200, 30));
        this.lblrateleft.setFont(new Font("Tahoma", 1, 11));
        this.lblrateleft.setForeground(new Color(51, 0, 255));
        this.lblrateleft.setHorizontalAlignment(4);
        this.lblrateleft.setText("000.00 (0.00");
        this.lblrateleft.setMaximumSize(new Dimension(81, 30));
        this.lblrateleft.setMinimumSize(new Dimension(81, 30));
        this.lblrateleft.setPreferredSize(new Dimension(81, 30));
        this.lblimage.setFont(new Font("Tahoma", 1, 12));
        this.lblimage.setForeground(new Color(51, 0, 255));
        this.lblimage.setIcon(new ImageIcon(this.getClass().getResource("/Images/level.png")));
        this.lblimage.setMaximumSize(new Dimension(10, 30));
        this.lblimage.setMinimumSize(new Dimension(10, 30));
        this.lblimage.setPreferredSize(new Dimension(10, 30));
        this.lblrateright.setFont(new Font("Tahoma", 1, 11));
        this.lblrateright.setForeground(new Color(51, 0, 255));
        this.lblrateright.setText("0.00%)");
        this.lblrateright.setMaximumSize(new Dimension(47, 30));
        this.lblrateright.setMinimumSize(new Dimension(47, 30));
        this.lblrateright.setPreferredSize(new Dimension(47, 30));
        GroupLayout pnlRate_leftLayout = new GroupLayout(this.pnlRate_left);
        this.pnlRate_left.setLayout(pnlRate_leftLayout);
        pnlRate_leftLayout.setHorizontalGroup(pnlRate_leftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRate_leftLayout.createSequentialGroup().addComponent(this.lblrateleft, -2, 115, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblimage, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblrateright, -2, 69, -2).addContainerGap(-1, Short.MAX_VALUE)));
        pnlRate_leftLayout.setVerticalGroup(pnlRate_leftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlRate_leftLayout.createSequentialGroup().addGroup(pnlRate_leftLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblrateleft, -1, -1, Short.MAX_VALUE).addComponent(this.lblrateright, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.lblimage, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pnlTop.add(this.pnlRate_left);
        this.jLabel21.setMaximumSize(new Dimension(5, 5));
        this.jLabel21.setMinimumSize(new Dimension(5, 5));
        this.jLabel21.setPreferredSize(new Dimension(5, 5));
        this.pnlTop.add(this.jLabel21);
        this.pnlRate_right.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.pnlRate_right.setPreferredSize(new Dimension(512, 30));
        this.lblSymbolName.setFont(new Font("Tahoma", 0, 18));
        this.lblSymbolName.setText("Symbol");
        this.lblSymbolName.setMaximumSize(new Dimension(65, 30));
        this.lblSymbolName.setMinimumSize(new Dimension(65, 30));
        this.lblSymbolName.setPreferredSize(new Dimension(65, 30));
        this.lblExSummary.setFont(new Font("Tahoma", 1, 11));
        this.lblExSummary.setHorizontalAlignment(0);
        this.lblExSummary.setIcon(new ImageIcon(this.getClass().getResource("/Images/exchangeStats.png")));
        this.lblExSummary.setText("Exchange Statistics Summary");
        this.lblExSummary.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                IndexGraph.this.lblExSummaryMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                IndexGraph.this.lblExSummaryMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                IndexGraph.this.lblExSummaryMousePressed(evt);
            }
        });
        this.jSeparator2.setOrientation(1);
        this.lblScripGraph.setFont(new Font("Tahoma", 1, 11));
        this.lblScripGraph.setHorizontalAlignment(0);
        this.lblScripGraph.setIcon(new ImageIcon(this.getClass().getResource("/Images/scripgraph.png")));
        this.lblScripGraph.setText("Scrip Graph");
        this.lblScripGraph.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                IndexGraph.this.lblScripGraphMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                IndexGraph.this.lblScripGraphMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                IndexGraph.this.lblScripGraphMousePressed(evt);
            }
        });
        GroupLayout pnlRate_rightLayout = new GroupLayout(this.pnlRate_right);
        this.pnlRate_right.setLayout(pnlRate_rightLayout);
        pnlRate_rightLayout.setHorizontalGroup(pnlRate_rightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRate_rightLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblSymbolName, -1, 210, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.lblScripGraph, -2, 90, -2).addGap(10, 10, 10).addComponent(this.jSeparator2, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblExSummary, -2, 188, -2).addContainerGap()));
        pnlRate_rightLayout.setVerticalGroup(pnlRate_rightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlRate_rightLayout.createSequentialGroup().addGroup(pnlRate_rightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSymbolName, -2, -1, -2).addComponent(this.lblScripGraph, -2, 30, -2).addGroup(pnlRate_rightLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jSeparator2, -2, 22, -2)).addComponent(this.lblExSummary, -2, 30, -2)).addGap(0, 0, 0)));
        this.pnlTop.add(this.pnlRate_right);
        this.leftSplitPane.add(this.pnlTop);
        this.pnlSeprator.setPreferredSize(new Dimension(898, 5));
        GroupLayout pnlSepratorLayout = new GroupLayout(this.pnlSeprator);
        this.pnlSeprator.setLayout(pnlSepratorLayout);
        pnlSepratorLayout.setHorizontalGroup(pnlSepratorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlSepratorLayout.createSequentialGroup().addContainerGap().addComponent(this.seprator1, -1, 730, Short.MAX_VALUE).addContainerGap()));
        pnlSepratorLayout.setVerticalGroup(pnlSepratorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.seprator1, -2, -1, -2));
        this.leftSplitPane.add(this.pnlSeprator);
        this.pnlBottom.setLayout(new BoxLayout(this.pnlBottom, 0));
        this.jLabel18.setMaximumSize(new Dimension(5, 5));
        this.jLabel18.setMinimumSize(new Dimension(5, 5));
        this.jLabel18.setPreferredSize(new Dimension(5, 5));
        this.pnlBottom.add(this.jLabel18);
        this.pnlBottom.add((Component)this.pnlBar1);
        this.jLabel16.setMaximumSize(new Dimension(5, 5));
        this.jLabel16.setMinimumSize(new Dimension(5, 5));
        this.jLabel16.setPreferredSize(new Dimension(5, 5));
        this.pnlBottom.add(this.jLabel16);
        this.jSeparator1.setOrientation(1);
        this.pnlBottom.add(this.jSeparator1);
        this.jLabel17.setText("jLabel17");
        this.jLabel17.setMaximumSize(new Dimension(5, 5));
        this.jLabel17.setMinimumSize(new Dimension(5, 5));
        this.jLabel17.setPreferredSize(new Dimension(5, 5));
        this.pnlBottom.add(this.jLabel17);
        this.pnlChart.setBackground(new Color(204, 204, 255));
        this.pnlChart.setPreferredSize(new Dimension(516, 25));
        this.pnlChart.setLayout(new BoxLayout(this.pnlChart, 1));
        this.pnlChart.add((Component)this.optionPanel1);
        this.pnlChartRegion.setBackground(new Color(0, 0, 0));
        this.pnlChartRegion.setLayout(new BorderLayout());
        this.pnlChart.add(this.pnlChartRegion);
        this.pnlBottom.add(this.pnlChart);
        this.jLabel19.setMaximumSize(new Dimension(5, 5));
        this.jLabel19.setMinimumSize(new Dimension(5, 5));
        this.jLabel19.setPreferredSize(new Dimension(5, 5));
        this.pnlBottom.add(this.jLabel19);
        this.leftSplitPane.add(this.pnlBottom);
        this.pnlGap.setPreferredSize(new Dimension(748, 5));
        GroupLayout pnlGapLayout = new GroupLayout(this.pnlGap);
        this.pnlGap.setLayout(pnlGapLayout);
        pnlGapLayout.setHorizontalGroup(pnlGapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 750, Short.MAX_VALUE));
        pnlGapLayout.setVerticalGroup(pnlGapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 5, Short.MAX_VALUE));
        this.leftSplitPane.add(this.pnlGap);
        this.add((Component)this.leftSplitPane, "Center");
    }

    private void formKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            // empty if block
        }
    }

    private void formKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            // empty if block
        }
    }

    private void lblExSummaryMouseEntered(MouseEvent evt) {
        this.lblExSummary.setText("<html><U>" + this.languageCentre.getValue(LanguageConstant.IndicesSummary) + "</U></html>");
    }

    private void lblExSummaryMouseExited(MouseEvent evt) {
        this.lblExSummary.setText("<html>" + this.languageCentre.getValue(LanguageConstant.IndicesSummary) + "</html>");
    }

    private void lblExSummaryMousePressed(MouseEvent evt) {
        TradeCast.getInstance().ShowDynamicForm(FormName.IndicesSummery, LanguageConstant.IndicesSummary);
    }

    private void lblScripGraphMouseEntered(MouseEvent evt) {
        this.lblScripGraph.setText("<html><U>" + LanguageConstant.ScripGraph + "</U></html>");
    }

    private void lblScripGraphMouseExited(MouseEvent evt) {
        this.lblScripGraph.setText("<html>" + LanguageConstant.ScripGraph + "</html>");
    }

    private void lblScripGraphMousePressed(MouseEvent evt) {
        TradeCast.getInstance().ShowGraphWindow(FormName.GraphsAndCharts, LanguageConstant.GraphsAndCharts, "", "");
    }

    private void setTitle() {
        if (this.frame != null) {
            this.frame.setTitle(this.Index + " - " + this.languageCentre.getValue(LanguageConstant.IndexVolumeChart));
        } else if (this.window != null) {
            this.window.setTitle(this.Index + " - " + this.languageCentre.getValue(LanguageConstant.IndexVolumeChart));
        }
    }
}

