/*
 * Decompiled with CFR 0.152.
 */
package CustomComponent;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class AutofitTableColumns {
    private static final int DEFAULT_COLUMN_PADDING = 5;

    public static int autoResizeTable(JTable aTable, boolean includeColumnHeaderWidth) {
        return AutofitTableColumns.autoResizeTable(aTable, includeColumnHeaderWidth, 5);
    }

    public static int autoResizeTable(JTable aTable, boolean includeColumnHeaderWidth, int columnPadding) {
        int columnCount = aTable.getColumnCount();
        int currentTableWidth = aTable.getWidth();
        int tableWidth = 0;
        Dimension cellSpacing = aTable.getIntercellSpacing();
        if (columnCount > 0) {
            int[] columnWidth = new int[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columnWidth[i] = AutofitTableColumns.getMaxColumnWidth(aTable, i, true, columnPadding);
                tableWidth += columnWidth[i];
            }
            JTableHeader tableHeader = aTable.getTableHeader();
            Dimension headerDim = tableHeader.getPreferredSize();
            headerDim.width = tableWidth += (columnCount - 1) * cellSpacing.width;
            tableHeader.setPreferredSize(headerDim);
            Dimension interCellSpacing = aTable.getIntercellSpacing();
            Dimension dim = new Dimension();
            int rowHeight = aTable.getRowHeight();
            if (rowHeight == 0) {
                rowHeight = 16;
            }
            dim.height = headerDim.height + (rowHeight + interCellSpacing.height) * aTable.getRowCount();
            dim.width = tableWidth;
            TableColumnModel tableColumnModel = aTable.getColumnModel();
            for (int i = 0; i < columnCount; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                tableColumn.setPreferredWidth(columnWidth[i]);
            }
            aTable.invalidate();
            aTable.doLayout();
            aTable.repaint();
        }
        return tableWidth;
    }

    private static int getMaxColumnWidth(JTable aTable, int columnNo, boolean includeColumnHeaderWidth, int columnPadding) {
        TableColumn column = aTable.getColumnModel().getColumn(columnNo);
        Component comp = null;
        int maxWidth = 0;
        if (includeColumnHeaderWidth) {
            FontMetrics fontMetrics;
            Font font;
            TableCellRenderer headerRenderer = column.getHeaderRenderer();
            if (headerRenderer != null) {
                comp = headerRenderer.getTableCellRendererComponent(aTable, column.getHeaderValue(), false, false, 0, columnNo);
                if (comp instanceof JTextComponent) {
                    JTextComponent jtextComp = (JTextComponent)comp;
                    String text = jtextComp.getText();
                    font = jtextComp.getFont();
                    fontMetrics = jtextComp.getFontMetrics(font);
                    maxWidth = SwingUtilities.computeStringWidth(fontMetrics, text);
                } else {
                    maxWidth = comp.getPreferredSize().width;
                }
            } else {
                try {
                    String headerText = (String)column.getHeaderValue();
                    JLabel defaultLabel = new JLabel(headerText);
                    font = defaultLabel.getFont();
                    fontMetrics = defaultLabel.getFontMetrics(font);
                    maxWidth = SwingUtilities.computeStringWidth(fontMetrics, headerText);
                }
                catch (ClassCastException ce) {
                    maxWidth = 0;
                }
            }
        }
        int cellWidth = 0;
        for (int i = 0; i < aTable.getRowCount(); ++i) {
            TableCellRenderer tableCellRenderer = aTable.getCellRenderer(i, columnNo);
            comp = tableCellRenderer.getTableCellRendererComponent(aTable, aTable.getValueAt(i, columnNo), false, false, i, columnNo);
            if (comp instanceof JTextComponent) {
                JTextComponent jtextComp = (JTextComponent)comp;
                String text = jtextComp.getText();
                Font font = jtextComp.getFont();
                FontMetrics fontMetrics = jtextComp.getFontMetrics(font);
                int textWidth = SwingUtilities.computeStringWidth(fontMetrics, text);
                maxWidth = Math.max(maxWidth, textWidth);
                continue;
            }
            cellWidth = comp.getPreferredSize().width;
            maxWidth = Math.max(maxWidth, cellWidth);
        }
        return maxWidth + columnPadding;
    }
}

