/*
 * Decompiled with CFR 0.152.
 */
package CustomComponent;

import CustomComponent.MyTime;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.ImageUtil;
import common.gui.util.LogCommon;
import common.gui.util.LoginMode;
import common.gui.util.Title;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import pmex.gui.util.LogsPMEX;

public class CustomMenu
extends JMenuBar {
    private TradeCast tradeCast = null;
    private Mediator mediator = Mediator.getInstance();
    public JCheckBoxMenuItem toolbar = null;
    public JCheckBoxMenuItem exstatsmenu = null;
    public JCheckBoxMenuItem statusumenu = null;
    public JCheckBoxMenuItem pmexBuyingPowerMenu = null;
    public JMenuItem unattendedMenu = null;
    private LanguageCentre languageCentre = new LanguageCentre();

    public CustomMenu() {
        try {
            this.tradeCast = TradeCast.getInstance();
            this.mediator.setCustomMenu(this);
            this.add(this.CreateFileMenu());
            this.add(this.CreateViewMenu());
            this.add(this.CreateOrderMenu());
            this.add(this.CreateMonitorMenu());
            this.add(this.CreateInquiryMenu());
            if (AppConfig.isHistoricalDataWatch && AppConfig.loginMode != LoginMode.PMEX) {
                this.add(this.CreateFinancialMenu());
            }
            if (AppConfig.loginMode == LoginMode.KSE || AppConfig.loginMode == LoginMode.KSEPMEX) {
                this.add(this.CreateServiceMenu());
            }
            this.add(this.CreateToolsMenu());
            if (AppConfig.isTickerEnable && AppConfig.loginMode != LoginMode.PMEX) {
                this.add(this.CreateTickerMenu());
            }
            if (AppConfig.ResreachMenuText.trim().length() > 0 && AppConfig.loginMode != LoginMode.PMEX) {
                this.add(this.CreateHouseMenu());
            }
            this.add(this.CreateHelpMenu());
            this.add(Box.createHorizontalGlue());
            JLabel logintime = new JLabel("  " + MyTime.getInstance().getLoginDateAndTime() + "  ");
            logintime.setForeground(new Color(188, 194, 207));
            JLabel ti = new JLabel("Connected @");
            ti.setForeground(new Color(188, 194, 207));
            this.add(ti);
            this.add(logintime);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setMenuForBuySell() {
        this.remove(2);
        this.add((Component)this.CreateOrderMenu(), 2);
    }

    private JMenu CreateFileMenu() {
        JMenu FileMenu = new JMenu(this.languageCentre.getValue(LanguageConstant.File));
        FileMenu.add(this.createMenuItem(LanguageConstant.Preferences));
        FileMenu.addSeparator();
        FileMenu.add(this.createMenuItem(LanguageConstant.ChangePassword));
        FileMenu.add(this.createMenuItem(LanguageConstant.ChangePIN));
        FileMenu.addSeparator();
        if (AppConfig.isCreatePinCode) {
            FileMenu.add(this.createMenuItem(LanguageConstant.CreatePIN));
            FileMenu.addSeparator();
        }
        if (AppConfig.isUseSecondaryPassword) {
            FileMenu.add(this.createMenuItem(Title.CreateSecondaryPassword));
            FileMenu.addSeparator();
        }
        FileMenu.add(this.createMenuItem(LanguageConstant.Unattended));
        JMenuItem mi = new JMenuItem(this.languageCentre.getValue(LanguageConstant.Logout));
        mi.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/logout.png")));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomMenu.this.tradeCast.Close();
            }
        });
        FileMenu.add(mi);
        return FileMenu;
    }

    private JMenu CreateViewMenu() {
        JMenu viewMenu = new JMenu(this.languageCentre.getValue(LanguageConstant.View));
        if (AppConfig.loginMode == LoginMode.KSE) {
            viewMenu.add(this.createMenuItem(LanguageConstant.MarketWatch));
            viewMenu.add(this.createMenuItem(LanguageConstant.MessageWindow));
            viewMenu.addSeparator();
            viewMenu.add(this.createToolBarItem());
            viewMenu.add(this.createExStatsMenuItem());
            viewMenu.add(this.createStatusBarMenuItem());
        } else if (AppConfig.loginMode == LoginMode.PMEX) {
            viewMenu.add(this.createMenuItem("Commodity Watches"));
            viewMenu.add(this.createMenuItem(Title.PMEX_Matirx));
            viewMenu.add(this.createMenuItem(LanguageConstant.MessageWindow));
            viewMenu.addSeparator();
            viewMenu.add(this.createToolBarItem());
            viewMenu.add(this.createPMEXBuyingPowerMenuItem());
            viewMenu.add(this.createStatusBarMenuItem());
            LogCommon.ShowExSatatsBar = false;
            this.tradeCast.ExStats.setVisible(false);
        } else if (AppConfig.loginMode == LoginMode.KSEPMEX) {
            viewMenu.add(this.createMenuItem(LanguageConstant.MarketWatch));
            viewMenu.add(this.createMenuItem("Commodity Watches"));
            viewMenu.add(this.createMenuItem(Title.PMEX_Matirx));
            viewMenu.add(this.createMenuItem(LanguageConstant.MessageWindow));
            viewMenu.addSeparator();
            viewMenu.add(this.createToolBarItem());
            viewMenu.add(this.createExStatsMenuItem());
            viewMenu.add(this.createPMEXBuyingPowerMenuItem());
            viewMenu.add(this.createStatusBarMenuItem());
        }
        return viewMenu;
    }

    private JMenu CreateOrderMenu() {
        JMenu orderMenu = new JMenu(this.languageCentre.getValue(LanguageConstant.Order));
        if (AppConfig.loginMode == LoginMode.KSE) {
            orderMenu.add(this.createMenuItem(LanguageConstant.Buy));
            orderMenu.add(this.createMenuItem(LanguageConstant.Sell));
            if (AppConfig.isLeverageBuy) {
                orderMenu.addSeparator();
                orderMenu.add(this.createMenuItem(LanguageConstant.LeverageBuy));
            }
            orderMenu.addSeparator();
            if (AppConfig.isMFSOrder) {
                orderMenu.add(this.createMenuItem(Title.MFS));
                orderMenu.addSeparator();
            }
            orderMenu.add(this.createMenuItem(LanguageConstant.BunchOrder));
            if (AppConfig.isShortSell) {
                orderMenu.add(this.createMenuItem(LanguageConstant.ShortSell));
            }
            orderMenu.addSeparator();
            orderMenu.add(this.createMenuItem(LanguageConstant.ChangeOrder));
            orderMenu.addSeparator();
            orderMenu.add(this.createMenuItem(LanguageConstant.Cancel));
            if (AppConfig.isOrderExportImport) {
                orderMenu.addSeparator();
                orderMenu.add(this.createMenuItem(LanguageConstant.OrderImport));
            }
            if (AppConfig.isStrategyOrder) {
                orderMenu.addSeparator();
                orderMenu.add(this.createMenuItem(LanguageConstant.StrategyOrder));
            }
        } else if (AppConfig.loginMode == LoginMode.PMEX) {
            orderMenu.add(this.createMenuItem(Title.PMEX_Buy));
            orderMenu.add(this.createMenuItem(Title.PMEX_Sell));
            orderMenu.addSeparator();
            orderMenu.add(this.createMenuItem(Title.PMEX_FastOrder));
        } else if (AppConfig.loginMode == LoginMode.KSEPMEX) {
            orderMenu.add(this.createMenuItem(LanguageConstant.Buy));
            orderMenu.add(this.createMenuItem(LanguageConstant.Sell));
            if (AppConfig.isLeverageBuy) {
                orderMenu.addSeparator();
                orderMenu.add(this.createMenuItem(LanguageConstant.LeverageBuy));
            }
            orderMenu.addSeparator();
            if (AppConfig.isMFSOrder) {
                orderMenu.add(this.createMenuItem(Title.MFS));
                orderMenu.addSeparator();
            }
            orderMenu.add(this.createMenuItem(LanguageConstant.BunchOrder));
            if (AppConfig.isShortSell) {
                orderMenu.add(this.createMenuItem(LanguageConstant.ShortSell));
            }
            orderMenu.addSeparator();
            orderMenu.add(this.createMenuItem(LanguageConstant.ChangeOrder));
            orderMenu.addSeparator();
            orderMenu.add(this.createMenuItem(LanguageConstant.Cancel));
            if (AppConfig.isOrderExportImport) {
                orderMenu.addSeparator();
                orderMenu.add(this.createMenuItem(LanguageConstant.OrderImport));
            }
            if (AppConfig.isStrategyOrder) {
                orderMenu.addSeparator();
                orderMenu.add(this.createMenuItem(LanguageConstant.StrategyOrder));
            }
            orderMenu.addSeparator();
            orderMenu.add(this.createMenuItem(Title.PMEX_Buy));
            orderMenu.add(this.createMenuItem(Title.PMEX_Sell));
            orderMenu.addSeparator();
            orderMenu.add(this.createMenuItem(Title.PMEX_FastOrder));
        }
        return orderMenu;
    }

    private JMenu CreateFinancialMenu() {
        JMenu financialMenu = new JMenu(this.languageCentre.getValue(LanguageConstant.Financial));
        financialMenu.add(this.createMenuItem(LanguageConstant.AnnualStatements));
        financialMenu.add(this.createMenuItem(LanguageConstant.QuarterlyStatements));
        return financialMenu;
    }

    private JMenu CreateMonitorMenu() {
        JMenu monitorMenu = new JMenu(this.languageCentre.getValue(LanguageConstant.Monitor));
        if (AppConfig.loginMode == LoginMode.KSE) {
            monitorMenu.add(this.createMenuItem(LanguageConstant.MarketDepthByPrice));
            monitorMenu.add(this.createMenuItem(LanguageConstant.MarketDepthByOrder));
            monitorMenu.add(this.createMenuItem(LanguageConstant.DetailedQuote));
            if (AppConfig.isHistoricalDataWatch) {
                monitorMenu.add(this.createMenuItem(LanguageConstant.ScripDetail));
                monitorMenu.add(this.createMenuItem(LanguageConstant.Historicaldata));
                monitorMenu.add(this.createMenuItem(Title.CompanyInfo));
            }
            monitorMenu.addSeparator();
            monitorMenu.add(this.createMenuItem(LanguageConstant.ScripBrowse));
            monitorMenu.add(this.createMenuItem(LanguageConstant.Top30Movers));
            monitorMenu.add(this.createMenuItem(LanguageConstant.SectorPerformance));
            monitorMenu.addSeparator();
            monitorMenu.add(this.createMenuItem(LanguageConstant.IndicesSummary));
        } else if (AppConfig.loginMode == LoginMode.PMEX) {
            monitorMenu.add(this.createMenuItem(Title.PMEX_MarketDepthByPrice));
            monitorMenu.add(this.createMenuItem(Title.PMEX_Ladder));
            monitorMenu.addSeparator();
            monitorMenu.add(this.createMenuItem(Title.PMEX_TopMovers));
            monitorMenu.addSeparator();
            monitorMenu.add(this.createMenuItem(Title.PMEX_ContractBrowse));
        } else if (AppConfig.loginMode == LoginMode.KSEPMEX) {
            monitorMenu.add(this.createMenuItem(LanguageConstant.MarketDepthByPrice));
            monitorMenu.add(this.createMenuItem(LanguageConstant.MarketDepthByOrder));
            monitorMenu.add(this.createMenuItem(LanguageConstant.DetailedQuote));
            if (AppConfig.isHistoricalDataWatch) {
                monitorMenu.add(this.createMenuItem(LanguageConstant.ScripDetail));
                monitorMenu.add(this.createMenuItem(LanguageConstant.Historicaldata));
                monitorMenu.add(this.createMenuItem(Title.CompanyInfo));
            }
            monitorMenu.addSeparator();
            monitorMenu.add(this.createMenuItem(LanguageConstant.ScripBrowse));
            monitorMenu.add(this.createMenuItem(LanguageConstant.Top30Movers));
            monitorMenu.add(this.createMenuItem(LanguageConstant.SectorPerformance));
            monitorMenu.addSeparator();
            monitorMenu.add(this.createMenuItem(LanguageConstant.IndicesSummary));
            monitorMenu.addSeparator();
            monitorMenu.add(this.createMenuItem(Title.PMEX_MarketDepthByPrice));
            monitorMenu.add(this.createMenuItem(Title.PMEX_Ladder));
            monitorMenu.addSeparator();
            monitorMenu.add(this.createMenuItem(Title.PMEX_TopMovers));
            monitorMenu.addSeparator();
            monitorMenu.add(this.createMenuItem(Title.PMEX_ContractBrowse));
        }
        return monitorMenu;
    }

    private JMenu CreateInquiryMenu() {
        JMenu inquiryMenu = new JMenu(this.languageCentre.getValue(LanguageConstant.Inquiry));
        if (AppConfig.loginMode == LoginMode.KSE) {
            inquiryMenu.add(this.createMenuItem(LanguageConstant.ExposureWatch));
            inquiryMenu.addSeparator();
            inquiryMenu.add(this.createMenuItem(LanguageConstant.OutstandingLog));
            inquiryMenu.add(this.createMenuItem(LanguageConstant.TradeLog));
            inquiryMenu.add(this.createMenuItem(LanguageConstant.ActivityLog));
            inquiryMenu.add(this.createMenuItem(LanguageConstant.DailyTradeReport));
            if (AppConfig.isAccountStatement) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.AccountStatement));
            }
            if (AppConfig.isPreviousAccountStatement) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.PreviousAccountStatement));
            }
            if (AppConfig.isOrderHistory) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.OrderHistory));
            }
            if (AppConfig.isPreviousOrderHistory) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.PreviousOrderHistory));
            }
            if (AppConfig.isCashWithdrawal) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.CashWithdrawalStatement));
            }
            if (AppConfig.isStandardCapital) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(Title.OpenNCDCPosition));
                inquiryMenu.add(this.createMenuItem(Title.TransactionHistory));
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(Title.LedgerActivity));
                inquiryMenu.add(this.createMenuItem(Title.InvestmentReport));
            }
            if (AppConfig.isPeriodicTradeSummary) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.PeriodicTradeSummary));
            }
            if (AppConfig.isPeriodicTradeDetail) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.PeriodicTradeDetail));
            }
            if (AppConfig.isPeriodicTradeSummaryByDealer) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.PeriodicTradeSummaryByDealer));
            }
            if (AppConfig.isPeriodicTradeDetailByDealer) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.PeriodicTradeDetailByDealer));
            }
            if (AppConfig.isPreviousPeriodicTradeDetail) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.PreviousPeriodicTradeDetail));
            }
            if (AppConfig.isCustodyNetShares) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.CustodyNetShares));
            }
            if (AppConfig.isScripHistory) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.ScripHistory));
            }
            if (AppConfig.isScripWisePosition) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.ScripWisePosition));
            }
            if (AppConfig.isClosePriceExport) {
                inquiryMenu.add(this.createMenuItem(Title.ClosePriceExport));
            }
            if (AppConfig.isXDividendWindow) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.XDividendWindow));
            }
            if (AppConfig.isExBenefitsWindow) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.ExBenefitsWindow));
            }
            if (AppConfig.isCustomerVerificationBIPL && LogCommon.UserType.equalsIgnoreCase("Trader")) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.CustomerVerificationBIPL));
            }
            if (AppConfig.isBankHistorical) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.BankHistorical));
            }
        } else if (AppConfig.loginMode == LoginMode.PMEX) {
            inquiryMenu.add(this.createMenuItem(Title.PMEX_BuyingPower));
            inquiryMenu.add(this.createMenuItem(Title.PMEX_RiskWatch));
            inquiryMenu.addSeparator();
            inquiryMenu.add(this.createMenuItem(Title.PMEX_WorkingOrder));
            inquiryMenu.add(this.createMenuItem(Title.PMEX_TradedOrder));
            inquiryMenu.add(this.createMenuItem(Title.PMEX_OrderActivity));
            if (AppConfig.isPMEXAccountStatement) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(Title.PMEX_AccountStatement));
            }
            if (AppConfig.isPMEXPeriodicTradeDetail) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(Title.PMEX_PeriodicTradeDetail));
            }
            if (AppConfig.isPMEXPeriodicTradeSummary) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(Title.PMEX_PeriodicTradeSummary));
            }
            if (AppConfig.isPMEXVaultPosition) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(Title.PMEX_VaultPosition));
            }
            if (AppConfig.isPMEXExpiringPosition) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(Title.PMEX_ExpiringPosition));
            }
        } else if (AppConfig.loginMode == LoginMode.KSEPMEX) {
            inquiryMenu.add(this.createMenuItem(LanguageConstant.ExposureWatch));
            inquiryMenu.addSeparator();
            inquiryMenu.add(this.createMenuItem(LanguageConstant.OutstandingLog));
            inquiryMenu.add(this.createMenuItem(LanguageConstant.TradeLog));
            inquiryMenu.add(this.createMenuItem(LanguageConstant.ActivityLog));
            inquiryMenu.add(this.createMenuItem(LanguageConstant.DailyTradeReport));
            if (AppConfig.isAccountStatement) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.AccountStatement));
            }
            if (AppConfig.isPreviousAccountStatement) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.PreviousAccountStatement));
            }
            if (AppConfig.isOrderHistory) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.OrderHistory));
            }
            if (AppConfig.isPreviousOrderHistory) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.PreviousOrderHistory));
            }
            if (AppConfig.isCashWithdrawal) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.CashWithdrawalStatement));
            }
            if (AppConfig.isFundTransferStatement) {
                inquiryMenu.add(this.createMenuItem(Title.FundTransferStatement));
            }
            if (AppConfig.isPeriodicTradeSummary) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.PeriodicTradeSummary));
            }
            if (AppConfig.isPeriodicTradeDetail) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.PeriodicTradeDetail));
            }
            if (AppConfig.isPeriodicTradeSummaryByDealer) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.PeriodicTradeSummaryByDealer));
            }
            if (AppConfig.isPeriodicTradeDetailByDealer) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.PeriodicTradeDetailByDealer));
            }
            if (AppConfig.isPreviousPeriodicTradeDetail) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.PreviousPeriodicTradeDetail));
            }
            if (AppConfig.isCustodyNetShares) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.CustodyNetShares));
            }
            if (AppConfig.isScripHistory) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.ScripHistory));
            }
            if (AppConfig.isScripWisePosition) {
                inquiryMenu.add(this.createMenuItem(LanguageConstant.ScripWisePosition));
            }
            if (AppConfig.isClosePriceExport) {
                inquiryMenu.add(this.createMenuItem(Title.ClosePriceExport));
            }
            if (AppConfig.isXDividendWindow) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.XDividendWindow));
            }
            if (AppConfig.isExBenefitsWindow) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.ExBenefitsWindow));
            }
            if (AppConfig.isBankHistorical) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.BankHistorical));
            }
            if (AppConfig.isStandardCapital) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(Title.OpenNCDCPosition));
                inquiryMenu.add(this.createMenuItem(Title.TransactionHistory));
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(Title.LedgerActivity));
                inquiryMenu.add(this.createMenuItem(Title.InvestmentReport));
            }
            if (AppConfig.isCustomerVerificationBIPL && LogCommon.UserType.equalsIgnoreCase("Trader")) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(LanguageConstant.CustomerVerificationBIPL));
            }
            inquiryMenu.addSeparator();
            inquiryMenu.add(this.createMenuItem(Title.PMEX_BuyingPower));
            inquiryMenu.add(this.createMenuItem(Title.PMEX_RiskWatch));
            inquiryMenu.addSeparator();
            inquiryMenu.add(this.createMenuItem(Title.PMEX_WorkingOrder));
            inquiryMenu.add(this.createMenuItem(Title.PMEX_TradedOrder));
            inquiryMenu.add(this.createMenuItem(Title.PMEX_OrderActivity));
            if (AppConfig.isPMEXAccountStatement) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(Title.PMEX_AccountStatement));
            }
            if (AppConfig.isPMEXPeriodicTradeDetail) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(Title.PMEX_PeriodicTradeDetail));
            }
            if (AppConfig.isPMEXPeriodicTradeSummary) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(Title.PMEX_PeriodicTradeSummary));
            }
            if (AppConfig.isPMEXVaultPosition) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(Title.PMEX_VaultPosition));
            }
            if (AppConfig.isPMEXExpiringPosition) {
                inquiryMenu.addSeparator();
                inquiryMenu.add(this.createMenuItem(Title.PMEX_ExpiringPosition));
            }
        }
        return inquiryMenu;
    }

    private JMenu CreateServiceMenu() {
        JMenu serviceMenu = new JMenu(this.languageCentre.getValue(LanguageConstant.Services));
        if (AppConfig.isCashWithdrawal) {
            serviceMenu.add(this.createMenuItem(LanguageConstant.CashWithdrawalRequest));
        }
        serviceMenu.add(this.createMenuItem(LanguageConstant.MarketDataExport));
        if (AppConfig.isFundTransfer) {
            serviceMenu.addSeparator();
            serviceMenu.add(this.createMenuItem(LanguageConstant.FundTransfer));
        }
        if (AppConfig.isFundTransferBIPL && LogCommon.UserType.equalsIgnoreCase("Client")) {
            serviceMenu.addSeparator();
            serviceMenu.add(this.createMenuItem(LanguageConstant.FundTransferBIPL));
        }
        if (AppConfig.houseName.equalsIgnoreCase("JSGCL")) {
            if (AppConfig.loginMode == LoginMode.KSEPMEX) {
                serviceMenu.addSeparator();
                serviceMenu.add(this.createMenuItem(LanguageConstant.JSFundTransferRequest));
                if (AppConfig.JSinternalBankFundTransfer) {
                    serviceMenu.add(this.createMenuItem(LanguageConstant.JSinternalBankFundTransfer));
                }
            }
            serviceMenu.addSeparator();
            serviceMenu.add(this.createMenuItem(LanguageConstant.MarkDelivery));
        }
        return serviceMenu;
    }

    private JMenu CreateToolsMenu() {
        JMenu toolsMenu = new JMenu(this.languageCentre.getValue(LanguageConstant.Tools));
        if (AppConfig.loginMode == LoginMode.KSE) {
            if (AppConfig.GraphURL.length() > 0) {
                toolsMenu.add(this.createMenuItem(LanguageConstant.GraphsAndCharts));
                toolsMenu.add(this.createMenuItem(LanguageConstant.IndexGraph));
            }
            if (!AppConfig.ScreenerText.equalsIgnoreCase("")) {
                JMenuItem screenerMenu = new JMenuItem(this.languageCentre.getValue(LanguageConstant.StockScreener));
                screenerMenu.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/screener.png")));
                screenerMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CustomMenu.this.tradeCast.showStockScreenerFrame();
                        ((CustomMenu)CustomMenu.this).mediator.stockScreenerFrame.openURL(AppConfig.ScreenerLink);
                    }
                });
                toolsMenu.add(screenerMenu);
            }
            if (AppConfig.isStandardCapital) {
                toolsMenu.addSeparator();
                toolsMenu.add(this.createMenuItem(Title.MarketValuationsURL_SC));
                toolsMenu.add(this.createMenuItem(Title.AnalystOpinion));
                toolsMenu.add(this.createMenuItem(Title.PSXHeatMap));
                toolsMenu.add(this.createMenuItem(Title.FIPIOverview));
                toolsMenu.addSeparator();
                toolsMenu.add(this.createMenuItem(Title.IndexSnapshot));
                toolsMenu.add(this.createMenuItem(Title.SectorSnapshot));
                toolsMenu.add(this.createMenuItem(Title.StockSearch));
                toolsMenu.add(this.createMenuItem(Title.StockComparisonURL_SC));
                toolsMenu.addSeparator();
                toolsMenu.add(this.createMenuItem(Title.RealtimeTechnicalCharting));
                toolsMenu.add(this.createMenuItem(Title.TradingSignal));
            }
            JMenuItem mi = new JMenuItem(this.languageCentre.getValue(LanguageConstant.RestoreDefaultLayout));
            mi.setAccelerator(KeyStroke.getKeyStroke(82, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/restoreDefault.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.tradeCast.setDefaultLayout();
                }
            });
            toolsMenu.addSeparator();
            toolsMenu.add(mi);
        } else if (AppConfig.loginMode == LoginMode.PMEX) {
            if (AppConfig.isStandardCapital) {
                toolsMenu.addSeparator();
                toolsMenu.add(this.createMenuItem(Title.MarketValuationsURL_SC));
                toolsMenu.add(this.createMenuItem(Title.AnalystOpinion));
                toolsMenu.add(this.createMenuItem(Title.PSXHeatMap));
                toolsMenu.add(this.createMenuItem(Title.FIPIOverview));
                toolsMenu.addSeparator();
                toolsMenu.add(this.createMenuItem(Title.IndexSnapshot));
                toolsMenu.add(this.createMenuItem(Title.SectorSnapshot));
                toolsMenu.add(this.createMenuItem(Title.StockSearch));
                toolsMenu.add(this.createMenuItem(Title.StockComparisonURL_SC));
                toolsMenu.addSeparator();
                toolsMenu.add(this.createMenuItem(Title.RealtimeTechnicalCharting));
                toolsMenu.add(this.createMenuItem(Title.TradingSignal));
                toolsMenu.addSeparator();
            }
            JMenuItem mi = new JMenuItem(this.languageCentre.getValue(LanguageConstant.RestoreDefaultLayout));
            mi.setAccelerator(KeyStroke.getKeyStroke(82, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/restoreDefault.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.tradeCast.setDefaultLayout();
                }
            });
            toolsMenu.add(mi);
        } else if (AppConfig.loginMode == LoginMode.KSEPMEX) {
            if (AppConfig.GraphURL.length() > 0) {
                toolsMenu.add(this.createMenuItem(LanguageConstant.GraphsAndCharts));
                toolsMenu.add(this.createMenuItem(LanguageConstant.IndexGraph));
            }
            if (AppConfig.isStandardCapital) {
                toolsMenu.addSeparator();
                toolsMenu.add(this.createMenuItem(Title.MarketValuationsURL_SC));
                toolsMenu.add(this.createMenuItem(Title.AnalystOpinion));
                toolsMenu.add(this.createMenuItem(Title.PSXHeatMap));
                toolsMenu.add(this.createMenuItem(Title.FIPIOverview));
                toolsMenu.addSeparator();
                toolsMenu.add(this.createMenuItem(Title.IndexSnapshot));
                toolsMenu.add(this.createMenuItem(Title.SectorSnapshot));
                toolsMenu.add(this.createMenuItem(Title.StockSearch));
                toolsMenu.add(this.createMenuItem(Title.StockComparisonURL_SC));
                toolsMenu.addSeparator();
                toolsMenu.add(this.createMenuItem(Title.RealtimeTechnicalCharting));
                toolsMenu.add(this.createMenuItem(Title.TradingSignal));
            }
            JMenuItem mi = new JMenuItem(this.languageCentre.getValue(LanguageConstant.RestoreDefaultLayout));
            mi.setAccelerator(KeyStroke.getKeyStroke(82, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/restoreDefault.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.tradeCast.setDefaultLayout();
                }
            });
            toolsMenu.addSeparator();
            toolsMenu.add(mi);
        }
        toolsMenu.addSeparator();
        toolsMenu.add(this.createMenuItem(LanguageConstant.TradeCastBrowser));
        return toolsMenu;
    }

    private JMenu CreateTickerMenu() {
        JMenu TickerMenu = new JMenu(this.languageCentre.getValue(LanguageConstant.Tickers));
        if (AppConfig.loginMode == LoginMode.KSE) {
            TickerMenu.add(this.createMenuItem(LanguageConstant.UpperCapped));
            TickerMenu.add(this.createMenuItem(LanguageConstant.LowerLocked));
            JMenu topMovers = new JMenu(this.languageCentre.getValue(LanguageConstant.TopMovers));
            topMovers.setIcon(new ImageIcon(this.getClass().getResource("/Images/TickertopMovers.png")));
            String osName = System.getProperty("os.name");
            if (osName.equalsIgnoreCase("Windows XP") || osName.equalsIgnoreCase("Windows 2003")) {
                topMovers.setMargin(new Insets(2, -10, 2, 0));
            }
            topMovers.add(this.createMenuItem(LanguageConstant.ByVolume));
            topMovers.add(this.createMenuItem(LanguageConstant.ByPriceIncrease));
            topMovers.add(this.createMenuItem(LanguageConstant.ByPriceDecrease));
            topMovers.add(this.createMenuItem(LanguageConstant.ByPercentIncrease));
            topMovers.add(this.createMenuItem(LanguageConstant.ByPercentDecrease));
            TickerMenu.add(topMovers);
            TickerMenu.add(this.createMenuItem(LanguageConstant.CustomTicker));
        } else if (AppConfig.loginMode != LoginMode.PMEX && AppConfig.loginMode == LoginMode.KSEPMEX) {
            TickerMenu.add(this.createMenuItem(LanguageConstant.UpperCapped));
            TickerMenu.add(this.createMenuItem(LanguageConstant.LowerLocked));
            JMenu topMovers = new JMenu(this.languageCentre.getValue(LanguageConstant.TopMovers));
            topMovers.setIcon(new ImageIcon(this.getClass().getResource("/Images/TickertopMovers.png")));
            String osName = System.getProperty("os.name");
            if (osName.equalsIgnoreCase("Windows XP") || osName.equalsIgnoreCase("Windows 2003")) {
                topMovers.setMargin(new Insets(2, -10, 2, 0));
            }
            topMovers.add(this.createMenuItem(LanguageConstant.ByVolume));
            topMovers.add(this.createMenuItem(LanguageConstant.ByPriceIncrease));
            topMovers.add(this.createMenuItem(LanguageConstant.ByPriceDecrease));
            topMovers.add(this.createMenuItem(LanguageConstant.ByPercentIncrease));
            topMovers.add(this.createMenuItem(LanguageConstant.ByPercentDecrease));
            TickerMenu.add(topMovers);
            TickerMenu.add(this.createMenuItem(LanguageConstant.CustomTicker));
        }
        return TickerMenu;
    }

    private JMenu CreateHelpMenu() {
        JMenu helpMenu = new JMenu(this.languageCentre.getValue(LanguageConstant.Help));
        JMenuItem about = new JMenuItem(this.languageCentre.getValue(LanguageConstant.AboutTradeCast));
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomMenu.this.mediator.OpenAboutWindow();
            }
        });
        about.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        about.setIcon(new ImageIcon(this.getClass().getResource("/Images/About.png")));
        JMenuItem keys = new JMenuItem(this.languageCentre.getValue(LanguageConstant.ShortcutKeys));
        keys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomMenu.this.tradeCast.ShowDynamicForm(FormName.ShortcutKeys, LanguageConstant.ShortcutKeys);
            }
        });
        if (!AppConfig.isExposureViaF1) {
            keys.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        }
        keys.setIcon(new ImageIcon(this.getClass().getResource("/Images/keys.png")));
        helpMenu.add(keys);
        if (AppConfig.isStandardCapital) {
            helpMenu.addSeparator();
            helpMenu.add(this.createMenuItem(Title.Disclaimer));
        }
        helpMenu.addSeparator();
        helpMenu.add(about);
        return helpMenu;
    }

    private JMenu CreateHouseMenu() {
        JMenu houseMenu = new JMenu(AppConfig.houseName);
        JMenuItem resreachMenu = new JMenuItem(AppConfig.ResreachMenuText);
        if (AppConfig.houseIcon == null) {
            try {
                AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
                resreachMenu.setIcon(new ImageIcon(AppConfig.houseIcon));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            resreachMenu.setIcon(new ImageIcon(AppConfig.houseIcon));
        }
        resreachMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomMenu.this.tradeCast.showWebBrowserFrame();
                ((CustomMenu)CustomMenu.this).mediator.webBrowserFrame.openURL(AppConfig.ResreachMenuLink);
            }
        });
        if (!AppConfig.DemoRegistrationLink.equalsIgnoreCase("")) {
            JMenuItem demoRegistrationMenu = new JMenuItem(AppConfig.DemoRegistrationText);
            demoRegistrationMenu.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/game.png")));
            demoRegistrationMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.tradeCast.showWebBrowserFrame();
                    ((CustomMenu)CustomMenu.this).mediator.webBrowserFrame.openURL(AppConfig.DemoRegistrationLink);
                }
            });
            houseMenu.add(demoRegistrationMenu);
        }
        houseMenu.add(resreachMenu);
        return houseMenu;
    }

    private JMenuItem createMenuItem(final String id) {
        boolean AddListener = true;
        boolean IsDynamic = false;
        FormName frmName = null;
        String FormTitle = "";
        String viewName = "";
        JMenuItem mi = null;
        mi = id.equalsIgnoreCase(LanguageConstant.DailyTradeReport) && AppConfig.houseName.equalsIgnoreCase("JSGCL") ? new JMenuItem("Blocked Profit Loss Details") : new JMenuItem(this.languageCentre.getValue(id));
        if (id.equalsIgnoreCase(LanguageConstant.MarketWatch)) {
            viewName = LanguageConstant.MarketWatch;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/MktWatch.png")));
        } else if (id.equalsIgnoreCase("Commodity Watches")) {
            viewName = "Commodity Watches";
            mi.setAccelerator(KeyStroke.getKeyStroke(123, 1));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/marketWatch16.png")));
        } else if (id.equalsIgnoreCase(Title.PMEX_Matirx)) {
            viewName = Title.PMEX_Matirx;
            mi.setAccelerator(KeyStroke.getKeyStroke(122, 1));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/matrix16.png")));
        } else if (id.equalsIgnoreCase(Title.PMEX_AccountStatement)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/accountStatement.png")));
            IsDynamic = true;
            frmName = FormName.PMEX_AccountStatement;
            FormTitle = Title.PMEX_AccountStatement;
        } else if (id.equalsIgnoreCase(Title.PMEX_ExpiringPosition)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/expiringPosition.png")));
            IsDynamic = true;
            frmName = FormName.PMEX_ExpiringPosition;
            FormTitle = Title.PMEX_ExpiringPosition;
        } else if (id.equalsIgnoreCase(Title.PMEX_PeriodicTradeDetail)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/PeriodicTradeDetail.png")));
            IsDynamic = true;
            frmName = FormName.PMEX_PeriodicTradeDetail;
            FormTitle = Title.PMEX_PeriodicTradeDetail;
        } else if (id.equalsIgnoreCase(Title.PMEX_VaultPosition)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/VaultPosition.png")));
            IsDynamic = true;
            frmName = FormName.PMEX_VaultPosition;
            FormTitle = Title.PMEX_VaultPosition;
        } else if (id.equalsIgnoreCase(Title.PMEX_PeriodicTradeSummary)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/PeriodicTradeSummary.png")));
            IsDynamic = true;
            frmName = FormName.PMEX_PeriodicTradeSummary;
            FormTitle = Title.PMEX_PeriodicTradeSummary;
        } else if (id.equalsIgnoreCase(LanguageConstant.Preferences)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(80, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/prefrences.png")));
            IsDynamic = true;
            frmName = FormName.Prefernces;
            FormTitle = LanguageConstant.Preferences;
        } else if (id.equalsIgnoreCase(LanguageConstant.ChangePassword)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(80, 8));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/password.png")));
            IsDynamic = true;
            frmName = FormName.Prefernces;
            FormTitle = LanguageConstant.ChangePassword;
        } else if (id.equalsIgnoreCase(LanguageConstant.ChangePIN)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(67, 8));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/pincode.png")));
            IsDynamic = true;
            frmName = FormName.Prefernces;
            FormTitle = LanguageConstant.ChangePIN;
        } else if (id.equalsIgnoreCase(LanguageConstant.MessageWindow)) {
            viewName = LanguageConstant.MessageWindow;
            mi.setAccelerator(KeyStroke.getKeyStroke(123, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/message.png")));
        } else if (id.equalsIgnoreCase(LanguageConstant.TradeLog)) {
            viewName = LanguageConstant.TradeLog;
            mi.setAccelerator(KeyStroke.getKeyStroke(117, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/TradeLog.png")));
        } else if (id.equalsIgnoreCase(LanguageConstant.OutstandingLog)) {
            viewName = LanguageConstant.OutstandingLog;
            mi.setAccelerator(KeyStroke.getKeyStroke(116, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/OutstandingLog.png")));
        } else if (id.equalsIgnoreCase(LanguageConstant.MarketDepthByPrice)) {
            viewName = LanguageConstant.MarketDepthByPrice;
            mi.setAccelerator(KeyStroke.getKeyStroke(113, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/MBP.png")));
        } else if (id.equalsIgnoreCase(LanguageConstant.Historicaldata)) {
            viewName = LanguageConstant.Historicaldata;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/HistoricalData.png")));
        } else if (id.equalsIgnoreCase(LanguageConstant.MarketDepthByOrder)) {
            viewName = LanguageConstant.MarketDepthByOrder;
            mi.setAccelerator(KeyStroke.getKeyStroke(114, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/MBO.png")));
        } else if (id.equalsIgnoreCase(LanguageConstant.DailyTradeReport)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(119, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/dailyRept.png")));
            IsDynamic = true;
            frmName = FormName.DailyReport;
            FormTitle = LanguageConstant.DailyTradeReport;
        } else if (id.equalsIgnoreCase(LanguageConstant.ScripBrowse)) {
            IsDynamic = true;
            frmName = FormName.ScripBrowse;
            FormTitle = LanguageConstant.ScripBrowse;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/symDetail2.png")));
            mi.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        } else if (id.equalsIgnoreCase(LanguageConstant.Top30Movers)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(84, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/topMovers.png")));
            IsDynamic = true;
            frmName = FormName.TopMovers;
            FormTitle = LanguageConstant.Top30Movers;
        } else if (id.equalsIgnoreCase(LanguageConstant.SectorPerformance)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(83, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/sectorPer.png")));
            IsDynamic = true;
            frmName = FormName.SectorPerformance;
            FormTitle = LanguageConstant.SectorPerformance;
        } else if (id.equalsIgnoreCase(LanguageConstant.ExposureWatch)) {
            if (AppConfig.isExposureViaF1) {
                mi.setAccelerator(KeyStroke.getKeyStroke(112, 0));
            } else {
                mi.setAccelerator(KeyStroke.getKeyStroke(113, 0));
            }
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/ExposureWatch.png")));
            IsDynamic = true;
            frmName = FormName.ExposureWatch;
            FormTitle = LanguageConstant.ExposureWatch;
        } else if (id.equalsIgnoreCase(LanguageConstant.AccountStatement)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(65, 8));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/accountStatement.png")));
            IsDynamic = true;
            frmName = FormName.AccountStatement;
            FormTitle = LanguageConstant.AccountStatement;
        } else if (id.equalsIgnoreCase(LanguageConstant.PreviousAccountStatement)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/accountStatement.png")));
            IsDynamic = true;
            frmName = FormName.PreviousAccountStatement;
            FormTitle = LanguageConstant.PreviousAccountStatement;
        } else if (id.equalsIgnoreCase(LanguageConstant.PreviousOrderHistory)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/orderHistory.png")));
            IsDynamic = true;
            frmName = FormName.PreviousOrderHistory;
            FormTitle = LanguageConstant.PreviousOrderHistory;
        } else if (id.equalsIgnoreCase(LanguageConstant.OrderHistory)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(79, 8));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/orderHistory.png")));
            IsDynamic = true;
            frmName = FormName.OrderHistory;
            FormTitle = LanguageConstant.OrderHistory;
        } else if (id.equalsIgnoreCase(LanguageConstant.ScripHistory)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/orderHistory.png")));
            IsDynamic = true;
            frmName = FormName.ScripHistory;
            FormTitle = LanguageConstant.ScripHistory;
        } else if (id.equalsIgnoreCase(LanguageConstant.ScripWisePosition)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/scripWisePosition.png")));
            IsDynamic = true;
            frmName = FormName.ScripWisePosition;
            FormTitle = LanguageConstant.ScripWisePosition;
        } else if (id.equalsIgnoreCase(Title.ClosePriceExport)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/export.png")));
            IsDynamic = true;
            frmName = FormName.ClosePriceExport;
            FormTitle = Title.ClosePriceExport;
        } else if (id.equalsIgnoreCase(LanguageConstant.ActivityLog)) {
            viewName = LanguageConstant.ActivityLog;
            mi.setAccelerator(KeyStroke.getKeyStroke(118, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/ActivityLog.png")));
        } else if (id.equalsIgnoreCase(LanguageConstant.IndexGraph)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/indexgraph.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TradeCast.getInstance().ShowGraphWindow(FormName.IndexGraph, LanguageConstant.IndexGraph, "", "");
                }
            });
        } else if (id.equalsIgnoreCase(LanguageConstant.GraphsAndCharts)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/graph.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TradeCast.getInstance().ShowGraphWindow(FormName.GraphsAndCharts, LanguageConstant.GraphsAndCharts, "", "");
                }
            });
            mi.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        } else if (id.equalsIgnoreCase(LanguageConstant.Buy)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(115, 0));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy.png")));
            IsDynamic = true;
            frmName = FormName.Buy;
            FormTitle = LanguageConstant.Buy;
        } else if (id.equalsIgnoreCase(LanguageConstant.Sell)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(116, 0));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/Sell.png")));
            IsDynamic = true;
            frmName = FormName.Sell;
            FormTitle = LanguageConstant.Sell;
        } else if (id.equalsIgnoreCase(LanguageConstant.LeverageBuy)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(118, 0));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy.png")));
            IsDynamic = true;
            frmName = FormName.LeverageBuy;
            FormTitle = LanguageConstant.LeverageBuy;
        } else if (id.equalsIgnoreCase(Title.MFS)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(123, 0));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy.png")));
            IsDynamic = true;
            frmName = FormName.MFS;
            FormTitle = Title.MFS;
        } else if (id.equalsIgnoreCase(LanguageConstant.BunchOrder)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(117, 0));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/bunchOrders.png")));
            IsDynamic = true;
            frmName = FormName.BunchOrder;
            FormTitle = LanguageConstant.BunchOrder;
        } else if (id.equalsIgnoreCase(LanguageConstant.ShortSell)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(119, 0));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/ShortSell.png")));
            IsDynamic = true;
            frmName = FormName.ShortSell;
            FormTitle = LanguageConstant.ShortSell;
        } else if (id.equalsIgnoreCase(LanguageConstant.ChangeOrder)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(121, 0));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/Change.png")));
            IsDynamic = true;
            frmName = FormName.ChangeOrder;
            FormTitle = LanguageConstant.ChangeOrder;
        } else if (id.equalsIgnoreCase(LanguageConstant.Cancel)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(122, 0));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/Cancel.png")));
            IsDynamic = true;
            frmName = FormName.Cancel;
            FormTitle = LanguageConstant.Cancel;
        } else if (id.equalsIgnoreCase(LanguageConstant.OrderImport)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/import16.png")));
            IsDynamic = true;
            frmName = FormName.OrderImport;
            FormTitle = LanguageConstant.OrderImport;
        } else if (id.equalsIgnoreCase(LanguageConstant.XDividendWindow)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/dividend.png")));
            IsDynamic = true;
            frmName = FormName.XDividendWindow;
            FormTitle = LanguageConstant.XDividendWindow;
        } else if (id.equalsIgnoreCase(LanguageConstant.ExBenefitsWindow)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/dividend.png")));
            IsDynamic = true;
            frmName = FormName.ExBenefitsWindow;
            FormTitle = LanguageConstant.ExBenefitsWindow;
        } else if (id.equalsIgnoreCase(LanguageConstant.BankHistorical)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/export.png")));
            IsDynamic = true;
            frmName = FormName.BankHistorical;
            FormTitle = LanguageConstant.BankHistorical;
        } else if (id.equalsIgnoreCase(LanguageConstant.StrategyOrder)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/strategyOrder.png")));
            IsDynamic = true;
            frmName = FormName.StrategyOrder;
            FormTitle = LanguageConstant.StrategyOrder;
        } else if (id.equalsIgnoreCase(LanguageConstant.DetailedQuote)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(115, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/detailQuote.png")));
            IsDynamic = true;
            frmName = FormName.DetailedQuote;
            FormTitle = LanguageConstant.DetailedQuote;
        } else if (id.equalsIgnoreCase(LanguageConstant.CashWithdrawalRequest)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(82, 8));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/WithdrawlRequest.png")));
            IsDynamic = true;
            frmName = FormName.WithdrawlRequest;
            FormTitle = LanguageConstant.CashWithdrawalRequest;
        } else if (id.equalsIgnoreCase(LanguageConstant.JSFundTransferRequest)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(82, 9));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/MenuFundTransfer.png")));
            IsDynamic = true;
            frmName = FormName.JSFundTransferRequest;
            FormTitle = LanguageConstant.JSFundTransferRequest;
        } else if (id.equalsIgnoreCase(LanguageConstant.JSinternalBankFundTransfer)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/MenuFundTransfer.png")));
            IsDynamic = true;
            frmName = FormName.JSinternalBankFundTransfer;
            FormTitle = LanguageConstant.JSinternalBankFundTransfer;
        } else if (id.equalsIgnoreCase(LanguageConstant.FundTransfer)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/MenuFundTransfer.png")));
            IsDynamic = true;
            frmName = FormName.FundTransfer;
            FormTitle = LanguageConstant.FundTransfer;
        } else if (id.equalsIgnoreCase(LanguageConstant.FundTransferBIPL)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/MenuFundTransfer.png")));
            IsDynamic = true;
            frmName = FormName.FundTransferBIPL;
            FormTitle = LanguageConstant.FundTransferBIPL;
        } else if (id.equalsIgnoreCase(LanguageConstant.CustomerVerificationBIPL)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/customerVerification.png")));
            IsDynamic = true;
            frmName = FormName.CustomerVerificationBIPL;
            FormTitle = LanguageConstant.CustomerVerificationBIPL;
        } else if (id.equalsIgnoreCase(LanguageConstant.MarkDelivery)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(77, 9));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/MarkDelivery.png")));
            IsDynamic = true;
            frmName = FormName.MarkDelivery;
            FormTitle = LanguageConstant.MarkDelivery;
        } else if (id.equalsIgnoreCase("Mark Delivery")) {
            IsDynamic = true;
            frmName = FormName.MarkDelivery;
            FormTitle = "Mark Delivery";
        } else if (id.equalsIgnoreCase(LanguageConstant.CashWithdrawalStatement)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(87, 8));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/withdrawlStatement.png")));
            IsDynamic = true;
            frmName = FormName.WithDrawStatement;
            FormTitle = LanguageConstant.CashWithdrawalStatement;
        } else if (id.equalsIgnoreCase(Title.FundTransferStatement)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(70, 9));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/FundTransferStatement.png")));
            IsDynamic = true;
            frmName = FormName.JSFundTransferStatement;
            FormTitle = Title.FundTransferStatement;
        } else if (id.equalsIgnoreCase(LanguageConstant.IndicesSummary)) {
            mi.setAccelerator(KeyStroke.getKeyStroke(69, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/exchangeStats.png")));
            IsDynamic = true;
            frmName = FormName.IndicesSummery;
            FormTitle = LanguageConstant.IndicesSummary;
        } else if (id.equalsIgnoreCase(Title.Fundamentals)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/Fundamentals.png")));
            IsDynamic = true;
            frmName = FormName.Fundamental;
            FormTitle = Title.Fundamentals;
        } else if (id.equalsIgnoreCase(LanguageConstant.CompanySnapshotURL_SC)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/snapshot.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.tradeCast.showWebBrowserFrame();
                    ((CustomMenu)CustomMenu.this).mediator.webBrowserFrame.openURL(AppConfig.CompanySnapshotURL_SC);
                }
            });
        } else if (id.equalsIgnoreCase(Title.StockComparisonURL_SC)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/stockComparison.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.mediator.openURLinOSBrowser(AppConfig.StockComparisonURL_SC);
                }
            });
        } else if (id.equalsIgnoreCase(Title.MarketValuationsURL_SC)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/marketValuations.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.mediator.openURLinOSBrowser(AppConfig.MarketValuationsURL_SC);
                }
            });
        } else if (id.equalsIgnoreCase(Title.ResearchReportsURL_SC)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/researchReports.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.tradeCast.showWebBrowserFrame();
                    ((CustomMenu)CustomMenu.this).mediator.webBrowserFrame.openURL(AppConfig.ResearchReportsURL_SC);
                }
            });
        } else if (id.equalsIgnoreCase(Title.TradingSignal)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/tradingSignal.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.mediator.openURLinOSBrowser(AppConfig.tradingSignalURL);
                }
            });
        } else if (id.equalsIgnoreCase(LanguageConstant.TradeCastBrowser)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/Browser.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.tradeCast.showWebBrowserFrame();
                    ((CustomMenu)CustomMenu.this).mediator.webBrowserFrame.openURL(AppConfig.ResreachMenuLink);
                }
            });
        } else if (id.equalsIgnoreCase(Title.TransactionHistory)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/clienthistory.png")));
            IsDynamic = true;
            frmName = FormName.TransactionHistory;
            FormTitle = Title.TransactionHistory;
        } else if (id.equalsIgnoreCase(Title.OpenNCDCPosition)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/openCDC.png")));
            IsDynamic = true;
            frmName = FormName.OpenANDCDCPosition;
            FormTitle = Title.OpenNCDCPosition;
        } else if (id.equalsIgnoreCase(Title.LedgerActivity)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/Ledger.png")));
            IsDynamic = true;
            frmName = FormName.LedgerActivity;
            FormTitle = Title.LedgerActivity;
        } else if (id.equalsIgnoreCase(LanguageConstant.MarketDataExport)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/export.png")));
            IsDynamic = true;
            frmName = FormName.MarketDataExport;
            FormTitle = LanguageConstant.MarketDataExport;
        } else if (id.equalsIgnoreCase(Title.InvestmentReport)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/invest.png")));
            IsDynamic = true;
            frmName = FormName.InvestmentReport;
            FormTitle = Title.InvestmentReport;
        } else if (id.equalsIgnoreCase(LanguageConstant.CreatePIN)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/Ledger.png")));
            IsDynamic = true;
            frmName = FormName.CreatePinCode;
            FormTitle = LanguageConstant.CreatePIN;
        } else if (id.equalsIgnoreCase(Title.CreateSecondaryPassword)) {
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/secondaryPassword16.png")));
            IsDynamic = true;
            frmName = FormName.CreateSecondaryPassword;
            FormTitle = Title.CreateSecondaryPassword;
        } else if (id.equalsIgnoreCase(Title.Disclaimer)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/disclaimer.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.mediator.openURLinOSBrowser(AppConfig.DisclaimerURL);
                }
            });
        } else if (id.equalsIgnoreCase(Title.CompanyInfo)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/info16.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.mediator.openCompanyInfo(LogsKSE.SelectedSymbol);
                }
            });
        } else if (id.equalsIgnoreCase("KSE Live Announcements")) {
            AddListener = false;
            mi.setAccelerator(KeyStroke.getKeyStroke(75, 2));
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/kseannouncement.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.mediator.OpenKSEAnnouncementLink();
                }
            });
        } else if (id.equalsIgnoreCase(Title.GraphsAndChartsSC)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/graph.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.tradeCast.showWebBrowserFrame();
                    ((CustomMenu)CustomMenu.this).mediator.webBrowserFrame.openURL(AppConfig.graphURLSC);
                }
            });
        } else if (id.equalsIgnoreCase(Title.SCOpinion)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/Opinion.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomMenu.this.tradeCast.showWebBrowserFrame();
                    ((CustomMenu)CustomMenu.this).mediator.webBrowserFrame.openURL(AppConfig.opinionURL);
                }
            });
        } else if (id.equalsIgnoreCase(LanguageConstant.UpperCapped)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/UpperCapped.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((CustomMenu)CustomMenu.this).mediator.tradecast.OpenTicker(LanguageConstant.UpperCapped, true);
                }
            });
        } else if (id.equalsIgnoreCase(LanguageConstant.LowerLocked)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/LowerLocked.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((CustomMenu)CustomMenu.this).mediator.tradecast.OpenTicker(LanguageConstant.LowerLocked, true);
                }
            });
        } else if (id.equalsIgnoreCase(LanguageConstant.CustomTicker)) {
            AddListener = false;
            mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/Custom-Ticker-1.png")));
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LogCommon.CustomTicker.length() > 0) {
                        ((CustomMenu)CustomMenu.this).mediator.tradecast.OpenTicker(Title.Custom, true);
                    } else {
                        ((CustomMenu)CustomMenu.this).mediator.tradecast.OpenTickerCustomizationForm();
                    }
                }
            });
        } else if (id.equalsIgnoreCase(LanguageConstant.ByVolume)) {
            AddListener = false;
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TradeCast.getInstance().OpenTopMovers(id, LanguageConstant.TopMovers, true);
                }
            });
        } else if (id.equalsIgnoreCase(LanguageConstant.ByPriceIncrease)) {
            AddListener = false;
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TradeCast.getInstance().OpenTopMovers(id, LanguageConstant.TopMovers, true);
                }
            });
        } else if (id.equalsIgnoreCase(LanguageConstant.ByPriceDecrease)) {
            AddListener = false;
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TradeCast.getInstance().OpenTopMovers(id, LanguageConstant.TopMovers, true);
                }
            });
        } else if (id.equalsIgnoreCase(LanguageConstant.ByPercentIncrease)) {
            AddListener = false;
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TradeCast.getInstance().OpenTopMovers(id, LanguageConstant.TopMovers, true);
                }
            });
        } else if (id.equalsIgnoreCase(LanguageConstant.ByPercentDecrease)) {
            AddListener = false;
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TradeCast.getInstance().OpenTopMovers(id, LanguageConstant.TopMovers, true);
                }
            });
        } else {
            if (id.equalsIgnoreCase(LanguageConstant.Unattended) || id.equalsIgnoreCase(LanguageConstant.NormalMode)) {
                AddListener = false;
                this.unattendedMenu = new JMenuItem(this.languageCentre.getValue(LanguageConstant.Unattended));
                this.unattendedMenu.setIcon(new ImageIcon(this.getClass().getResource("/Images/user2.png")));
                this.unattendedMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (LogCommon.isUnattended) {
                            CustomMenu.this.mediator.setAttendedMode(CustomMenu.this.unattendedMenu);
                        } else {
                            CustomMenu.this.mediator.setUnattendedMode(CustomMenu.this.unattendedMenu, true);
                        }
                    }
                });
                return this.unattendedMenu;
            }
            if (id.equalsIgnoreCase(Title.PMEX_ContractBrowse)) {
                IsDynamic = true;
                frmName = FormName.ContractBrowse;
                FormTitle = Title.PMEX_ContractBrowse;
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/contractBrowse16.png")));
                mi.setAccelerator(KeyStroke.getKeyStroke(114, 1));
            } else if (id.equalsIgnoreCase(Title.PMEX_Ladder)) {
                mi.setAccelerator(KeyStroke.getKeyStroke(114, 8));
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/ladder16.png")));
                IsDynamic = true;
                frmName = FormName.PMEX_Ladder;
                FormTitle = Title.PMEX_Ladder;
            } else if (id.equalsIgnoreCase(Title.PMEX_MarketDepthByPrice)) {
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/marketDeptByPrice16.png")));
                mi.setAccelerator(KeyStroke.getKeyStroke(113, 8));
                IsDynamic = true;
                frmName = FormName.PMEX_MBP;
                FormTitle = Title.PMEX_MarketDepthByPrice;
            } else if (id.equalsIgnoreCase(Title.PMEX_Buy)) {
                mi.setAccelerator(KeyStroke.getKeyStroke(115, 1));
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/bid16.png")));
                IsDynamic = true;
                frmName = FormName.PMEX_Buy;
                FormTitle = Title.PMEX_Buy;
            } else if (id.equalsIgnoreCase(Title.PMEX_Sell)) {
                mi.setAccelerator(KeyStroke.getKeyStroke(116, 1));
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/ask16.png")));
                IsDynamic = true;
                frmName = FormName.PMEX_Sell;
                FormTitle = Title.PMEX_Sell;
            } else if (id.equalsIgnoreCase(Title.PMEX_FastOrder)) {
                AddListener = false;
                mi.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/fastOrder16x16.png")));
                mi.setAccelerator(KeyStroke.getKeyStroke(117, 1));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CustomMenu.this.tradeCast.showPMEX_FastOrderFrame();
                    }
                });
            } else if (id.equalsIgnoreCase(Title.PMEX_WorkingOrder)) {
                viewName = Title.PMEX_WorkingOrder;
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/workingOrders16.png")));
                mi.setAccelerator(KeyStroke.getKeyStroke(116, 8));
            } else if (id.equalsIgnoreCase(Title.PMEX_TradedOrder)) {
                viewName = Title.PMEX_TradedOrder;
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/tradedOrders16.png")));
                mi.setAccelerator(KeyStroke.getKeyStroke(117, 8));
            } else if (id.equalsIgnoreCase(Title.PMEX_OrderActivity)) {
                viewName = Title.PMEX_OrderActivity;
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/orderActivity16.png")));
                mi.setAccelerator(KeyStroke.getKeyStroke(118, 8));
            } else if (id.equalsIgnoreCase(Title.PMEX_TopMovers)) {
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/topMovers16.png")));
                mi.setAccelerator(KeyStroke.getKeyStroke(84, 8));
                IsDynamic = true;
                frmName = FormName.PMEX_TopMovers;
                FormTitle = Title.PMEX_TopMovers;
            } else if (id.equalsIgnoreCase(Title.PMEX_BuyingPower)) {
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/netposition16x16.png")));
                mi.setAccelerator(KeyStroke.getKeyStroke(113, 1));
                IsDynamic = true;
                frmName = FormName.PMEX_BuyingPower;
                FormTitle = Title.PMEX_BuyingPower;
            } else if (id.equalsIgnoreCase(Title.PMEX_BuyingPower_Dock)) {
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/netposition16x16.png")));
                IsDynamic = true;
                frmName = FormName.PMEX_BuyingPower_Dock;
                FormTitle = Title.PMEX_BuyingPower_Dock;
            } else if (id.equalsIgnoreCase(Title.PMEX_RiskWatch)) {
                mi.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/riskWatch16x16.png")));
                mi.setAccelerator(KeyStroke.getKeyStroke(87, 2));
                IsDynamic = true;
                frmName = FormName.PMEX_RiskWatch;
                FormTitle = Title.PMEX_RiskWatch;
            } else if (id.equalsIgnoreCase(LanguageConstant.AnnualStatements)) {
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/AnnualStatements.png")));
                IsDynamic = true;
                frmName = FormName.Statement;
                FormTitle = LanguageConstant.AnnualStatements;
            } else if (id.equalsIgnoreCase(LanguageConstant.QuarterlyStatements)) {
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/QuarterlyStatement.png")));
                IsDynamic = true;
                frmName = FormName.QuarterStatement;
                FormTitle = LanguageConstant.QuarterlyStatements;
            } else if (id.equalsIgnoreCase(LanguageConstant.ScripDetail)) {
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/scripDetail.png")));
                mi.setAccelerator(KeyStroke.getKeyStroke(68, 2));
                IsDynamic = true;
                frmName = FormName.ScripDetails;
                FormTitle = LanguageConstant.ScripDetail;
            } else if (id.equalsIgnoreCase(LanguageConstant.PeriodicTradeSummary)) {
                mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/PeriodicTradeSummary.png")));
                IsDynamic = true;
                frmName = FormName.PeriodicTradeSummary;
                FormTitle = LanguageConstant.PeriodicTradeSummary;
            } else if (id.equalsIgnoreCase(LanguageConstant.PeriodicTradeSummaryByDealer)) {
                mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/PeriodicTradeSummary.png")));
                IsDynamic = true;
                frmName = FormName.PeriodicTradeSummaryByDealer;
                FormTitle = LanguageConstant.PeriodicTradeSummaryByDealer;
            } else if (id.equalsIgnoreCase(LanguageConstant.PreviousPeriodicTradeDetail)) {
                mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/PeriodicTradeDetail.png")));
                IsDynamic = true;
                frmName = FormName.PreviousPeriodicTradeDetail;
                FormTitle = LanguageConstant.PreviousPeriodicTradeDetail;
            } else if (id.equalsIgnoreCase(LanguageConstant.PeriodicTradeDetail)) {
                mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/PeriodicTradeDetail.png")));
                IsDynamic = true;
                frmName = FormName.PeriodicTradeDetail;
                FormTitle = LanguageConstant.PeriodicTradeDetail;
            } else if (id.equalsIgnoreCase(LanguageConstant.PeriodicTradeDetailByDealer)) {
                mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/PeriodicTradeDetail.png")));
                IsDynamic = true;
                frmName = FormName.PeriodicTradeDetailByDealer;
                FormTitle = LanguageConstant.PeriodicTradeDetailByDealer;
            } else if (id.equalsIgnoreCase(LanguageConstant.CustodyNetShares)) {
                mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/CustodyNetShares.png")));
                IsDynamic = true;
                frmName = FormName.CustodyNetShares;
                FormTitle = LanguageConstant.CustodyNetShares;
            } else if (id.equalsIgnoreCase(Title.AnalystOpinion)) {
                AddListener = false;
                mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/Opinion.png")));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CustomMenu.this.mediator.openURLinOSBrowser(AppConfig.AnalystOpinionURL_SC);
                    }
                });
            } else if (id.equalsIgnoreCase(Title.RealtimeTechnicalCharting)) {
                AddListener = false;
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/advanceCharting.png")));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CustomMenu.this.mediator.openURLinOSBrowser(AppConfig.RealtimeTechnicalChartingURL_SC);
                    }
                });
            } else if (id.equalsIgnoreCase(Title.IndexSnapshot)) {
                AddListener = false;
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/snapshot.png")));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CustomMenu.this.mediator.openURLinOSBrowser(AppConfig.IndexSnapshotURL_SC);
                    }
                });
            } else if (id.equalsIgnoreCase(Title.SectorSnapshot)) {
                AddListener = false;
                mi.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/snapshot.png")));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CustomMenu.this.mediator.openURLinOSBrowser(AppConfig.SectorSnapshotURL_SC);
                    }
                });
            } else if (id.equalsIgnoreCase(Title.PSXHeatMap)) {
                AddListener = false;
                mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/heat-map.png")));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CustomMenu.this.mediator.openURLinOSBrowser(AppConfig.PSXHeatMapURL_SC);
                    }
                });
            } else if (id.equalsIgnoreCase(Title.FIPIOverview)) {
                AddListener = false;
                mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/investment-portfolio.png")));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CustomMenu.this.mediator.openURLinOSBrowser(AppConfig.FIPIOverviewURL_SC);
                    }
                });
            } else if (id.equalsIgnoreCase(Title.StockSearch)) {
                AddListener = false;
                mi.setIcon(new ImageIcon(this.getClass().getResource("/Images/icon_searchci.gif")));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CustomMenu.this.mediator.openURLinOSBrowser(AppConfig.StockSearchURL_SC);
                    }
                });
            }
        }
        if (AddListener) {
            if (IsDynamic) {
                final FormName finalfrmName = frmName;
                final String finalFormTitle = FormTitle;
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (finalfrmName == FormName.PMEX_Ladder) {
                                    CustomMenu.this.tradeCast.ShowLadderWindow(finalfrmName, finalFormTitle, LogsPMEX.SelectedSymbol);
                                } else if (finalfrmName == FormName.PMEX_MBP) {
                                    CustomMenu.this.tradeCast.ShowPMEX_MBPWindow(FormName.PMEX_MBP, Title.PMEX_MarketDepthByPrice, LogsPMEX.SelectedSymbol);
                                } else {
                                    CustomMenu.this.tradeCast.ShowDynamicForm(finalfrmName, finalFormTitle);
                                    if ((id.equalsIgnoreCase(LanguageConstant.Preferences) || id.equalsIgnoreCase(LanguageConstant.ChangePassword) || id.equalsIgnoreCase(LanguageConstant.ChangePIN)) && ((CustomMenu)CustomMenu.this).mediator.prefrences != null) {
                                        ((CustomMenu)CustomMenu.this).mediator.prefrences.selectTab(id);
                                    }
                                    if (id.equalsIgnoreCase(LanguageConstant.DetailedQuote)) {
                                        ((CustomMenu)CustomMenu.this).mediator.detailedQuote.AddSymbol(LogsKSE.SelectedMarket, LogsKSE.SelectedSymbol);
                                        ((CustomMenu)CustomMenu.this).mediator.detailedQuote.setTitle("");
                                    }
                                }
                            }
                        });
                    }
                });
            } else {
                final String finalViewName = viewName;
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CustomMenu.this.tradeCast.showStaticWindow(finalViewName, true);
                                if (finalViewName.equalsIgnoreCase(LanguageConstant.MarketDepthByPrice)) {
                                    ((CustomMenu)CustomMenu.this).mediator.mbp.AddSymbol(LogsKSE.SelectedSymbol, LogsKSE.SelectedMarket);
                                }
                                if (finalViewName.equalsIgnoreCase(LanguageConstant.MarketDepthByOrder)) {
                                    ((CustomMenu)CustomMenu.this).mediator.mbo.AddSymbol(LogsKSE.SelectedSymbol, LogsKSE.SelectedMarket);
                                }
                                if (finalViewName.equalsIgnoreCase(LanguageConstant.Historicaldata)) {
                                    ((CustomMenu)CustomMenu.this).mediator.mbo.AddSymbol(LogsKSE.SelectedSymbol, LogsKSE.SelectedMarket);
                                }
                            }
                        });
                    }
                });
            }
        }
        return mi;
    }

    private JMenuItem createToolBarItem() {
        this.toolbar = new JCheckBoxMenuItem(this.languageCentre.getValue(LanguageConstant.ToolBar));
        this.toolbar.setSelected(true);
        this.toolbar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomMenu.this.toolbar.isSelected()) {
                    ((CustomMenu)CustomMenu.this).tradeCast.toolBar.setVisible(true);
                    LogCommon.ShowToolBar = true;
                } else {
                    ((CustomMenu)CustomMenu.this).tradeCast.toolBar.setVisible(false);
                    LogCommon.ShowToolBar = false;
                }
            }
        });
        return this.toolbar;
    }

    private JMenuItem createExStatsMenuItem() {
        this.exstatsmenu = new JCheckBoxMenuItem(this.languageCentre.getValue(LanguageConstant.ExchangeStats));
        this.exstatsmenu.setSelected(true);
        this.exstatsmenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomMenu.this.exstatsmenu.isSelected()) {
                    ((CustomMenu)CustomMenu.this).tradeCast.ExStats.setVisible(true);
                    LogCommon.ShowExSatatsBar = true;
                } else {
                    ((CustomMenu)CustomMenu.this).tradeCast.ExStats.setVisible(false);
                    LogCommon.ShowExSatatsBar = false;
                }
            }
        });
        return this.exstatsmenu;
    }

    private JMenuItem createStatusBarMenuItem() {
        this.statusumenu = new JCheckBoxMenuItem(this.languageCentre.getValue(LanguageConstant.StatusBar));
        this.statusumenu.setSelected(true);
        this.statusumenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomMenu.this.statusumenu.isSelected()) {
                    ((CustomMenu)CustomMenu.this).tradeCast.statusbar.setVisible(true);
                    LogCommon.ShowStatusBar = true;
                } else {
                    ((CustomMenu)CustomMenu.this).tradeCast.statusbar.setVisible(false);
                    LogCommon.ShowStatusBar = false;
                }
            }
        });
        return this.statusumenu;
    }

    private JMenuItem createPMEXBuyingPowerMenuItem() {
        this.pmexBuyingPowerMenu = new JCheckBoxMenuItem(this.languageCentre.getValue(LanguageConstant.PMEX_BuyingPower_Dock));
        this.pmexBuyingPowerMenu.setSelected(false);
        this.pmexBuyingPowerMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomMenu.this.pmexBuyingPowerMenu.isSelected()) {
                    ((CustomMenu)CustomMenu.this).tradeCast.pmex_BuyingPower_Dock.setVisible(true);
                    LogCommon.ShowPMEXBuyingPower = true;
                } else {
                    ((CustomMenu)CustomMenu.this).tradeCast.pmex_BuyingPower_Dock.setVisible(false);
                    LogCommon.ShowPMEXBuyingPower = false;
                }
            }
        });
        return this.pmexBuyingPowerMenu;
    }
}

